/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.plantuml;

import java.awt.image.BufferedImage;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import net.atmp.PixelImage;
import net.sourceforge.plantuml.BlockUml;
import net.sourceforge.plantuml.FileFormat;
import net.sourceforge.plantuml.FileFormatOption;
import net.sourceforge.plantuml.StringUtils;
import net.sourceforge.plantuml.core.Diagram;
import net.sourceforge.plantuml.klimt.AffineTransformType;
import net.sourceforge.plantuml.klimt.creole.Neutron;
import net.sourceforge.plantuml.klimt.creole.atom.Atom;
import net.sourceforge.plantuml.klimt.drawing.UGraphic;
import net.sourceforge.plantuml.klimt.font.StringBounder;
import net.sourceforge.plantuml.klimt.geom.HorizontalAlignment;
import net.sourceforge.plantuml.klimt.geom.XDimension2D;
import net.sourceforge.plantuml.klimt.shape.AbstractTextBlock;
import net.sourceforge.plantuml.klimt.shape.Line;
import net.sourceforge.plantuml.klimt.shape.UImage;
import net.sourceforge.plantuml.klimt.shape.UImageSvg;
import net.sourceforge.plantuml.log.Logme;
import net.sourceforge.plantuml.preproc.Defines;
import net.sourceforge.plantuml.security.SImageIO;
import net.sourceforge.plantuml.style.ISkinSimple;
import net.sourceforge.plantuml.text.StringLocated;

public class EmbeddedDiagram
extends AbstractTextBlock
implements Line,
Atom {
    public static final String EMBEDDED_START = "{{";
    public static final String EMBEDDED_END = "}}";
    private final List<StringLocated> list;
    private final ISkinSimple skinParam;
    private BufferedImage image;

    public static String getEmbeddedType(CharSequence cs) {
        if (cs == null) {
            return null;
        }
        String s = StringUtils.trin(cs.toString());
        if (!s.startsWith(EMBEDDED_START)) {
            return null;
        }
        if (s.equals(EMBEDDED_START)) {
            return "uml";
        }
        if (s.equals("{{ditaa")) {
            return "ditaa";
        }
        if (s.equals("{{uml")) {
            return "uml";
        }
        if (s.equals("{{wbs")) {
            return "wbs";
        }
        if (s.equals("{{mindmap")) {
            return "mindmap";
        }
        if (s.equals("{{gantt")) {
            return "gantt";
        }
        if (s.equals("{{json")) {
            return "json";
        }
        if (s.equals("{{yaml")) {
            return "yaml";
        }
        if (s.equals("{{wire")) {
            return "wire";
        }
        if (s.equals("{{creole")) {
            return "creole";
        }
        if (s.equals("{{board")) {
            return "board";
        }
        if (s.equals("{{ebnf")) {
            return "ebnf";
        }
        if (s.equals("{{regex")) {
            return "regex";
        }
        if (s.equals("{{files")) {
            return "files";
        }
        if (s.equals("{{chronology")) {
            return "chronology";
        }
        if (s.equals("{{chen")) {
            return "chen";
        }
        return null;
    }

    public static EmbeddedDiagram createAndSkip(String type, Iterator<CharSequence> it, ISkinSimple skinParam) {
        ArrayList<String> result = new ArrayList<String>();
        result.add("@start" + type);
        int nested = 1;
        while (it.hasNext()) {
            CharSequence s2 = it.next();
            if (EmbeddedDiagram.getEmbeddedType(StringUtils.trinNoTrace(s2)) != null) {
                ++nested;
            } else if (StringUtils.trinNoTrace(s2).equals(EMBEDDED_END) && --nested == 0) break;
            result.add(s2.toString());
        }
        result.add("@end" + type);
        return EmbeddedDiagram.from(skinParam, result);
    }

    private EmbeddedDiagram(ISkinSimple skinParam, List<StringLocated> system) {
        this.list = system;
        this.skinParam = skinParam;
    }

    public static EmbeddedDiagram from(ISkinSimple skinParam, List<String> strings) {
        return new EmbeddedDiagram(skinParam, BlockUml.convert(strings));
    }

    @Override
    public double getStartingAltitude(StringBounder stringBounder) {
        return 0.0;
    }

    @Override
    public XDimension2D calculateDimension(StringBounder stringBounder) {
        try {
            if (stringBounder.matchesProperty("SVG")) {
                String imageSvg = this.getImageSvg();
                UImageSvg svg = new UImageSvg(imageSvg, 1.0);
                return new XDimension2D(svg.getWidth(), svg.getHeight());
            }
            BufferedImage im = this.getImage();
            return new XDimension2D(im.getWidth(), im.getHeight());
        }
        catch (IOException e) {
            Logme.error(e);
        }
        catch (InterruptedException e) {
            Logme.error(e);
        }
        return new XDimension2D(42.0, 42.0);
    }

    @Override
    public void drawU(UGraphic ug) {
        try {
            boolean isSvg = ug.matchesProperty("SVG");
            if (isSvg) {
                String imageSvg = this.getImageSvg();
                UImageSvg svg = new UImageSvg(imageSvg, 1.0);
                ug.draw(svg);
                return;
            }
            BufferedImage im = this.getImage();
            UImage image = new UImage(new PixelImage(im, AffineTransformType.TYPE_BILINEAR));
            ug.draw(image);
        }
        catch (IOException e) {
            Logme.error(e);
        }
        catch (InterruptedException e) {
            Logme.error(e);
        }
    }

    private String getImageSvg() throws IOException, InterruptedException {
        Diagram system = this.getSystem();
        ByteArrayOutputStream os = new ByteArrayOutputStream();
        system.exportDiagram(os, 0, new FileFormatOption(FileFormat.SVG));
        os.close();
        return new String(os.toByteArray());
    }

    private BufferedImage getImage() throws IOException, InterruptedException {
        if (this.image == null) {
            this.image = this.getImageSlow();
        }
        return this.image;
    }

    private BufferedImage getImageSlow() throws IOException, InterruptedException {
        Diagram system = this.getSystem();
        ByteArrayOutputStream os = new ByteArrayOutputStream();
        system.exportDiagram(os, 0, new FileFormatOption(FileFormat.PNG));
        os.close();
        return SImageIO.read(os.toByteArray());
    }

    @Override
    public HorizontalAlignment getHorizontalAlignment() {
        return HorizontalAlignment.LEFT;
    }

    private Diagram getSystem() throws IOException, InterruptedException {
        Map<String, String> skinMap = this.skinParam == null ? Collections.emptyMap() : this.skinParam.values();
        BlockUml blockUml = new BlockUml(this.list, Defines.createEmpty(), skinMap, null, null);
        return blockUml.getDiagram();
    }

    @Override
    public List<Neutron> getNeutrons() {
        return Arrays.asList(Neutron.create(this));
    }
}

