/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.plantuml.xmi;

import javax.xml.parsers.ParserConfigurationException;
import net.sourceforge.plantuml.abel.Entity;
import net.sourceforge.plantuml.abel.Link;
import net.sourceforge.plantuml.decoration.LinkDecor;
import net.sourceforge.plantuml.descdiagram.DescriptionDiagram;
import net.sourceforge.plantuml.klimt.creole.Display;
import net.sourceforge.plantuml.xmi.UMLAggregationKind;
import net.sourceforge.plantuml.xmi.XmiDescriptionDiagramAbstract;
import org.w3c.dom.Element;

public class XmiDescriptionDiagramScript
extends XmiDescriptionDiagramAbstract {
    public XmiDescriptionDiagramScript(DescriptionDiagram diagram) throws ParserConfigurationException {
        super(diagram);
    }

    @Override
    protected void addLink(Link link) {
        if (link.isHidden() || link.isInvis()) {
            return;
        }
        if (!link.getType().getStyle().isNormal()) {
            Element dependency = this.createDependency(link);
            this.ownedElement.appendChild(dependency);
            return;
        }
        String assId = "ass" + this.diagram.getUniqueSequence("");
        UMLAggregationKind aggregation = UMLAggregationKind.None;
        if (link.getType().getDecor1() == LinkDecor.COMPOSITION) {
            aggregation = UMLAggregationKind.Composite;
        }
        if (link.getType().getDecor2() == LinkDecor.COMPOSITION) {
            aggregation = UMLAggregationKind.Composite;
        }
        if (link.getType().getDecor1() == LinkDecor.AGREGATION) {
            aggregation = UMLAggregationKind.Aggregation;
        }
        if (link.getType().getDecor2() == LinkDecor.AGREGATION) {
            aggregation = UMLAggregationKind.Aggregation;
        }
        Element association = this.document.createElement("UML:Association");
        association.setAttribute("xmi.id", assId);
        if (!Display.isNull(link.getLabel())) {
            association.setAttribute("name", XmiDescriptionDiagramScript.forXMI(link.getLabel()));
        }
        Element connection = this.document.createElement("UML:Association.connection");
        Element end1 = this.createAssociationEnd(assId, link.getType().getDecor2(), link.getQuantifier1(), link.getEntity1(), aggregation);
        connection.appendChild(end1);
        Element end2 = this.createAssociationEnd(assId, link.getType().getDecor1(), link.getQuantifier2(), link.getEntity2(), aggregation);
        connection.appendChild(end2);
        association.appendChild(connection);
        this.ownedElement.appendChild(association);
    }

    private Element createAssociationEnd(String assId, LinkDecor decor, String quantifier, Entity entity, UMLAggregationKind aggregation) {
        Element end = this.document.createElement("UML:AssociationEnd");
        end.setAttribute("xmi.id", "end" + this.diagram.getUniqueSequence(""));
        end.setAttribute("association", assId);
        if (quantifier != null) {
            end.setAttribute("name", XmiDescriptionDiagramScript.forXMI(quantifier));
        }
        end.setAttribute("participant", entity.getUid());
        if (aggregation != UMLAggregationKind.None) {
            end.setAttribute("aggregation", aggregation.name);
        }
        boolean navigable = decor != LinkDecor.NOT_NAVIGABLE && decor != LinkDecor.NONE;
        end.setAttribute("isNavigable", Boolean.toString(navigable));
        return end;
    }

    private Element createDependency(Link link) {
        if (link.isInverted()) {
            return this.createDependencyClientSupplier(link.getEntity2(), link.getEntity1());
        }
        return this.createDependencyClientSupplier(link.getEntity1(), link.getEntity2());
    }

    private Element createRef(Entity entity) {
        Element ref = this.document.createElement("UML:Component");
        ref.setAttribute("xmi.idref", entity.getUid());
        return ref;
    }

    private Element createDependencyClientSupplier(Entity clientEntity, Entity supplierEntity) {
        Element supplierRef;
        String depID = this.diagram.getUniqueSequence("dep");
        Element dependency = this.document.createElement("UML:Dependency");
        dependency.setAttribute("xmi.id", depID);
        Element client = this.document.createElement("UML:Dependency.client");
        Element supplier = this.document.createElement("UML:Dependency.supplier");
        Element clientRef = this.createRef(clientEntity);
        if (clientRef != null) {
            client.appendChild(clientRef);
        }
        if ((supplierRef = this.createRef(supplierEntity)) != null) {
            supplier.appendChild(supplierRef);
        }
        dependency.appendChild(client);
        dependency.appendChild(supplier);
        return dependency;
    }
}

