/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.plantuml.xmi;

import java.io.OutputStream;
import java.nio.charset.StandardCharsets;
import java.util.HashSet;
import java.util.Set;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerException;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import net.sourceforge.plantuml.abel.Entity;
import net.sourceforge.plantuml.abel.LeafType;
import net.sourceforge.plantuml.classdiagram.ClassDiagram;
import net.sourceforge.plantuml.cucadiagram.Member;
import net.sourceforge.plantuml.klimt.creole.Display;
import net.sourceforge.plantuml.skin.VisibilityModifier;
import net.sourceforge.plantuml.stereo.Stereotype;
import net.sourceforge.plantuml.version.Version;
import net.sourceforge.plantuml.xmi.CucaDiagramXmiMaker;
import net.sourceforge.plantuml.xmi.XmlDiagramTransformer;
import net.sourceforge.plantuml.xml.XmlFactories;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

abstract class XmiClassDiagramAbstract
implements XmlDiagramTransformer {
    protected final ClassDiagram classDiagram;
    protected final Document document;
    protected final Element ownedElementRoot;
    protected final Set<Entity> done = new HashSet<Entity>();

    public XmiClassDiagramAbstract(ClassDiagram classDiagram) throws ParserConfigurationException {
        this.classDiagram = classDiagram;
        DocumentBuilder builder = XmlFactories.newDocumentBuilder();
        this.document = builder.newDocument();
        this.document.setXmlVersion("1.0");
        this.document.setXmlStandalone(true);
        Element xmi = this.document.createElement("XMI");
        xmi.setAttribute("xmi.version", "1.1");
        xmi.setAttribute("xmlns:UML", "href://org.omg/UML/1.3");
        this.document.appendChild(xmi);
        Element header = this.document.createElement("XMI.header");
        xmi.appendChild(header);
        header.appendChild(this.createXmiDocumentation());
        header.appendChild(this.createXmiMetamodel());
        Element content = this.document.createElement("XMI.content");
        xmi.appendChild(content);
        Element model = this.document.createElement("UML:Model");
        model.setAttribute("xmi.id", CucaDiagramXmiMaker.getModel(classDiagram));
        model.setAttribute("name", "PlantUML");
        content.appendChild(model);
        this.ownedElementRoot = this.document.createElement("UML:Namespace.ownedElement");
        model.appendChild(this.ownedElementRoot);
    }

    private Element createXmiDocumentation() {
        Element documentation = this.document.createElement("XMI.documentation");
        Element exporter = this.document.createElement("XMI.exporter");
        exporter.setTextContent("PlantUML");
        Element exporterVersion = this.document.createElement("XMI.exporterVersion");
        exporterVersion.setTextContent(Version.versionString());
        documentation.appendChild(exporter);
        documentation.appendChild(exporterVersion);
        return documentation;
    }

    private Element createXmiMetamodel() {
        Element metamodel = this.document.createElement("XMI.metamodel");
        metamodel.setAttribute("xmi.name", "UML");
        metamodel.setAttribute("xmi.version", "1.4");
        return metamodel;
    }

    protected final String forXMI(String s) {
        return s.replace(':', ' ');
    }

    protected final String forXMI(Display s) {
        if (Display.isNull(s)) {
            return "";
        }
        return s.get(0).toString().replace(':', ' ');
    }

    @Override
    public final void transformerXml(OutputStream os) throws TransformerException, ParserConfigurationException {
        DOMSource source = new DOMSource(this.document);
        StreamResult resultat = new StreamResult(os);
        Transformer transformer = XmlFactories.newTransformer();
        transformer.setOutputProperty("indent", "yes");
        transformer.setOutputProperty("encoding", StandardCharsets.UTF_8.name());
        transformer.transform(source, resultat);
    }

    protected final Element createEntityNode(Entity entity) {
        VisibilityModifier visibility;
        Member m;
        LeafType type;
        Element cla = this.document.createElement("UML:Class");
        if (entity.getLeafType() == LeafType.NOTE) {
            return null;
        }
        cla.setAttribute("xmi.id", entity.getUid());
        cla.setAttribute("name", entity.getDisplay().get(0).toString());
        Stereotype stereotype = entity.getStereotype();
        if (stereotype != null) {
            Element stereo = this.document.createElement("UML:ModelElement.stereotype");
            for (String s : stereotype.getMultipleLabels()) {
                Element name = this.document.createElement("UML:Stereotype");
                name.setAttribute("name", s);
                stereo.appendChild(name);
            }
            cla.appendChild(stereo);
        }
        if ((type = entity.getLeafType()) == LeafType.ABSTRACT_CLASS) {
            cla.setAttribute("isAbstract", "true");
        } else if (type == LeafType.INTERFACE) {
            cla.setAttribute("isInterface", "true");
        }
        if (entity.isStatic()) {
            cla.setAttribute("isStatic", "true");
        }
        if (entity.getVisibilityModifier() == VisibilityModifier.PRIVATE_FIELD || entity.getVisibilityModifier() == VisibilityModifier.PRIVATE_METHOD) {
            cla.setAttribute("visibility", entity.getVisibilityModifier().getXmiVisibility());
        }
        Element feature = this.document.createElement("UML:Classifier.feature");
        cla.appendChild(feature);
        for (CharSequence cs : entity.getBodier().getFieldsToDisplay()) {
            m = (Member)cs;
            Element attribute = this.document.createElement("UML:Attribute");
            attribute.setAttribute("xmi.id", "att" + this.classDiagram.getUniqueSequence(""));
            attribute.setAttribute("name", m.getDisplay(false));
            visibility = m.getVisibilityModifier();
            if (visibility != null) {
                attribute.setAttribute("visibility", visibility.getXmiVisibility());
            }
            if (m.isStatic()) {
                attribute.setAttribute("isStatic", "true");
            }
            feature.appendChild(attribute);
        }
        for (CharSequence cs : entity.getBodier().getMethodsToDisplay()) {
            m = (Member)cs;
            Element operation = this.document.createElement("UML:Operation");
            operation.setAttribute("xmi.id", "att" + this.classDiagram.getUniqueSequence(""));
            operation.setAttribute("name", m.getDisplay(false));
            visibility = m.getVisibilityModifier();
            if (visibility != null) {
                operation.setAttribute("visibility", visibility.getXmiVisibility());
            }
            if (m.isStatic()) {
                operation.setAttribute("isStatic", "true");
            }
            feature.appendChild(operation);
        }
        return cla;
    }
}

