/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.plantuml.timingdiagram;

import net.sourceforge.plantuml.klimt.Fashion;
import net.sourceforge.plantuml.klimt.UStroke;
import net.sourceforge.plantuml.klimt.color.Colors;
import net.sourceforge.plantuml.klimt.color.HColor;
import net.sourceforge.plantuml.klimt.creole.Display;
import net.sourceforge.plantuml.klimt.font.FontConfiguration;
import net.sourceforge.plantuml.klimt.font.StringBounder;
import net.sourceforge.plantuml.klimt.geom.HorizontalAlignment;
import net.sourceforge.plantuml.klimt.shape.TextBlock;
import net.sourceforge.plantuml.klimt.shape.UDrawable;
import net.sourceforge.plantuml.skin.ArrowConfiguration;
import net.sourceforge.plantuml.stereo.Stereotype;
import net.sourceforge.plantuml.style.ISkinParam;
import net.sourceforge.plantuml.style.PName;
import net.sourceforge.plantuml.style.SName;
import net.sourceforge.plantuml.style.Style;
import net.sourceforge.plantuml.style.StyleSignature;
import net.sourceforge.plantuml.style.StyleSignatureBasic;
import net.sourceforge.plantuml.timingdiagram.TimeProjected;
import net.sourceforge.plantuml.timingdiagram.TimeTick;
import net.sourceforge.plantuml.timingdiagram.TimingRuler;
import net.sourceforge.plantuml.utils.Position;

public abstract class Player
implements TimeProjected {
    protected final ISkinParam skinParam;
    protected final TimingRuler ruler;
    private final boolean compact;
    private final Display title;
    protected int suggestedHeight;
    protected final Stereotype stereotype;
    private final HColor generalBackgroundColor;

    public Player(String title, ISkinParam skinParam, TimingRuler ruler, boolean compact, Stereotype stereotype, HColor generalBackgroundColor) {
        this.generalBackgroundColor = generalBackgroundColor;
        this.stereotype = stereotype;
        this.skinParam = skinParam;
        this.compact = compact;
        this.ruler = ruler;
        this.title = Display.getWithNewlines(title);
    }

    public boolean isCompact() {
        return this.compact;
    }

    public HColor getGeneralBackgroundColor() {
        return this.generalBackgroundColor;
    }

    protected abstract StyleSignature getStyleSignature();

    protected final Style getStyle() {
        return this.getStyleSignature().getMergedStyle(this.skinParam.getCurrentStyleBuilder());
    }

    protected final FontConfiguration getFontConfiguration() {
        return FontConfiguration.create(this.skinParam, StyleSignatureBasic.of(SName.root, SName.element, SName.timingDiagram).getMergedStyle(this.skinParam.getCurrentStyleBuilder()));
    }

    protected final UStroke getStroke() {
        Style style = this.getStyleSignature().getMergedStyle(this.skinParam.getCurrentStyleBuilder());
        return style.getStroke();
    }

    protected final Fashion getContext() {
        Style style = this.getStyleSignature().getMergedStyle(this.skinParam.getCurrentStyleBuilder());
        HColor lineColor = style.value(PName.LineColor).asColor(this.skinParam.getIHtmlColorSet());
        HColor backgroundColor = style.value(PName.BackGroundColor).asColor(this.skinParam.getIHtmlColorSet());
        return new Fashion(backgroundColor, lineColor).withStroke(this.getStroke());
    }

    protected final TextBlock getTitle() {
        return this.title.create(this.getFontConfiguration(), HorizontalAlignment.LEFT, this.skinParam);
    }

    public abstract void addNote(TimeTick var1, Display var2, Position var3, Stereotype var4);

    public abstract void defineState(String var1, String var2);

    public abstract void setState(TimeTick var1, String var2, Colors var3, String ... var4);

    public abstract void createConstraint(TimeTick var1, TimeTick var2, String var3, ArrowConfiguration var4);

    public abstract TextBlock getPart1(double var1, double var3);

    public abstract UDrawable getPart2();

    public abstract double getFullHeight(StringBounder var1);

    public final void setHeight(int height) {
        this.suggestedHeight = height;
    }
}

