/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.plantuml.tim;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.Reader;
import java.io.UnsupportedEncodingException;
import java.nio.charset.StandardCharsets;
import net.sourceforge.plantuml.file.AFile;
import net.sourceforge.plantuml.log.Logme;
import net.sourceforge.plantuml.preproc.FileWithSuffix;
import net.sourceforge.plantuml.preproc.ImportedFiles;
import net.sourceforge.plantuml.preproc.ReadLine;
import net.sourceforge.plantuml.preproc.ReadLineReader;
import net.sourceforge.plantuml.preproc2.PreprocessorUtils;
import net.sourceforge.plantuml.security.SURL;
import net.sourceforge.plantuml.text.StringLocated;
import net.sourceforge.plantuml.theme.ThemeUtils;
import net.sourceforge.plantuml.tim.Eater;
import net.sourceforge.plantuml.tim.EaterException;
import net.sourceforge.plantuml.tim.TContext;
import net.sourceforge.plantuml.tim.TMemory;

public class EaterTheme
extends Eater {
    private String realName;
    private String name;
    private String from;
    private TContext context;
    private final ImportedFiles importedFiles;

    public EaterTheme(StringLocated s, ImportedFiles importedFiles) {
        super(s);
        this.importedFiles = importedFiles;
    }

    @Override
    public void analyze(TContext context, TMemory memory) throws EaterException {
        this.skipSpaces();
        this.checkAndEatChar("!theme");
        this.skipSpaces();
        this.name = this.eatAllToEnd();
        int x = this.name.toLowerCase().indexOf(" from ");
        if (x != -1) {
            String fromTmp = this.name.substring(x + " from ".length()).trim();
            this.from = context.applyFunctionsAndVariables(memory, new StringLocated(fromTmp, this.getLineLocation()));
            this.name = this.name.substring(0, x).trim();
            this.context = context;
        }
        this.realName = context.applyFunctionsAndVariables(memory, new StringLocated(this.name, this.getLineLocation()));
    }

    public final ReadLine getTheme() throws EaterException {
        if (this.from == null) {
            try {
                BufferedReader br;
                ReadLine reader = ThemeUtils.getReaderTheme(this.realName);
                if (reader != null) {
                    return reader;
                }
                AFile localFile = this.importedFiles.getAFile(ThemeUtils.getFilename(this.realName));
                if (localFile != null && localFile.isOk() && (br = localFile.getUnderlyingFile().openBufferedReader()) != null) {
                    return ReadLineReader.create(br, "theme " + this.realName);
                }
            }
            catch (IOException e) {
                Logme.error(e);
            }
            throw new EaterException("Cannot load " + this.realName, this.getStringLocated());
        }
        if (this.from.startsWith("<") && this.from.endsWith(">")) {
            ReadLine reader = ThemeUtils.getReaderTheme(this.realName, this.from);
            if (reader == null) {
                throw new EaterException("No such theme " + this.realName + " in " + this.from, this.getStringLocated());
            }
            return reader;
        }
        if (this.from.startsWith("http://") || this.from.startsWith("https://")) {
            SURL url = SURL.create(ThemeUtils.getFullPath(this.from, this.realName));
            if (url == null) {
                throw new EaterException("Cannot open URL", this.getStringLocated());
            }
            try {
                return PreprocessorUtils.getReaderInclude(url, this.getStringLocated(), StandardCharsets.UTF_8);
            }
            catch (UnsupportedEncodingException e) {
                Logme.error(e);
                throw new EaterException("Cannot decode charset", this.getStringLocated());
            }
        }
        try {
            FileWithSuffix file = this.context.getFileWithSuffix(this.from, this.realName);
            Reader tmp = file.getReader(StandardCharsets.UTF_8);
            if (tmp == null) {
                throw new EaterException("No such theme " + this.realName, this.getStringLocated());
            }
            return ReadLineReader.create(tmp, "theme " + this.realName);
        }
        catch (IOException e) {
            Logme.error(e);
            throw new EaterException("Cannot load " + this.realName, this.getStringLocated());
        }
    }

    public String getName() {
        return this.name;
    }
}

