/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.plantuml.dedication;

import net.sourceforge.plantuml.argon2.Argon2;
import net.sourceforge.plantuml.argon2.Argon2Factory;
import net.sourceforge.plantuml.argon2.model.Argon2Type;
import net.sourceforge.plantuml.dedication.BlumBlumShub;
import net.sourceforge.plantuml.utils.MTRandom;

public class Noise {
    private static Argon2 argon2(byte[] buffer, byte[] salt) {
        Argon2 argon = Argon2Factory.create().setType(Argon2Type.Argon2id).setMemory(8).setSalt((byte[])salt.clone()).setIterations(50).setPassword((byte[])buffer.clone());
        argon.hashNow();
        return argon;
    }

    public static String computeArgon2String(byte[] buffer, byte[] salt) {
        return Noise.argon2(buffer, salt).getOutputString();
    }

    public static byte[] computeArgon2bytes(byte[] buffer, byte[] salt) {
        return Noise.argon2(buffer, salt).getOutput();
    }

    public static int shortHash(byte[] buffer, byte[] salt) {
        byte[] hash = Noise.argon2(buffer, salt).getOutput();
        int result = 0;
        for (byte b : hash) {
            int b1 = b & 0xF;
            int b2 = (b & 0xF0) >> 4;
            result ^= b1 ^ b2;
        }
        return result;
    }

    public static void shuffle(byte[] buffer, MTRandom rnd) {
        for (int i = 0; i < buffer.length; ++i) {
            int r1 = rnd.nextInt();
            int r2 = rnd.nextInt();
            int a = Math.abs(r1) % buffer.length;
            int b = Math.abs(r2) % buffer.length;
            byte tmp = buffer[a];
            buffer[a] = buffer[b];
            buffer[b] = tmp;
        }
    }

    public static void xor(byte[] buffer, byte[] xor) {
        for (int i = 0; i < buffer.length; ++i) {
            int n = i;
            buffer[n] = (byte)(buffer[n] ^ xor[i % xor.length]);
        }
    }

    public static void xor(byte[] buffer, BlumBlumShub rnd) {
        for (int i = 0; i < buffer.length; ++i) {
            byte mask = (byte)(rnd.nextRnd(8) & 0xFF);
            buffer[i] = (byte)(buffer[i] ^ mask);
        }
    }

    public static byte[] reverse(byte[] buffer, int delta) {
        delta = Math.abs(delta) % buffer.length;
        byte[] result = new byte[buffer.length];
        for (int i = 0; i < buffer.length; ++i) {
            result[i] = buffer[(buffer.length - 1 - i + delta) % buffer.length];
        }
        return result;
    }
}

