/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.plantuml.real;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import net.sourceforge.plantuml.real.AbstractReal;
import net.sourceforge.plantuml.real.Real;
import net.sourceforge.plantuml.real.RealDelta;
import net.sourceforge.plantuml.real.RealMax;

class RealMin
extends AbstractReal
implements Real {
    private final List<Real> all = new ArrayList<Real>();

    RealMin(Collection<Real> reals) {
        super(RealMax.line(reals));
        this.all.addAll(reals);
    }

    @Override
    public String getName() {
        return "min " + this.all;
    }

    @Override
    double getCurrentValueInternal() {
        double result = this.all.get(0).getCurrentValue();
        for (int i = 1; i < this.all.size(); ++i) {
            double v = this.all.get(i).getCurrentValue();
            if (!(v < result)) continue;
            result = v;
        }
        return result;
    }

    @Override
    public Real addFixed(double delta) {
        return new RealDelta(this, delta);
    }

    @Override
    public Real addAtLeast(double delta) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void ensureBiggerThan(Real other) {
        for (Real r : this.all) {
            r.ensureBiggerThan(other);
        }
    }

    public int size() {
        return this.all.size();
    }

    @Override
    public void printCreationStackTrace() {
        throw new UnsupportedOperationException();
    }
}

