/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.plantuml.klimt.creole.legacy;

import java.util.Collections;
import java.util.List;
import net.sourceforge.plantuml.klimt.creole.CreoleContext;
import net.sourceforge.plantuml.klimt.creole.CreoleMode;
import net.sourceforge.plantuml.klimt.creole.Stripe;
import net.sourceforge.plantuml.klimt.creole.StripeStyle;
import net.sourceforge.plantuml.klimt.creole.StripeStyleType;
import net.sourceforge.plantuml.klimt.creole.atom.Atom;
import net.sourceforge.plantuml.klimt.creole.atom.AtomTree;
import net.sourceforge.plantuml.klimt.creole.atom.AtomWithMargin;
import net.sourceforge.plantuml.klimt.creole.legacy.StripeSimple;
import net.sourceforge.plantuml.klimt.creole.legacy.StripeTable;
import net.sourceforge.plantuml.klimt.font.FontConfiguration;
import net.sourceforge.plantuml.style.ISkinSimple;

public class StripeTree
implements Stripe {
    private FontConfiguration fontConfiguration;
    private final ISkinSimple skinParam;
    private final AtomTree tree;
    private final Atom marged;
    private final StripeStyle stripeStyle = new StripeStyle(StripeStyleType.TREE, 0, '\u0000');

    public StripeTree(FontConfiguration fontConfiguration, ISkinSimple skinParam, String line) {
        this.fontConfiguration = fontConfiguration;
        this.skinParam = skinParam;
        this.tree = new AtomTree(fontConfiguration.getColor());
        this.marged = new AtomWithMargin(this.tree, 2.0, 2.0);
        this.analyzeAndAdd(line);
    }

    @Override
    public List<Atom> getAtoms() {
        return Collections.singletonList(this.marged);
    }

    @Override
    public Atom getLHeader() {
        return null;
    }

    public void analyzeAndAdd(String line) {
        List<String> lines = StripeTable.getWithNewlinesInternal(line);
        for (String s : lines) {
            StripeSimple cell = new StripeSimple(this.fontConfiguration, this.stripeStyle, new CreoleContext(), this.skinParam, CreoleMode.FULL);
            String text = s.replaceFirst("^\\s*\\|_", "");
            int level = this.computeLevel(s);
            cell.analyzeAndAdd(text);
            this.tree.addCell(StripeTable.asAtom(Collections.singletonList(cell), 0.0), level);
        }
    }

    private int computeLevel(String s) {
        int result = 1;
        while (s.length() > 0) {
            if (s.startsWith("  ")) {
                ++result;
                s = s.substring(2);
                continue;
            }
            if (s.startsWith("\t")) {
                ++result;
                s = s.substring(1);
                continue;
            }
            return result;
        }
        return result;
    }
}

