/*
 * Decompiled with CFR 0.152.
 */
package org.semanticweb.owlapi.owlxml.parser;

import java.io.IOException;
import org.semanticweb.owlapi.formats.OWLXMLDocumentFormat;
import org.semanticweb.owlapi.formats.OWLXMLDocumentFormatFactory;
import org.semanticweb.owlapi.io.AbstractOWLParser;
import org.semanticweb.owlapi.io.OWLOntologyDocumentSource;
import org.semanticweb.owlapi.io.OWLOntologyInputSourceException;
import org.semanticweb.owlapi.io.OWLParserException;
import org.semanticweb.owlapi.model.OWLDocumentFormat;
import org.semanticweb.owlapi.model.OWLDocumentFormatFactory;
import org.semanticweb.owlapi.model.OWLOntology;
import org.semanticweb.owlapi.model.OWLOntologyLoaderConfiguration;
import org.semanticweb.owlapi.owlxml.parser.OWLXMLPH;
import org.semanticweb.owlapi.owlxml.parser.OWLXMLParserException;
import org.semanticweb.owlapi.util.SAXParsers;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.DefaultHandler;

public class OWLXMLParser
extends AbstractOWLParser {
    public OWLDocumentFormatFactory getSupportedFormat() {
        return new OWLXMLDocumentFormatFactory();
    }

    public OWLDocumentFormat parse(OWLOntologyDocumentSource documentSource, OWLOntology ontology, OWLOntologyLoaderConfiguration configuration) {
        try {
            OWLXMLDocumentFormat format = new OWLXMLDocumentFormat();
            InputSource isrc = this.getInputSource(documentSource, configuration);
            OWLXMLPH handler = new OWLXMLPH(ontology, configuration);
            SAXParsers.initParserWithOWLAPIStandards(null, (String)configuration.getEntityExpansionLimit()).parse(isrc, (DefaultHandler)handler);
            if (!handler.atLeastOneTagFound()) {
                throw new OWLXMLParserException(handler, "No known tags in the input: is the file an OWL/XML ontology?");
            }
            format.copyPrefixesFrom(handler.getPrefixName2PrefixMap());
            format.setDefaultPrefix(handler.getBase().toString());
            return format;
        }
        catch (IOException | IllegalStateException | OWLOntologyInputSourceException | SAXException e) {
            throw new OWLParserException(e);
        }
    }
}

