/*
 * Decompiled with CFR 0.152.
 */
package org.semanticweb.owlapi.manchestersyntax.parser;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;

public class ManchesterOWLSyntaxTokenizer {
    public static final String EOFTOKEN = "|EOF|";
    protected final Set<Character> skip = new HashSet<Character>();
    protected final Set<Character> commentDelimiters = new HashSet<Character>();
    protected final Set<Character> delims = new HashSet<Character>();
    private final String buffer;
    private int pos;
    private int col;
    private int row;
    int startPos = 0;
    int startCol = 1;
    int startRow = 1;
    List<Token> tokens = new ArrayList<Token>();
    private StringBuilder sb = new StringBuilder();
    private static final char ESCAPE_CHAR = '\\';

    public ManchesterOWLSyntaxTokenizer(String buffer) {
        this.buffer = buffer;
        this.skip.add(Character.valueOf(' '));
        this.skip.add(Character.valueOf('\n'));
        this.skip.add(Character.valueOf('\r'));
        this.skip.add(Character.valueOf('\t'));
        this.commentDelimiters.add(Character.valueOf('#'));
        this.commentDelimiters.add(Character.valueOf('*'));
        this.delims.add(Character.valueOf('('));
        this.delims.add(Character.valueOf(')'));
        this.delims.add(Character.valueOf('['));
        this.delims.add(Character.valueOf(']'));
        this.delims.add(Character.valueOf(','));
        this.delims.add(Character.valueOf('{'));
        this.delims.add(Character.valueOf('}'));
        this.delims.add(Character.valueOf('^'));
        this.delims.add(Character.valueOf('@'));
        this.delims.add(Character.valueOf('<'));
        this.delims.add(Character.valueOf('>'));
        this.delims.add(Character.valueOf('='));
        this.delims.add(Character.valueOf('?'));
    }

    public static boolean eof(String s) {
        return EOFTOKEN.equals(s);
    }

    private void reset() {
        this.sb = new StringBuilder();
        this.tokens.clear();
        this.startRow = 1;
        this.startCol = 1;
        this.startPos = 0;
        this.pos = 0;
        this.row = 1;
        this.col = 1;
    }

    public List<Token> tokenize() {
        this.reset();
        int bufferLen = this.buffer.length();
        char lastChar = ' ';
        while (this.pos < bufferLen) {
            lastChar = this.handleChar(lastChar);
        }
        this.consumeToken();
        this.tokens.add(new Token(EOFTOKEN, this.pos, this.col, this.row));
        return new ArrayList<Token>(this.tokens);
    }

    protected char handleChar(char last) {
        char lastChar = last;
        char ch = this.readChar();
        if (ch == '\\') {
            lastChar = ch;
            ch = this.readChar();
        }
        if (ch == '\"' && lastChar != '\\') {
            this.readString('\"', true);
        } else if (ch == '\'' && lastChar != '\\') {
            this.readString('\'', true);
        } else if (ch == '<') {
            this.readIRI();
        } else if (this.skip.contains(Character.valueOf(ch))) {
            this.consumeToken();
        } else if (this.commentDelimiters.contains(Character.valueOf(ch))) {
            this.consumeToken();
            this.readComment();
        } else if (this.delims.contains(Character.valueOf(ch))) {
            this.consumeToken();
            this.sb.append(ch);
            if (ch != '@') {
                this.consumeToken();
            }
        } else {
            this.sb.append(ch);
        }
        return ch;
    }

    private void consumeToken() {
        if (this.sb.length() > 0) {
            String string = this.sb.toString();
            this.tokens.add(new Token(string, this.startPos, this.startCol, this.startRow));
            this.sb = new StringBuilder();
        }
        this.startPos = this.pos;
        this.startCol = this.col;
        this.startRow = this.row;
    }

    private void readComment() {
        int ch = 35;
        while (ch != 10 && this.pos < this.buffer.length()) {
            ch = this.readChar();
        }
        this.consumeToken();
    }

    private void readString(char terminator, boolean appendTerminator) {
        if (appendTerminator) {
            this.sb.append(terminator);
        }
        while (this.pos < this.buffer.length()) {
            char ch = this.readChar();
            if (ch == '\\') {
                int j = this.pos + 1;
                this.handleEscapeChar(ch, j);
                continue;
            }
            if (ch == terminator) {
                if (!appendTerminator) break;
                this.sb.append(ch);
                break;
            }
            this.sb.append(ch);
        }
        this.consumeToken();
    }

    protected void handleEscapeChar(char ch, int j) {
        if (j < this.buffer.length()) {
            char escapedChar = this.readChar();
            if (escapedChar == '\"' || escapedChar == '\'' || escapedChar == '\\') {
                this.sb.append(escapedChar);
            } else {
                this.sb.append(ch);
                this.sb.append(escapedChar);
            }
        } else {
            this.sb.append('\\');
        }
    }

    private void readIRI() {
        this.sb = new StringBuilder("<");
        int startPos1 = this.pos;
        while (this.pos < this.buffer.length()) {
            char ch = this.readChar();
            if (Character.isWhitespace(ch)) {
                this.pos = startPos1;
                this.sb = new StringBuilder("<");
                this.consumeToken();
                return;
            }
            if (ch == '>') {
                this.sb.append('>');
                this.consumeToken();
                return;
            }
            this.sb.append(ch);
        }
    }

    private char readChar() {
        char ch = this.buffer.charAt(this.pos);
        ++this.pos;
        ++this.col;
        if (ch == '\n') {
            ++this.row;
            this.col = 0;
        }
        return ch;
    }

    public static class Token {
        private final String currentToken;
        private final int pos;
        private final int col;
        private final int row;

        public Token(String token, int pos, int col, int row) {
            this.currentToken = token;
            this.pos = pos;
            this.col = col;
            this.row = row;
        }

        public String getToken() {
            return this.currentToken;
        }

        public int getPos() {
            return this.pos;
        }

        public int getCol() {
            return this.col;
        }

        public int getRow() {
            return this.row;
        }

        public String toString() {
            return this.currentToken + " [" + this.pos + ", " + this.col + ", " + this.row + ']';
        }
    }
}

