/*
 * Decompiled with CFR 0.152.
 */
package org.semanticweb.owlapi.functional.renderer;

import java.io.IOException;
import java.io.Writer;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Stream;
import javax.annotation.Nullable;
import org.semanticweb.owlapi.formats.PrefixDocumentFormat;
import org.semanticweb.owlapi.model.AxiomType;
import org.semanticweb.owlapi.model.IRI;
import org.semanticweb.owlapi.model.OWLAnnotation;
import org.semanticweb.owlapi.model.OWLAnnotationAssertionAxiom;
import org.semanticweb.owlapi.model.OWLAnnotationProperty;
import org.semanticweb.owlapi.model.OWLAnnotationPropertyDomainAxiom;
import org.semanticweb.owlapi.model.OWLAnnotationPropertyRangeAxiom;
import org.semanticweb.owlapi.model.OWLAnnotationSubject;
import org.semanticweb.owlapi.model.OWLAnonymousIndividual;
import org.semanticweb.owlapi.model.OWLAsymmetricObjectPropertyAxiom;
import org.semanticweb.owlapi.model.OWLAxiom;
import org.semanticweb.owlapi.model.OWLCardinalityRestriction;
import org.semanticweb.owlapi.model.OWLClass;
import org.semanticweb.owlapi.model.OWLClassAssertionAxiom;
import org.semanticweb.owlapi.model.OWLClassExpression;
import org.semanticweb.owlapi.model.OWLDataAllValuesFrom;
import org.semanticweb.owlapi.model.OWLDataComplementOf;
import org.semanticweb.owlapi.model.OWLDataExactCardinality;
import org.semanticweb.owlapi.model.OWLDataFactory;
import org.semanticweb.owlapi.model.OWLDataHasValue;
import org.semanticweb.owlapi.model.OWLDataIntersectionOf;
import org.semanticweb.owlapi.model.OWLDataMaxCardinality;
import org.semanticweb.owlapi.model.OWLDataMinCardinality;
import org.semanticweb.owlapi.model.OWLDataOneOf;
import org.semanticweb.owlapi.model.OWLDataProperty;
import org.semanticweb.owlapi.model.OWLDataPropertyAssertionAxiom;
import org.semanticweb.owlapi.model.OWLDataPropertyDomainAxiom;
import org.semanticweb.owlapi.model.OWLDataPropertyExpression;
import org.semanticweb.owlapi.model.OWLDataPropertyRangeAxiom;
import org.semanticweb.owlapi.model.OWLDataRange;
import org.semanticweb.owlapi.model.OWLDataSomeValuesFrom;
import org.semanticweb.owlapi.model.OWLDataUnionOf;
import org.semanticweb.owlapi.model.OWLDatatype;
import org.semanticweb.owlapi.model.OWLDatatypeDefinitionAxiom;
import org.semanticweb.owlapi.model.OWLDatatypeRestriction;
import org.semanticweb.owlapi.model.OWLDeclarationAxiom;
import org.semanticweb.owlapi.model.OWLDifferentIndividualsAxiom;
import org.semanticweb.owlapi.model.OWLDisjointClassesAxiom;
import org.semanticweb.owlapi.model.OWLDisjointDataPropertiesAxiom;
import org.semanticweb.owlapi.model.OWLDisjointObjectPropertiesAxiom;
import org.semanticweb.owlapi.model.OWLDisjointUnionAxiom;
import org.semanticweb.owlapi.model.OWLDocumentFormat;
import org.semanticweb.owlapi.model.OWLEntity;
import org.semanticweb.owlapi.model.OWLEntityVisitorEx;
import org.semanticweb.owlapi.model.OWLEquivalentClassesAxiom;
import org.semanticweb.owlapi.model.OWLEquivalentDataPropertiesAxiom;
import org.semanticweb.owlapi.model.OWLEquivalentObjectPropertiesAxiom;
import org.semanticweb.owlapi.model.OWLFacetRestriction;
import org.semanticweb.owlapi.model.OWLFunctionalDataPropertyAxiom;
import org.semanticweb.owlapi.model.OWLFunctionalObjectPropertyAxiom;
import org.semanticweb.owlapi.model.OWLHasKeyAxiom;
import org.semanticweb.owlapi.model.OWLIndividual;
import org.semanticweb.owlapi.model.OWLInverseFunctionalObjectPropertyAxiom;
import org.semanticweb.owlapi.model.OWLInverseObjectPropertiesAxiom;
import org.semanticweb.owlapi.model.OWLIrreflexiveObjectPropertyAxiom;
import org.semanticweb.owlapi.model.OWLLiteral;
import org.semanticweb.owlapi.model.OWLNamedIndividual;
import org.semanticweb.owlapi.model.OWLNegativeDataPropertyAssertionAxiom;
import org.semanticweb.owlapi.model.OWLNegativeObjectPropertyAssertionAxiom;
import org.semanticweb.owlapi.model.OWLObject;
import org.semanticweb.owlapi.model.OWLObjectAllValuesFrom;
import org.semanticweb.owlapi.model.OWLObjectComplementOf;
import org.semanticweb.owlapi.model.OWLObjectExactCardinality;
import org.semanticweb.owlapi.model.OWLObjectHasSelf;
import org.semanticweb.owlapi.model.OWLObjectHasValue;
import org.semanticweb.owlapi.model.OWLObjectIntersectionOf;
import org.semanticweb.owlapi.model.OWLObjectInverseOf;
import org.semanticweb.owlapi.model.OWLObjectMaxCardinality;
import org.semanticweb.owlapi.model.OWLObjectMinCardinality;
import org.semanticweb.owlapi.model.OWLObjectOneOf;
import org.semanticweb.owlapi.model.OWLObjectProperty;
import org.semanticweb.owlapi.model.OWLObjectPropertyAssertionAxiom;
import org.semanticweb.owlapi.model.OWLObjectPropertyDomainAxiom;
import org.semanticweb.owlapi.model.OWLObjectPropertyExpression;
import org.semanticweb.owlapi.model.OWLObjectPropertyRangeAxiom;
import org.semanticweb.owlapi.model.OWLObjectSomeValuesFrom;
import org.semanticweb.owlapi.model.OWLObjectUnionOf;
import org.semanticweb.owlapi.model.OWLObjectVisitor;
import org.semanticweb.owlapi.model.OWLOntology;
import org.semanticweb.owlapi.model.OWLOntologyManager;
import org.semanticweb.owlapi.model.OWLOntologySetProvider;
import org.semanticweb.owlapi.model.OWLPropertyExpression;
import org.semanticweb.owlapi.model.OWLPropertyRange;
import org.semanticweb.owlapi.model.OWLQuantifiedDataRestriction;
import org.semanticweb.owlapi.model.OWLQuantifiedObjectRestriction;
import org.semanticweb.owlapi.model.OWLReflexiveObjectPropertyAxiom;
import org.semanticweb.owlapi.model.OWLRuntimeException;
import org.semanticweb.owlapi.model.OWLSameIndividualAxiom;
import org.semanticweb.owlapi.model.OWLSubAnnotationPropertyOfAxiom;
import org.semanticweb.owlapi.model.OWLSubClassOfAxiom;
import org.semanticweb.owlapi.model.OWLSubDataPropertyOfAxiom;
import org.semanticweb.owlapi.model.OWLSubObjectPropertyOfAxiom;
import org.semanticweb.owlapi.model.OWLSubPropertyChainOfAxiom;
import org.semanticweb.owlapi.model.OWLSymmetricObjectPropertyAxiom;
import org.semanticweb.owlapi.model.OWLTransitiveObjectPropertyAxiom;
import org.semanticweb.owlapi.model.PrefixManager;
import org.semanticweb.owlapi.model.SWRLBuiltInAtom;
import org.semanticweb.owlapi.model.SWRLClassAtom;
import org.semanticweb.owlapi.model.SWRLDArgument;
import org.semanticweb.owlapi.model.SWRLDataPropertyAtom;
import org.semanticweb.owlapi.model.SWRLDataRangeAtom;
import org.semanticweb.owlapi.model.SWRLDifferentIndividualsAtom;
import org.semanticweb.owlapi.model.SWRLIArgument;
import org.semanticweb.owlapi.model.SWRLIndividualArgument;
import org.semanticweb.owlapi.model.SWRLLiteralArgument;
import org.semanticweb.owlapi.model.SWRLObjectPropertyAtom;
import org.semanticweb.owlapi.model.SWRLRule;
import org.semanticweb.owlapi.model.SWRLSameIndividualAtom;
import org.semanticweb.owlapi.model.SWRLVariable;
import org.semanticweb.owlapi.model.parameters.Imports;
import org.semanticweb.owlapi.util.AnnotationValueShortFormProvider;
import org.semanticweb.owlapi.util.CollectionFactory;
import org.semanticweb.owlapi.util.DefaultPrefixManager;
import org.semanticweb.owlapi.util.EscapeUtils;
import org.semanticweb.owlapi.util.OWLAPIPreconditions;
import org.semanticweb.owlapi.util.OWLAPIStreamUtils;
import org.semanticweb.owlapi.util.ShortFormProvider;
import org.semanticweb.owlapi.vocab.OWLRDFVocabulary;
import org.semanticweb.owlapi.vocab.OWLXMLVocabulary;

public class FunctionalSyntaxObjectRenderer
implements OWLObjectVisitor {
    private DefaultPrefixManager defaultPrefixManager;
    private PrefixManager prefixManager;
    protected final OWLOntology ont;
    private final Writer writer;
    private boolean writeEntitiesAsURIs = true;
    private boolean addMissingDeclarations = true;
    @Nullable
    protected AnnotationValueShortFormProvider labelMaker = null;

    public FunctionalSyntaxObjectRenderer(OWLOntology ontology, Writer writer) {
        this.ont = ontology;
        this.writer = writer;
        this.defaultPrefixManager = new DefaultPrefixManager();
        this.prefixManager = this.defaultPrefixManager;
        OWLDocumentFormat ontologyFormat = ontology.getNonnullFormat();
        this.addMissingDeclarations = ontologyFormat.isAddMissingTypes();
        if (ontologyFormat instanceof PrefixDocumentFormat) {
            this.prefixManager.copyPrefixesFrom((PrefixManager)((PrefixDocumentFormat)ontologyFormat));
            this.prefixManager.setPrefixComparator(((PrefixDocumentFormat)ontologyFormat).getPrefixComparator());
        }
        if (!ontology.isAnonymous() && this.prefixManager.getDefaultPrefix() == null) {
            String existingDefault = this.prefixManager.getDefaultPrefix();
            String ontologyIRIString = ((IRI)ontology.getOntologyID().getOntologyIRI().get()).toString();
            if (existingDefault == null || !existingDefault.startsWith(ontologyIRIString)) {
                String defaultPrefix = ontologyIRIString;
                if (!ontologyIRIString.endsWith("/")) {
                    defaultPrefix = ontologyIRIString + '#';
                }
                this.prefixManager.setDefaultPrefix(defaultPrefix);
            }
        }
        HashMap prefLangMap = new HashMap();
        OWLOntologyManager manager = ontology.getOWLOntologyManager();
        OWLDataFactory df = manager.getOWLDataFactory();
        OWLAnnotationProperty labelProp = df.getOWLAnnotationProperty(OWLRDFVocabulary.RDFS_LABEL.getIRI());
        this.labelMaker = new AnnotationValueShortFormProvider(Collections.singletonList(labelProp), prefLangMap, (OWLOntologySetProvider)manager, (ShortFormProvider)this.defaultPrefixManager);
    }

    public void setAddMissingDeclarations(boolean flag) {
        this.addMissingDeclarations = flag;
    }

    public void setPrefixManager(PrefixManager prefixManager) {
        this.prefixManager = prefixManager;
        if (prefixManager instanceof DefaultPrefixManager) {
            this.defaultPrefixManager = (DefaultPrefixManager)prefixManager;
        }
    }

    protected void writePrefix(String prefix, String namespace) {
        this.write("Prefix");
        this.writeOpenBracket();
        this.write(prefix);
        this.write("=");
        this.write("<");
        this.write(namespace);
        this.write(">");
        this.writeCloseBracket();
        this.writeReturn();
    }

    protected void writePrefixes() {
        this.prefixManager.getPrefixName2PrefixMap().forEach((k, v) -> this.writePrefix((String)k, (String)v));
    }

    private void write(OWLXMLVocabulary v) {
        this.write(v.getShortForm());
    }

    private void write(String s) {
        try {
            this.writer.write(s);
        }
        catch (IOException e) {
            throw new OWLRuntimeException((Throwable)e);
        }
    }

    private void flush() {
        try {
            this.writer.flush();
        }
        catch (IOException e) {
            throw new OWLRuntimeException((Throwable)e);
        }
    }

    private void write(IRI iri) {
        String qname = this.prefixManager.getPrefixIRI(iri);
        if (qname != null) {
            boolean lastCharIsColon;
            boolean bl = lastCharIsColon = qname.charAt(qname.length() - 1) == ':';
            if (!lastCharIsColon) {
                this.write(qname);
                return;
            }
        }
        this.writeFullIRI(iri);
    }

    private void writeFullIRI(IRI iri) {
        this.write("<");
        this.write(iri.toString());
        this.write(">");
    }

    public void visit(OWLOntology ontology) {
        this.writePrefixes();
        this.writeReturn();
        this.writeReturn();
        this.write(OWLXMLVocabulary.ONTOLOGY);
        this.writeOpenBracket();
        if (!ontology.isAnonymous()) {
            this.writeFullIRI((IRI)ontology.getOntologyID().getOntologyIRI().get());
            Optional versionIRI = ontology.getOntologyID().getVersionIRI();
            if (versionIRI.isPresent()) {
                this.writeReturn();
                this.writeFullIRI((IRI)versionIRI.get());
            }
            this.writeReturn();
        }
        ontology.importsDeclarations().forEach(decl -> {
            this.write(OWLXMLVocabulary.IMPORT);
            this.writeOpenBracket();
            this.writeFullIRI(decl.getIRI());
            this.writeCloseBracket();
            this.writeReturn();
        });
        CollectionFactory.sortOptionally((Stream)ontology.annotations()).forEach(this::acceptAndReturn);
        this.writeReturn();
        HashSet<OWLAxiom> writtenAxioms = new HashSet<OWLAxiom>();
        List signature = CollectionFactory.sortOptionally((Stream)ontology.signature());
        Collection illegals = OWLDocumentFormat.determineIllegalPunnings((boolean)this.addMissingDeclarations, signature.stream(), (Collection)this.ont.getPunnedIRIs(Imports.INCLUDED));
        signature.forEach(e -> this.writeDeclarations((OWLEntity)e, (Set<OWLAxiom>)writtenAxioms, illegals));
        this.writeSortedEntities("Annotation Properties", "Annotation Property", ontology.annotationPropertiesInSignature(Imports.EXCLUDED), writtenAxioms);
        this.writeSortedEntities("Object Properties", "Object Property", ontology.objectPropertiesInSignature(Imports.EXCLUDED), writtenAxioms);
        this.writeSortedEntities("Data Properties", "Data Property", ontology.dataPropertiesInSignature(Imports.EXCLUDED), writtenAxioms);
        this.writeSortedEntities("Datatypes", "Datatype", ontology.datatypesInSignature(Imports.EXCLUDED), writtenAxioms);
        this.writeSortedEntities("Classes", "Class", ontology.classesInSignature(Imports.EXCLUDED), writtenAxioms);
        this.writeSortedEntities("Named Individuals", "Individual", ontology.individualsInSignature(Imports.EXCLUDED), writtenAxioms);
        signature.forEach(e -> this.writeAxioms((OWLEntity)e, (Set<OWLAxiom>)writtenAxioms));
        CollectionFactory.sortOptionally(ontology.axioms().filter(ax -> !writtenAxioms.contains(ax))).forEach(this::acceptAndReturn);
        this.writeCloseBracket();
        this.flush();
    }

    private void writeSortedEntities(String bannerComment, String entityTypeName, Stream<? extends OWLEntity> entities, Set<OWLAxiom> writtenAxioms) {
        List sortOptionally = CollectionFactory.sortOptionally(entities);
        if (!sortOptionally.isEmpty()) {
            this.writeEntities(bannerComment, entityTypeName, sortOptionally, writtenAxioms);
            this.writeReturn();
        }
    }

    private void writeln(String s) {
        this.write(s);
        this.writeReturn();
    }

    private void writeEntities(String comment, String entityTypeName, List<? extends OWLEntity> entities, Set<OWLAxiom> writtenAxioms) {
        boolean haveWrittenBanner = false;
        for (OWLEntity oWLEntity : entities) {
            List axiomsForEntity = OWLAPIStreamUtils.asList(this.getUnsortedAxiomsForEntity(oWLEntity).filter(ax -> !writtenAxioms.contains(ax)));
            List list = OWLAPIStreamUtils.asList(this.ont.annotationAssertionAxioms((OWLAnnotationSubject)oWLEntity.getIRI()).filter(ax -> !writtenAxioms.contains(ax)));
            if (axiomsForEntity.isEmpty() && list.isEmpty()) continue;
            if (!haveWrittenBanner) {
                this.writeln("############################");
                this.writeln("#   " + comment);
                this.writeln("############################");
                this.writeReturn();
                haveWrittenBanner = true;
            }
            this.writeEntity2(oWLEntity, entityTypeName, CollectionFactory.sortOptionally((List)axiomsForEntity), CollectionFactory.sortOptionally((List)list), writtenAxioms);
        }
    }

    protected Set<OWLAxiom> writeAxioms(OWLEntity entity) {
        HashSet<OWLAxiom> writtenAxioms = new HashSet<OWLAxiom>();
        this.writeAxioms(entity, writtenAxioms);
        return writtenAxioms;
    }

    protected Set<OWLAxiom> writeEntity(OWLEntity entity) {
        HashSet<OWLAxiom> writtenAxioms = new HashSet<OWLAxiom>();
        this.writeEntity(entity, writtenAxioms);
        return writtenAxioms;
    }

    protected void writeEntity(OWLEntity entity, Set<OWLAxiom> alreadyWrittenAxioms) {
        this.writeEntity2(entity, "", CollectionFactory.sortOptionally(this.getUnsortedAxiomsForEntity(entity)), CollectionFactory.sortOptionally((Stream)this.ont.annotationAssertionAxioms((OWLAnnotationSubject)entity.getIRI())), alreadyWrittenAxioms);
    }

    protected void writeEntity2(OWLEntity entity, String entityTypeName, List<? extends OWLAxiom> axiomsForEntity, List<OWLAnnotationAssertionAxiom> annotationAssertionAxioms, Set<OWLAxiom> alreadyWrittenAxioms) {
        this.writeln("# " + entityTypeName + ": " + this.getIRIString(entity) + " (" + this.getEntityLabel(entity) + ")");
        this.writeReturn();
        annotationAssertionAxioms.stream().filter(alreadyWrittenAxioms::add).forEach(this::acceptAndReturn);
        axiomsForEntity.stream().filter(this::shouldWrite).filter(alreadyWrittenAxioms::add).forEach(this::acceptAndReturn);
        this.writeReturn();
    }

    private boolean shouldWrite(OWLAxiom ax) {
        if (ax.getAxiomType().equals((Object)AxiomType.DIFFERENT_INDIVIDUALS)) {
            return false;
        }
        return !ax.getAxiomType().equals((Object)AxiomType.DISJOINT_CLASSES) || ((OWLDisjointClassesAxiom)ax).classExpressions().count() <= 2L;
    }

    private Stream<? extends OWLAxiom> getUnsortedAxiomsForEntity(OWLEntity entity) {
        return (Stream)entity.accept((OWLEntityVisitorEx)new AxiomRetriever());
    }

    private String getIRIString(OWLEntity entity) {
        return this.defaultPrefixManager.getShortForm(entity);
    }

    private String getEntityLabel(OWLEntity entity) {
        return ((AnnotationValueShortFormProvider)OWLAPIPreconditions.verifyNotNull((Object)this.labelMaker, (String)"labelMaker has not been set yet")).getShortForm(entity);
    }

    private void writeAxioms(OWLEntity entity, Set<OWLAxiom> alreadyWrittenAxioms) {
        this.writeAnnotations(entity, alreadyWrittenAxioms);
        ArrayList writtenAxioms = new ArrayList();
        Stream<OWLAxiom> stream = this.getUnsortedAxiomsForEntity(entity).filter(alreadyWrittenAxioms::contains).filter(ax -> ax.getAxiomType().equals((Object)AxiomType.DIFFERENT_INDIVIDUALS)).filter(ax -> ax.getAxiomType().equals((Object)AxiomType.DISJOINT_CLASSES) && ((OWLDisjointClassesAxiom)ax).classExpressions().count() > 2L);
        CollectionFactory.sortOptionally(stream).forEach(ax -> {
            ax.accept((OWLObjectVisitor)this);
            writtenAxioms.add(ax);
            this.writeReturn();
        });
        alreadyWrittenAxioms.addAll(writtenAxioms);
    }

    protected Set<OWLAxiom> writeDeclarations(OWLEntity entity) {
        HashSet<OWLAxiom> axioms = new HashSet<OWLAxiom>();
        CollectionFactory.sortOptionally((Stream)this.ont.declarationAxioms(entity)).forEach(ax -> {
            ax.accept((OWLObjectVisitor)this);
            axioms.add((OWLAxiom)ax);
            this.writeReturn();
        });
        return axioms;
    }

    private void writeDeclarations(OWLEntity entity, Set<OWLAxiom> alreadyWrittenAxioms, Collection<IRI> illegals) {
        List axioms = CollectionFactory.sortOptionally((Stream)this.ont.declarationAxioms(entity));
        axioms.stream().filter(alreadyWrittenAxioms::add).forEach(this::acceptAndReturn);
        if (this.addMissingDeclarations && axioms.isEmpty() && !entity.isBuiltIn() && !illegals.contains(entity.getIRI()) && !this.ont.isDeclared(entity, Imports.INCLUDED)) {
            OWLDeclarationAxiom declaration = this.ont.getOWLOntologyManager().getOWLDataFactory().getOWLDeclarationAxiom(entity);
            this.acceptAndReturn((OWLObject)declaration);
        }
    }

    protected void acceptAndReturn(OWLObject ax) {
        ax.accept((OWLObjectVisitor)this);
        this.writeReturn();
    }

    protected void acceptAndSpace(OWLObject ax) {
        ax.accept((OWLObjectVisitor)this);
        this.writeSpace();
    }

    protected void spaceAndAccept(OWLObject ax) {
        this.writeSpace();
        ax.accept((OWLObjectVisitor)this);
    }

    protected void writeAnnotations(OWLEntity entity, Set<OWLAxiom> alreadyWrittenAxioms) {
        CollectionFactory.sortOptionally(this.ont.annotationAssertionAxioms((OWLAnnotationSubject)entity.getIRI()).filter(alreadyWrittenAxioms::add)).forEach(this::acceptAndReturn);
    }

    protected void write(OWLXMLVocabulary v, OWLObject o) {
        this.write(v);
        this.writeOpenBracket();
        o.accept((OWLObjectVisitor)this);
        this.writeCloseBracket();
    }

    private void write(Stream<? extends OWLObject> objects) {
        this.write(OWLAPIStreamUtils.asList(objects));
    }

    private void write(List<? extends OWLObject> objects) {
        for (int i = 0; i < objects.size(); ++i) {
            if (i > 0) {
                this.writeSpace();
            }
            objects.get(i).accept((OWLObjectVisitor)this);
        }
    }

    protected void writeOpenBracket() {
        this.write("(");
    }

    protected void writeCloseBracket() {
        this.write(")");
    }

    protected void writeSpace() {
        this.write(" ");
    }

    protected void writeReturn() {
        this.write("\n");
    }

    protected void writeAnnotations(OWLAxiom ax) {
        ax.annotations().forEach(this::acceptAndSpace);
    }

    protected void writeAxiomStart(OWLXMLVocabulary v, OWLAxiom axiom) {
        this.write(v);
        this.writeOpenBracket();
        this.writeAnnotations(axiom);
    }

    protected void writeAxiomEnd() {
        this.writeCloseBracket();
    }

    protected void writePropertyCharacteristic(OWLXMLVocabulary v, OWLAxiom ax, OWLPropertyExpression prop) {
        this.writeAxiomStart(v, ax);
        prop.accept((OWLObjectVisitor)this);
        this.writeAxiomEnd();
    }

    public void visit(OWLAsymmetricObjectPropertyAxiom axiom) {
        this.writePropertyCharacteristic(OWLXMLVocabulary.ASYMMETRIC_OBJECT_PROPERTY, (OWLAxiom)axiom, (OWLPropertyExpression)axiom.getProperty());
    }

    public void visit(OWLClassAssertionAxiom axiom) {
        this.writeAxiomStart(OWLXMLVocabulary.CLASS_ASSERTION, (OWLAxiom)axiom);
        this.acceptAndSpace((OWLObject)axiom.getClassExpression());
        axiom.getIndividual().accept((OWLObjectVisitor)this);
        this.writeAxiomEnd();
    }

    public void visit(OWLDataPropertyAssertionAxiom axiom) {
        this.writeAxiomStart(OWLXMLVocabulary.DATA_PROPERTY_ASSERTION, (OWLAxiom)axiom);
        this.acceptAndSpace((OWLObject)axiom.getProperty());
        this.acceptAndSpace((OWLObject)axiom.getSubject());
        ((OWLLiteral)axiom.getObject()).accept((OWLObjectVisitor)this);
        this.writeAxiomEnd();
    }

    public void visit(OWLDataPropertyDomainAxiom axiom) {
        this.writeAxiomStart(OWLXMLVocabulary.DATA_PROPERTY_DOMAIN, (OWLAxiom)axiom);
        this.acceptAndSpace(axiom.getProperty());
        ((OWLClassExpression)axiom.getDomain()).accept((OWLObjectVisitor)this);
        this.writeAxiomEnd();
    }

    public void visit(OWLDataPropertyRangeAxiom axiom) {
        this.writeAxiomStart(OWLXMLVocabulary.DATA_PROPERTY_RANGE, (OWLAxiom)axiom);
        this.acceptAndSpace(axiom.getProperty());
        ((OWLDataRange)axiom.getRange()).accept((OWLObjectVisitor)this);
        this.writeAxiomEnd();
    }

    public void visit(OWLSubDataPropertyOfAxiom axiom) {
        this.writeAxiomStart(OWLXMLVocabulary.SUB_DATA_PROPERTY_OF, (OWLAxiom)axiom);
        this.acceptAndSpace((OWLObject)axiom.getSubProperty());
        ((OWLDataPropertyExpression)axiom.getSuperProperty()).accept((OWLObjectVisitor)this);
        this.writeAxiomEnd();
    }

    public void visit(OWLDeclarationAxiom axiom) {
        this.writeAxiomStart(OWLXMLVocabulary.DECLARATION, (OWLAxiom)axiom);
        this.writeEntitiesAsURIs = false;
        axiom.getEntity().accept((OWLObjectVisitor)this);
        this.writeEntitiesAsURIs = true;
        this.writeAxiomEnd();
    }

    public void visit(OWLDifferentIndividualsAxiom axiom) {
        List individuals = OWLAPIStreamUtils.asList((Stream)axiom.individuals());
        if (individuals.size() < 2) {
            return;
        }
        this.writeAxiomStart(OWLXMLVocabulary.DIFFERENT_INDIVIDUALS, (OWLAxiom)axiom);
        this.write(individuals);
        this.writeAxiomEnd();
    }

    public void visit(OWLDisjointClassesAxiom axiom) {
        List classExpressions = OWLAPIStreamUtils.asList((Stream)axiom.classExpressions());
        if (classExpressions.size() < 2) {
            return;
        }
        this.writeAxiomStart(OWLXMLVocabulary.DISJOINT_CLASSES, (OWLAxiom)axiom);
        this.write(classExpressions);
        this.writeAxiomEnd();
    }

    public void visit(OWLDisjointDataPropertiesAxiom axiom) {
        List properties = OWLAPIStreamUtils.asList((Stream)axiom.properties());
        if (properties.size() < 2) {
            return;
        }
        this.writeAxiomStart(OWLXMLVocabulary.DISJOINT_DATA_PROPERTIES, (OWLAxiom)axiom);
        this.write(properties);
        this.writeAxiomEnd();
    }

    public void visit(OWLDisjointObjectPropertiesAxiom axiom) {
        List properties = OWLAPIStreamUtils.asList((Stream)axiom.properties());
        if (properties.size() < 2) {
            return;
        }
        this.writeAxiomStart(OWLXMLVocabulary.DISJOINT_OBJECT_PROPERTIES, (OWLAxiom)axiom);
        this.write(properties);
        this.writeAxiomEnd();
    }

    public void visit(OWLDisjointUnionAxiom axiom) {
        this.writeAxiomStart(OWLXMLVocabulary.DISJOINT_UNION, (OWLAxiom)axiom);
        this.acceptAndSpace((OWLObject)axiom.getOWLClass());
        this.write(axiom.classExpressions());
        this.writeAxiomEnd();
    }

    public void visit(OWLAnnotationAssertionAxiom axiom) {
        this.writeAxiomStart(OWLXMLVocabulary.ANNOTATION_ASSERTION, (OWLAxiom)axiom);
        this.acceptAndSpace(axiom.getProperty());
        this.acceptAndSpace(axiom.getSubject());
        axiom.getValue().accept((OWLObjectVisitor)this);
        this.writeAxiomEnd();
    }

    public void visit(OWLEquivalentClassesAxiom axiom) {
        List classExpressions = OWLAPIStreamUtils.asList((Stream)axiom.classExpressions());
        if (classExpressions.size() < 2) {
            return;
        }
        this.writeAxiomStart(OWLXMLVocabulary.EQUIVALENT_CLASSES, (OWLAxiom)axiom);
        this.write(classExpressions);
        this.writeAxiomEnd();
    }

    public void visit(OWLEquivalentDataPropertiesAxiom axiom) {
        List properties = OWLAPIStreamUtils.asList((Stream)axiom.properties());
        if (properties.size() < 2) {
            return;
        }
        this.writeAxiomStart(OWLXMLVocabulary.EQUIVALENT_DATA_PROPERTIES, (OWLAxiom)axiom);
        this.write(properties);
        this.writeAxiomEnd();
    }

    public void visit(OWLEquivalentObjectPropertiesAxiom axiom) {
        List properties = OWLAPIStreamUtils.asList((Stream)axiom.properties());
        if (properties.size() < 2) {
            return;
        }
        this.writeAxiomStart(OWLXMLVocabulary.EQUIVALENT_OBJECT_PROPERTIES, (OWLAxiom)axiom);
        this.write(properties);
        this.writeAxiomEnd();
    }

    public void visit(OWLFunctionalDataPropertyAxiom axiom) {
        this.writePropertyCharacteristic(OWLXMLVocabulary.FUNCTIONAL_DATA_PROPERTY, (OWLAxiom)axiom, (OWLPropertyExpression)axiom.getProperty());
    }

    public void visit(OWLFunctionalObjectPropertyAxiom axiom) {
        this.writePropertyCharacteristic(OWLXMLVocabulary.FUNCTIONAL_OBJECT_PROPERTY, (OWLAxiom)axiom, (OWLPropertyExpression)axiom.getProperty());
    }

    public void visit(OWLInverseFunctionalObjectPropertyAxiom axiom) {
        this.writePropertyCharacteristic(OWLXMLVocabulary.INVERSE_FUNCTIONAL_OBJECT_PROPERTY, (OWLAxiom)axiom, (OWLPropertyExpression)axiom.getProperty());
    }

    public void visit(OWLInverseObjectPropertiesAxiom axiom) {
        this.writeAxiomStart(OWLXMLVocabulary.INVERSE_OBJECT_PROPERTIES, (OWLAxiom)axiom);
        this.acceptAndSpace((OWLObject)axiom.getFirstProperty());
        axiom.getSecondProperty().accept((OWLObjectVisitor)this);
        this.writeAxiomEnd();
    }

    public void visit(OWLIrreflexiveObjectPropertyAxiom axiom) {
        this.writePropertyCharacteristic(OWLXMLVocabulary.IRREFLEXIVE_OBJECT_PROPERTY, (OWLAxiom)axiom, (OWLPropertyExpression)axiom.getProperty());
    }

    public void visit(OWLNegativeDataPropertyAssertionAxiom axiom) {
        this.writeAxiomStart(OWLXMLVocabulary.NEGATIVE_DATA_PROPERTY_ASSERTION, (OWLAxiom)axiom);
        this.acceptAndSpace((OWLObject)axiom.getProperty());
        this.acceptAndSpace((OWLObject)axiom.getSubject());
        ((OWLLiteral)axiom.getObject()).accept((OWLObjectVisitor)this);
        this.writeAxiomEnd();
    }

    public void visit(OWLNegativeObjectPropertyAssertionAxiom axiom) {
        this.writeAxiomStart(OWLXMLVocabulary.NEGATIVE_OBJECT_PROPERTY_ASSERTION, (OWLAxiom)axiom);
        this.acceptAndSpace((OWLObject)axiom.getProperty());
        this.acceptAndSpace((OWLObject)axiom.getSubject());
        ((OWLIndividual)axiom.getObject()).accept((OWLObjectVisitor)this);
        this.writeAxiomEnd();
    }

    public void visit(OWLObjectPropertyAssertionAxiom axiom) {
        this.writeAxiomStart(OWLXMLVocabulary.OBJECT_PROPERTY_ASSERTION, (OWLAxiom)axiom);
        this.acceptAndSpace((OWLObject)axiom.getProperty());
        this.acceptAndSpace((OWLObject)axiom.getSubject());
        ((OWLIndividual)axiom.getObject()).accept((OWLObjectVisitor)this);
        this.writeAxiomEnd();
    }

    public void visit(OWLSubPropertyChainOfAxiom axiom) {
        this.writeAxiomStart(OWLXMLVocabulary.SUB_OBJECT_PROPERTY_OF, (OWLAxiom)axiom);
        this.write(OWLXMLVocabulary.OBJECT_PROPERTY_CHAIN);
        this.writeOpenBracket();
        this.write(axiom.getPropertyChain());
        this.writeCloseBracket();
        this.spaceAndAccept((OWLObject)axiom.getSuperProperty());
        this.writeAxiomEnd();
    }

    public void visit(OWLObjectPropertyDomainAxiom axiom) {
        this.writeAxiomStart(OWLXMLVocabulary.OBJECT_PROPERTY_DOMAIN, (OWLAxiom)axiom);
        this.acceptAndSpace(axiom.getProperty());
        ((OWLClassExpression)axiom.getDomain()).accept((OWLObjectVisitor)this);
        this.writeAxiomEnd();
    }

    public void visit(OWLObjectPropertyRangeAxiom axiom) {
        this.writeAxiomStart(OWLXMLVocabulary.OBJECT_PROPERTY_RANGE, (OWLAxiom)axiom);
        this.acceptAndSpace(axiom.getProperty());
        ((OWLClassExpression)axiom.getRange()).accept((OWLObjectVisitor)this);
        this.writeAxiomEnd();
    }

    public void visit(OWLSubObjectPropertyOfAxiom axiom) {
        this.writeAxiomStart(OWLXMLVocabulary.SUB_OBJECT_PROPERTY_OF, (OWLAxiom)axiom);
        this.acceptAndSpace((OWLObject)axiom.getSubProperty());
        ((OWLObjectPropertyExpression)axiom.getSuperProperty()).accept((OWLObjectVisitor)this);
        this.writeAxiomEnd();
    }

    public void visit(OWLReflexiveObjectPropertyAxiom axiom) {
        this.writePropertyCharacteristic(OWLXMLVocabulary.REFLEXIVE_OBJECT_PROPERTY, (OWLAxiom)axiom, (OWLPropertyExpression)axiom.getProperty());
    }

    public void visit(OWLSameIndividualAxiom axiom) {
        List individuals = axiom.getIndividualsAsList();
        if (individuals.size() < 2) {
            return;
        }
        this.writeAxiomStart(OWLXMLVocabulary.SAME_INDIVIDUAL, (OWLAxiom)axiom);
        this.write(individuals);
        this.writeAxiomEnd();
    }

    public void visit(OWLSubClassOfAxiom axiom) {
        this.writeAxiomStart(OWLXMLVocabulary.SUB_CLASS_OF, (OWLAxiom)axiom);
        this.acceptAndSpace((OWLObject)axiom.getSubClass());
        axiom.getSuperClass().accept((OWLObjectVisitor)this);
        this.writeAxiomEnd();
    }

    public void visit(OWLSymmetricObjectPropertyAxiom axiom) {
        this.writePropertyCharacteristic(OWLXMLVocabulary.SYMMETRIC_OBJECT_PROPERTY, (OWLAxiom)axiom, (OWLPropertyExpression)axiom.getProperty());
    }

    public void visit(OWLTransitiveObjectPropertyAxiom axiom) {
        this.writePropertyCharacteristic(OWLXMLVocabulary.TRANSITIVE_OBJECT_PROPERTY, (OWLAxiom)axiom, (OWLPropertyExpression)axiom.getProperty());
    }

    public void visit(OWLClass ce) {
        if (!this.writeEntitiesAsURIs) {
            this.write(OWLXMLVocabulary.CLASS);
            this.writeOpenBracket();
        }
        ce.getIRI().accept((OWLObjectVisitor)this);
        if (!this.writeEntitiesAsURIs) {
            this.writeCloseBracket();
        }
    }

    private <F extends OWLPropertyRange> void writeRestriction(OWLXMLVocabulary v, OWLCardinalityRestriction<F> restriction, OWLPropertyExpression p) {
        this.write(v);
        this.writeOpenBracket();
        this.write(Integer.toString(restriction.getCardinality()));
        this.spaceAndAccept((OWLObject)p);
        if (restriction.isQualified()) {
            this.spaceAndAccept(restriction.getFiller());
        }
        this.writeCloseBracket();
    }

    private void writeRestriction(OWLXMLVocabulary v, OWLQuantifiedDataRestriction restriction) {
        this.writeRestriction(v, (OWLPropertyExpression)restriction.getProperty(), restriction.getFiller());
    }

    private void writeRestriction(OWLXMLVocabulary v, OWLQuantifiedObjectRestriction restriction) {
        this.writeRestriction(v, (OWLPropertyExpression)restriction.getProperty(), restriction.getFiller());
    }

    private void writeRestriction(OWLXMLVocabulary v, OWLPropertyExpression prop, OWLObject filler) {
        this.write(v);
        this.writeOpenBracket();
        this.acceptAndSpace((OWLObject)prop);
        filler.accept((OWLObjectVisitor)this);
        this.writeCloseBracket();
    }

    public void visit(OWLDataAllValuesFrom ce) {
        this.writeRestriction(OWLXMLVocabulary.DATA_ALL_VALUES_FROM, (OWLQuantifiedDataRestriction)ce);
    }

    public void visit(OWLDataExactCardinality ce) {
        this.writeRestriction(OWLXMLVocabulary.DATA_EXACT_CARDINALITY, (OWLCardinalityRestriction)ce, (OWLPropertyExpression)ce.getProperty());
    }

    public void visit(OWLDataMaxCardinality ce) {
        this.writeRestriction(OWLXMLVocabulary.DATA_MAX_CARDINALITY, (OWLCardinalityRestriction)ce, (OWLPropertyExpression)ce.getProperty());
    }

    public void visit(OWLDataMinCardinality ce) {
        this.writeRestriction(OWLXMLVocabulary.DATA_MIN_CARDINALITY, (OWLCardinalityRestriction)ce, (OWLPropertyExpression)ce.getProperty());
    }

    public void visit(OWLDataSomeValuesFrom ce) {
        this.writeRestriction(OWLXMLVocabulary.DATA_SOME_VALUES_FROM, (OWLQuantifiedDataRestriction)ce);
    }

    public void visit(OWLDataHasValue ce) {
        this.writeRestriction(OWLXMLVocabulary.DATA_HAS_VALUE, (OWLPropertyExpression)ce.getProperty(), ce.getFiller());
    }

    public void visit(OWLObjectAllValuesFrom ce) {
        this.writeRestriction(OWLXMLVocabulary.OBJECT_ALL_VALUES_FROM, (OWLQuantifiedObjectRestriction)ce);
    }

    public void visit(OWLObjectComplementOf ce) {
        this.write(OWLXMLVocabulary.OBJECT_COMPLEMENT_OF, (OWLObject)ce.getOperand());
    }

    public void visit(OWLObjectExactCardinality ce) {
        this.writeRestriction(OWLXMLVocabulary.OBJECT_EXACT_CARDINALITY, (OWLCardinalityRestriction)ce, (OWLPropertyExpression)ce.getProperty());
    }

    public void visit(OWLObjectIntersectionOf ce) {
        if (ce.operands().count() == 1L) {
            ce.operands().forEach(x -> x.accept((OWLObjectVisitor)this));
            return;
        }
        this.write(OWLXMLVocabulary.OBJECT_INTERSECTION_OF);
        this.writeOpenBracket();
        this.write(ce.operands());
        this.writeCloseBracket();
    }

    public void visit(OWLObjectMaxCardinality ce) {
        this.writeRestriction(OWLXMLVocabulary.OBJECT_MAX_CARDINALITY, (OWLCardinalityRestriction)ce, (OWLPropertyExpression)ce.getProperty());
    }

    public void visit(OWLObjectMinCardinality ce) {
        this.writeRestriction(OWLXMLVocabulary.OBJECT_MIN_CARDINALITY, (OWLCardinalityRestriction)ce, (OWLPropertyExpression)ce.getProperty());
    }

    public void visit(OWLObjectOneOf ce) {
        this.write(OWLXMLVocabulary.OBJECT_ONE_OF);
        this.writeOpenBracket();
        this.write(ce.individuals());
        this.writeCloseBracket();
    }

    public void visit(OWLObjectHasSelf ce) {
        this.write(OWLXMLVocabulary.OBJECT_HAS_SELF, (OWLObject)ce.getProperty());
    }

    public void visit(OWLObjectSomeValuesFrom ce) {
        this.writeRestriction(OWLXMLVocabulary.OBJECT_SOME_VALUES_FROM, (OWLQuantifiedObjectRestriction)ce);
    }

    public void visit(OWLObjectUnionOf ce) {
        if (ce.operands().count() == 1L) {
            ce.operands().forEach(x -> x.accept((OWLObjectVisitor)this));
            return;
        }
        this.write(OWLXMLVocabulary.OBJECT_UNION_OF);
        this.writeOpenBracket();
        this.write(ce.operands());
        this.writeCloseBracket();
    }

    public void visit(OWLObjectHasValue ce) {
        this.writeRestriction(OWLXMLVocabulary.OBJECT_HAS_VALUE, (OWLPropertyExpression)ce.getProperty(), ce.getFiller());
    }

    public void visit(OWLDataComplementOf node) {
        this.write(OWLXMLVocabulary.DATA_COMPLEMENT_OF, (OWLObject)node.getDataRange());
    }

    public void visit(OWLDataOneOf node) {
        this.write(OWLXMLVocabulary.DATA_ONE_OF);
        this.writeOpenBracket();
        this.write(node.values());
        this.writeCloseBracket();
    }

    public void visit(OWLDatatype node) {
        if (!this.writeEntitiesAsURIs) {
            this.write(OWLXMLVocabulary.DATATYPE);
            this.writeOpenBracket();
        }
        node.getIRI().accept((OWLObjectVisitor)this);
        if (!this.writeEntitiesAsURIs) {
            this.writeCloseBracket();
        }
    }

    public void visit(OWLDatatypeRestriction node) {
        this.write(OWLXMLVocabulary.DATATYPE_RESTRICTION);
        this.writeOpenBracket();
        node.getDatatype().accept((OWLObjectVisitor)this);
        node.facetRestrictions().forEach(this::spaceAndAccept);
        this.writeCloseBracket();
    }

    public void visit(OWLFacetRestriction node) {
        this.write(node.getFacet().getIRI());
        this.spaceAndAccept((OWLObject)node.getFacetValue());
    }

    public void visit(OWLLiteral node) {
        this.write("\"");
        this.write(EscapeUtils.escapeString((String)node.getLiteral()));
        this.write("\"");
        if (node.hasLang()) {
            this.write("@");
            this.write(node.getLang());
        } else if (!node.isRDFPlainLiteral()) {
            this.write("^^");
            this.write(node.getDatatype().getIRI());
        }
    }

    public void visit(OWLDataProperty property) {
        if (!this.writeEntitiesAsURIs) {
            this.write(OWLXMLVocabulary.DATA_PROPERTY);
            this.writeOpenBracket();
        }
        property.getIRI().accept((OWLObjectVisitor)this);
        if (!this.writeEntitiesAsURIs) {
            this.writeCloseBracket();
        }
    }

    public void visit(OWLObjectProperty property) {
        if (!this.writeEntitiesAsURIs) {
            this.write(OWLXMLVocabulary.OBJECT_PROPERTY);
            this.writeOpenBracket();
        }
        property.getIRI().accept((OWLObjectVisitor)this);
        if (!this.writeEntitiesAsURIs) {
            this.writeCloseBracket();
        }
    }

    public void visit(OWLObjectInverseOf property) {
        this.write(OWLXMLVocabulary.OBJECT_INVERSE_OF);
        this.writeOpenBracket();
        property.getInverse().accept((OWLObjectVisitor)this);
        this.writeCloseBracket();
    }

    public void visit(OWLNamedIndividual individual) {
        if (!this.writeEntitiesAsURIs) {
            this.write(OWLXMLVocabulary.NAMED_INDIVIDUAL);
            this.writeOpenBracket();
        }
        individual.getIRI().accept((OWLObjectVisitor)this);
        if (!this.writeEntitiesAsURIs) {
            this.writeCloseBracket();
        }
    }

    public void visit(OWLHasKeyAxiom axiom) {
        this.writeAxiomStart(OWLXMLVocabulary.HAS_KEY, (OWLAxiom)axiom);
        this.acceptAndSpace((OWLObject)axiom.getClassExpression());
        this.writeOpenBracket();
        this.write(OWLAPIStreamUtils.asList((Stream)axiom.objectPropertyExpressions()));
        this.writeCloseBracket();
        this.writeSpace();
        this.writeOpenBracket();
        this.write(OWLAPIStreamUtils.asList((Stream)axiom.dataPropertyExpressions()));
        this.writeCloseBracket();
        this.writeAxiomEnd();
    }

    public void visit(OWLAnnotationPropertyDomainAxiom axiom) {
        this.writeAxiomStart(OWLXMLVocabulary.ANNOTATION_PROPERTY_DOMAIN, (OWLAxiom)axiom);
        this.acceptAndSpace(axiom.getProperty());
        ((IRI)axiom.getDomain()).accept((OWLObjectVisitor)this);
        this.writeAxiomEnd();
    }

    public void visit(OWLAnnotationPropertyRangeAxiom axiom) {
        this.writeAxiomStart(OWLXMLVocabulary.ANNOTATION_PROPERTY_RANGE, (OWLAxiom)axiom);
        this.acceptAndSpace(axiom.getProperty());
        ((IRI)axiom.getRange()).accept((OWLObjectVisitor)this);
        this.writeAxiomEnd();
    }

    public void visit(OWLSubAnnotationPropertyOfAxiom axiom) {
        this.writeAxiomStart(OWLXMLVocabulary.SUB_ANNOTATION_PROPERTY_OF, (OWLAxiom)axiom);
        this.acceptAndSpace((OWLObject)axiom.getSubProperty());
        axiom.getSuperProperty().accept((OWLObjectVisitor)this);
        this.writeAxiomEnd();
    }

    public void visit(OWLDataIntersectionOf node) {
        if (node.operands().count() == 1L) {
            node.operands().forEach(x -> x.accept((OWLObjectVisitor)this));
            return;
        }
        this.write(OWLXMLVocabulary.DATA_INTERSECTION_OF);
        this.writeOpenBracket();
        this.write(node.operands());
        this.writeCloseBracket();
    }

    public void visit(OWLDataUnionOf node) {
        if (node.operands().count() == 1L) {
            node.operands().forEach(x -> x.accept((OWLObjectVisitor)this));
            return;
        }
        this.write(OWLXMLVocabulary.DATA_UNION_OF);
        this.writeOpenBracket();
        this.write(node.operands());
        this.writeCloseBracket();
    }

    public void visit(OWLAnnotationProperty property) {
        if (!this.writeEntitiesAsURIs) {
            this.write(OWLXMLVocabulary.ANNOTATION_PROPERTY);
            this.writeOpenBracket();
        }
        property.getIRI().accept((OWLObjectVisitor)this);
        if (!this.writeEntitiesAsURIs) {
            this.writeCloseBracket();
        }
    }

    public void visit(OWLAnonymousIndividual individual) {
        this.write(individual.getID().toString());
    }

    public void visit(IRI iri) {
        this.write(iri);
    }

    public void visit(OWLAnnotation node) {
        this.write(OWLXMLVocabulary.ANNOTATION);
        this.writeOpenBracket();
        node.annotations().forEach(this::acceptAndSpace);
        this.acceptAndSpace((OWLObject)node.getProperty());
        node.getValue().accept((OWLObjectVisitor)this);
        this.writeCloseBracket();
    }

    public void visit(OWLDatatypeDefinitionAxiom axiom) {
        this.writeAxiomStart(OWLXMLVocabulary.DATATYPE_DEFINITION, (OWLAxiom)axiom);
        this.acceptAndSpace((OWLObject)axiom.getDatatype());
        axiom.getDataRange().accept((OWLObjectVisitor)this);
        this.writeAxiomEnd();
    }

    public void visit(SWRLRule rule) {
        this.writeAxiomStart(OWLXMLVocabulary.DL_SAFE_RULE, (OWLAxiom)rule);
        this.write(OWLXMLVocabulary.BODY);
        this.writeOpenBracket();
        this.write(rule.body());
        this.writeCloseBracket();
        this.write(OWLXMLVocabulary.HEAD);
        this.writeOpenBracket();
        this.write(rule.head());
        this.writeCloseBracket();
        this.writeAxiomEnd();
    }

    public void visit(SWRLIndividualArgument node) {
        node.getIndividual().accept((OWLObjectVisitor)this);
    }

    public void visit(SWRLClassAtom node) {
        this.write(OWLXMLVocabulary.CLASS_ATOM);
        this.writeOpenBracket();
        this.acceptAndSpace((OWLObject)node.getPredicate());
        ((SWRLIArgument)node.getArgument()).accept((OWLObjectVisitor)this);
        this.writeCloseBracket();
    }

    public void visit(SWRLDataRangeAtom node) {
        this.write(OWLXMLVocabulary.DATA_RANGE_ATOM);
        this.writeOpenBracket();
        this.acceptAndSpace((OWLObject)node.getPredicate());
        ((SWRLDArgument)node.getArgument()).accept((OWLObjectVisitor)this);
        this.writeCloseBracket();
    }

    public void visit(SWRLObjectPropertyAtom node) {
        this.write(OWLXMLVocabulary.OBJECT_PROPERTY_ATOM);
        this.writeOpenBracket();
        this.acceptAndSpace((OWLObject)node.getPredicate());
        this.acceptAndSpace((OWLObject)node.getFirstArgument());
        ((SWRLIArgument)node.getSecondArgument()).accept((OWLObjectVisitor)this);
        this.writeCloseBracket();
    }

    public void visit(SWRLDataPropertyAtom node) {
        this.write(OWLXMLVocabulary.DATA_PROPERTY_ATOM);
        this.writeOpenBracket();
        this.acceptAndSpace((OWLObject)node.getPredicate());
        this.acceptAndSpace((OWLObject)node.getFirstArgument());
        ((SWRLDArgument)node.getSecondArgument()).accept((OWLObjectVisitor)this);
        this.writeCloseBracket();
    }

    public void visit(SWRLBuiltInAtom node) {
        this.write(OWLXMLVocabulary.BUILT_IN_ATOM);
        this.writeOpenBracket();
        this.acceptAndSpace((OWLObject)node.getPredicate());
        this.write(node.getArguments());
        this.writeCloseBracket();
    }

    public void visit(SWRLVariable node) {
        this.write(OWLXMLVocabulary.VARIABLE);
        this.writeOpenBracket();
        node.getIRI().accept((OWLObjectVisitor)this);
        this.writeCloseBracket();
    }

    public void visit(SWRLLiteralArgument node) {
        node.getLiteral().accept((OWLObjectVisitor)this);
    }

    public void visit(SWRLDifferentIndividualsAtom node) {
        this.write(OWLXMLVocabulary.DIFFERENT_INDIVIDUALS_ATOM);
        this.writeOpenBracket();
        this.acceptAndSpace((OWLObject)node.getFirstArgument());
        ((SWRLIArgument)node.getSecondArgument()).accept((OWLObjectVisitor)this);
        this.writeCloseBracket();
    }

    public void visit(SWRLSameIndividualAtom node) {
        this.write(OWLXMLVocabulary.SAME_INDIVIDUAL_ATOM);
        this.writeOpenBracket();
        this.acceptAndSpace((OWLObject)node.getFirstArgument());
        ((SWRLIArgument)node.getSecondArgument()).accept((OWLObjectVisitor)this);
        this.writeCloseBracket();
    }

    class AxiomRetriever
    implements OWLEntityVisitorEx<Stream<? extends OWLAxiom>> {
        AxiomRetriever() {
        }

        public Stream<? extends OWLAxiom> visit(OWLClass cls) {
            return FunctionalSyntaxObjectRenderer.this.ont.axioms(cls, Imports.EXCLUDED);
        }

        public Stream<? extends OWLAxiom> visit(OWLObjectProperty property) {
            return FunctionalSyntaxObjectRenderer.this.ont.axioms((OWLObjectPropertyExpression)property, Imports.EXCLUDED);
        }

        public Stream<? extends OWLAxiom> visit(OWLDataProperty property) {
            return FunctionalSyntaxObjectRenderer.this.ont.axioms(property, Imports.EXCLUDED);
        }

        public Stream<? extends OWLAxiom> visit(OWLNamedIndividual individual) {
            return FunctionalSyntaxObjectRenderer.this.ont.axioms((OWLIndividual)individual, Imports.EXCLUDED);
        }

        public Stream<? extends OWLAxiom> visit(OWLDatatype datatype) {
            return FunctionalSyntaxObjectRenderer.this.ont.axioms(datatype, Imports.EXCLUDED);
        }

        public Stream<? extends OWLAxiom> visit(OWLAnnotationProperty property) {
            return FunctionalSyntaxObjectRenderer.this.ont.axioms(property, Imports.EXCLUDED);
        }
    }
}

