/*
 * Decompiled with CFR 0.152.
 */
package org.coode.oppl.template.commons;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import org.coode.oppl.template.ReplacementStrategy;
import org.coode.oppl.utils.ArgCheck;

public class CombinedReplacementStrategy<I, P extends I>
implements ReplacementStrategy<I, P> {
    private final List<ReplacementStrategy<I, P>> strategies = new ArrayList<ReplacementStrategy<I, P>>();

    public CombinedReplacementStrategy(List<ReplacementStrategy<I, P>> strategies) {
        this.strategies.addAll((Collection)ArgCheck.checkNotNull(strategies, (String)"strategies"));
        if (strategies.isEmpty()) {
            throw new IllegalArgumentException("The list of the combined strategies cannot be empty");
        }
    }

    @Override
    public final P replace(I input) {
        P replaced = null;
        Iterator<ReplacementStrategy<I, P>> iterator = this.strategies.iterator();
        do {
            ReplacementStrategy<I, P> strategy = iterator.next();
            replaced = strategy.replace(replaced == null ? input : replaced);
        } while (iterator.hasNext());
        return replaced;
    }

    public final List<ReplacementStrategy<I, P>> getStrategies() {
        return new ArrayList<ReplacementStrategy<I, P>>(this.strategies);
    }
}

