/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.mailprobe.util;

import java.util.ArrayList;
import java.util.List;

public enum Protocol {
    SMTP("smtp"),
    SMTPS("smtps"),
    IMAP("imap"),
    IMAPS("imaps"),
    POP3("pop3"),
    POP3S("pop3s");

    private String proto;
    private static List nameList;
    private static List protoList;

    private Protocol(String name) {
        this.proto = name;
    }

    public String toString() {
        return this.proto;
    }

    public String value() {
        return this.name();
    }

    public static List namelist() {
        if (nameList != null) {
            return nameList;
        }
        Protocol.buildList();
        return nameList;
    }

    public static List list() {
        if (protoList != null) {
            return protoList;
        }
        Protocol.buildList();
        return protoList;
    }

    private static synchronized List buildList() {
        nameList = new ArrayList();
        protoList = new ArrayList();
        for (Protocol c : Protocol.values()) {
            nameList.add(c.name());
            protoList.add(c.proto);
        }
        return nameList;
    }

    public static Protocol fromValue(String v) {
        return Protocol.valueOf(v);
    }
}

