/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.mailprobe.check;

import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.mail.Flags;
import javax.mail.Message;
import javax.mail.MessagingException;
import net.sourceforge.mailprobe.store.Mailstore;

public class StoreChecker {
    private static final StoreChecker INSTANCE = new StoreChecker();
    private Map<String, StoreUUIDHolder> mailstoreMap = new HashMap<String, StoreUUIDHolder>();
    private Set<String> foundUUIDs = new HashSet<String>();
    private long lastCheckTime = new Date().getTime();
    private static final long MIN_CHECK_DELTA = 5000L;
    private static final Logger logger = Logger.getLogger(StoreChecker.class.getName());

    private StoreChecker() {
    }

    public static StoreChecker getInstance() {
        return INSTANCE;
    }

    public synchronized boolean searchUUID(Mailstore mailstore, String UUID2) throws MessagingException {
        if (this.foundUUIDs.remove(UUID2)) {
            logger.log(Level.FINE, "Found UUID whithout search UUID: {0}", UUID2);
            return true;
        }
        if (this.mailstoreMap.containsKey(mailstore.toString())) {
            this.mailstoreMap.get(mailstore.toString()).addUUID(UUID2);
        } else {
            StoreUUIDHolder storeUUIDHolder = new StoreUUIDHolder(mailstore, UUID2);
            this.mailstoreMap.put(mailstore.toString(), storeUUIDHolder);
        }
        if (new Date().getTime() - this.lastCheckTime > 5000L) {
            for (String mailstoreID : this.mailstoreMap.keySet()) {
                StoreUUIDHolder currStoreUUIDHolder = this.mailstoreMap.get(mailstoreID);
                if (currStoreUUIDHolder.UUIDs.size() <= 0) continue;
                logger.log(Level.FINE, "Search for UUID: {0}", UUID2);
                boolean connectSuccesful = currStoreUUIDHolder.getMailstore().connect();
                if (!connectSuccesful) {
                    throw new MessagingException("Connect to INBOX wasn't successful.");
                }
                for (String currUUID : currStoreUUIDHolder.getAllUUIs()) {
                    Message msg = currStoreUUIDHolder.getMailstore().searchForUUID(currUUID);
                    if (msg == null) continue;
                    msg.setFlag(Flags.Flag.DELETED, true);
                    currStoreUUIDHolder.removeUUID(currUUID);
                    this.foundUUIDs.add(currUUID);
                }
                currStoreUUIDHolder.getMailstore().disconnect(true);
                this.lastCheckTime = new Date().getTime();
            }
        } else {
            logger.log(Level.FINE, "Don''t search for UUID: {0}. Last check was {1}ms before.", new Object[]{UUID2, String.valueOf(new Date().getTime() - this.lastCheckTime)});
        }
        if (this.foundUUIDs.remove(UUID2)) {
            logger.log(Level.FINE, "Found and remove UUID after search UUID: {0}", UUID2);
            return true;
        }
        return false;
    }

    class StoreUUIDHolder {
        private Mailstore mailstore;
        private Set<String> UUIDs;

        private StoreUUIDHolder() {
        }

        public StoreUUIDHolder(Mailstore mailstore, String UUID2) {
            this.mailstore = mailstore;
            this.UUIDs = new HashSet<String>();
            this.UUIDs.add(UUID2);
        }

        public boolean addUUID(String UUID2) {
            return this.UUIDs.add(UUID2);
        }

        public boolean removeUUID(String UUID2) {
            return this.UUIDs.remove(UUID2);
        }

        public ArrayList<String> getAllUUIs() {
            ArrayList<String> result = new ArrayList<String>();
            for (String UUID2 : this.UUIDs) {
                result.add(UUID2);
            }
            return result;
        }

        public Mailstore getMailstore() {
            return this.mailstore;
        }
    }
}

