/*
 * Decompiled with CFR 0.152.
 */
package jxl.write.biff;

import common.Assert;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Iterator;
import jxl.Cell;
import jxl.CellType;
import jxl.Range;
import jxl.WorkbookSettings;
import jxl.biff.SheetRangeImpl;
import jxl.write.Blank;
import jxl.write.WritableSheet;
import jxl.write.WriteException;
import jxl.write.biff.File;
import jxl.write.biff.MergedCellsRecord;
import jxl.write.biff.WritableSheetImpl;
import org.jboss.seam.log.Log;
import org.jboss.seam.log.Logging;

class MergedCells {
    private static Log logger = Logging.getLog(MergedCells.class);
    private ArrayList ranges = new ArrayList();
    private WritableSheet sheet;
    private static final int maxRangesPerSheet = 1020;

    public MergedCells(WritableSheet ws) {
        this.sheet = ws;
    }

    void add(Range r) {
        this.ranges.add(r);
    }

    void insertRow(int row) {
        SheetRangeImpl sr2 = null;
        for (SheetRangeImpl sr2 : this.ranges) {
            sr2.insertRow(row);
        }
    }

    void insertColumn(int col) {
        SheetRangeImpl sr2 = null;
        for (SheetRangeImpl sr2 : this.ranges) {
            sr2.insertColumn(col);
        }
    }

    void removeColumn(int col) {
        SheetRangeImpl sr2 = null;
        for (SheetRangeImpl sr2 : this.ranges) {
            if (sr2.getTopLeft().getColumn() == col && sr2.getBottomRight().getColumn() == col) {
                this.ranges.remove(this.ranges.indexOf(sr2));
                continue;
            }
            sr2.removeColumn(col);
        }
    }

    void removeRow(int row) {
        SheetRangeImpl sr = null;
        Iterator i = this.ranges.iterator();
        while (i.hasNext()) {
            sr = (SheetRangeImpl)i.next();
            if (sr.getTopLeft().getRow() == row && sr.getBottomRight().getRow() == row) {
                i.remove();
                continue;
            }
            sr.removeRow(row);
        }
    }

    Range[] getMergedCells() {
        Range[] cells = new Range[this.ranges.size()];
        int i = 0;
        while (i < cells.length) {
            cells[i] = (Range)this.ranges.get(i);
            ++i;
        }
        return cells;
    }

    void unmergeCells(Range r) {
        int index = this.ranges.indexOf(r);
        if (index != -1) {
            this.ranges.remove(index);
        }
    }

    private void checkIntersections() {
        ArrayList<SheetRangeImpl> newcells = new ArrayList<SheetRangeImpl>(this.ranges.size());
        for (SheetRangeImpl r : this.ranges) {
            Iterator i = newcells.iterator();
            SheetRangeImpl range = null;
            boolean intersects = false;
            while (i.hasNext() && !intersects) {
                range = (SheetRangeImpl)i.next();
                if (!range.intersects(r)) continue;
                logger.warn((Object)("Could not merge cells " + r + " as they clash with an existing set of merged cells."), new Object[0]);
                intersects = true;
            }
            if (intersects) continue;
            newcells.add(r);
        }
        this.ranges = newcells;
    }

    private void checkRanges() {
        try {
            SheetRangeImpl range = null;
            int i = 0;
            while (i < this.ranges.size()) {
                range = (SheetRangeImpl)this.ranges.get(i);
                Cell tl = range.getTopLeft();
                Cell br = range.getBottomRight();
                boolean found = false;
                int c = tl.getColumn();
                while (c <= br.getColumn()) {
                    int r = tl.getRow();
                    while (r <= br.getRow()) {
                        Cell cell = this.sheet.getCell(c, r);
                        if (cell.getType() != CellType.EMPTY) {
                            if (!found) {
                                found = true;
                            } else {
                                logger.warn((Object)("Range " + range + " contains more than one data cell.  " + "Setting the other cells to blank."), new Object[0]);
                                Blank b = new Blank(c, r);
                                this.sheet.addCell(b);
                            }
                        }
                        ++r;
                    }
                    ++c;
                }
                ++i;
            }
        }
        catch (WriteException e) {
            Assert.verify(false);
        }
    }

    void write(File outputFile) throws IOException {
        if (this.ranges.size() == 0) {
            return;
        }
        WorkbookSettings ws = ((WritableSheetImpl)this.sheet).getWorkbookSettings();
        if (!ws.getMergedCellCheckingDisabled()) {
            this.checkIntersections();
            this.checkRanges();
        }
        if (this.ranges.size() < 1020) {
            MergedCellsRecord mcr = new MergedCellsRecord(this.ranges);
            outputFile.write(mcr);
            return;
        }
        int numRecordsRequired = this.ranges.size() / 1020 + 1;
        int pos = 0;
        int i = 0;
        while (i < numRecordsRequired) {
            int numranges = Math.min(1020, this.ranges.size() - pos);
            ArrayList cells = new ArrayList(numranges);
            int j = 0;
            while (j < numranges) {
                cells.add(this.ranges.get(pos + j));
                ++j;
            }
            MergedCellsRecord mcr = new MergedCellsRecord(cells);
            outputFile.write(mcr);
            pos += numranges;
            ++i;
        }
    }
}

