/*
 * Decompiled with CFR 0.152.
 */
package jxl.read.biff;

import java.io.IOException;
import java.io.InputStream;
import java.io.InterruptedIOException;
import jxl.WorkbookSettings;
import jxl.biff.BaseCompoundFile;
import jxl.biff.IntegerHelper;
import jxl.biff.Type;
import jxl.read.biff.BiffException;
import jxl.read.biff.CompoundFile;
import jxl.read.biff.Record;
import org.jboss.seam.log.Log;
import org.jboss.seam.log.Logging;

public class File {
    private static Log logger = Logging.getLog(File.class);
    private byte[] data;
    private int filePos;
    private int oldPos;
    private int initialFileSize;
    private int arrayGrowSize;
    private CompoundFile compoundFile;
    private WorkbookSettings workbookSettings;

    /*
     * Unable to fully structure code
     */
    public File(InputStream is, WorkbookSettings ws) throws IOException, BiffException {
        super();
        this.workbookSettings = ws;
        this.initialFileSize = this.workbookSettings.getInitialFileSize();
        this.arrayGrowSize = this.workbookSettings.getArrayGrowSize();
        d = new byte[this.initialFileSize];
        pos = bytesRead = is.read(d);
        if (!Thread.currentThread().isInterrupted()) ** GOTO lbl17
        throw new InterruptedIOException();
lbl-1000:
        // 1 sources

        {
            if (pos >= d.length) {
                newArray = new byte[d.length + this.arrayGrowSize];
                System.arraycopy(d, 0, newArray, 0, d.length);
                d = newArray;
            }
            bytesRead = is.read(d, pos, d.length - pos);
            pos += bytesRead;
            if (!Thread.currentThread().isInterrupted()) continue;
            throw new InterruptedIOException();
lbl17:
            // 2 sources

            ** while (bytesRead != -1)
        }
lbl18:
        // 1 sources

        bytesRead = pos + 1;
        if (bytesRead == 0) {
            throw new BiffException(BiffException.excelFileNotFound);
        }
        cf = new CompoundFile(d, ws);
        try {
            this.data = cf.getStream("workbook");
        }
        catch (BiffException e) {
            this.data = cf.getStream("book");
        }
        if (!this.workbookSettings.getPropertySetsDisabled() && cf.getNumberOfPropertySets() > BaseCompoundFile.STANDARD_PROPERTY_SETS.length) {
            this.compoundFile = cf;
        }
        cf = null;
        if (!this.workbookSettings.getGCDisabled()) {
            System.gc();
        }
    }

    public File(byte[] d) {
        this.data = d;
    }

    Record next() {
        Record r = new Record(this.data, this.filePos, this);
        return r;
    }

    Record peek() {
        int tempPos = this.filePos;
        Record r = new Record(this.data, this.filePos, this);
        this.filePos = tempPos;
        return r;
    }

    public void skip(int bytes) {
        this.filePos += bytes;
    }

    public byte[] read(int pos, int length) {
        byte[] ret = new byte[length];
        try {
            System.arraycopy(this.data, pos, ret, 0, length);
        }
        catch (ArrayIndexOutOfBoundsException e) {
            logger.error((Object)("Array index out of bounds at position " + pos + " record length " + length), new Object[0]);
            throw e;
        }
        return ret;
    }

    public int getPos() {
        return this.filePos;
    }

    public void setPos(int p) {
        this.oldPos = this.filePos;
        this.filePos = p;
    }

    public void restorePos() {
        this.filePos = this.oldPos;
    }

    private void moveToFirstBof() {
        boolean bofFound = false;
        while (!bofFound) {
            int code = IntegerHelper.getInt(this.data[this.filePos], this.data[this.filePos + 1]);
            if (code == Type.BOF.value) {
                bofFound = true;
                continue;
            }
            this.skip(128);
        }
    }

    public void close() {
    }

    public void clear() {
        this.data = null;
    }

    public boolean hasNext() {
        return this.filePos < this.data.length - 4;
    }

    CompoundFile getCompoundFile() {
        return this.compoundFile;
    }
}

