/*
 * Decompiled with CFR 0.152.
 */
package jxl.read.biff;

import jxl.WorkbookSettings;
import jxl.biff.IntegerHelper;
import jxl.biff.RecordData;
import jxl.biff.StringHelper;
import jxl.read.biff.Record;
import org.jboss.seam.log.Log;
import org.jboss.seam.log.Logging;

public class ExternalNameRecord
extends RecordData {
    private static Log logger = Logging.getLog(ExternalNameRecord.class);
    private String name;
    private boolean addInFunction;

    ExternalNameRecord(Record t, WorkbookSettings ws) {
        super(t);
        byte[] data = this.getRecord().getData();
        int options = IntegerHelper.getInt(data[0], data[1]);
        if (options == 0) {
            this.addInFunction = true;
        }
        if (!this.addInFunction) {
            return;
        }
        byte length = data[6];
        boolean unicode = data[7] != 0;
        this.name = unicode ? StringHelper.getUnicodeString(data, length, 8) : StringHelper.getString(data, length, 8, ws);
    }

    public boolean isAddInFunction() {
        return this.addInFunction;
    }

    public String getName() {
        return this.name;
    }
}

