/*
 * Decompiled with CFR 0.152.
 */
package jxl.demo;

import java.io.BufferedWriter;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.UnsupportedEncodingException;
import jxl.Cell;
import jxl.Sheet;
import jxl.Workbook;

public class CSV {
    public CSV(Workbook w, OutputStream out, String encoding, boolean hide) throws IOException {
        if (encoding == null || !encoding.equals("UnicodeBig")) {
            encoding = "UTF8";
        }
        try {
            OutputStreamWriter osw = new OutputStreamWriter(out, encoding);
            BufferedWriter bw = new BufferedWriter(osw);
            int sheet = 0;
            while (sheet < w.getNumberOfSheets()) {
                Sheet s = w.getSheet(sheet);
                if (!hide || !s.getSettings().isHidden()) {
                    bw.write("*** " + s.getName() + " ****");
                    bw.newLine();
                    Cell[] row = null;
                    int i = 0;
                    while (i < s.getRows()) {
                        row = s.getRow(i);
                        if (row.length > 0) {
                            if (!hide || !row[0].isHidden()) {
                                bw.write(row[0].getContents());
                            }
                            int j = 1;
                            while (j < row.length) {
                                bw.write(44);
                                if (!hide || !row[j].isHidden()) {
                                    bw.write(row[j].getContents());
                                }
                                ++j;
                            }
                        }
                        bw.newLine();
                        ++i;
                    }
                }
                ++sheet;
            }
            bw.flush();
            bw.close();
        }
        catch (UnsupportedEncodingException e) {
            System.err.println(e.toString());
        }
    }
}

