/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.jeuclid.app.mathviewer;

import java.awt.Color;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.FlowLayout;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.swing.Box;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JColorChooser;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JFormattedTextField;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import net.sourceforge.jeuclid.app.mathviewer.FontSelectionDialog;
import net.sourceforge.jeuclid.app.mathviewer.MainFrame;
import net.sourceforge.jeuclid.app.mathviewer.Messages;
import net.sourceforge.jeuclid.context.Parameter;
import net.sourceforge.jeuclid.context.typewrapper.BooleanTypeWrapper;
import net.sourceforge.jeuclid.context.typewrapper.ColorTypeWrapper;
import net.sourceforge.jeuclid.context.typewrapper.EnumTypeWrapper;
import net.sourceforge.jeuclid.context.typewrapper.NumberTypeWrapper;
import net.sourceforge.jeuclid.context.typewrapper.TypeWrapper;
import net.sourceforge.jeuclid.swing.JMathComponent;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ParametersDialog
extends JDialog {
    private static final int NUMBER_OF_COLUMNS = 5;
    private static final long serialVersionUID = 1L;
    private static final int PADDING = 30;
    private final JMathComponent mathComponent;
    private final Map<Parameter, DataExtractor> extractors = new HashMap<Parameter, DataExtractor>();

    public ParametersDialog(MainFrame mainFrame) {
        super(mainFrame);
        this.mathComponent = mainFrame.getMathComponent();
        this.setTitle(Messages.getString("MathViewer.ParametersDialog.title"));
        this.setDefaultCloseOperation(2);
        JPanel jPanel = new JPanel(new GridBagLayout());
        this.getContentPane().add((Component)jPanel, "Center");
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridy = 0;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.ipadx = 30;
        for (Parameter parameter : Parameter.values()) {
            JLabel jLabel = new JLabel(parameter.getOptionName());
            jLabel.setToolTipText(parameter.getOptionDesc());
            gridBagConstraints.gridx = 0;
            gridBagConstraints.anchor = 13;
            jPanel.add((Component)jLabel, gridBagConstraints);
            gridBagConstraints.gridx = 1;
            gridBagConstraints.anchor = 17;
            jPanel.add((Component)this.createInputForParameter(parameter), gridBagConstraints);
            ++gridBagConstraints.gridy;
        }
        this.setupButtonsPanel();
        this.setSize(this.getMinimumSize().width, this.getPreferredSize().height);
        this.setLocationByPlatform(true);
        this.setModal(true);
    }

    private void setupButtonsPanel() {
        JPanel jPanel = new JPanel(new FlowLayout(1));
        JButton jButton = new JButton(Messages.getString("MathViewer.save"));
        jButton.setMnemonic('S');
        jButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                HashMap hashMap = new HashMap();
                for (Map.Entry entry : ParametersDialog.this.extractors.entrySet()) {
                    hashMap.put(entry.getKey(), ((DataExtractor)entry.getValue()).extractData());
                }
                ParametersDialog.this.mathComponent.setParameters(hashMap);
                ParametersDialog.this.dispose();
            }
        });
        jPanel.add(jButton);
        JButton jButton2 = new JButton(Messages.getString("MathViewer.cancel"));
        jButton2.setMnemonic('C');
        jButton2.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                ParametersDialog.this.dispose();
            }
        });
        jPanel.add(jButton2);
        this.getContentPane().add((Component)jPanel, "South");
    }

    private JComponent createInputForParameter(Parameter parameter) {
        JComboBox<Object> jComboBox = null;
        TypeWrapper typeWrapper = parameter.getTypeWrapper();
        DataExtractor dataExtractor = null;
        if (typeWrapper instanceof BooleanTypeWrapper) {
            final JCheckBox jCheckBox = new JCheckBox();
            Boolean bl = (Boolean)this.mathComponent.getParameters().getParameter(parameter);
            if (bl == null) {
                bl = Boolean.FALSE;
            }
            jCheckBox.setSelected(bl);
            jComboBox = jCheckBox;
            dataExtractor = new DataExtractor(){

                public Object extractData() {
                    return jCheckBox.isSelected();
                }
            };
        } else if (typeWrapper instanceof ColorTypeWrapper) {
            Map.Entry<? extends JComponent, ? extends DataExtractor> entry = this.setupColorParameter(parameter);
            jComboBox = entry.getKey();
            dataExtractor = entry.getValue();
        } else if (typeWrapper instanceof EnumTypeWrapper) {
            Object object = this.mathComponent.getParameters().getParameter(parameter);
            final JComboBox<Object> jComboBox2 = new JComboBox<Object>(((EnumTypeWrapper)typeWrapper).values());
            if (object != null) {
                jComboBox2.setSelectedItem(object);
            }
            jComboBox = jComboBox2;
            dataExtractor = new DataExtractor(){

                public Object extractData() {
                    return jComboBox2.getSelectedItem();
                }
            };
        } else if (typeWrapper instanceof NumberTypeWrapper) {
            final JFormattedTextField jFormattedTextField = new JFormattedTextField(this.mathComponent.getParameters().getParameter(parameter));
            jComboBox = jFormattedTextField;
            dataExtractor = new DataExtractor(){

                public Object extractData() {
                    return jFormattedTextField.getValue();
                }
            };
        } else {
            Map.Entry<? extends JComponent, ? extends DataExtractor> entry = this.setupTextParameter(parameter);
            jComboBox = entry.getKey();
            dataExtractor = entry.getValue();
        }
        jComboBox.setToolTipText(parameter.getOptionDesc());
        this.extractors.put(parameter, dataExtractor);
        return jComboBox;
    }

    private Map.Entry<? extends JComponent, ? extends DataExtractor> setupColorParameter(Parameter parameter) {
        Color color = (Color)this.mathComponent.getParameters().getParameter(parameter);
        if (color == null) {
            color = Color.white;
        }
        final JColorChooser jColorChooser = new JColorChooser(color);
        final JDialog jDialog = JColorChooser.createDialog(this, Messages.getString("MathViewer.ParametersDialog.pickColor"), true, jColorChooser, null, null);
        final JPanel jPanel = new JPanel(new FlowLayout(0, 0, 0));
        jPanel.setBackground(color);
        JButton jButton = new JButton(Messages.getString("MathViewer.ParametersDialog.showColorChooser"));
        jButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                jDialog.setVisible(true);
                jPanel.setBackground(jColorChooser.getColor());
                jPanel.revalidate();
            }
        });
        jPanel.add(jButton);
        jPanel.add(Box.createHorizontalStrut(30));
        return Collections.singletonMap(jPanel, new DataExtractor(){

            public Object extractData() {
                return jColorChooser.getColor();
            }
        }).entrySet().iterator().next();
    }

    private Map.Entry<? extends JComponent, ? extends DataExtractor> setupTextParameter(final Parameter parameter) {
        final JTextField jTextField = new JTextField(parameter.toString(this.mathComponent.getParameters().getParameter(parameter)), 50);
        jTextField.setMinimumSize(jTextField.getPreferredSize());
        Box box = Box.createHorizontalBox();
        box.add(jTextField);
        box.add(Box.createHorizontalStrut(5));
        JButton jButton = new JButton(Messages.getString("MathViewer.ParametersDialog.showFontSelection"));
        box.add(jButton);
        jButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                FontSelectionDialog fontSelectionDialog = new FontSelectionDialog((Dialog)ParametersDialog.this, (List<String>)((List)parameter.fromString(jTextField.getText())));
                fontSelectionDialog.setVisible(true);
                if (fontSelectionDialog.getFontNames().isEmpty()) {
                    jTextField.setText("");
                } else {
                    jTextField.setText(parameter.toString(fontSelectionDialog.getFontNames()));
                }
            }
        });
        return Collections.singletonMap(box, new DataExtractor(){

            public Object extractData() {
                return parameter.fromString(jTextField.getText());
            }
        }).entrySet().iterator().next();
    }

    private static interface DataExtractor {
        public Object extractData();
    }
}

