/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.jeuclid.app.mathviewer;

import com.apple.eawt.Application;
import com.apple.eawt.ApplicationListener;
import java.io.File;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import javax.swing.UnsupportedLookAndFeelException;
import net.sourceforge.jeuclid.app.mathviewer.MainFrame;
import net.sourceforge.jeuclid.app.mathviewer.MainFrameAppListener;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public final class MathViewer {
    public static final boolean OSX = System.getProperty("mrj.version") != null;
    private static final Log LOGGER = LogFactory.getLog(MathViewer.class);
    private static File source;

    private MathViewer() {
    }

    public static void main(String[] stringArray) {
        source = null;
        if (stringArray.length > 0) {
            source = new File(stringArray[0]);
        }
        if (OSX) {
            System.setProperty("apple.laf.useScreenMenuBar", "true");
        }
        try {
            UIManager.setLookAndFeel(UIManager.getSystemLookAndFeelClassName());
        }
        catch (ClassNotFoundException classNotFoundException) {
            LOGGER.debug((Object)classNotFoundException);
        }
        catch (InstantiationException instantiationException) {
            LOGGER.debug((Object)instantiationException);
        }
        catch (IllegalAccessException illegalAccessException) {
            LOGGER.debug((Object)illegalAccessException);
        }
        catch (UnsupportedLookAndFeelException unsupportedLookAndFeelException) {
            LOGGER.debug((Object)unsupportedLookAndFeelException);
        }
        SwingUtilities.invokeLater(new Runnable(){

            public void run() {
                MainFrame mainFrame = new MainFrame();
                mainFrame.setDefaultCloseOperation(3);
                if (OSX) {
                    Application application = Application.getApplication();
                    application.setEnabledAboutMenu(true);
                    application.setEnabledPreferencesMenu(true);
                    application.addApplicationListener((ApplicationListener)new MainFrameAppListener(mainFrame));
                }
                if (source != null) {
                    mainFrame.loadFile(source);
                }
                mainFrame.setVisible(true);
            }
        });
    }
}

