package net.sourceforge.jaad.aac.syntax;

/**
 * Inverse quantization lookup table for all possible values
 * from 0<sup>4/3</sup> to 8191<sup>4/3</sup>.
 * @author in-somnia
 */
//TODO: list is too big, create at startup
interface IQTable {

	float[] IQ_TABLE = {
		0.0f,
		1.0f,
		2.519842099789746f,
		4.3267487109222245f,
		6.3496042078727974f,
		8.549879733383484f,
		10.902723556992836f,
		13.390518279406722f,
		15.999999999999998f,
		18.720754407467133f,
		21.544346900318835f,
		24.463780996262464f,
		27.47314182127996f,
		30.567350940369842f,
		33.74199169845321f,
		36.993181114957046f,
		40.317473596635935f,
		43.71178704118999f,
		47.173345095760126f,
		50.69963132571694f,
		54.28835233189812f,
		57.93740770400352f,
		61.6448652744185f,
		65.40894053658599f,
		69.22797937475559f,
		73.10044345532164f,
		77.02489777859162f,
		80.99999999999997f,
		85.02449121251853f,
		89.09718794488955f,
		93.21697517861574f,
		97.38280022413316f,
		101.59366732596474f,
		105.84863288986224f,
		110.14680124343441f,
		114.4873208566006f,
		118.86938096020653f,
		123.29220851090024f,
		127.75506545836058f,
		132.25724627755247f,
		136.79807573413572f,
		141.3769068556919f,
		145.99311908523086f,
		150.6461165966291f,
		155.33532675434674f,
		160.0601987020528f,
		164.8202020667335f,
		169.6148257665186f,
		174.44357691188537f,
		179.30597979112554f,
		184.20157493201927f,
		189.12991823257562f,
		194.09058015449685f,
		199.08314497371674f,
		204.1072100829694f,
		209.16238534187647f,
		214.24829247050752f,
		219.36456448277784f,
		224.51084515641213f,
		229.6867885365223f,
		234.89205847013176f,
		240.1263281692325f,
		245.38927980018508f,
		250.6806040974726f,
		255.99999999999991f,
		261.3471743082887f,
		266.7218413610645f,
		272.12372272986045f,
		277.5525469303796f,
		283.0080491494619f,
		288.4899709865989f,
		293.99806020902247f,
		299.5320705194741f,
		305.0917613358298f,
		310.67689758182206f,
		316.28724948815585f,
		321.92259240337177f,
		327.58270661385535f,
		333.2673771724374f,
		338.97639373507025f,
		344.70955040510125f,
		350.46664558470013f,
		356.2474818330261f,
		362.0518657307514f,
		367.8796077505826f,
		373.7305221334451f,
		379.60442677002084f,
		385.501143087346f,
		391.42049594019943f,
		397.3623135070237f,
		403.32642719014467f,
		409.3126715200626f,
		415.320884063608f,
		421.35090533576465f,
		427.4025787149762f,
		433.4757503617617f,
		439.5702691404793f,
		445.6859865440827f,
		451.8227566217276f,
		457.9804359090913f,
		464.15888336127773f,
		470.35796028818726f,
		476.5775302922363f,
		482.81745920832043f,
		489.0776150459174f,
		495.3578679332358f,
		501.6580900633169f,
		507.9781556420037f,
		514.3179408376965f,
		520.6773237328167f,
		527.056184276906f,
		533.4544042412917f,
		539.8718671752513f,
		546.308458363615f,
		552.7640647857461f,
		559.2385750758419f,
		565.7318794845041f,
		572.2438698415234f,
		578.7744395198338f,
		585.3234834005884f,
		591.8908978393126f,
		598.4765806330926f,
		605.0804309887604f,
		611.7023494920364f,
		618.3422380775919f,
		624.9999999999998f,
		631.6755398055375f,
		638.3687633048116f,
		645.0795775461748f,
		651.8078907899041f,
		658.553612483115f,
		665.3166532353836f,
		672.0969247950522f,
		678.8943400261944f,
		685.7088128862142f,
		692.540258404062f,
		699.3885926590398f,
		706.2537327601806f,
		713.1355968261797f,
		720.0341039658604f,
		726.9491742591542f,
		733.8807287385821f,
		740.8286893712154f,
		747.7929790411054f,
		754.7735215321619f,
		761.7702415114704f,
		768.7830645130296f,
		775.811916921899f,
		782.8567259587425f,
		789.9174196647544f,
		796.993926886958f,
		804.0861772638627f,
		811.194101211471f,
		818.3176299096223f,
		825.4566952886656f,
		832.6112300164486f,
		839.781167485616f,
		846.9664418012055f,
		854.1669877685351f,
		861.3827408813713f,
		868.6136373103698f,
		875.859613891782f,
		883.1206081164196f,
		890.3965581188676f,
		897.6874026669418f,
		904.9930811513817f,
		912.3135335757719f,
		919.6487005466876f,
		926.9985232640562f,
		934.3629435117291f,
		941.7419036482586f,
		949.1353465978742f,
		956.5432158416521f,
		963.9654554088735f,
		971.4020098685654f,
		978.8528243212218f,
		986.3178443906959f,
		993.7970162162635f,
		1001.29028644485f,
		1008.797602223418f,
		1016.3189111915103f,
		1023.8541614739464f,
		1031.4033016736653f,
		1038.9662808647138f,
		1046.5430485853758f,
		1054.1335548314366f,
		1061.7377500495838f,
		1069.3555851309357f,
		1076.9870114046978f,
		1084.6319806319443f,
		1092.2904449995174f,
		1099.9623571140482f,
		1107.6476699960892f,
		1115.3463370743607f,
		1123.058312180106f,
		1130.783549541554f,
		1138.5220037784857f,
		1146.273629896901f,
		1154.0383832837879f,
		1161.816219701986f,
		1169.607095285146f,
		1177.4109665327805f,
		1185.2277903054078f,
		1193.0575238197798f,
		1200.9001246442f,
		1208.7555506939248f,
		1216.6237602266442f,
		1224.5047118380478f,
		1232.3983644574657f,
		1240.3046773435874f,
		1248.2236100802568f,
		1256.1551225723395f,
		1264.099175041662f,
		1272.0557280230228f,
		1280.024742360269f,
		1288.0061792024444f,
		1295.9999999999995f,
		1304.006166501068f,
		1312.0246407478062f,
		1320.055385072793f,
		1328.0983620954903f,
		1336.153534718765f,
		1344.2208661254647f,
		1352.3003197750522f,
		1360.3918594002962f,
		1368.4954490040145f,
		1376.6110528558709f,
		1384.7386354892244f,
		1392.8781616980295f,
		1401.0295965337855f,
		1409.1929053025353f,
		1417.368053561912f,
		1425.5550071182324f,
		1433.7537320236374f,
		1441.9641945732744f,
		1450.186361302528f,
		1458.4201989842913f,
		1466.6656746262797f,
		1474.9227554683875f,
		1483.1914089800841f,
		1491.4716028578516f,
		1499.7633050226596f,
		1508.0664836174794f,
		1516.3811070048375f,
		1524.7071437644029f,
		1533.044562690613f,
		1541.3933327903342f,
		1549.753423280558f,
		1558.1248035861304f,
		1566.507443337515f,
		1574.9013123685909f,
		1583.3063807144795f,
		1591.722618609407f,
		1600.149996484594f,
		1608.58848496618f,
		1617.0380548731737f,
		1625.4986772154357f,
		1633.9703231916887f,
		1642.4529641875577f,
		1650.9465717736346f,
		1659.4511177035752f,
		1667.9665739122186f,
		1676.4929125137353f,
		1685.0301057998013f,
		1693.5781262377957f,
		1702.136946469027f,
		1710.7065393069795f,
		1719.286877735588f,
		1727.8779349075323f,
		1736.4796841425596f,
		1745.0920989258252f,
		1753.7151529062583f,
		1762.3488198949503f,
		1770.993073863563f,
		1779.6478889427597f,
		1788.3132394206564f,
		1796.9890997412947f,
		1805.6754445031333f,
		1814.3722484575621f,
		1823.0794865074322f,
		1831.7971337056094f,
		1840.5251652535437f,
		1849.263556499858f,
		1858.0122829389563f,
		1866.7713202096493f,
		1875.5406440937966f,
		1884.3202305149687f,
		1893.110055537124f,
		1901.9100953633042f,
		1910.7203263343454f,
		1919.5407249276057f,
		1928.3712677557098f,
		1937.2119315653083f,
		1946.0626932358525f,
		1954.923529778386f,
		1963.79441833435f,
		1972.6753361744036f,
		1981.5662606972594f,
		1990.467169428533f,
		1999.378040019607f,
		2008.2988502465078f,
		2017.2295780087982f,
		2026.1702013284819f,
		2035.1206983489212f,
		2044.0810473337688f,
		2053.0512266659125f,
		2062.031214846431f,
		2071.0209904935646f,
		2080.020532341696f,
		2089.0298192403443f,
		2098.0488301531714f,
		2107.0775441569995f,
		2116.115940440839f,
		2125.1639983049317f,
		2134.2216971597995f,
		2143.2890165253098f,
		2152.3659360297484f,
		2161.452435408903f,
		2170.5484945051617f,
		2179.6540932666144f,
		2188.769211746171f,
		2197.893830100689f,
		2207.0279285901042f,
		2216.171487576584f,
		2225.324487523676f,
		2234.486908995478f,
		2243.65873265581f,
		2252.839939267398f,
		2262.03050969107f,
		2271.2304248849537f,
		2280.4396659036897f,
		2289.6582138976523f,
		2298.8860501121762f,
		2308.1231558867926f,
		2317.3695126544767f,
		2326.6251019409005f,
		2335.8899053636933f,
		2345.163904631713f,
		2354.4470815443233f,
		2363.739417990679f,
		2373.0408959490205f,
		2382.351497485973f,
		2391.671204755856f,
		2400.999999999999f,
		2410.337865546065f,
		2419.6847838073813f,
		2429.0407372822747f,
		2438.405708553419f,
		2447.779680287186f,
		2457.162635233001f,
		2466.554556222711f,
		2475.955426169957f,
		2485.3652280695474f,
		2494.7839449968487f,
		2504.2115601071737f,
		2513.648056635179f,
		2523.0934178942675f,
		2532.5476272760025f,
		2542.010668249519f,
		2551.482524360948f,
		2560.963179232844f,
		2570.4526165636184f,
		2579.950820126979f,
		2589.4577737713744f,
		2598.973461419446f,
		2608.4978670674823f,
		2618.0309747848837f,
		2627.572768713626f,
		2637.1232330677353f,
		2646.6823521327647f,
		2656.250110265277f,
		2665.826491892333f,
		2675.4114815109842f,
		2685.0050636877722f,
		2694.6072230582295f,
		2704.2179443263894f,
		2713.8372122642972f,
		2723.465011711528f,
		2733.1013275747096f,
		2742.7461448270483f,
		2752.39944850786f,
		2762.0612237221085f,
		2771.731455639942f,
		2781.4101294962406f,
		2791.097230590165f,
		2800.7927442847094f,
		2810.496656006259f,
		2820.208951244152f,
		2829.9296155502466f,
		2839.6586345384894f,
		2849.395993884492f,
		2859.1416793251065f,
		2868.8956766580086f,
		2878.6579717412847f,
		2888.4285504930212f,
		2898.2073988908974f,
		2907.9945029717837f,
		2917.789848831344f,
		2927.5934226236377f,
		2937.4052105607307f,
		2947.225198912308f,
		2957.053374005286f,
		2966.8897222234364f,
		2976.734230007005f,
		2986.5868838523397f,
		2996.4476703115197f,
		3006.316575991989f,
		3016.193587556191f,
		3026.078691721209f,
		3035.971875258411f,
		3045.8731249930906f,
		3055.7824278041207f,
		3065.699770623604f,
		3075.6251404365285f,
		3085.5585242804245f,
		3095.49990924503f,
		3105.449282471949f,
		3115.4066311543256f,
		3125.371942536509f,
		3135.3452039137287f,
		3145.3264026317715f,
		3155.3155260866592f,
		3165.3125617243295f,
		3175.3174970403234f,
		3185.330319579468f,
		3195.35101693557f,
		3205.379576751108f,
		3215.4159867169246f,
		3225.460234571929f,
		3235.5123081027928f,
		3245.572195143656f,
		3255.63988357583f,
		3265.7153613275095f,
		3275.7986163734795f,
		3285.889636734829f,
		3295.9884104786665f,
		3306.0949257178395f,
		3316.2091706106517f,
		3326.331133360588f,
		3336.4608022160382f,
		3346.598165470023f,
		3356.7432114599264f,
		3366.8959285672245f,
		3377.056305217221f,
		3387.2243298787826f,
		3397.3999910640764f,
		3407.5832773283128f,
		3417.7741772694862f,
		3427.9726795281194f,
		3438.1787727870123f,
		3448.3924457709873f,
		3458.6136872466445f,
		3468.842486022111f,
		3479.0788309467976f,
		3489.3227109111554f,
		3499.5741148464344f,
		3509.8330317244445f,
		3520.0994505573185f,
		3530.373360397275f,
		3540.6547503363886f,
		3550.9436095063534f,
		3561.239927078258f,
		3571.543692262354f,
		3581.854894307831f,
		3592.1735225025936f,
		3602.4995661730372f,
		3612.8330146838275f,
		3623.1738574376814f,
		3633.52208387515f,
		3643.877683474403f,
		3654.240645751014f,
		3664.6109602577494f,
		3674.9886165843564f,
		3685.3736043573545f,
		3695.7659132398294f,
		3706.165532931225f,
		3716.57245316714f,
		3726.986663719126f,
		3737.4081543944876f,
		3747.836915036078f,
		3758.272935522107f,
		3768.716205765941f,
		3779.1667157159077f,
		3789.6244553551055f,
		3800.089414701208f,
		3810.5615838062768f,
		3821.0409527565694f,
		3831.5275116723533f,
		3842.0212507077194f,
		3852.522160050396f,
		3863.0302299215673f,
		3873.5454505756893f,
		3884.067812300311f,
		3894.597305415892f,
		3905.1339202756285f,
		3915.677647265273f,
		3926.2284768029604f,
		3936.786399339034f,
		3947.3514053558706f,
		3957.9234853677135f,
		3968.502629920497f,
		3979.0888295916798f,
		3989.6820749900776f,
		4000.2823567556948f,
		4010.8896655595613f,
		4021.5039921035655f,
		4032.1253271202945f,
		4042.7536613728694f,
		4053.3889856547858f,
		4064.031290789755f,
		4074.680567631545f,
		4085.336807063822f,
		4095.999999999998f,
		4106.670137383071f,
		4117.347210185475f,
		4128.031209408926f,
		4138.722126084268f,
		4149.419951271327f,
		4160.124676058758f,
		4170.836291563898f,
		4181.554788932618f,
		4192.280159339177f,
		4203.012393986074f,
		4213.75148410391f,
		4224.497420951238f,
		4235.250195814426f,
		4246.0098000075095f,
		4256.776224872057f,
		4267.549461777031f,
		4278.329502118642f,
		4289.11633732022f,
		4299.909958832071f,
		4310.7103581313495f,
		4321.517526721914f,
		4332.3314561342f,
		4343.152137925088f,
		4353.979563677767f,
		4364.813725001605f,
		4375.654613532022f,
		4386.502220930359f,
		4397.356538883747f,
		4408.217559104982f,
		4419.085273332402f,
		4429.959673329753f,
		4440.840750886073f,
		4451.72849781556f,
		4462.622905957458f,
		4473.523967175923f,
		4484.431673359913f,
		4495.346016423058f,
		4506.26698830355f,
		4517.194580964012f,
		4528.128786391389f,
		4539.069596596828f,
		4550.017003615559f,
		4560.970999506781f,
		4571.931576353546f,
		4582.898726262647f,
		4593.8724413645f,
		4604.852713813035f,
		4615.839535785582f,
		4626.832899482757f,
		4637.832797128359f,
		4648.839220969251f,
		4659.852163275256f,
		4670.871616339047f,
		4681.897572476039f,
		4692.930024024284f,
		4703.9689633443595f,
		4715.014382819267f,
		4726.0662748543255f,
		4737.124631877068f,
		4748.189446337137f,
		4759.26071070618f,
		4770.338417477749f,
		4781.422559167199f,
		4792.513128311585f,
		4803.610117469561f,
		4814.713519221285f,
		4825.823326168315f,
		4836.93953093351f,
		4848.062126160935f,
		4859.191104515763f,
		4870.326458684178f,
		4881.468181373277f,
		4892.616265310977f,
		4903.770703245919f,
		4914.931487947375f,
		4926.098612205151f,
		4937.272068829496f,
		4948.451850651012f,
		4959.637950520555f,
		4970.830361309152f,
		4982.029075907904f,
		4993.234087227897f,
		5004.445388200115f,
		5015.662971775347f,
		5026.886830924101f,
		5038.116958636513f,
		5049.353347922266f,
		5060.595991810493f,
		5071.8448833497005f,
		5083.100015607673f,
		5094.3613816714f,
		5105.628974646975f,
		5116.902787659525f,
		5128.18281385312f,
		5139.469046390692f,
		5150.761478453947f,
		5162.060103243293f,
		5173.364913977747f,
		5184.675903894859f,
		5195.993066250632f,
		5207.316394319439f,
		5218.645881393944f,
		5229.981520785022f,
		5241.323305821685f,
		5252.671229850992f,
		5264.025286237983f,
		5275.385468365595f,
		5286.751769634588f,
		5298.124183463464f,
		5309.502703288395f,
		5320.887322563145f,
		5332.278034758998f,
		5343.674833364676f,
		5355.077711886272f,
		5366.486663847172f,
		5377.901682787985f,
		5389.3227622664635f,
		5400.749895857437f,
		5412.183077152737f,
		5423.622299761123f,
		5435.067557308219f,
		5446.518843436432f,
		5457.976151804887f,
		5469.439476089359f,
		5480.908809982197f,
		5492.384147192261f,
		5503.8654814448455f,
		5515.35280648162f,
		5526.846116060552f,
		5538.345403955847f,
		5549.850663957874f,
		5561.361889873103f,
		5572.879075524037f,
		5584.402214749145f,
		5595.9313014027975f,
		5607.466329355201f,
		5619.00729249233f,
		5630.554184715866f,
		5642.106999943128f,
		5653.665732107017f,
		5665.230375155943f,
		5676.8009230537655f,
		5688.377369779733f,
		5699.959709328416f,
		5711.547935709647f,
		5723.142042948459f,
		5734.742025085021f,
		5746.347876174581f,
		5757.959590287402f,
		5769.577161508701f,
		5781.200583938591f,
		5792.829851692021f,
		5804.464958898715f,
		5816.1058997031105f,
		5827.7526682643065f,
		5839.405258755998f,
		5851.06366536642f,
		5862.727882298291f,
		5874.397903768755f,
		5886.07372400932f,
		5897.755337265809f,
		5909.442737798296f,
		5921.135919881051f,
		5932.834877802487f,
		5944.539605865103f,
		5956.250098385426f,
		5967.966349693957f,
		5979.688354135121f,
		5991.416106067203f,
		6003.1495998623f,
		6014.888829906269f,
		6026.6337905986675f,
		6038.384476352703f,
		6050.140881595178f,
		6061.903000766441f,
		6073.670828320332f,
		6085.444358724127f,
		6097.223586458489f,
		6109.00850601742f,
		6120.7991119082f,
		6132.595398651345f,
		6144.397360780552f,
		6156.204992842646f,
		6168.018289397536f,
		6179.837245018158f,
		6191.661854290431f,
		6203.492111813202f,
		6215.3280121982025f,
		6227.1695500699925f,
		6239.01672006592f,
		6250.869516836063f,
		6262.727935043189f,
		6274.591969362706f,
		6286.461614482607f,
		6298.3368651034325f,
		6310.217715938217f,
		6322.104161712446f,
		6333.996197164003f,
		6345.893817043131f,
		6357.7970161123785f,
		6369.705789146558f,
		6381.620130932701f,
		6393.5400362700075f,
		6405.465499969803f,
		6417.396516855498f,
		6429.333081762534f,
		6441.275189538345f,
		6453.222835042314f,
		6465.176013145724f,
		6477.134718731716f,
		6489.098946695247f,
		6501.0686919430445f,
		6513.043949393563f,
		6525.024713976942f,
		6537.010980634961f,
		6549.002744321001f,
		6560.999999999996f,
		6573.002742648398f,
		6585.010967254128f,
		6597.024668816537f,
		6609.043842346366f,
		6621.0684828657f,
		6633.098585407935f,
		6645.134145017727f,
		6657.175156750956f,
		6669.221615674691f,
		6681.273516867135f,
		6693.3308554176f,
		6705.393626426459f,
		6717.461825005108f,
		6729.535446275926f,
		6741.614485372234f,
		6753.69893743826f,
		6765.788797629097f,
		6777.884061110663f,
		6789.984723059666f,
		6802.090778663563f,
		6814.20222312052f,
		6826.31905163938f,
		6838.441259439618f,
		6850.568841751307f,
		6862.701793815083f,
		6874.8401108821f,
		6886.983788213999f,
		6899.132821082872f,
		6911.287204771221f,
		6923.44693457192f,
		6935.612005788186f,
		6947.7824137335365f,
		6959.958153731754f,
		6972.139221116853f,
		6984.325611233041f,
		6996.517319434686f,
		7008.714341086277f,
		7020.916671562394f,
		7033.124306247668f,
		7045.337240536748f,
		7057.555469834268f,
		7069.77898955481f,
		7082.007795122871f,
		7094.241881972827f,
		7106.481245548902f,
		7118.7258813051285f,
		7130.975784705322f,
		7143.23095122304f,
		7155.491376341552f,
		7167.757055553804f,
		7180.027984362389f,
		7192.304158279513f,
		7204.585572826957f,
		7216.872223536052f,
		7229.164105947641f,
		7241.461215612049f,
		7253.76354808905f,
		7266.0710989478375f,
		7278.383863766987f,
		7290.70183813443f,
		7303.025017647417f,
		7315.353397912493f,
		7327.68697454546f,
		7340.025743171346f,
		7352.36969942438f,
		7364.718838947954f,
		7377.073157394597f,
		7389.432650425941f,
		7401.797313712694f,
		7414.167142934606f,
		7426.542133780443f,
		7438.922281947951f,
		7451.307583143835f,
		7463.698033083718f,
		7476.093627492121f,
		7488.49436210243f,
		7500.900232656865f,
		7513.311234906452f,
		7525.727364610994f,
		7538.148617539045f,
		7550.574989467873f,
		7563.006476183442f,
		7575.443073480374f,
		7587.884777161926f,
		7600.33158303996f,
		7612.783486934915f,
		7625.24048467578f,
		7637.702572100064f,
		7650.169745053768f,
		7662.64199939136f,
		7675.119330975745f,
		7687.60173567824f,
		7700.089209378544f,
		7712.581747964711f,
		7725.079347333125f,
		7737.582003388473f,
		7750.089712043714f,
		7762.602469220058f,
		7775.1202708469355f,
		7787.643112861973f,
		7800.1709912109645f,
		7812.703901847848f,
		7825.241840734677f,
		7837.784803841597f,
		7850.3327871468155f,
		7862.885786636581f,
		7875.443798305154f,
		7888.006818154784f,
		7900.57484219568f,
		7913.14786644599f,
		7925.725886931772f,
		7938.308899686972f,
		7950.896900753395f,
		7963.489886180685f,
		7976.087852026296f,
		7988.690794355469f,
		8001.298709241209f,
		8013.911592764257f,
		8026.529441013069f,
		8039.152250083789f,
		8051.780016080227f,
		8064.412735113835f,
		8077.05040330368f,
		8089.693016776422f,
		8102.340571666295f,
		8114.993064115073f,
		8127.650490272057f,
		8140.312846294045f,
		8152.98012834531f,
		8165.652332597579f,
		8178.329455230005f,
		8191.011492429153f,
		8203.698440388966f,
		8216.390295310746f,
		8229.087053403142f,
		8241.788710882107f,
		8254.495263970894f,
		8267.206708900021f,
		8279.923041907257f,
		8292.644259237595f,
		8305.37035714323f,
		8318.101331883543f,
		8330.837179725066f,
		8343.577896941475f,
		8356.323479813558f,
		8369.073924629198f,
		8381.82922768335f,
		8394.589385278021f,
		8407.354393722242f,
		8420.124249332057f,
		8432.898948430495f,
		8445.67848734755f,
		8458.462862420158f,
		8471.25206999218f,
		8484.046106414384f,
		8496.844968044408f,
		8509.648651246764f,
		8522.457152392795f,
		8535.270467860666f,
		8548.088594035344f,
		8560.911527308566f,
		8573.73926407884f,
		8586.5718007514f,
		8599.409133738207f,
		8612.251259457915f,
		8625.098174335855f,
		8637.94987480402f,
		8650.806357301039f,
		8663.667618272157f,
		8676.533654169225f,
		8689.404461450664f,
		8702.28003658146f,
		8715.160376033142f,
		8728.04547628375f,
		8740.935333817839f,
		8753.829945126436f,
		8766.729306707033f,
		8779.633415063572f,
		8792.542266706416f,
		8805.455858152332f,
		8818.374185924482f,
		8831.29724655239f,
		8844.225036571936f,
		8857.157552525327f,
		8870.094790961084f,
		8883.03674843403f,
		8895.983421505252f,
		8908.934806742107f,
		8921.890900718185f,
		8934.8517000133f,
		8947.817201213471f,
		8960.7874009109f,
		8973.76229570396f,
		8986.741882197173f,
		8999.726157001192f,
		9012.715116732788f,
		9025.708758014824f,
		9038.707077476247f,
		9051.710071752064f,
		9064.717737483328f,
		9077.730071317117f,
		9090.747069906518f,
		9103.768729910615f,
		9116.795047994465f,
		9129.826020829081f,
		9142.861645091423f,
		9155.901917464373f,
		9168.946834636716f,
		9181.996393303136f,
		9195.050590164185f,
		9208.109421926274f,
		9221.172885301656f,
		9234.240977008405f,
		9247.313693770408f,
		9260.391032317339f,
		9273.472989384647f,
		9286.559561713542f,
		9299.650746050975f,
		9312.74653914962f,
		9325.84693776787f,
		9338.951938669801f,
		9352.061538625176f,
		9365.175734409413f,
		9378.294522803584f,
		9391.417900594384f,
		9404.545864574127f,
		9417.678411540726f,
		9430.815538297675f,
		9443.957241654036f,
		9457.103518424428f,
		9470.254365429f,
		9483.40977949343f,
		9496.569757448893f,
		9509.734296132066f,
		9522.903392385091f,
		9536.07704305558f,
		9549.255244996582f,
		9562.437995066583f,
		9575.62529012948f,
		9588.817127054574f,
		9602.013502716549f,
		9615.214413995463f,
		9628.419857776727f,
		9641.629830951093f,
		9654.844330414644f,
		9668.063353068772f,
		9681.286895820167f,
		9694.514955580802f,
		9707.74752926792f,
		9720.984613804016f,
		9734.226206116828f,
		9747.472303139319f,
		9760.722901809664f,
		9773.977999071232f,
		9787.237591872581f,
		9800.501677167433f,
		9813.77025191467f,
		9827.04331307831f,
		9840.320857627503f,
		9853.602882536512f,
		9866.8893847847f,
		9880.18036135651f,
		9893.475809241469f,
		9906.775725434152f,
		9920.080106934185f,
		9933.388950746223f,
		9946.702253879943f,
		9960.020013350022f,
		9973.34222617613f,
		9986.668889382916f,
		9999.999999999995f,
		10013.335555061929f,
		10026.675551608221f,
		10040.0199866833f,
		10053.368857336509f,
		10066.722160622081f,
		10080.079893599144f,
		10093.442053331697f,
		10106.808636888598f,
		10120.17964134355f,
		10133.555063775097f,
		10146.934901266595f,
		10160.31915090622f,
		10173.707809786936f,
		10187.100875006496f,
		10200.498343667417f,
		10213.900212876984f,
		10227.306479747222f,
		10240.717141394889f,
		10254.132194941467f,
		10267.551637513146f,
		10280.975466240814f,
		10294.40367826004f,
		10307.836270711065f,
		10321.273240738796f,
		10334.71458549278f,
		10348.160302127204f,
		10361.610387800878f,
		10375.064839677221f,
		10388.523654924258f,
		10401.986830714592f,
		10415.454364225412f,
		10428.926252638465f,
		10442.402493140049f,
		10455.883082921007f,
		10469.368019176709f,
		10482.85729910704f,
		10496.350919916393f,
		10509.848878813653f,
		10523.351173012188f,
		10536.857799729838f,
		10550.368756188902f,
		10563.884039616121f,
		10577.403647242685f,
		10590.927576304197f,
		10604.455824040679f,
		10617.988387696556f,
		10631.525264520642f,
		10645.066451766135f,
		10658.611946690598f,
		10672.161746555956f,
		10685.715848628475f,
		10699.274250178762f,
		10712.836948481747f,
		10726.403940816675f,
		10739.97522446709f,
		10753.550796720836f,
		10767.130654870027f,
		10780.714796211058f,
		10794.303218044579f,
		10807.895917675487f,
		10821.492892412922f,
		10835.094139570248f,
		10848.699656465047f,
		10862.309440419107f,
		10875.923488758415f,
		10889.541798813138f,
		10903.16436791762f,
		10916.791193410372f,
		10930.422272634056f,
		10944.05760293548f,
		10957.697181665582f,
		10971.341006179427f,
		10984.98907383619f,
		10998.641381999149f,
		11012.297928035676f,
		11025.958709317223f,
		11039.623723219316f,
		11053.292967121542f,
		11066.96643840754f,
		11080.64413446499f,
		11094.326052685608f,
		11108.012190465128f,
		11121.702545203298f,
		11135.397114303863f,
		11149.09589517457f,
		11162.798885227143f,
		11176.506081877276f,
		11190.217482544635f,
		11203.933084652828f,
		11217.652885629415f,
		11231.376882905886f,
		11245.105073917659f,
		11258.837456104062f,
		11272.574026908333f,
		11286.314783777601f,
		11300.059724162888f,
		11313.808845519083f,
		11327.56214530495f,
		11341.319620983111f,
		11355.081270020033f,
		11368.847089886023f,
		11382.617078055218f,
		11396.391232005579f,
		11410.169549218874f,
		11423.952027180676f,
		11437.738663380347f,
		11451.529455311042f,
		11465.324400469679f,
		11479.123496356951f,
		11492.926740477304f,
		11506.734130338931f,
		11520.545663453764f,
		11534.361337337468f,
		11548.181149509423f,
		11562.005097492724f,
		11575.83317881417f,
		11589.665391004253f,
		11603.501731597149f,
		11617.342198130715f,
		11631.186788146468f,
		11645.03549918959f,
		11658.888328808911f,
		11672.745274556906f,
		11686.606333989675f,
		11700.471504666955f,
		11714.340784152086f,
		11728.214170012021f,
		11742.091659817312f,
		11755.9732511421f,
		11769.85894156411f,
		11783.748728664636f,
		11797.642610028539f,
		11811.540583244237f,
		11825.442645903695f,
		11839.34879560242f,
		11853.259029939445f,
		11867.173346517331f,
		11881.091742942153f,
		11895.014216823492f,
		11908.940765774427f,
		11922.871387411526f,
		11936.80607935484f,
		11950.744839227897f,
		11964.687664657684f,
		11978.634553274653f,
		11992.5855027127f,
		12006.540510609168f,
		12020.499574604826f,
		12034.462692343877f,
		12048.429861473938f,
		12062.401079646032f,
		12076.376344514589f,
		12090.355653737432f,
		12104.339004975769f,
		12118.326395894186f,
		12132.317824160644f,
		12146.313287446457f,
		12160.312783426303f,
		12174.316309778205f,
		12188.323864183525f,
		12202.335444326955f,
		12216.35104789651f,
		12230.37067258353f,
		12244.394316082657f,
		12258.421976091831f,
		12272.453650312296f,
		12286.489336448576f,
		12300.529032208471f,
		12314.57273530306f,
		12328.620443446678f,
		12342.672154356922f,
		12356.727865754638f,
		12370.78757536391f,
		12384.851280912055f,
		12398.918980129623f,
		12412.990670750381f,
		12427.066350511306f,
		12441.146017152583f,
		12455.229668417589f,
		12469.317302052901f,
		12483.408915808272f,
		12497.50450743663f,
		12511.604074694078f,
		12525.707615339878f,
		12539.815127136444f,
		12553.926607849342f,
		12568.042055247275f,
		12582.161467102082f,
		12596.284841188726f,
		12610.41217528529f,
		12624.54346717297f,
		12638.67871463607f,
		12652.817915461985f,
		12666.961067441209f,
		12681.108168367316f,
		12695.259216036962f,
		12709.41420824987f,
		12723.573142808826f,
		12737.73601751968f,
		12751.902830191326f,
		12766.073578635704f,
		12780.248260667788f,
		12794.426874105588f,
		12808.609416770132f,
		12822.795886485468f,
		12836.986281078653f,
		12851.180598379744f,
		12865.378836221802f,
		12879.580992440871f,
		12893.787064875982f,
		12907.997051369144f,
		12922.210949765336f,
		12936.428757912496f,
		12950.650473661524f,
		12964.876094866271f,
		12979.105619383532f,
		12993.33904507304f,
		13007.576369797454f,
		13021.817591422368f,
		13036.062707816287f,
		13050.311716850629f,
		13064.564616399723f,
		13078.821404340792f,
		13093.082078553954f,
		13107.346636922217f,
		13121.615077331466f,
		13135.887397670458f,
		13150.163595830825f,
		13164.44366970706f,
		13178.727617196502f,
		13193.015436199352f,
		13207.307124618648f,
		13221.602680360265f,
		13235.902101332911f,
		13250.20538544812f,
		13264.512530620239f,
		13278.823534766434f,
		13293.138395806676f,
		13307.457111663734f,
		13321.779680263176f,
		13336.106099533357f,
		13350.43636740541f,
		13364.770481813252f,
		13379.108440693562f,
		13393.450241985796f,
		13407.795883632158f,
		13422.145363577607f,
		13436.498679769855f,
		13450.855830159346f,
		13465.216812699266f,
		13479.58162534553f,
		13493.950266056772f,
		13508.32273279435f,
		13522.69902352233f,
		13537.079136207483f,
		13551.463068819285f,
		13565.850819329906f,
		13580.2423857142f,
		13594.637765949712f,
		13609.036958016655f,
		13623.439959897927f,
		13637.84676957908f,
		13652.257385048335f,
		13666.67180429656f,
		13681.090025317284f,
		13695.512046106669f,
		13709.93786466352f,
		13724.367478989278f,
		13738.800887088004f,
		13753.238086966387f,
		13767.679076633725f,
		13782.12385410194f,
		13796.572417385545f,
		13811.024764501659f,
		13825.480893469998f,
		13839.94080231286f,
		13854.404489055134f,
		13868.871951724283f,
		13883.34318835034f,
		13897.818196965914f,
		13912.296975606168f,
		13926.779522308825f,
		13941.26583511416f,
		13955.755912064991f,
		13970.24975120668f,
		13984.747350587126f,
		13999.248708256751f,
		14013.75382226851f,
		14028.262690677873f,
		14042.775311542828f,
		14057.291682923867f,
		14071.811802883994f,
		14086.335669488704f,
		14100.863280805994f,
		14115.39463490634f,
		14129.92972986271f,
		14144.468563750548f,
		14159.01113464777f,
		14173.55744063476f,
		14188.10747979437f,
		14202.6612502119f,
		14217.218749975118f,
		14231.779977174227f,
		14246.34492990188f,
		14260.913606253163f,
		14275.486004325601f,
		14290.062122219148f,
		14304.64195803617f,
		14319.225509881464f,
		14333.812775862236f,
		14348.403754088098f,
		14362.998442671067f,
		14377.59683972556f,
		14392.198943368388f,
		14406.804751718748f,
		14421.414262898223f,
		14436.027475030774f,
		14450.64438624274f,
		14465.264994662828f,
		14479.889298422106f,
		14494.517295654005f,
		14509.148984494313f,
		14523.784363081166f,
		14538.423429555049f,
		14553.066182058781f,
		14567.712618737527f,
		14582.362737738777f,
		14597.016537212348f,
		14611.674015310382f,
		14626.33517018734f,
		14640.999999999993f,
		14655.668502907418f,
		14670.340677071003f,
		14685.016520654426f,
		14699.69603182367f,
		14714.379208747f,
		14729.066049594967f,
		14743.756552540408f,
		14758.45071575843f,
		14773.148537426418f,
		14787.850015724018f,
		14802.555148833142f,
		14817.26393493796f,
		14831.976372224897f,
		14846.692458882624f,
		14861.41219310206f,
		14876.135573076363f,
		14890.862597000923f,
		14905.593263073371f,
		14920.327569493558f,
		14935.065514463557f,
		14949.807096187662f,
		14964.552312872382f,
		14979.301162726431f,
		14994.053643960735f,
		15008.809754788414f,
		15023.569493424788f,
		15038.33285808737f,
		15053.099846995858f,
		15067.870458372134f,
		15082.644690440264f,
		15097.422541426484f,
		15112.204009559202f,
		15126.989093068994f,
		15141.777790188597f,
		15156.570099152905f,
		15171.366018198967f,
		15186.165545565986f,
		15200.968679495301f,
		15215.775418230402f,
		15230.58576001691f,
		15245.39970310258f,
		15260.217245737298f,
		15275.038386173073f,
		15289.863122664035f,
		15304.691453466432f,
		15319.52337683862f,
		15334.358891041069f,
		15349.197994336348f,
		15364.040684989128f,
		15378.886961266177f,
		15393.736821436356f,
		15408.59026377061f,
		15423.447286541972f,
		15438.307888025554f,
		15453.172066498542f,
		15468.039820240196f,
		15482.91114753184f,
		15497.786046656869f,
		15512.664515900733f,
		15527.54655355094f,
		15542.432157897045f,
		15557.32132723066f,
		15572.214059845435f,
		15587.110354037064f,
		15602.010208103273f,
		15616.913620343823f,
		15631.820589060506f,
		15646.731112557136f,
		15661.645189139546f,
		15676.562817115593f,
		15691.483994795139f,
		15706.408720490062f,
		15721.336992514242f,
		15736.26880918356f,
		15751.2041688159f,
		15766.143069731135f,
		15781.085510251132f,
		15796.03148869974f,
		15810.981003402798f,
		15825.934052688119f,
		15840.890634885489f,
		15855.850748326673f,
		15870.8143913454f,
		15885.781562277361f,
		15900.752259460214f,
		15915.726481233565f,
		15930.704225938982f,
		15945.685491919978f,
		15960.67027752201f,
		15975.65858109248f,
		15990.65040098073f,
		16005.645735538035f,
		16020.644583117599f,
		16035.646942074556f,
		16050.652810765967f,
		16065.662187550806f,
		16080.675070789974f,
		16095.691458846273f,
		16110.711350084424f,
		16125.734742871053f,
		16140.761635574685f,
		16155.792026565747f,
		16170.82591421656f,
		16185.863296901338f,
		16200.904172996183f,
		16215.948540879079f,
		16230.9963989299f,
		16246.047745530386f,
		16261.102579064163f,
		16276.160897916721f,
		16291.22270047542f,
		16306.287985129484f,
		16321.356750269995f,
		16336.428994289896f,
		16351.504715583982f,
		16366.5839125489f,
		16381.66658358314f,
		16396.75272708704f,
		16411.842341462776f,
		16426.935425114363f,
		16442.031976447644f,
		16457.131993870298f,
		16472.23547579183f,
		16487.34242062356f,
		16502.45282677864f,
		16517.566692672033f,
		16532.684016720516f,
		16547.804797342676f,
		16562.929032958902f,
		16578.056721991394f,
		16593.18786286415f,
		16608.322454002962f,
		16623.460493835417f,
		16638.601980790896f,
		16653.746913300558f,
		16668.895289797354f,
		16684.047108716015f,
		16699.202368493046f,
		16714.361067566726f,
		16729.523204377107f,
		16744.68877736601f,
		16759.85778497701f,
		16775.030225655464f,
		16790.206097848466f,
		16805.385400004874f,
		16820.568130575302f,
		16835.754288012104f,
		16850.94387076938f,
		16866.136877302983f,
		16881.333306070494f,
		16896.53315553123f,
		16911.73642414625f,
		16926.94311037833f,
		16942.153212691992f,
		16957.366729553454f,
		16972.583659430682f,
		16987.804000793338f,
		17003.027752112816f,
		17018.254911862205f,
		17033.48547851631f,
		17048.719450551645f,
		17063.95682644642f,
		17079.197604680547f,
		17094.44178373563f,
		17109.689362094967f,
		17124.940338243552f,
		17140.19471066806f,
		17155.452477856852f,
		17170.713638299967f,
		17185.978190489128f,
		17201.246132917724f,
		17216.517464080825f,
		17231.792182475165f,
		17247.07028659914f,
		17262.351774952826f,
		17277.636646037936f,
		17292.924898357855f,
		17308.216530417623f,
		17323.51154072392f,
		17338.80992778509f,
		17354.111690111105f,
		17369.416826213594f,
		17384.72533460582f,
		17400.037213802683f,
		17415.352462320716f,
		17430.67107867809f,
		17445.993061394587f,
		17461.318408991636f,
		17476.647119992274f,
		17491.979192921164f,
		17507.314626304586f,
		17522.653418670423f,
		17537.995568548187f,
		17553.341074468986f,
		17568.689934965536f,
		17584.042148572156f,
		17599.39771382477f,
		17614.75662926089f,
		17630.118893419625f,
		17645.484504841683f,
		17660.853462069354f,
		17676.22576364651f,
		17691.60140811862f,
		17706.98039403272f,
		17722.362719937424f,
		17737.748384382936f,
		17753.137385921014f,
		17768.529723105f,
		17783.92539448979f,
		17799.324398631856f,
		17814.726734089225f,
		17830.13239942148f,
		17845.541393189767f,
		17860.95371395678f,
		17876.36936028677f,
		17891.788330745527f,
		17907.210623900395f,
		17922.636238320254f,
		17938.065172575527f,
		17953.497425238176f,
		17968.932994881692f,
		17984.371880081104f,
		17999.814079412972f,
		18015.25959145537f,
		18030.708414787914f,
		18046.16054799173f,
		18061.615989649465f,
		18077.074738345284f,
		18092.53679266486f,
		18108.002151195393f,
		18123.47081252557f,
		18138.9427752456f,
		18154.41803794719f,
		18169.896599223546f,
		18185.37845766938f,
		18200.863611880886f,
		18216.352060455767f,
		18231.843801993204f,
		18247.338835093873f,
		18262.837158359936f,
		18278.338770395032f,
		18293.84366980429f,
		18309.35185519431f,
		18324.863325173166f,
		18340.37807835041f,
		18355.89611333707f,
		18371.417428745623f,
		18386.942023190033f,
		18402.469895285714f,
		18418.00104364955f,
		18433.53546689987f,
		18449.073163656474f,
		18464.614132540602f,
		18480.158372174956f,
		18495.705881183676f,
		18511.25665819236f,
		18526.810701828035f,
		18542.368010719183f,
		18557.928583495715f,
		18573.492418788985f,
		18589.059515231773f,
		18604.629871458303f,
		18620.203486104212f,
		18635.78035780658f,
		18651.3604852039f,
		18666.943866936086f,
		18682.53050164448f,
		18698.12038797184f,
		18713.713524562332f,
		18729.30991006154f,
		18744.909543116457f,
		18760.51242237548f,
		18776.11854648842f,
		18791.72791410648f,
		18807.340523882274f,
		18822.95637446981f,
		18838.57546452449f,
		18854.19779270311f,
		18869.823357663863f,
		18885.452158066328f,
		18901.08419257147f,
		18916.71945984164f,
		18932.357958540564f,
		18947.999687333362f,
		18963.64464488652f,
		18979.292829867907f,
		18994.94424094676f,
		19010.598876793687f,
		19026.256736080668f,
		19041.917817481044f,
		19057.582119669532f,
		19073.2496413222f,
		19088.920381116473f,
		19104.594337731145f,
		19120.271509846356f,
		19135.951896143604f,
		19151.635495305738f,
		19167.322306016948f,
		19183.01232696278f,
		19198.705556830122f,
		19214.401994307198f,
		19230.10163808358f,
		19245.804486850167f,
		19261.510539299208f,
		19277.219794124274f,
		19292.932250020265f,
		19308.64790568342f,
		19324.366759811302f,
		19340.088811102793f,
		19355.8140582581f,
		19371.542499978754f,
		19387.2741349676f,
		19403.008961928797f,
		19418.746979567823f,
		19434.48818659147f,
		19450.232581707827f,
		19465.980163626304f,
		19481.730931057613f,
		19497.48488271376f,
		19513.242017308068f,
		19529.00233355514f,
		19544.765830170898f,
		19560.53250587254f,
		19576.302359378566f,
		19592.07538940876f,
		19607.85159468421f,
		19623.63097392727f,
		19639.41352586159f,
		19655.199249212103f,
		19670.988142705017f,
		19686.780205067822f,
		19702.57543502929f,
		19718.373831319448f,
		19734.175392669615f,
		19749.980117812374f,
		19765.78800548157f,
		19781.59905441232f,
		19797.413263341008f,
		19813.230631005274f,
		19829.051156144014f,
		19844.874837497395f,
		19860.701673806827f,
		19876.531663814985f,
		19892.36480626579f,
		19908.201099904407f,
		19924.04054347726f,
		19939.883135732012f,
		19955.72887541758f,
		19971.577761284105f,
		19987.429792082985f,
		20003.284966566847f,
		20019.14328348956f,
		20035.00474160622f,
		20050.86933967316f,
		20066.737076447942f,
		20082.60795068936f,
		20098.481961157428f,
		20114.359106613385f,
		20130.239385819703f,
		20146.122797540054f,
		20162.009340539353f,
		20177.899013583716f,
		20193.791815440476f,
		20209.68774487818f,
		20225.58680066659f,
		20241.48898157667f,
		20257.394286380597f,
		20273.302713851754f,
		20289.214262764715f,
		20305.128931895277f,
		20321.046720020415f,
		20336.967625918318f,
		20352.89164836836f,
		20368.818786151114f,
		20384.749038048347f,
		20400.68240284301f,
		20416.61887931925f,
		20432.55846626239f,
		20448.501162458953f,
		20464.44696669663f,
		20480.395877764302f,
		20496.347894452025f,
		20512.30301555103f,
		20528.261239853735f,
		20544.22256615372f,
		20560.18699324574f,
		20576.15451992572f,
		20592.125144990758f,
		20608.098867239107f,
		20624.075685470198f,
		20640.055598484618f,
		20656.038605084115f,
		20672.024704071595f,
		20688.013894251126f,
		20704.006174427926f,
		20720.00154340837f,
		20735.99999999999f,
		20752.001543011454f,
		20768.006171252597f,
		20784.013883534382f,
		20800.02467866893f,
		20816.038555469506f,
		20832.055512750507f,
		20848.075549327474f,
		20864.098664017085f,
		20880.12485563716f,
		20896.154123006647f,
		20912.186464945626f,
		20928.221880275312f,
		20944.260367818053f,
		20960.30192639731f,
		20976.346554837684f,
		20992.394251964895f,
		21008.445016605787f,
		21024.49884758832f,
		21040.555743741574f,
		21056.615703895754f,
		21072.67872688217f,
		21088.74481153325f,
		21104.813956682538f,
		21120.886161164683f,
		21136.96142381544f,
		21153.039743471683f,
		21169.12111897138f,
		21185.205549153605f,
		21201.293032858535f,
		21217.383568927453f,
		21233.47715620273f,
		21249.573793527845f,
		21265.67347974736f,
		21281.776213706937f,
		21297.881994253334f,
		21313.990820234398f,
		21330.102690499054f,
		21346.21760389733f,
		21362.335559280327f,
		21378.45655550024f,
		21394.580591410333f,
		21410.70766586496f,
		21426.837777719556f,
		21442.97092583063f,
		21459.10710905576f,
		21475.246326253604f,
		21491.388576283895f,
		21507.53385800743f,
		21523.682170286087f,
		21539.833511982797f,
		21555.987881961566f,
		21572.14527908746f,
		21588.305702226615f,
		21604.469150246216f,
		21620.63562201452f,
		21636.805116400832f,
		21652.97763227552f,
		21669.153168510005f,
		21685.331723976764f,
		21701.513297549318f,
		21717.697888102244f,
		21733.885494511167f,
		21750.07611565276f,
		21766.269750404736f,
		21782.46639764586f,
		21798.666056255934f,
		21814.8687251158f,
		21831.07440310734f,
		21847.283089113484f,
		21863.494782018177f,
		21879.709480706417f,
		21895.92718406423f,
		21912.147890978667f,
		21928.371600337818f,
		21944.598311030797f,
		21960.828021947746f,
		21977.06073197983f,
		21993.296440019243f,
		22009.535144959198f,
		22025.77684569393f,
		22042.02154111869f,
		22058.269230129757f,
		22074.51991162441f,
		22090.77358450096f,
		22107.030247658717f,
		22123.289899998013f,
		22139.552540420187f,
		22155.818167827587f,
		22172.08678112357f,
		22188.358379212495f,
		22204.632960999726f,
		22220.910525391642f,
		22237.1910712956f,
		22253.474597619977f,
		22269.761103274148f,
		22286.050587168473f,
		22302.343048214312f,
		22318.638485324027f,
		22334.936897410968f,
		22351.23828338947f,
		22367.54264217487f,
		22383.849972683485f,
		22400.16027383262f,
		22416.473544540568f,
		22432.789783726603f,
		22449.10899031099f,
		22465.431163214962f,
		22481.75630136074f,
		22498.084403671528f,
		22514.415469071497f,
		22530.749496485798f,
		22547.08648484056f,
		22563.42643306288f,
		22579.769340080824f,
		22596.115204823436f,
		22612.46402622072f,
		22628.815803203655f,
		22645.17053470418f,
		22661.5282196552f,
		22677.888856990587f,
		22694.25244564517f,
		22710.618984554734f,
		22726.988472656034f,
		22743.360908886778f,
		22759.736292185622f,
		22776.11462149219f,
		22792.495895747044f,
		22808.88011389172f,
		22825.26727486868f,
		22841.657377621348f,
		22858.050421094096f,
		22874.446404232243f,
		22890.845325982053f,
		22907.247185290722f,
		22923.651981106406f,
		22940.059712378195f,
		22956.470378056114f,
		22972.88397709113f,
		22989.300508435153f,
		23005.719971041017f,
		23022.1423638625f,
		23038.56768585431f,
		23054.99593597208f,
		23071.427113172387f,
		23087.86121641273f,
		23104.29824465153f,
		23120.738196848142f,
		23137.18107196285f,
		23153.626868956846f,
		23170.075586792263f,
		23186.52722443214f,
		23202.981780840448f,
		23219.439254982062f,
		23235.899645822796f,
		23252.362952329357f,
		23268.829173469378f,
		23285.298308211408f,
		23301.7703555249f,
		23318.245314380227f,
		23334.723183748658f,
		23351.203962602387f,
		23367.687649914504f,
		23384.174244659007f,
		23400.663745810794f,
		23417.15615234568f,
		23433.651463240367f,
		23450.14967747246f,
		23466.650794020472f,
		23483.154811863806f,
		23499.661729982763f,
		23516.171547358543f,
		23532.684262973235f,
		23549.19987580982f,
		23565.71838485219f,
		23582.23978908509f,
		23598.764087494194f,
		23615.29127906604f,
		23631.821362788058f,
		23648.354337648565f,
		23664.890202636765f,
		23681.428956742733f,
		23697.970598957443f,
		23714.51512827274f,
		23731.062543681343f,
		23747.612844176863f,
		23764.166028753774f,
		23780.72209640744f,
		23797.281046134085f,
		23813.842876930816f,
		23830.407587795606f,
		23846.975177727305f,
		23863.545645725622f,
		23880.11899079115f,
		23896.695211925336f,
		23913.2743081305f,
		23929.85627840982f,
		23946.441121767348f,
		23963.02883720799f,
		23979.619423737513f,
		23996.212880362546f,
		24012.809206090584f,
		24029.408399929966f,
		24046.0104608899f,
		24062.615387980433f,
		24079.223180212488f,
		24095.833836597827f,
		24112.447356149067f,
		24129.063737879667f,
		24145.682980803947f,
		24162.305083937077f,
		24178.930046295063f,
		24195.557866894764f,
		24212.18854475388f,
		24228.82207889096f,
		24245.45846832539f,
		24262.097712077397f,
		24278.73980916805f,
		24295.384758619257f,
		24312.03255945377f,
		24328.683210695162f,
		24345.33671136786f,
		24361.99306049711f,
		24378.652257108995f,
		24395.314300230442f,
		24411.979188889192f,
		24428.646922113825f,
		24445.317498933746f,
		24461.990918379193f,
		24478.66717948122f,
		24495.346281271726f,
		24512.028222783407f,
		24528.7130030498f,
		24545.40062110527f,
		24562.091075984976f,
		24578.784366724925f,
		24595.480492361927f,
		24612.179451933614f,
		24628.881244478434f,
		24645.585869035654f,
		24662.293324645343f,
		24679.003610348394f,
		24695.716725186514f,
		24712.43266820221f,
		24729.151438438807f,
		24745.873034940436f,
		24762.59745675203f,
		24779.324702919344f,
		24796.054772488926f,
		24812.787664508123f,
		24829.5233780251f,
		24846.26191208882f,
		24863.003265749034f,
		24879.747438056307f,
		24896.494428062004f,
		24913.244234818278f,
		24929.99685737808f,
		24946.752294795166f,
		24963.51054612408f,
		24980.271610420154f,
		24997.035486739525f,
		25013.802174139113f,
		25030.57167167663f,
		25047.343978410572f,
		25064.119093400237f,
		25080.897015705697f,
		25097.677744387816f,
		25114.46127850824f,
		25131.247617129404f,
		25148.036759314517f,
		25164.828704127583f,
		25181.62345063337f,
		25198.420997897447f,
		25215.221344986145f,
		25232.024490966574f,
		25248.83043490663f,
		25265.639175874974f,
		25282.45071294105f,
		25299.26504517507f,
		25316.082171648024f,
		25332.902091431668f,
		25349.724803598532f,
		25366.550307221914f,
		25383.378601375884f,
		25400.20968513527f,
		25417.04355757568f,
		25433.880217773472f,
		25450.719664805783f,
		25467.561897750507f,
		25484.406915686297f,
		25501.254717692573f,
		25518.10530284951f,
		25534.958670238055f,
		25551.814818939893f,
		25568.67374803748f,
		25585.535456614027f,
		25602.399943753502f,
		25619.26720854062f,
		25636.137250060856f,
		25653.01006740043f,
		25669.885659646327f,
		25686.76402588627f,
		25703.645165208734f,
		25720.529076702944f,
		25737.415759458876f,
		25754.305212567244f,
		25771.197435119517f,
		25788.0924262079f,
		25804.990184925344f,
		25821.890710365547f,
		25838.794001622948f,
		25855.700057792717f,
		25872.608877970775f,
		25889.52046125378f,
		25906.43480673912f,
		25923.351913524923f,
		25940.271780710063f,
		25957.194407394138f,
		25974.119792677477f,
		25991.047935661154f,
		26007.978835446964f,
		26024.912491137442f,
		26041.84890183584f,
		26058.788066646157f,
		26075.729984673108f,
		26092.674655022136f,
		26109.62207679941f,
		26126.57224911183f,
		26143.525171067016f,
		26160.480841773315f,
		26177.43926033979f,
		26194.40042587623f,
		26211.36433749315f,
		26228.330994301767f,
		26245.30039541404f,
		26262.272539942627f,
		26279.24742700092f,
		26296.225055703006f,
		26313.205425163702f,
		26330.18853449854f,
		26347.174382823756f,
		26364.162969256307f,
		26381.154292913852f,
		26398.148352914774f,
		26415.14514837815f,
		26432.144678423778f,
		26449.146942172156f,
		26466.151938744493f,
		26483.159667262702f,
		26500.170126849403f,
		26517.18331662792f,
		26534.199235722277f,
		26551.2178832572f,
		26568.239258358124f,
		26585.263360151173f,
		26602.29018776318f,
		26619.319740321676f,
		26636.352016954883f,
		26653.387016791727f,
		26670.424738961825f,
		26687.465182595493f,
		26704.508346823743f,
		26721.554230778267f,
		26738.602833591467f,
		26755.65415439643f,
		26772.70819232693f,
		26789.764946517433f,
		26806.824416103096f,
		26823.88660021976f,
		26840.95149800396f,
		26858.01910859291f,
		26875.089431124517f,
		26892.162464737365f,
		26909.23820857072f,
		26926.316661764547f,
		26943.39782345947f,
		26960.481692796813f,
		26977.56826891857f,
		26994.657550967422f,
		27011.74953808672f,
		27028.844229420498f,
		27045.941624113464f,
		27063.041721311005f,
		27080.14452015918f,
		27097.250019804727f,
		27114.35821939505f,
		27131.469118078236f,
		27148.58271500303f,
		27165.699009318858f,
		27182.818000175816f,
		27199.939686724665f,
		27217.064068116837f,
		27234.191143504428f,
		27251.320912040203f,
		27268.453372877593f,
		27285.588525170693f,
		27302.72636807427f,
		27319.866900743735f,
		27337.01012233518f,
		27354.156032005358f,
		27371.30462891167f,
		27388.455912212183f,
		27405.609881065626f,
		27422.766534631388f,
		27439.925872069507f,
		27457.087892540683f,
		27474.252595206275f,
		27491.419979228293f,
		27508.5900437694f,
		27525.762787992917f,
		27542.93821106281f,
		27560.116312143706f,
		27577.297090400876f,
		27594.480545000246f,
		27611.666675108383f,
		27628.855479892518f,
		27646.046958520514f,
		27663.24111016089f,
		27680.4379339828f,
		27697.637429156064f,
		27714.83959485113f,
		27732.04443023909f,
		27749.251934491687f,
		27766.4621067813f,
		27783.67494628095f,
		27800.8904521643f,
		27818.108623605658f,
		27835.329459779954f,
		27852.55295986278f,
		27869.779123030345f,
		27887.007948459504f,
		27904.239435327745f,
		27921.473582813196f,
		27938.710390094617f,
		27955.94985635139f,
		27973.19198076355f,
		27990.436762511745f,
		28007.684200777272f,
		28024.934294742037f,
		28042.1870435886f,
		28059.44244650013f,
		28076.700502660427f,
		28093.961211253933f,
		28111.224571465696f,
		28128.4905824814f,
		28145.759243487362f,
		28163.03055367051f,
		28180.304512218394f,
		28197.581118319198f,
		28214.860371161725f,
		28232.14226993539f,
		28249.426813830236f,
		28266.71400203693f,
		28284.003833746745f,
		28301.296308151585f,
		28318.59142444396f,
		28335.889181817f,
		28353.189579464466f,
		28370.492616580705f,
		28387.798292360705f,
		28405.10660600005f,
		28422.417556694945f,
		28439.73114364221f,
		28457.047366039264f,
		28474.36622308415f,
		28491.687713975512f,
		28509.01183791261f,
		28526.338594095305f,
		28543.66798172407f,
		28560.999999999985f,
		28578.33464812473f,
		28595.671925300605f,
		28613.0118307305f,
		28630.35436361791f,
		28647.699523166943f,
		28665.0473085823f,
		28682.39771906929f,
		28699.750753833818f,
		28717.10641208239f,
		28734.46469302212f,
		28751.82559586071f,
		28769.189119806462f,
		28786.55526406828f,
		28803.92402785566f,
		28821.2954103787f,
		28838.669410848088f,
		28856.046028475103f,
		28873.42526247163f,
		28890.80711205013f,
		28908.191576423673f,
		28925.578654805915f,
		28942.968346411097f,
		28960.360650454055f,
		28977.755566150212f,
		28995.15309271559f,
		29012.553229366786f,
		29029.955975320987f,
		29047.361329795975f,
		29064.769292010107f,
		29082.179861182336f,
		29099.593036532187f,
		29117.00881727978f,
		29134.427202645813f,
		29151.848191851568f,
		29169.27178411891f,
		29186.697978670283f,
		29204.126774728706f,
		29221.55817151779f,
		29238.992168261717f,
		29256.42876418525f,
		29273.867958513725f,
		29291.30975047306f,
		29308.754139289747f,
		29326.201124190855f,
		29343.65070440403f,
		29361.102879157483f,
		29378.557647680012f,
		29396.015009200975f,
		29413.47496295031f,
		29430.937508158524f,
		29448.402644056692f,
		29465.87036987647f,
		29483.34068485007f,
		29500.81358821028f,
		29518.289079190454f,
		29535.76715702451f,
		29553.247820946945f,
		29570.731070192807f,
		29588.216903997723f,
		29605.70532159787f,
		29623.19632223f,
		29640.68990513143f,
		29658.18606954003f,
		29675.684814694236f,
		29693.186139833047f,
		29710.690044196028f,
		29728.196527023298f,
		29745.705587555527f,
		29763.217225033964f,
		29780.731438700397f,
		29798.248227797183f,
		29815.76759156723f,
		29833.289529254005f,
		29850.81404010153f,
		29868.34112335438f,
		29885.870778257693f,
		29903.403004057145f,
		29920.937799998974f,
		29938.475165329975f,
		29956.01509929748f,
		29973.557601149394f,
		29991.102670134147f,
		30008.65030550074f,
		30026.20050649871f,
		30043.753272378144f,
		30061.308602389683f,
		30078.866495784507f,
		30096.426951814352f,
		30113.989969731494f,
		30131.55554878875f,
		30149.12368823949f,
		30166.69438733763f,
		30184.26764533761f,
		30201.843461494434f,
		30219.42183506364f,
		30237.00276530131f,
		30254.586251464058f,
		30272.172292809046f,
		30289.760888593977f,
		30307.35203807709f,
		30324.94574051716f,
		30342.541995173502f,
		30360.140801305966f,
		30377.742158174944f,
		30395.346065041358f,
		30412.952521166666f,
		30430.56152581286f,
		30448.173078242475f,
		30465.78717771856f,
		30483.40382350472f,
		30501.02301486507f,
		30518.644751064272f,
		30536.269031367516f,
		30553.895855040515f,
		30571.52522134952f,
		30589.157129561307f,
		30606.791578943175f,
		30624.428568762964f,
		30642.06809828903f,
		30659.71016679026f,
		30677.35477353607f,
		30695.00191779639f,
		30712.651598841687f,
		30730.303815942945f,
		30747.958568371676f,
		30765.615855399912f,
		30783.27567630021f,
		30800.938030345646f,
		30818.602916809814f,
		30836.270334966837f,
		30853.940284091354f,
		30871.61276345852f,
		30889.28777234401f,
		30906.965310024025f,
		30924.64537577527f,
		30942.327968874983f,
		30960.013088600903f,
		30977.700734231294f,
		30995.39090504493f,
		31013.0836003211f,
		31030.77881933962f,
		31048.476561380798f,
		31066.17682572547f,
		31083.87961165498f,
		31101.58491845118f,
		31119.29274539644f,
		31137.003091773637f,
		31154.715956866155f,
		31172.431339957893f,
		31190.14924033326f,
		31207.869657277162f,
		31225.592590075023f,
		31243.31803801277f,
		31261.04600037684f,
		31278.77647645417f,
		31296.50946553221f,
		31314.24496689891f,
		31331.98297984272f,
		31349.7235036526f,
		31367.466537618013f,
		31385.212081028923f,
		31402.960133175795f,
		31420.710693349596f,
		31438.46376084179f,
		31456.21933494435f,
		31473.977414949743f,
		31491.738000150934f,
		31509.50108984139f,
		31527.26668331507f,
		31545.034779866437f,
		31562.80537879045f,
		31580.578479382562f,
		31598.35408093872f,
		31616.13218275537f,
		31633.91278412945f,
		31651.695884358396f,
		31669.48148274013f,
		31687.269578573076f,
		31705.060171156143f,
		31722.853259788735f,
		31740.64884377075f,
		31758.446922402567f,
		31776.247494985066f,
		31794.050560819614f,
		31811.85611920806f,
		31829.664169452753f,
		31847.47471085652f,
		31865.287742722685f,
		31883.103264355046f,
		31900.9212750579f,
		31918.74177413602f,
		31936.56476089467f,
		31954.3902346396f,
		31972.21819467704f,
		31990.048640313704f,
		32007.881570856793f,
		32025.716985613984f,
		32043.554883893445f,
		32061.395265003815f,
		32079.238128254223f,
		32097.08347295427f,
		32114.93129841405f,
		32132.781603944117f,
		32150.634388855524f,
		32168.48965245979f,
		32186.347394068915f,
		32204.20761299537f,
		32222.07030855212f,
		32239.935480052583f,
		32257.80312681067f,
		32275.673248140767f,
		32293.54584335772f,
		32311.420911776862f,
		32329.298452713996f,
		32347.178465485395f,
		32365.060949407813f,
		32382.945903798463f,
		32400.83332797504f,
		32418.723221255706f,
		32436.615582959093f,
		32454.510412404306f,
		32472.407708910916f,
		32490.307471798966f,
		32508.20970038896f,
		32526.114394001877f,
		32544.021551959166f,
		32561.931173582732f,
		32579.843258194956f,
		32597.75780511868f,
		32615.67481367721f,
		32633.59428319433f,
		32651.51621299426f,
		32669.44060240171f,
		32687.367450741847f,
		32705.296757340297f,
		32723.228521523146f,
		32741.162742616943f,
		32759.099419948703f,
		32777.0385528459f,
		32794.980140636464f,
		32812.92418264879f,
		32830.87067821173f,
		32848.81962665459f,
		32866.77102730715f,
		32884.72487949962f,
		32902.68118256269f,
		32920.639935827494f,
		32938.60113862564f,
		32956.56479028918f,
		32974.53089015061f,
		32992.499437542894f,
		33010.47043179945f,
		33028.443872254145f,
		33046.41975824131f,
		33064.39808909571f,
		33082.37886415258f,
		33100.36208274759f,
		33118.34774421688f,
		33136.335847897026f,
		33154.32639312506f,
		33172.31937923847f,
		33190.31480557517f,
		33208.312671473555f,
		33226.31297627244f,
		33244.31571931111f,
		33262.320899929284f,
		33280.328517467125f,
		33298.33857126526f,
		33316.35106066475f,
		33334.36598500709f,
		33352.38334363424f,
		33370.40313588859f,
		33388.42536111299f,
		33406.45001865072f,
		33424.4771078455f,
		33442.50662804151f,
		33460.53857858335f,
		33478.57295881608f,
		33496.60976808519f,
		33514.64900573662f,
		33532.69067111674f,
		33550.734763572356f,
		33568.781282450735f,
		33586.83022709956f,
		33604.88159686697f,
		33622.93539110153f,
		33640.99160915224f,
		33659.05025036854f,
		33677.11131410032f,
		33695.17479969788f,
		33713.240706511984f,
		33731.309033893805f,
		33749.37978119497f,
		33767.45294776753f,
		33785.528532963974f,
		33803.60653613721f,
		33821.6869566406f,
		33839.76979382794f,
		33857.855047053425f,
		33875.94271567171f,
		33894.03279903787f,
		33912.12529650743f,
		33930.220207436316f,
		33948.31753118089f,
		33966.41726709796f,
		33984.519414544746f,
		34002.6239728789f,
		34020.73094145851f,
		34038.84031964208f,
		34056.952106788536f,
		34075.066302257255f,
		34093.182905408015f,
		34111.30191560103f,
		34129.42333219693f,
		34147.547154556785f,
		34165.67338204208f,
		34183.80201401472f,
		34201.93304983703f,
		34220.06648887178f,
		34238.20233048214f,
		34256.3405740317f,
		34274.481218884495f,
		34292.62426440495f,
		34310.76970995794f,
		34328.91755490873f,
		34347.06779862303f,
		34365.220440466954f,
		34383.37547980705f,
		34401.53291601026f,
		34419.69274844397f,
		34437.85497647597f,
		34456.01959947445f,
		34474.18661680806f,
		34492.35602784582f,
		34510.527831957195f,
		34528.70202851205f,
		34546.87861688068f,
		34565.05759643377f,
		34583.23896654245f,
		34601.42272657823f,
		34619.608875913065f,
		34637.797413919296f,
		34655.98833996969f,
		34674.18165343742f,
		34692.37735369608f,
		34710.57544011967f,
		34728.77591208258f,
		34746.97876895965f,
		34765.18401012608f,
		34783.39163495754f,
		34801.60164283005f,
		34819.81403312006f,
		34838.028805204456f,
		34856.24595846048f,
		34874.46549226582f,
		34892.68740599856f,
		34910.91169903718f,
		34929.138370760564f,
		34947.36742054803f,
		34965.59884777927f,
		34983.8326518344f,
		35002.06883209391f,
		35020.30738793874f,
		35038.54831875018f,
		35056.79162390998f,
		35075.03730280025f,
		35093.285354803505f,
		35111.53577930269f,
		35129.788575681116f,
		35148.043743322516f,
		35166.30128161101f,
		35184.56118993114f,
		35202.823467667826f,
		35221.08811420639f,
		35239.355128932555f,
		35257.62451123245f,
		35275.896260492584f,
		35294.170376099886f,
		35312.44685744167f,
		35330.72570390563f,
		35349.00691487989f,
		35367.290489752944f,
		35385.576427913686f,
		35403.86472875142f,
		35422.15539165581f,
		35440.44841601697f,
		35458.74380122534f,
		35477.041546671804f,
		35495.34165174762f,
		35513.644115844436f,
		35531.948938354304f,
		35550.256118669655f,
		35568.56565618331f,
		35586.8775502885f,
		35605.191800378816f,
		35623.50840584827f,
		35641.82736609124f,
		35660.148680502505f,
		35678.47234847723f,
		35696.79836941098f,
		35715.12674269968f,
		35733.45746773966f,
		35751.790543927644f,
		35770.12597066074f,
		35788.46374733642f,
		35806.80387335257f,
		35825.14634810745f,
		35843.49117099971f,
		35861.83834142837f,
		35880.18785879285f,
		35898.539722492955f,
		35916.89393192886f,
		35935.25048650113f,
		35953.60938561072f,
		35971.97062865896f,
		35990.33421504756f,
		36008.70014417861f,
		36027.068415454596f,
		36045.43902827837f,
		36063.81198205317f,
		36082.18727618261f,
		36100.564910070694f,
		36118.94488312179f,
		36137.327194740654f,
		36155.71184433243f,
		36174.09883130262f,
		36192.488155057115f,
		36210.87981500219f,
		36229.27381054447f,
		36247.670141091f,
		36266.06880604917f,
		36284.46980482674f,
		36302.87313683186f,
		36321.27880147307f,
		36339.68679815925f,
		36358.09712629968f,
		36376.50978530401f,
		36394.924774582265f,
		36413.342093544816f,
		36431.761741602444f,
		36450.18371816629f,
		36468.60802264786f,
		36487.03465445903f,
		36505.46361301206f,
		36523.89489771958f,
		36542.32850799458f,
		36560.76444325041f,
		36579.20270290083f,
		36597.643286359926f,
		36616.08619304218f,
		36634.53142236244f,
		36652.978973735895f,
		36671.42884657814f,
		36689.881040305125f,
		36708.33555433315f,
		36726.7923880789f,
		36745.25154095943f,
		36763.71301239214f,
		36782.17680179481f,
		36800.64290858559f,
		36819.11133218299f,
		36837.58207200587f,
		36856.05512747348f,
		36874.53049800542f,
		36893.00818302165f,
		36911.488181942506f,
		36929.970494188674f,
		36948.455119181206f,
		36966.94205634152f,
		36985.43130509139f,
		37003.92286485296f,
		37022.41673504873f,
		37040.91291510156f,
		37059.411404434664f,
		37077.91220247162f,
		37096.41530863639f,
		37114.92072235324f,
		37133.42844304686f,
		37151.93847014225f,
		37170.450803064785f,
		37188.96544124021f,
		37207.4823840946f,
		37226.0016310544f,
		37244.52318154643f,
		37263.04703499784f,
		37281.57319083615f,
		37300.101648489224f,
		37318.632407385296f,
		37337.165466952945f,
		37355.70082662111f,
		37374.238485819085f,
		37392.77844397651f,
		37411.320700523385f,
		37429.86525489006f,
		37448.41210650723f,
		37466.96125480597f,
		37485.51269921768f,
		37504.066439174116f,
		37522.622474107404f,
		37541.18080344999f,
		37559.741426634704f,
		37578.30434309469f,
		37596.86955226349f,
		37615.43705357494f,
		37634.00684646328f,
		37652.578930363044f,
		37671.153304709165f,
		37689.729968936896f,
		37708.30892248185f,
		37726.890164779965f,
		37745.47369526756f,
		37764.059513381275f,
		37782.64761855811f,
		37801.238010235415f,
		37819.83068785086f,
		37838.425650842495f,
		37857.02289864869f,
		37875.62243070817f,
		37894.22424646001f,
		37912.828345343616f,
		37931.43472679875f,
		37950.043390265506f,
		37968.65433518433f,
		37987.267560996f,
		38005.883067141665f,
		38024.500853062775f,
		38043.12091820116f,
		38061.74326199896f,
		38080.36788389868f,
		38098.99478334316f,
		38117.62395977556f,
		38136.25541263942f,
		38154.889141378575f,
		38173.525145437234f,
		38192.16342425994f,
		38210.80397729155f,
		38229.44680397729f,
		38248.0919037627f,
		38266.739276093685f,
		38285.388920416466f,
		38304.040836177606f,
		38322.695022824f,
		38341.3514798029f,
		38360.01020656186f,
		38378.671202548816f,
		38397.33446721199f,
		38415.99999999998f,
		38434.66780036168f,
		38453.33786774637f,
		38472.01020160361f,
		38490.68480138334f,
		38509.361666535784f,
		38528.04079651155f,
		38546.72219076155f,
		38565.405848737035f,
		38584.091769889594f,
		38602.77995367113f,
		38621.47039953391f,
		38640.163106930486f,
		38658.858075313794f,
		38677.55530413706f,
		38696.25479285386f,
		38714.956540918094f,
		38733.66054778399f,
		38752.36681290611f,
		38771.07533573935f,
		38789.78611573892f,
		38808.49915236037f,
		38827.21444505957f,
		38845.93199329274f,
		38864.65179651639f,
		38883.37385418738f,
		38902.098165762916f,
		38920.824730700486f,
		38939.55354845794f,
		38958.28461849343f,
		38977.01794026546f,
		38995.753513232834f,
		39014.4913368547f,
		39033.23141059052f,
		39051.97373390007f,
		39070.718306243485f,
		39089.46512708119f,
		39108.214195873945f,
		39126.96551208283f,
		39145.71907516926f,
		39164.474884594965f,
		39183.23293982199f,
		39201.99324031271f,
		39220.755785529815f,
		39239.52057493633f,
		39258.28760799559f,
		39277.05688417125f,
		39295.82840292729f,
		39314.60216372801f,
		39333.37816603802f,
		39352.15640932227f,
		39370.936893046004f,
		39389.71961667481f,
		39408.50457967458f,
		39427.29178151152f,
		39446.08122165217f,
		39464.87289956337f,
		39483.66681471229f,
		39502.46296656641f,
		39521.26135459354f,
		39540.06197826178f,
		39558.86483703957f,
		39577.669930395656f,
		39596.47725779911f,
		39615.2868187193f,
		39634.09861262592f,
		39652.91263898899f,
		39671.72889727882f,
		39690.547386966064f,
		39709.36810752165f,
		39728.19105841686f,
		39747.01623912326f,
		39765.84364911275f,
		39784.67328785753f,
		39803.505154830105f,
		39822.33924950332f,
		39841.17557135029f,
		39860.0141198445f,
		39878.85489445968f,
		39897.69789466991f,
		39916.54311994958f,
		39935.39056977337f,
		39954.2402436163f,
		39973.092140953675f,
		39991.94626126112f,
		40010.80260401455f,
		40029.661168690225f,
		40048.52195476468f,
		40067.38496171478f,
		40086.25018901768f,
		40105.117636150855f,
		40123.98730259209f,
		40142.85918781947f,
		40161.73329131138f,
		40180.60961254653f,
		40199.48815100391f,
		40218.368906162854f,
		40237.25187750296f,
		40256.13706450415f,
		40275.02446664667f,
		40293.91408341103f,
		40312.805914278084f,
		40331.69995872896f,
		40350.5962162451f,
		40369.49468630827f,
		40388.39536840051f,
		40407.29826200417f,
		40426.20336660192f,
		40445.110681676706f,
		40464.02020671179f,
		40482.93194119075f,
		40501.84588459744f,
		40520.76203641603f,
		40539.680396130985f,
		40558.60096322707f,
		40577.52373718937f,
		40596.448717503234f,
		40615.37590365434f,
		40634.30529512866f,
		40653.23689141245f,
		40672.170691992294f,
		40691.10669635505f,
		40710.04490398787f,
		40728.98531437824f,
		40747.9279270139f,
		40766.87274138292f,
		40785.81975697365f,
		40804.768973274746f,
		40823.72038977516f,
		40842.67400596413f,
		40861.62982133121f,
		40880.58783536623f,
		40899.54804755933f,
		40918.51045740093f,
		40937.47506438176f,
		40956.44186799285f,
		40975.4108677255f,
		40994.38206307133f,
		41013.355453522236f,
		41032.33103857042f,
		41051.30881770836f,
		41070.288790428865f,
		41089.27095622499f,
		41108.25531459011f,
		41127.24186501789f,
		41146.23060700229f,
		41165.22154003754f,
		41184.2146636182f,
		41203.20997723908f,
		41222.20748039531f,
		41241.2071725823f,
		41260.20905329575f,
		41279.21312203166f,
		41298.2193782863f,
		41317.227821556255f,
		41336.23845133838f,
		41355.25126712983f,
		41374.26626842804f,
		41393.28345473074f,
		41412.30282553595f,
		41431.32438034198f,
		41450.34811864742f,
		41469.374039951144f,
		41488.40214375233f,
		41507.43242955043f,
		41526.46489684518f,
		41545.49954513663f,
		41564.536373925075f,
		41583.575382711126f,
		41602.61657099567f,
		41621.659938279874f,
		41640.705484065205f,
		41659.7532078534f,
		41678.803109146495f,
		41697.8551874468f,
		41716.90944225691f,
		41735.96587307971f,
		41755.02447941836f,
		41774.085260776315f,
		41793.1482166573f,
		41812.21334656533f,
		41831.280650004715f,
		41850.350126480014f,
		41869.42177549611f,
		41888.49559655813f,
		41907.571589171515f,
		41926.64975284196f,
		41945.73008707546f,
		41964.812591378286f,
		41983.89726525698f,
		42002.98410821838f,
		42022.07311976959f,
		42041.164299418015f,
		42060.25764667131f,
		42079.35316103742f,
		42098.45084202459f,
		42117.550689141324f,
		42136.652701896404f,
		42155.75687979889f,
		42174.86322235814f,
		42193.97172908376f,
		42213.082399485655f,
		42232.195233074f,
		42251.310229359246f,
		42270.42738785213f,
		42289.546708063644f,
		42308.66818950508f,
		42327.791831687995f,
		42346.91763412423f,
		42366.04559632589f,
		42385.17571780535f,
		42404.307998075295f,
		42423.44243664864f,
		42442.57903303861f,
		42461.71778675867f,
		42480.858697322605f,
		42500.00176424442f,
		42519.146987038446f,
		42538.29436521925f,
		42557.44389830169f,
		42576.59558580088f,
		42595.74942723224f,
		42614.90542211142f,
		42634.06356995438f,
		42653.22387027732f,
		42672.386322596736f,
		42691.55092642938f,
		42710.71768129229f,
		42729.88658670276f,
		42749.05764217836f,
		42768.23084723694f,
		42787.4062013966f,
		42806.58370417574f,
		42825.76335509299f,
		42844.945153667286f,
		42864.129099417805f,
		42883.315191864014f,
		42902.50343052565f,
		42921.69381492269f,
		42940.88634457541f,
		42960.08101900435f,
		42979.2778377303f,
		42998.47680027432f,
		43017.67790615777f,
		43036.881154902236f,
		43056.08654602958f,
		43075.29407906196f,
		43094.50375352177f,
		43113.71556893167f,
		43132.9295248146f,
		43152.14562069376f,
		43171.36385609262f,
		43190.58423053491f,
		43209.80674354462f,
		43229.031394646016f,
		43248.25818336362f,
		43267.487109222224f,
		43286.71817174688f,
		43305.951370462906f,
		43325.18670489588f,
		43344.42417457165f,
		43363.66377901632f,
		43382.90551775626f,
		43402.1493903181f,
		43421.39539622875f,
		43440.64353501535f,
		43459.89380620532f,
		43479.146209326354f,
		43498.40074390638f,
		43517.657409473606f,
		43536.916205556496f,
		43556.177131683784f,
		43575.44018738444f,
		43594.705372187724f,
		43613.972685623135f,
		43633.24212722044f,
		43652.51369650967f,
		43671.78739302109f,
		43691.06321628527f,
		43710.341165833f,
		43729.621241195346f,
		43748.903441903625f,
		43768.18776748941f,
		43787.474217484545f,
		43806.762791421126f,
		43826.0534888315f,
		43845.34630924828f,
		43864.641252204325f,
		43883.938317232765f,
		43903.23750386697f,
		43922.538811640596f,
		43941.84224008751f,
		43961.14778874188f,
		43980.4554571381f,
		43999.765244810835f,
		44019.077151295f,
		44038.391176125755f,
		44057.70731883854f,
		44077.02557896902f,
		44096.34595605314f,
		44115.66844962708f,
		44134.99305922729f,
		44154.319784390456f,
		44173.648624653535f,
		44192.97957955373f,
		44212.31264862849f,
		44231.64783141553f,
		44250.985127452805f,
		44270.32453627854f,
		44289.66605743118f,
		44309.009690449464f,
		44328.355434872356f,
		44347.703290239064f,
		44367.05325608907f,
		44386.40533196211f,
		44405.75951739814f,
		44425.11581193739f,
		44444.47421512033f,
		44463.834726487694f,
		44483.19734558046f,
		44502.56207193984f,
		44521.92890510733f,
		44541.297844624634f,
		44560.66889003373f,
		44580.042040876855f,
		44599.417296696454f,
		44618.794657035265f,
		44638.174121436256f,
		44657.55568944264f,
		44676.93936059787f,
		44696.32513444567f,
		44715.71301053f,
		44735.102988395054f,
		44754.495067585296f,
		44773.88924764542f,
		44793.285528120374f,
		44812.683908555344f,
		44832.08438849578f,
		44851.48696748736f,
		44870.891645076015f,
		44890.298420807914f,
		44909.70729422949f,
		44929.11826488741f,
		44948.531332328566f,
		44967.946496100136f,
		44987.36375574951f,
		45006.783110824326f,
		45026.20456087247f,
		45045.6281054421f,
		45065.05374408157f,
		45084.48147633949f,
		45103.91130176475f,
		45123.34321990643f,
		45142.777230313885f,
		45162.21333253671f,
		45181.65152612473f,
		45201.09181062803f,
		45220.53418559692f,
		45239.978650581965f,
		45259.42520513396f,
		45278.87384880394f,
		45298.32458114319f,
		45317.777401703235f,
		45337.23231003585f,
		45356.68930569302f,
		45376.148388227f,
		45395.60955719027f,
		45415.07281213556f,
		45434.53815261583f,
		45454.00557818428f,
		45473.47508839436f,
		45492.946682799746f,
		45512.42036095436f,
		45531.89612241236f,
		45551.373966728155f,
		45570.85389345636f,
		45590.33590215187f,
		45609.819992369776f,
		45629.30616366544f,
		45648.79441559444f,
		45668.28474771261f,
		45687.777159576006f,
		45707.27165074092f,
		45726.76822076389f,
		45746.26686920169f,
		45765.76759561132f,
		45785.270399550034f,
		45804.7752805753f,
		45824.28223824482f,
		45843.79127211657f,
		45863.30238174872f,
		45882.81556669969f,
		45902.33082652812f,
		45921.84816079293f,
		45941.367569053225f,
		45960.889050868354f,
		45980.41260579793f,
		45999.93823340176f,
		46019.4659332399f,
		46038.99570487266f,
		46058.52754786055f,
		46078.06146176433f,
		46097.597446144995f,
		46117.135500563774f,
		46136.67562458211f,
		46156.2178177617f,
		46175.76207966446f,
		46195.30840985254f,
		46214.85680788833f,
		46234.40727333444f,
		46253.95980575372f,
		46273.51440470924f,
		46293.07106976431f,
		46312.62980048248f,
		46332.1905964275f,
		46351.75345716338f,
		46371.31838225435f,
		46390.88537126487f,
		46410.45442375962f,
		46430.025539303526f,
		46449.59871746173f,
		46469.17395779962f,
		46488.75125988279f,
		46508.33062327707f,
		46527.91204754854f,
		46547.49553226347f,
		46567.0810769884f,
		46586.66868129006f,
		46606.258344735434f,
		46625.850066891726f,
		46645.44384732635f,
		46665.039685606986f,
		46684.6375813015f,
		46704.237533978005f,
		46723.83954320484f,
		46743.44360855057f,
		46763.04972958399f,
		46782.657905874104f,
		46802.26813699017f,
		46821.88042250163f,
		46841.494761978196f,
		46861.111154989776f,
		46880.72960110652f,
		46900.3500998988f,
		46919.9726509372f,
		46939.597253792526f,
		46959.22390803584f,
		46978.8526132384f,
		46998.48336897169f,
		47018.11617480742f,
		47037.75103031755f,
		47057.38793507422f,
		47077.02688864981f,
		47096.66789061694f,
		47116.31094054843f,
		47135.95603801733f,
		47155.60318259692f,
		47175.2523738607f,
		47194.903611382375f,
		47214.5568947359f,
		47234.21222349542f,
		47253.86959723534f,
		47273.52901553025f,
		47293.19047795498f,
		47312.85398408458f,
		47332.519533494306f,
		47352.187125759665f,
		47371.85676045634f,
		47391.52843716029f,
		47411.20215544765f,
		47430.877914894794f,
		47450.5557150783f,
		47470.23555557498f,
		47489.91743596186f,
		47509.6013558162f,
		47529.28731471546f,
		47548.97531223731f,
		47568.66534795967f,
		47588.35742146065f,
		47608.051532318605f,
		47627.74768011208f,
		47647.445864419846f,
		47667.14608482091f,
		47686.848340894474f,
		47706.55263221997f,
		47726.258958377046f,
		47745.96731894555f,
		47765.67771350559f,
		47785.39014163743f,
		47805.104602921594f,
		47824.821096938824f,
		47844.539623270044f,
		47864.26018149643f,
		47883.98277119934f,
		47903.70739196039f,
		47923.43404336137f,
		47943.162724984315f,
		47962.89343641144f,
		47982.62617722522f,
		48002.36094700831f,
		48022.0977453436f,
		48041.83657181417f,
		48061.57742600335f,
		48081.32030749465f,
		48101.065215871815f,
		48120.81215071879f,
		48140.56111161974f,
		48160.31209815905f,
		48180.0651099213f,
		48199.82014649131f,
		48219.57720745407f,
		48239.336292394844f,
		48259.097400899045f,
		48278.86053255234f,
		48298.62568694059f,
		48318.392863649875f,
		48338.16206226648f,
		48357.933282376915f,
		48377.70652356789f,
		48397.48178542632f,
		48417.259067539344f,
		48437.0383694943f,
		48456.819690878765f,
		48476.60303128049f,
		48496.38839028745f,
		48516.17576748783f,
		48535.96516247005f,
		48555.756574822684f,
		48575.550004134566f,
		48595.34544999472f,
		48615.14291199238f,
		48634.94238971699f,
		48654.7438827582f,
		48674.54739070588f,
		48694.35291315008f,
		48714.16044968111f,
		48733.969999889436f,
		48753.78156336576f,
		48773.59513970098f,
		48793.41072848621f,
		48813.22832931277f,
		48833.04794177219f,
		48852.86956545619f,
		48872.69319995672f,
		48892.51884486592f,
		48912.346499776155f,
		48932.176164279976f,
		48952.00783797016f,
		48971.84152043966f,
		48991.677211281676f,
		49011.51491008959f,
		49031.354616456985f,
		49051.196329977654f,
		49071.04005024561f,
		49090.88577685506f,
		49110.73350940041f,
		49130.58324747627f,
		49150.43499067749f,
		49170.28873859906f,
		49190.14449083623f,
		49210.00224698444f,
		49229.86200663932f,
		49249.72376939672f,
		49269.587534852675f,
		49289.45330260345f,
		49309.32107224548f,
		49329.19084337544f,
		49349.06261559019f,
		49368.936388486785f,
		49388.81216166249f,
		49408.689934714785f,
		49428.569707241324f,
		49448.45147883999f,
		49468.33524910886f,
		49488.22101764621f,
		49508.10878405052f,
		49527.99854792047f,
		49547.89030885494f,
		49567.78406645301f,
		49587.67982031398f,
		49607.57757003732f,
		49627.47731522272f,
		49647.37905547007f,
		49667.28279037946f,
		49687.18851955118f,
		49707.09624258571f,
		49727.00595908374f,
		49746.917668646165f,
		49766.83137087407f,
		49786.747065368734f,
		49806.66475173166f,
		49826.58442956452f,
		49846.5060984692f,
		49866.429758047794f,
		49886.35540790258f,
		49906.28304763604f,
		49926.212676850846f,
		49946.14429514988f,
		49966.077902136225f,
		49986.01349741315f,
		50005.951080584135f,
		50025.890651252834f,
		50045.83220902312f,
		50065.77575349907f,
		50085.72128428493f,
		50105.668800985164f,
		50125.61830320443f,
		50145.569790547575f,
		50165.52326261965f,
		50185.4787190259f,
		50205.43615937177f,
		50225.39558326289f,
		50245.3569903051f,
		50265.32038010443f,
		50285.2857522671f,
		50305.25310639953f,
		50325.22244210834f,
		50345.193759000336f,
		50365.16705668252f,
		50385.1423347621f,
		50405.11959284647f,
		50425.09883054322f,
		50445.08004746013f,
		50465.06324320518f,
		50485.04841738654f,
		50505.03556961258f,
		50525.024699491856f,
		50545.01580663313f,
		50565.00889064534f,
		50585.00395113762f,
		50605.00098771933f,
		50624.99999999997f,
		50645.00098758927f,
		50665.00395009713f,
		50685.00888713368f,
		50705.01579830919f,
		50725.024683234165f,
		50745.03554151928f,
		50765.04837277541f,
		50785.06317661362f,
		50805.07995264516f,
		50825.09870048149f,
		50845.11941973424f,
		50865.142110015244f,
		50885.16677093652f,
		50905.19340211028f,
		50925.222003148934f,
		50945.25257366507f,
		50965.28511327147f,
		50985.31962158112f,
		51005.356098207165f,
		51025.39454276298f,
		51045.434954862096f,
		51065.477334118244f,
		51085.521680145364f,
		51105.567992557546f,
		51125.61627096911f,
		51145.66651499454f,
		51165.71872424852f,
		51185.77289834591f,
		51205.82903690178f,
		51225.88713953136f,
		51245.947205850105f,
		51266.00923547362f,
		51286.07322801772f,
		51306.1391830984f,
		51326.207100331856f,
		51346.27697933445f,
		51366.348819722756f,
		51386.42262111351f,
		51406.49838312366f,
		51426.57610537032f,
		51446.655787470794f,
		51466.73742904259f,
		51486.82102970338f,
		51506.90658907105f,
		51526.99410676363f,
		51547.08358239939f,
		51567.17501559674f,
		51587.2684059743f,
		51607.36375315086f,
		51627.461056745415f,
		51647.56031637713f,
		51667.66153166536f,
		51687.76470222966f,
		51707.86982768973f,
		51727.9769076655f,
		51748.085941777055f,
		51768.19692964468f,
		51788.309870888836f,
		51808.42476513017f,
		51828.54161198952f,
		51848.660411087905f,
		51868.781162046515f,
		51888.90386448674f,
		51909.02851803014f,
		51929.155122298485f,
		51949.28367691369f,
		51969.41418149788f,
		51989.54663567335f,
		52009.68103906259f,
		52029.81739128826f,
		52049.95569197321f,
		52070.09594074048f,
		52090.23813721327f,
		52110.38228101499f,
		52130.5283717692f,
		52150.676409099666f,
		52170.82639263033f,
		52190.97832198532f,
		52211.13219678893f,
		52231.288016665654f,
		52251.44578124015f,
		52271.60549013727f,
		52291.76714298204f,
		52311.93073939967f,
		52332.096279015546f,
		52352.26376145525f,
		52372.43318634451f,
		52392.604553309284f,
		52412.777861975665f,
		52432.953111969946f,
		52453.130302918595f,
		52473.30943444827f,
		52493.49050618579f,
		52513.67351775817f,
		52533.858468792605f,
		52554.04535891645f,
		52574.23418775725f,
		52594.42495494274f,
		52614.61766010081f,
		52634.81230285956f,
		52655.00888284723f,
		52675.20739969227f,
		52695.407853023295f,
		52715.6102424691f,
		52735.81456765866f,
		52756.02082822111f,
		52776.229023785796f,
		52796.439153982225f,
		52816.65121844006f,
		52836.86521678917f,
		52857.0811486596f,
		52877.29901368155f,
		52897.518811485425f,
		52917.74054170177f,
		52937.96420396135f,
		52958.18979789508f,
		52978.41732313405f,
		52998.64677930953f,
		53018.87816605298f,
		53039.111482996006f,
		53059.34672977042f,
		53079.58390600819f,
		53099.82301134148f,
		53120.0640454026f,
		53140.30700782406f,
		53160.55189823853f,
		53180.79871627886f,
		53201.04746157809f,
		53221.2981337694f,
		53241.550732486176f,
		53261.805257361964f,
		53282.06170803049f,
		53302.32008412564f,
		53322.58038528149f,
		53342.8426111323f,
		53363.10676131247f,
		53383.3728354566f,
		53403.64083319945f,
		53423.91075417597f,
		53444.18259802126f,
		53464.45636437061f,
		53484.73205285948f,
		53505.0096631235f,
		53525.28919479847f,
		53545.57064752036f,
		53565.85402092533f,
		53586.1393146497f,
		53606.426528329954f,
		53626.715661602764f,
		53647.00671410496f,
		53667.299685473554f,
		53687.59457534572f,
		53707.891383358816f,
		53728.19010915037f,
		53748.490752358055f,
		53768.79331261975f,
		53789.0977895735f,
		53809.404182857485f,
		53829.712492110106f,
		53850.0227169699f,
		53870.33485707559f,
		53890.648912066055f,
		53910.96488158037f,
		53931.28276525774f,
		53951.60256273758f,
		53971.92427365946f,
		53992.24789766311f,
		54012.57343438844f,
		54032.90088347553f,
		54053.23024456462f,
		54073.561517296126f,
		54093.894701310644f,
		54114.22979624891f,
		54134.566801751855f,
		54154.90571746057f,
		54175.246543016314f,
		54195.589278060506f,
		54215.933922234755f,
		54236.280475180814f,
		54256.62893654063f,
		54276.97930595628f,
		54297.331583070045f,
		54317.68576752436f,
		54338.04185896183f,
		54358.399857025215f,
		54378.75976135746f,
		54399.12157160167f,
		54419.48528740111f,
		54439.850908399225f,
		54460.218434239614f,
		54480.587864566056f,
		54500.95919902248f,
		54521.332437253f,
		54541.70757890188f,
		54562.084623613555f,
		54582.46357103264f,
		54602.844420803885f,
		54623.227172572246f,
		54643.61182598281f,
		54663.99838068084f,
		54684.38683631177f,
		54704.7771925212f,
		54725.1694489549f,
		54745.56360525877f,
		54765.95966107893f,
		54786.357616061614f,
		54806.757469853255f,
		54827.15922210044f,
		54847.56287244991f,
		54867.96842054858f,
		54888.375866043534f,
		54908.78520858201f,
		54929.19644781142f,
		54949.60958337932f,
		54970.02461493346f,
		54990.44154212173f,
		55010.86036459218f,
		55031.28108199306f,
		55051.70369397273f,
		55072.12820017975f,
		55092.55460026284f,
		55112.98289387087f,
		55133.41308065288f,
		55153.84516025806f,
		55174.27913233579f,
		55194.714996535586f,
		55215.15275250714f,
		55235.5923999003f,
		55256.033938365086f,
		55276.477367551655f,
		55296.92268711036f,
		55317.369896691685f,
		55337.818995946305f,
		55358.269984525024f,
		55378.72286207883f,
		55399.17762825887f,
		55419.63428271644f,
		55440.09282510301f,
		55460.553255070205f,
		55481.01557226981f,
		55501.479776353764f,
		55521.94586697419f,
		55542.413843783346f,
		55562.883706433655f,
		55583.355454577715f,
		55603.82908786826f,
		55624.30460595821f,
		55644.78200850064f,
		55665.26129514875f,
		55685.742465555944f,
		55706.225519375774f,
		55726.71045626193f,
		55747.197275868275f,
		55767.68597784884f,
		55788.176561857814f,
		55808.66902754953f,
		55829.16337457848f,
		55849.65960259933f,
		55870.15771126689f,
		55890.657700236145f,
		55911.15956916222f,
		55931.66331770041f,
		55952.168945506164f,
		55972.676452235086f,
		55993.185837542944f,
		56013.69710108565f,
		56034.2102425193f,
		56054.72526150012f,
		56075.24215768451f,
		56095.76093072901f,
		56116.28158029034f,
		56136.80410602537f,
		56157.328507591104f,
		56177.85478464474f,
		56198.3829368436f,
		56218.912963845185f,
		56239.44486530714f,
		56259.97864088727f,
		56280.51429024353f,
		56301.05181303404f,
		56321.59120891709f,
		56342.13247755108f,
		56362.675618594614f,
		56383.22063170642f,
		56403.7675165454f,
		56424.31627277061f,
		56444.86690004124f,
		56465.41939801667f,
		56485.973766356394f,
		56506.5300047201f,
		56527.08811276761f,
		56547.6480901589f,
		56568.20993655411f,
		56588.77365161352f,
		56609.339234997584f,
		56629.9066863669f,
		56650.47600538221f,
		56671.04719170442f,
		56691.6202449946f,
		56712.19516491396f,
		56732.77195112387f,
		56753.350603285835f,
		56773.93112106154f,
		56794.51350411282f,
		56815.09775210165f,
		56835.68386469015f,
		56856.27184154063f,
		56876.86168231552f,
		56897.4533866774f,
		56918.04695428902f,
		56938.6423848133f,
		56959.23967791326f,
		56979.83883325211f,
		57000.439850493225f,
		57021.04272930009f,
		57041.64746933637f,
		57062.25407026587f,
		57082.86253175256f,
		57103.47285346055f,
		57124.08503505411f,
		57144.69907619765f,
		57165.31497655575f,
		57185.9327357931f,
		57206.55235357461f,
		57227.173829565276f,
		57247.79716343028f,
		57268.42235483494f,
		57289.04940344473f,
		57309.678308925286f,
		57330.30907094237f,
		57350.94168916191f,
		57371.576163249985f,
		57392.212492872815f,
		57412.850677696784f,
		57433.490717388406f,
		57454.13261161437f,
		57474.77636004149f,
		57495.421962336746f,
		57516.069418167266f,
		57536.718727200314f,
		57557.36988910332f,
		57578.02290354386f,
		57598.67777018964f,
		57619.33448870855f,
		57639.99305876859f,
		57660.65348003794f,
		57681.315752184906f,
		57701.97987487797f,
		57722.64584778573f,
		57743.31367057695f,
		57763.98334292055f,
		57784.65486448557f,
		57805.32823494123f,
		57826.00345395688f,
		57846.680521202026f,
		57867.359436346305f,
		57888.04019905953f,
		57908.72280901163f,
		57929.40726587271f,
		57950.093569313f,
		57970.781719002895f,
		57991.47171461291f,
		58012.16355581375f,
		58032.85724227622f,
		58053.55277367131f,
		58074.25014967013f,
		58094.94936994395f,
		58115.650434164185f,
		58136.35334200239f,
		58157.058093130276f,
		58177.76468721969f,
		58198.47312394264f,
		58219.18340297126f,
		58239.89552397784f,
		58260.60948663482f,
		58281.325290614775f,
		58302.042935590434f,
		58322.76242123468f,
		58343.48374722051f,
		58364.206913221096f,
		58384.93191890975f,
		58405.65876395992f,
		58426.3874480452f,
		58447.11797083934f,
		58467.85033201621f,
		58488.584531249864f,
		58509.32056821446f,
		58530.05844258433f,
		58550.79815403393f,
		58571.539702237875f,
		58592.283086870906f,
		58613.02830760793f,
		58633.77536412398f,
		58654.52425609425f,
		58675.27498319405f,
		58696.02754509888f,
		58716.781941484325f,
		58737.53817202616f,
		58758.296236400274f,
		58779.05613428273f,
		58799.817865349694f,
		58820.5814292775f,
		58841.34682574264f,
		58862.11405442171f,
		58882.883114991484f,
		58903.65400712885f,
		58924.42673051085f,
		58945.201284814684f,
		58965.977669717664f,
		58986.75588489727f,
		59007.53593003111f,
		59028.31780479695f,
		59049.10150887266f,
		59069.8870419363f,
		59090.674403666046f,
		59111.46359374021f,
		59132.25461183726f,
		59153.0474576358f,
		59173.84213081458f,
		59194.63863105247f,
		59215.436958028506f,
		59236.237111421855f,
		59257.03909091183f,
		59277.84289617788f,
		59298.64852689959f,
		59319.455982756685f,
		59340.26526342905f,
		59361.076368596696f,
		59381.88929793976f,
		59402.70405113854f,
		59423.520627873484f,
		59444.33902782514f,
		59465.15925067423f,
		59485.9812961016f,
		59506.80516378825f,
		59527.63085341531f,
		59548.458364664046f,
		59569.28769721586f,
		59590.11885075232f,
		59610.95182495509f,
		59631.78661950601f,
		59652.62323408705f,
		59673.46166838031f,
		59694.30192206803f,
		59715.14399483259f,
		59735.987886356525f,
		59756.83359632248f,
		59777.681124413255f,
		59798.530470311794f,
		59819.38163370116f,
		59840.23461426457f,
		59861.08941168538f,
		59881.94602564707f,
		59902.80445583327f,
		59923.664701927744f,
		59944.52676361438f,
		59965.39064057724f,
		59986.25633250049f,
		60007.12383906844f,
		60027.99315996554f,
		60048.86429487638f,
		60069.73724348569f,
		60090.612005478324f,
		60111.488580539284f,
		60132.36696835371f,
		60153.24716860687f,
		60174.129180984164f,
		60195.01300517115f,
		60215.89864085351f,
		60236.78608771706f,
		60257.67534544775f,
		60278.56641373167f,
		60299.459292255044f,
		60320.35398070425f,
		60341.25047876576f,
		60362.14878612623f,
		60383.04890247242f,
		60403.95082749124f,
		60424.85456086972f,
		60445.76010229504f,
		60466.667451454516f,
		60487.57660803559f,
		60508.48757172584f,
		60529.400342213f,
		60550.31491918489f,
		60571.23130232952f,
		60592.149491335f,
		60613.06948588959f,
		60633.99128568168f,
		60654.914890399785f,
		60675.84029973257f,
		60696.76751336883f,
		60717.69653099749f,
		60738.6273523076f,
		60759.55997698837f,
		60780.49440472912f,
		60801.43063521932f,
		60822.368668148556f,
		60843.308503206565f,
		60864.250140083204f,
		60885.19357846847f,
		60906.138818052495f,
		60927.08585852554f,
		60948.03469957801f,
		60968.98534090042f,
		60989.93778218344f,
		61010.89202311786f,
		61031.84806339462f,
		61052.805902704764f,
		61073.76554073949f,
		61094.726977190134f,
		61115.69021174814f,
		61136.6552441051f,
		61157.62207395274f,
		61178.590700982924f,
		61199.561124887616f,
		61220.53334535895f,
		61241.50736208917f,
		61262.48317477066f,
		61283.46078309594f,
		61304.440186757645f,
		61325.42138544856f,
		61346.40437886158f,
		61367.389166689754f,
		61388.37574862626f,
		61409.36412436439f,
		61430.35429359757f,
		61451.34625601937f,
		61472.3400113235f,
		61493.33555920376f,
		61514.33289935412f,
		61535.33203146867f,
		61556.33295524162f,
		61577.33567036731f,
		61598.34017654024f,
		61619.34647345499f,
		61640.35456080633f,
		61661.3644382891f,
		61682.37610559831f,
		61703.38956242909f,
		61724.40480847669f,
		61745.42184343651f,
		61766.44066700406f,
		61787.46127887499f,
		61808.48367874506f,
		61829.5078663102f,
		61850.533841266435f,
		61871.56160330993f,
		61892.59115213697f,
		61913.62248744399f,
		61934.655608927525f,
		61955.69051628427f,
		61976.72720921102f,
		61997.765687404724f,
		62018.80595056245f,
		62039.847998381374f,
		62060.891830558845f,
		62081.93744679229f,
		62102.9848467793f,
		62124.034030217575f,
		62145.084996804966f,
		62166.137746239416f,
		62187.19227821903f,
		62208.248592442025f,
		62229.30668860674f,
		62250.366566411656f,
		62271.42822555538f,
		62292.49166573663f,
		62313.55688665427f,
		62334.62388800727f,
		62355.69266949476f,
		62376.763230815974f,
		62397.83557167027f,
		62418.909691757144f,
		62439.98559077621f,
		62461.06326842723f,
		62482.14272441005f,
		62503.223958424685f,
		62524.30697017127f,
		62545.39175935003f,
		62566.47832566137f,
		62587.56666880577f,
		62608.65678848388f,
		62629.74868439645f,
		62650.842356244364f,
		62671.93780372862f,
		62693.035026550366f,
		62714.13402441086f,
		62735.23479701148f,
		62756.33734405374f,
		62777.441665239276f,
		62798.54776026985f,
		62819.65562884736f,
		62840.7652706738f,
		62861.87668545132f,
		62882.989872882186f,
		62904.104832668774f,
		62925.2215645136f,
		62946.34006811931f,
		62967.46034318866f,
		62988.582389424526f,
		63009.70620652994f,
		63030.83179420802f,
		63051.95915216204f,
		63073.08828009537f,
		63094.21917771154f,
		63115.351844714154f,
		63136.48628080699f,
		63157.62248569392f,
		63178.760459078956f,
		63199.90020066622f,
		63221.04171015997f,
		63242.18498726457f,
		63263.330031684534f,
		63284.476843124474f,
		63305.62542128914f,
		63326.77576588341f,
		63347.92787661226f,
		63369.08175318081f,
		63390.237395294316f,
		63411.39480265812f,
		63432.553974977716f,
		63453.71491195871f,
		63474.87761330684f,
		63496.04207872794f,
		63517.208307928f,
		63538.37630061312f,
		63559.546056489504f,
		63580.717575263516f,
		63601.89085664161f,
		63623.06590033037f,
		63644.242706036515f,
		63665.42127346687f,
		63686.60160232838f,
		63707.783692328136f,
		63728.967543173334f,
		63750.15315457128f,
		63771.34052622942f,
		63792.52965785532f,
		63813.72054915665f,
		63834.91319984123f,
		63856.10760961698f,
		63877.30377819194f,
		63898.501705274284f,
		63919.7013905723f,
		63940.902833794404f,
		63962.106034649114f,
		63983.310992845094f,
		64004.51770809111f,
		64025.72618009605f,
		64046.93640856894f,
		64068.1483932189f,
		64089.362133755196f,
		64110.57762988719f,
		64131.79488132439f,
		64153.013887776404f,
		64174.23464895297f,
		64195.45716456394f,
		64216.68143431929f,
		64237.90745792911f,
		64259.135235103626f,
		64280.36476555316f,
		64301.59604898817f,
		64322.829085119236f,
		64344.06387365704f,
		64365.3004143124f,
		64386.53870679625f,
		64407.778750819634f,
		64429.02054609372f,
		64450.26409232981f,
		64471.50938923929f,
		64492.75643653371f,
		64514.005233924705f,
		64535.25578112403f,
		64556.50807784358f,
		64577.76212379536f,
		64599.017918691476f,
		64620.27546224417f,
		64641.534754165805f,
		64662.795794168844f,
		64684.058581965895f,
		64705.32311726966f,
		64726.589399792974f,
		64747.857429248776f,
		64769.12720535014f,
		64790.398727810236f,
		64811.671996342375f,
		64832.94701065997f,
		64854.22377047656f,
		64875.502275505794f,
		64896.78252546145f,
		64918.064520057414f,
		64939.34825900768f,
		64960.63374202639f,
		64981.92096882776f,
		65003.209939126165f,
		65024.50065263607f,
		65045.79310907207f,
		65067.08730814886f,
		65088.38324958128f,
		65109.68093308426f,
		65130.980358372864f,
		65152.28152516226f,
		65173.584433167736f,
		65194.8890821047f,
		65216.19547168868f,
		65237.50360163532f,
		65258.81347166035f,
		65280.125081479666f,
		65301.43843080924f,
		65322.75351936518f,
		65344.07034686371f,
		65365.38891302115f,
		65386.70921755396f,
		65408.0312601787f,
		65429.355040612056f,
		65450.68055857082f,
		65472.00781377191f,
		65493.336805932355f,
		65514.66753476928f,
		65535.999999999956f,
		65557.33420134176f,
		65578.67013851217f,
		65600.00781122879f,
		65621.34721920933f,
		65642.68836217163f,
		65664.03123983364f,
		65685.37585191341f,
		65706.72219812914f,
		65728.07027819908f,
		65749.42009184166f,
		65770.7716387754f,
		65792.12491871894f,
		65813.479931391f,
		65834.83667651046f,
		65856.1951537963f,
		65877.5553629676f,
		65898.91730374355f,
		65920.28097584349f,
		65941.64637898684f,
		65963.01351289316f,
		65984.38237728208f,
		66005.75297187339f,
		66027.12529638696f,
		66048.4993505428f,
		66069.87513406102f,
		66091.25264666184f,
		66112.63188806562f,
		66134.01285799277f,
		66155.39555616389f,
		66176.77998229963f,
		66198.1661361208f,
		66219.55401734827f,
		66240.9436257031f,
		66262.33496090639f,
		66283.7280226794f,
		66305.12281074344f,
		66326.51932482002f,
		66347.9175646307f,
		66369.31752989716f,
		66390.71922034123f,
		66412.12263568479f,
		66433.52777564988f,
		66454.93463995864f,
		66476.34322833332f,
		66497.75354049628f,
		66519.16557617f,
		66540.57933507704f,
		66561.99481694012f,
		66583.41202148204f,
		66604.83094842573f,
		66626.25159749422f,
		66647.67396841063f,
		66669.09806089824f,
		66690.52387468038f,
		66711.95140948056f,
		66733.38066502237f,
		66754.81164102948f,
		66776.24433722571f,
		66797.67875333499f,
		66819.11488908132f,
		66840.55274418888f,
		66861.9923183819f,
		66883.43361138474f,
		66904.87662292189f,
		66926.3213527179f,
		66947.7678004975f,
		66969.21596598547f,
		66990.66584890673f,
		67012.1174489863f,
		67033.57076594933f,
		67055.02579952106f,
		67076.48254942682f,
		67097.94101539208f,
		67119.40119714243f,
		67140.86309440355f,
		67162.32670690122f,
		67183.79203436135f,
		67205.25907650996f,
		67226.72783307315f,
		67248.19830377717f,
		67269.67048834835f,
		67291.14438651314f,
		67312.61999799809f,
		67334.09732252988f,
		67355.5763598353f,
		67377.05710964119f,
		67398.53957167457f,
		67420.02374566255f,
		67441.50963133233f,
		67462.99722841123f,
		67484.48653662669f,
		67505.97755570622f,
		67527.4702853775f,
		67548.96472536826f,
		67570.46087540637f,
		67591.9587352198f,
		67613.45830453663f,
		67634.95958308503f,
		67656.46257059333f,
		67677.9672667899f,
		67699.47367140325f,
		67720.98178416202f,
		67742.49160479492f,
		67764.0031330308f,
		67785.51636859858f,
		67807.03131122731f,
		67828.54796064617f,
		67850.0663165844f,
		67871.58637877138f,
		67893.10814693659f,
		67914.63162080961f,
		67936.15680012014f,
		67957.68368459797f,
		67979.21227397301f,
		68000.74256797526f,
		68022.27456633488f,
		68043.80826878206f,
		68065.34367504714f,
		68086.88078486058f,
		68108.41959795292f,
		68129.96011405479f,
		68151.50233289697f,
		68173.04625421032f,
		68194.59187772583f,
		68216.13920317456f,
		68237.6882302877f,
		68259.23895879654f,
		68280.79138843248f,
		68302.34551892703f,
		68323.90135001179f,
		68345.45888141848f,
		68367.01811287891f,
		68388.57904412503f,
		68410.14167488884f,
		68431.7060049025f,
		68453.27203389826f,
		68474.83976160845f,
		68496.40918776554f,
		68517.98031210208f,
		68539.55313435073f,
		68561.12765424428f,
		68582.70387151558f,
		68604.28178589763f,
		68625.8613971235f,
		68647.44270492639f,
		68669.0257090396f,
		68690.61040919652f,
		68712.19680513066f,
		68733.78489657563f,
		68755.37468326512f,
		68776.966164933f,
		68798.55934131313f,
		68820.15421213959f,
		68841.75077714647f,
		68863.34903606804f,
		68884.94898863863f,
		68906.55063459268f,
		68928.15397366474f,
		68949.75900558944f,
		68971.36573010158f,
		68992.97414693599f,
		69014.58425582763f,
		69036.19605651159f,
		69057.80954872302f,
		69079.4247321972f,
		69101.04160666953f,
		69122.66017187547f,
		69144.2804275506f,
		69165.90237343062f,
		69187.52600925133f,
		69209.15133474862f,
		69230.77834965847f,
		69252.40705371699f,
		69274.0374466604f,
		69295.669528225f,
		69317.30329814719f,
		69338.9387561635f,
		69360.57590201053f,
		69382.214735425f,
		69403.85525614375f,
		69425.49746390368f,
		69447.14135844183f,
		69468.78693949533f,
		69490.4342068014f,
		69512.08316009739f,
		69533.73379912072f,
		69555.38612360893f,
		69577.04013329967f,
		69598.69582793067f,
		69620.3532072398f,
		69642.01227096497f,
		69663.67301884426f,
		69685.33545061579f,
		69706.99956601784f,
		69728.66536478874f,
		69750.33284666698f,
		69772.00201139107f,
		69793.67285869969f,
		69815.34538833161f,
		69837.01960002567f,
		69858.69549352085f,
		69880.3730685562f,
		69902.0523248709f,
		69923.73326220422f,
		69945.41588029549f,
		69967.10017888421f,
		69988.78615770994f,
		70010.47381651236f,
		70032.16315503122f,
		70053.8541730064f,
		70075.54687017787f,
		70097.24124628572f,
		70118.93730107011f,
		70140.6350342713f,
		70162.33444562969f,
		70184.03553488574f,
		70205.73830178002f,
		70227.44274605322f,
		70249.1488674461f,
		70270.85666569954f,
		70292.56614055451f,
		70314.2772917521f,
		70335.9901190335f,
		70357.70462213994f,
		70379.42080081282f,
		70401.13865479361f,
		70422.85818382389f,
		70444.57938764534f,
		70466.30226599972f,
		70488.02681862892f,
		70509.75304527488f,
		70531.48094567971f,
		70553.21051958555f,
		70574.9417667347f,
		70596.6746868695f,
		70618.40927973246f,
		70640.1455450661f,
		70661.8834826131f,
		70683.62309211626f,
		70705.36437331841f,
		70727.10732596253f,
		70748.85194979167f,
		70770.59824454901f,
		70792.34620997778f,
		70814.09584582137f,
		70835.84715182323f,
		70857.6001277269f,
		70879.35477327603f,
		70901.11108821441f,
		70922.86907228586f,
		70944.62872523433f,
		70966.39004680388f,
		70988.15303673863f,
		71009.91769478285f,
		71031.68402068088f,
		71053.45201417715f,
		71075.22167501619f,
		71096.99300294266f,
		71118.76599770127f,
		71140.54065903684f,
		71162.31698669434f,
		71184.09498041874f,
		71205.87463995522f,
		71227.65596504895f,
		71249.4389554453f,
		71271.22361088963f,
		71293.00993112748f,
		71314.79791590448f,
		71336.5875649663f,
		71358.37887805876f,
		71380.17185492777f,
		71401.96649531931f,
		71423.76279897949f,
		71445.56076565449f,
		71467.3603950906f,
		71489.16168703421f,
		71510.96464123181f,
		71532.76925742996f,
		71554.57553537536f,
		71576.38347481475f,
		71598.19307549503f,
		71620.00433716313f,
		71641.81725956615f,
		71663.63184245121f,
		71685.4480855656f,
		71707.26598865664f,
		71729.0855514718f,
		71750.90677375859f,
		71772.72965526467f,
		71794.55419573777f,
		71816.38039492571f,
		71838.20825257644f,
		71860.03776843796f,
		71881.86894225838f,
		71903.70177378594f,
		71925.53626276893f,
		71947.37240895575f,
		71969.2102120949f,
		71991.04967193498f,
		72012.89078822469f,
		72034.73356071279f,
		72056.57798914817f,
		72078.42407327982f,
		72100.2718128568f,
		72122.12120762825f,
		72143.97225734347f,
		72165.8249617518f,
		72187.67932060269f,
		72209.53533364569f,
		72231.39300063043f,
		72253.25232130665f,
		72275.11329542418f,
		72296.97592273295f,
		72318.84020298296f,
		72340.70613592434f,
		72362.57372130727f,
		72384.4429588821f,
		72406.31384839918f,
		72428.18638960904f,
		72450.06058226222f,
		72471.93642610943f,
		72493.81392090143f,
		72515.6930663891f,
		72537.57386232339f,
		72559.45630845535f,
		72581.34040453614f,
		72603.22615031699f,
		72625.11354554925f,
		72647.00258998433f,
		72668.89328337376f,
		72690.78562546917f,
		72712.67961602227f,
		72734.57525478485f,
		72756.47254150882f,
		72778.37147594614f,
		72800.27205784894f,
		72822.17428696936f,
		72844.07816305969f,
		72865.98368587228f,
		72887.8908551596f,
		72909.79967067418f,
		72931.7101321687f,
		72953.62223939585f,
		72975.53599210849f,
		72997.45139005952f,
		73019.36843300196f,
		73041.28712068892f,
		73063.20745287361f,
		73085.1294293093f,
		73107.05304974939f,
		73128.97831394733f,
		73150.90522165672f,
		73172.83377263122f,
		73194.76396662457f,
		73216.69580339061f,
		73238.62928268328f,
		73260.56440425663f,
		73282.50116786477f,
		73304.4395732619f,
		73326.37962020234f,
		73348.32130844049f,
		73370.26463773084f,
		73392.20960782796f,
		73414.15621848653f,
		73436.10446946132f,
		73458.05436050717f,
		73480.00589137906f,
		73501.95906183199f,
		73523.91387162112f,
		73545.87032050166f,
		73567.82840822893f,
		73589.78813455833f,
		73611.74949924536f,
		73633.71250204562f,
		73655.67714271475f,
		73677.64342100856f,
		73699.61133668288f,
		73721.58088949369f,
		73743.55207919702f,
		73765.524905549f,
		73787.49936830586f,
		73809.4754672239f,
		73831.45320205955f,
		73853.43257256929f,
		73875.41357850972f,
		73897.3962196375f,
		73919.38049570941f,
		73941.36640648231f,
		73963.35395171314f,
		73985.34313115895f,
		74007.33394457687f,
		74029.32639172411f,
		74051.32047235797f,
		74073.31618623588f,
		74095.3135331153f,
		74117.31251275384f,
		74139.31312490914f,
		74161.31536933898f,
		74183.31924580119f,
		74205.32475405373f,
		74227.33189385463f,
		74249.34066496199f,
		74271.35106713403f,
		74293.36310012905f,
		74315.37676370544f,
		74337.39205762166f,
		74359.4089816363f,
		74381.427535508f,
		74403.4477189955f,
		74425.46953185767f,
		74447.4929738534f,
		74469.5180447417f,
		74491.54474428168f,
		74513.57307223254f,
		74535.60302835355f,
		74557.63461240409f,
		74579.6678241436f,
		74601.70266333164f,
		74623.73912972784f,
		74645.77722309194f,
		74667.81694318372f,
		74689.85828976311f,
		74711.9012625901f,
		74733.94586142474f,
		74755.99208602723f,
		74778.0399361578f,
		74800.08941157682f,
		74822.1405120447f,
		74844.19323732196f,
		74866.24758716923f,
		74888.30356134719f,
		74910.36115961662f,
		74932.42038173841f,
		74954.4812274735f,
		74976.54369658297f,
		74998.60778882793f,
		75020.6735039696f,
		75042.74084176932f,
		75064.80980198846f,
		75086.88038438853f,
		75108.9525887311f,
		75131.02641477782f,
		75153.10186229047f,
		75175.17893103085f,
		75197.25762076092f,
		75219.33793124268f,
		75241.41986223822f,
		75263.50341350974f,
		75285.5885848195f,
		75307.67537592987f,
		75329.76378660332f,
		75351.85381660235f,
		75373.94546568961f,
		75396.0387336278f,
		75418.13362017972f,
		75440.23012510825f,
		75462.32824817636f,
		75484.42798914711f,
		75506.52934778365f,
		75528.63232384919f,
		75550.73691710707f,
		75572.8431273207f,
		75594.95095425354f,
		75617.0603976692f,
		75639.17145733131f,
		75661.28413300365f,
		75683.39842445003f,
		75705.5143314344f,
		75727.63185372074f,
		75749.75099107318f,
		75771.87174325586f,
		75793.99411003308f,
		75816.11809116918f,
		75838.24368642858f,
		75860.37089557585f,
		75882.49971837556f,
		75904.63015459242f,
		75926.76220399122f,
		75948.89586633682f,
		75971.03114139418f,
		75993.16802892832f,
		76015.3065287044f,
		76037.4466404876f,
		76059.58836404321f,
		76081.73169913665f,
		76103.87664553335f,
		76126.02320299888f,
		76148.17137129887f,
		76170.32115019904f,
		76192.4725394652f,
		76214.62553886326f,
		76236.78014815917f,
		76258.93636711901f,
		76281.09419550892f,
		76303.25363309514f,
		76325.41467964397f,
		76347.57733492184f,
		76369.74159869523f,
		76391.90747073069f,
		76414.07495079488f,
		76436.24403865456f,
		76458.41473407655f,
		76480.58703682775f,
		76502.76094667517f,
		76524.93646338588f,
		76547.11358672705f,
		76569.29231646592f,
		76591.47265236982f,
		76613.65459420616f,
		76635.83814174247f,
		76658.02329474631f,
		76680.21005298535f,
		76702.39841622734f,
		76724.58838424014f,
		76746.77995679164f,
		76768.97313364987f,
		76791.1679145829f,
		76813.3642993589f,
		76835.56228774616f,
		76857.76187951297f,
		76879.9630744278f,
		76902.16587225911f,
		76924.37027277553f,
		76946.57627574573f,
		76968.78388093844f,
		76990.99308812252f,
		77013.2038970669f,
		77035.41630754055f,
		77057.63031931262f,
		77079.84593215224f,
		77102.0631458287f,
		77124.28196011129f,
		77146.50237476948f,
		77168.72438957276f,
		77190.94800429072f,
		77213.17321869303f,
		77235.40003254944f,
		77257.6284456298f,
		77279.85845770403f,
		77302.09006854212f,
		77324.32327791417f,
		77346.55808559034f,
		77368.79449134089f,
		77391.03249493614f,
		77413.27209614652f,
		77435.51329474253f,
		77457.75609049473f,
		77480.0004831738f,
		77502.2464725505f,
		77524.49405839563f,
		77546.74324048011f,
		77568.99401857494f,
		77591.2463924512f,
		77613.50036188003f,
		77635.75592663266f,
		77658.01308648044f,
		77680.27184119476f,
		77702.53219054709f,
		77724.79413430902f,
		77747.0576722522f,
		77769.32280414834f,
		77791.58952976925f,
		77813.85784888684f,
		77836.12776127306f,
		77858.3992667f,
		77880.67236493979f,
		77902.94705576463f,
		77925.22333894683f,
		77947.50121425878f,
		77969.78068147293f,
		77992.06174036184f,
		78014.34439069813f,
		78036.62863225449f,
		78058.91446480375f,
		78081.20188811873f,
		78103.49090197241f,
		78125.78150613782f,
		78148.07370038806f,
		78170.36748449634f,
		78192.66285823593f,
		78214.95982138017f,
		78237.2583737025f,
		78259.55851497645f,
		78281.86024497561f,
		78304.16356347366f,
		78326.46847024436f,
		78348.77496506154f,
		78371.08304769913f,
		78393.3927179311f,
		78415.70397553158f,
		78438.0168202747f,
		78460.3312519347f,
		78482.6472702859f,
		78504.96487510273f,
		78527.28406615963f,
		78549.6048432312f,
		78571.92720609205f,
		78594.25115451691f,
		78616.5766882806f,
		78638.90380715799f,
		78661.23251092403f,
		78683.56279935378f,
		78705.89467222235f,
		78728.22812930495f,
		78750.56317037686f,
		78772.89979521342f,
		78795.2380035901f,
		78817.5777952824f,
		78839.91917006593f,
		78862.26212771636f,
		78884.60666800945f,
		78906.95279072104f,
		78929.30049562705f,
		78951.64978250346f,
		78974.00065112638f,
		78996.35310127193f,
		79018.70713271636f,
		79041.06274523598f,
		79063.41993860717f,
		79085.77871260644f,
		79108.13906701028f,
		79130.50100159539f,
		79152.86451613842f,
		79175.22961041618f,
		79197.59628420553f,
		79219.96453728342f,
		79242.33436942687f,
		79264.70578041299f,
		79287.07877001894f,
		79309.45333802201f,
		79331.82948419951f,
		79354.20720832888f,
		79376.58651018758f,
		79398.96738955322f,
		79421.34984620343f,
		79443.73387991595f,
		79466.11949046858f,
		79488.50667763922f,
		79510.89544120582f,
		79533.28578094643f,
		79555.67769663916f,
		79578.07118806223f,
		79600.4662549939f,
		79622.86289721253f,
		79645.26111449653f,
		79667.66090662447f,
		79690.06227337488f,
		79712.46521452646f,
		79734.86972985794f,
		79757.27581914813f,
		79779.68348217595f,
		79802.09271872038f,
		79824.50352856045f,
		79846.91591147533f,
		79869.3298672442f,
		79891.74539564634f,
		79914.16249646115f,
		79936.58116946805f,
		79959.00141444655f,
		79981.42323117626f,
		80003.84661943685f,
		80026.27157900808f,
		80048.69810966977f,
		80071.12621120183f,
		80093.55588338424f,
		80115.98712599705f,
		80138.41993882041f,
		80160.85432163453f,
		80183.29027421969f,
		80205.72779635628f,
		80228.16688782471f,
		80250.60754840553f,
		80273.04977787934f,
		80295.49357602678f,
		80317.93894262865f,
		80340.38587746573f,
		80362.83438031895f,
		80385.28445096928f,
		80407.73608919779f,
		80430.1892947856f,
		80452.64406751392f,
		80475.10040716403f,
		80497.55831351732f,
		80520.01778635521f,
		80542.47882545921f,
		80564.94143061092f,
		80587.405601592f,
		80609.8713381842f,
		80632.33864016933f,
		80654.8075073293f,
		80677.27793944607f,
		80699.74993630168f,
		80722.22349767828f,
		80744.69862335804f,
		80767.17531312324f,
		80789.65356675624f,
		80812.13338403947f,
		80834.6147647554f,
		80857.09770868665f,
		80879.58221561585f,
		80902.06828532573f,
		80924.5559175991f,
		80947.04511221882f,
		80969.53586896788f,
		80992.02818762927f,
		81014.52206798614f,
		81037.01750982161f,
		81059.514512919f,
		81082.01307706161f,
		81104.51320203283f,
		81127.01488761618f,
		81149.5181335952f,
		81172.0229397535f,
		81194.5293058748f,
		81217.0372317429f,
		81239.54671714164f,
		81262.05776185496f,
		81284.57036566685f,
		81307.0845283614f,
		81329.60024972277f,
		81352.11752953519f,
		81374.63636758295f,
		81397.15676365045f,
		81419.67871752213f,
		81442.20222898253f,
		81464.72729781622f,
		81487.25392380793f,
		81509.78210674238f,
		81532.3118464044f,
		81554.8431425789f,
		81577.37599505084f,
		81599.91040360527f,
		81622.44636802733f,
		81644.98388810222f,
		81667.52296361518f,
		81690.06359435158f,
		81712.60578009684f,
		81735.14952063645f,
		81757.69481575597f,
		81780.24166524105f,
		81802.79006887741f,
		81825.34002645082f,
		81847.89153774717f,
		81870.44460255238f,
		81892.99922065248f,
		81915.5553918335f,
		81938.11311588167f,
		81960.67239258319f,
		81983.23322172434f,
		82005.79560309154f,
		82028.35953647122f,
		82050.9250216499f,
		82073.49205841421f,
		82096.06064655079f,
		82118.63078584638f,
		82141.20247608784f,
		82163.77571706203f,
		82186.35050855593f,
		82208.92685035657f,
		82231.50474225105f,
		82254.08418402658f,
		82276.66517547039f,
		82299.24771636983f,
		82321.83180651232f,
		82344.4174456853f,
		82367.00463367635f,
		82389.59337027307f,
		82412.18365526316f,
		82434.77548843439f,
		82457.3688695746f,
		82479.9637984717f,
		82502.56027491367f,
		82525.1582986886f,
		82547.7578695846f,
		82570.35898738986f,
		82592.96165189268f,
		82615.5658628814f,
		82638.17162014442f,
		82660.77892347026f,
		82683.38777264747f,
		82705.99816746471f,
		82728.61010771066f,
		82751.22359317412f,
		82773.83862364394f,
		82796.45519890904f,
		82819.07331875843f,
		82841.69298298119f,
		82864.31419136643f,
		82886.93694370337f,
		82909.56123978132f,
		82932.18707938964f,
		82954.81446231774f,
		82977.44338835512f,
		83000.07385729137f,
		83022.70586891612f,
		83045.33942301909f,
		83067.97451939009f,
		83090.61115781896f,
		83113.24933809563f,
		83135.8890600101f,
		83158.53032335246f,
		83181.17312791286f,
		83203.8174734815f,
		83226.46335984867f,
		83249.11078680474f,
		83271.75975414013f,
		83294.41026164537f,
		83317.062309111f,
		83339.7158963277f,
		83362.37102308616f,
		83385.02768917716f,
		83407.68589439159f,
		83430.34563852036f,
		83453.00692135448f,
		83475.669742685f,
		83498.33410230308f,
		83520.99999999994f,
		83543.66743556687f,
		83566.33640879519f,
		83589.00691947635f,
		83611.67896740185f,
		83634.35255236324f,
		83657.02767415217f,
		83679.70433256036f,
		83702.38252737955f,
		83725.06225840164f,
		83747.74352541851f,
		83770.42632822218f,
		83793.11066660468f,
		83815.79654035816f,
		83838.48394927483f,
		83861.17289314694f,
		83883.86337176684f,
		83906.55538492696f,
		83929.24893241975f,
		83951.9440140378f,
		83974.6406295737f,
		83997.33877882015f,
		84020.03846156993f,
		84042.73967761586f,
		84065.44242675084f,
		84088.14670876783f,
		84110.85252345992f,
		84133.55987062017f,
		84156.2687500418f,
		84178.97916151803f,
		84201.6911048422f,
		84224.40457980771f,
		84247.119586208f,
		84269.83612383662f,
		84292.55419248715f,
		84315.27379195328f,
		84337.99492202874f,
		84360.71758250732f,
		84383.44177318295f,
		84406.16749384951f,
		84428.89474430107f,
		84451.62352433169f,
		84474.35383373554f,
		84497.08567230683f,
		84519.81903983987f,
		84542.553936129f,
		84565.29036096868f,
		84588.0283141534f,
		84610.76779547772f,
		84633.50880473628f,
		84656.25134172381f,
		84678.99540623507f,
		84701.74099806492f,
		84724.48811700825f,
		84747.23676286006f,
		84769.9869354154f,
		84792.73863446941f,
		84815.49185981725f,
		84838.2466112542f,
		84861.00288857557f,
		84883.76069157677f,
		84906.52002005326f,
		84929.28087380057f,
		84952.0432526143f,
		84974.80715629015f,
		84997.5725846238f,
		85020.33953741111f,
		85043.10801444795f,
		85065.87801553024f,
		85088.64954045399f,
		85111.4225890153f,
		85134.19716101032f,
		85156.97325623524f,
		85179.75087448637f,
		85202.53001556007f,
		85225.31067925273f,
		85248.09286536086f,
		85270.87657368102f,
		85293.66180400981f,
		85316.44855614395f,
		85339.23682988019f,
		85362.02662501535f,
		85384.81794134635f,
		85407.61077867013f,
		85430.40513678372f,
		85453.20101548426f,
		85475.99841456886f,
		85498.7973338348f,
		85521.59777307935f,
		85544.3997320999f,
		85567.2032106939f,
		85590.00820865881f,
		85612.81472579224f,
		85635.62276189183f,
		85658.43231675526f,
		85681.24339018033f,
		85704.05598196488f,
		85726.8700919068f,
		85749.68571980408f,
		85772.50286545476f,
		85795.32152865696f,
		85818.14170920885f,
		85840.96340690868f,
		85863.78662155475f,
		85886.61135294545f,
		85909.43760087922f,
		85932.26536515457f,
		85955.09464557009f,
		85977.92544192442f,
		86000.75775401627f,
		86023.59158164443f,
		86046.42692460775f,
		86069.26378270512f,
		86092.10215573556f,
		86114.94204349807f,
		86137.7834457918f,
		86160.62636241592f,
		86183.47079316968f,
		86206.31673785238f,
		86229.1641962634f,
		86252.0131682022f,
		86274.8636534683f,
		86297.71565186126f,
		86320.56916318073f,
		86343.42418722642f,
		86366.28072379812f,
		86389.13877269567f,
		86411.99833371898f,
		86434.85940666801f,
		86457.72199134283f,
		86480.58608754353f,
		86503.45169507028f,
		86526.31881372335f,
		86549.18744330303f,
		86572.05758360968f,
		86594.92923444376f,
		86617.80239560577f,
		86640.67706689627f,
		86663.5532481159f,
		86686.43093906538f,
		86709.31013954544f,
		86732.19084935696f,
		86755.07306830082f,
		86777.95679617795f,
		86800.84203278944f,
		86823.72877793635f,
		86846.61703141985f,
		86869.50679304118f,
		86892.39806260161f,
		86915.29083990252f,
		86938.1851247453f,
		86961.08091693149f,
		86983.97821626259f,
		87006.87702254027f,
		87029.77733556618f,
		87052.67915514208f,
		87075.5824810698f,
		87098.48731315118f,
		87121.39365118822f,
		87144.3014949829f,
		87167.21084433729f,
		87190.12169905353f,
		87213.03405893384f,
		87235.9479237805f,
		87258.86329339583f,
		87281.78016758224f,
		87304.69854614217f,
		87327.61842887818f,
		87350.53981559286f,
		87373.46270608885f,
		87396.3871001689f,
		87419.31299763577f,
		87442.24039829234f,
		87465.16930194154f,
		87488.09970838632f,
		87511.03161742973f,
		87533.9650288749f,
		87556.89994252501f,
		87579.83635818327f,
		87602.77427565302f,
		87625.71369473761f,
		87648.65461524049f,
		87671.59703696515f,
		87694.54095971514f,
		87717.4863832941f,
		87740.43330750574f,
		87763.38173215378f,
		87786.33165704206f,
		87809.28308197446f,
		87832.23600675492f,
		87855.19043118745f,
		87878.14635507615f,
		87901.10377822515f,
		87924.06270043863f,
		87947.02312152089f,
		87969.98504127625f,
		87992.94845950909f,
		88015.9133760239f,
		88038.87979062517f,
		88061.84770311751f,
		88084.81711330556f,
		88107.78802099405f,
		88130.76042598773f,
		88153.73432809146f,
		88176.70972711014f,
		88199.68662284875f,
		88222.6650151123f,
		88245.6449037059f,
		88268.62628843471f,
		88291.60916910395f,
		88314.5935455189f,
		88337.57941748491f,
		88360.56678480741f,
		88383.55564729185f,
		88406.5460047438f,
		88429.53785696882f,
		88452.53120377261f,
		88475.52604496089f,
		88498.52238033945f,
		88521.52020971413f,
		88544.51953289087f,
		88567.52034967564f,
		88590.5226598745f,
		88613.52646329353f,
		88636.53175973892f,
		88659.5385490169f,
		88682.54683093374f,
		88705.55660529585f,
		88728.56787190959f,
		88751.58063058149f,
		88774.59488111807f,
		88797.61062332596f,
		88820.62785701183f,
		88843.6465819824f,
		88866.66679804446f,
		88889.68850500489f,
		88912.71170267061f,
		88935.73639084859f,
		88958.7625693459f,
		88981.79023796963f,
		89004.81939652696f,
		89027.85004482511f,
		89050.88218267141f,
		89073.9158098732f,
		89096.95092623789f,
		89119.98753157297f,
		89143.025625686f,
		89166.06520838456f,
		89189.10627947636f,
		89212.14883876909f,
		89235.19288607058f,
		89258.23842118867f,
		89281.28544393127f,
		89304.33395410638f,
		89327.38395152202f,
		89350.4354359863f,
		89373.4884073074f,
		89396.54286529354f,
		89419.598809753f,
		89442.65624049417f,
		89465.71515732541f,
		89488.77556005522f,
		89511.83744849212f,
		89534.90082244476f,
		89557.96568172173f,
		89581.03202613181f,
		89604.09985548374f,
		89627.1691695864f,
		89650.23996824867f,
		89673.31225127954f,
		89696.38601848802f,
		89719.4612696832f,
		89742.53800467425f,
		89765.61622327036f,
		89788.69592528083f,
		89811.77711051499f,
		89834.85977878221f,
		89857.94392989198f,
		89881.0295636538f,
		89904.11667987728f,
		89927.20527837201f,
		89950.29535894774f,
		89973.38692141422f,
		89996.47996558127f,
		90019.57449125877f,
		90042.67049825669f,
		90065.76798638502f,
		90088.86695545384f,
		90111.96740527326f,
		90135.06933565348f,
		90158.17274640476f,
		90181.2776373374f,
		90204.3840082618f,
		90227.49185898836f,
		90250.60118932759f,
		90273.71199909004f,
		90296.82428808633f,
		90319.93805612714f,
		90343.05330302319f,
		90366.1700285853f,
		90389.2882326243f,
		90412.40791495114f,
		90435.52907537678f,
		90458.65171371226f,
		90481.77582976868f,
		90504.90142335721f,
		90528.02849428906f,
		90551.1570423755f,
		90574.28706742791f,
		90597.41856925764f,
		90620.5515476762f,
		90643.68600249507f,
		90666.82193352585f,
		90689.95934058019f,
		90713.09822346977f,
		90736.23858200636f,
		90759.3804160018f,
		90782.52372526795f,
		90805.66850961676f,
		90828.81476886023f,
		90851.96250281043f,
		90875.11171127946f,
		90898.26239407953f,
		90921.41455102284f,
		90944.56818192174f,
		90967.72328658856f,
		90990.87986483572f,
		91014.03791647572f,
		91037.19744132107f,
		91060.35843918439f,
		91083.52090987834f,
		91106.68485321563f,
		91129.85026900904f,
		91153.0171570714f,
		91176.18551721562f,
		91199.35534925465f,
		91222.52665300149f,
		91245.69942826925f,
		91268.87367487104f,
		91292.04939262004f,
		91315.22658132955f,
		91338.40524081283f,
		91361.58537088329f,
		91384.76697135434f,
		91407.95004203948f,
		91431.13458275225f,
		91454.32059330626f,
		91477.50807351517f,
		91500.69702319271f,
		91523.88744215269f,
		91547.07933020893f,
		91570.27268717533f,
		91593.46751286586f,
		91616.66380709453f,
		91639.86156967544f,
		91663.06080042271f,
		91686.26149915057f,
		91709.46366567322f,
		91732.66729980502f,
		91755.87240136032f,
		91779.07897015357f,
		91802.28700599924f,
		91825.49650871192f,
		91848.70747810617f,
		91871.91991399668f,
		91895.13381619815f,
		91918.34918452542f,
		91941.56601879328f,
		91964.78431881666f,
		91988.0040844105f,
		92011.22531538982f,
		92034.44801156971f,
		92057.67217276528f,
		92080.89779879176f,
		92104.12488946435f,
		92127.35344459841f,
		92150.58346400928f,
		92173.81494751238f,
		92197.04789492322f,
		92220.28230605731f,
		92243.51818073026f,
		92266.75551875774f,
		92289.99431995547f,
		92313.2345841392f,
		92336.47631112477f,
		92359.71950072808f,
		92382.96415276507f,
		92406.21026705173f,
		92429.45784340418f,
		92452.70688163847f,
		92475.95738157081f,
		92499.20934301744f,
		92522.46276579465f,
		92545.7176497188f,
		92568.9739946063f,
		92592.23180027361f,
		92615.49106653726f,
		92638.75179321383f,
		92662.01398011995f,
		92685.27762707233f,
		92708.54273388773f,
		92731.80930038294f,
		92755.07732637487f,
		92778.34681168041f,
		92801.61775611658f,
		92824.89015950038f,
		92848.16402164895f,
		92871.43934237942f,
		92894.71612150903f,
		92917.99435885502f,
		92941.27405423473f,
		92964.55520746557f,
		92987.83781836496f,
		93011.12188675042f,
		93034.40741243947f,
		93057.69439524977f,
		93080.98283499895f,
		93104.27273150477f,
		93127.564084585f,
		93150.8568940575f,
		93174.15115974014f,
		93197.44688145092f,
		93220.7440590078f,
		93244.04269222889f,
		93267.34278093232f,
		93290.64432493623f,
		93313.94732405891f,
		93337.25177811863f,
		93360.55768693375f,
		93383.8650503227f,
		93407.17386810391f,
		93430.48414009594f,
		93453.79586611736f,
		93477.10904598678f,
		93500.42367952294f,
		93523.73976654456f,
		93547.05730687045f,
		93570.37630031949f,
		93593.69674671057f,
		93617.0186458627f,
		93640.3419975949f,
		93663.66680172624f,
		93686.99305807588f,
		93710.32076646303f,
		93733.64992670694f,
		93756.98053862691f,
		93780.31260204234f,
		93803.64611677264f,
		93826.9810826373f,
		93850.31749945584f,
		93873.65536704786f,
		93896.99468523303f,
		93920.33545383104f,
		93943.67767266167f,
		93967.0213415447f,
		93990.36646030005f,
		94013.71302874765f,
		94037.06104670743f,
		94060.4105139995f,
		94083.7614304439f,
		94107.11379586085f,
		94130.46761007051f,
		94153.82287289316f,
		94177.17958414911f,
		94200.53774365876f,
		94223.89735124253f,
		94247.25840672091f,
		94270.62090991443f,
		94293.98486064372f,
		94317.35025872942f,
		94340.71710399224f,
		94364.08539625294f,
		94387.45513533235f,
		94410.82632105134f,
		94434.19895323085f,
		94457.57303169188f,
		94480.94855625545f,
		94504.32552674267f,
		94527.70394297468f,
		94551.08380477272f,
		94574.46511195804f,
		94597.84786435193f,
		94621.23206177581f,
		94644.61770405111f,
		94668.00479099927f,
		94691.39332244187f,
		94714.78329820049f,
		94738.1747180968f,
		94761.56758195249f,
		94784.9618895893f,
		94808.35764082908f,
		94831.7548354937f,
		94855.15347340508f,
		94878.55355438517f,
		94901.95507825605f,
		94925.35804483978f,
		94948.76245395854f,
		94972.16830543448f,
		94995.57559908989f,
		95018.98433474707f,
		95042.3945122284f,
		95065.80613135628f,
		95089.21919195318f,
		95112.63369384164f,
		95136.04963684424f,
		95159.46702078362f,
		95182.88584548247f,
		95206.30611076353f,
		95229.72781644962f,
		95253.15096236358f,
		95276.57554832831f,
		95300.00157416679f,
		95323.42903970205f,
		95346.85794475715f,
		95370.28828915521f,
		95393.72007271941f,
		95417.15329527302f,
		95440.5879566393f,
		95464.02405664159f,
		95487.46159510332f,
		95510.9005718479f,
		95534.34098669887f,
		95557.78283947978f,
		95581.22613001426f,
		95604.67085812596f,
		95628.1170236386f,
		95651.56462637598f,
		95675.01366616192f,
		95698.4641428203f,
		95721.91605617508f,
		95745.36940605023f,
		95768.8241922698f,
		95792.28041465791f,
		95815.7380730387f,
		95839.19716723639f,
		95862.65769707522f,
		95886.11966237954f,
		95909.58306297369f,
		95933.04789868211f,
		95956.51416932927f,
		95979.98187473971f,
		96003.451014738f,
		96026.92158914881f,
		96050.39359779679f,
		96073.86704050671f,
		96097.34191710339f,
		96120.81822741163f,
		96144.29597125638f,
		96167.77514846258f,
		96191.25575885524f,
		96214.73780225945f,
		96238.2212785003f,
		96261.70618740298f,
		96285.19252879272f,
		96308.68030249479f,
		96332.16950833453f,
		96355.66014613732f,
		96379.1522157286f,
		96402.64571693387f,
		96426.14064957868f,
		96449.6370134886f,
		96473.13480848931f,
		96496.63403440651f,
		96520.13469106596f,
		96543.63677829347f,
		96567.1402959149f,
		96590.64524375615f,
		96614.15162164322f,
		96637.65942940213f,
		96661.16866685895f,
		96684.6793338398f,
		96708.19143017087f,
		96731.7049556784f,
		96755.21991018867f,
		96778.73629352801f,
		96802.25410552284f,
		96825.77334599958f,
		96849.29401478474f,
		96872.81611170487f,
		96896.33963658658f,
		96919.86458925651f,
		96943.39096954139f,
		96966.91877726796f,
		96990.44801226305f,
		97013.97867435352f,
		97037.5107633663f,
		97061.04427912834f,
		97084.57922146667f,
		97108.11559020838f,
		97131.6533851806f,
		97155.19260621049f,
		97178.73325312529f,
		97202.2753257523f,
		97225.81882391885f,
		97249.36374745233f,
		97272.91009618019f,
		97296.4578699299f,
		97320.00706852904f,
		97343.5576918052f,
		97367.10973958601f,
		97390.6632116992f,
		97414.2181079725f,
		97437.77442823374f,
		97461.33217231077f,
		97484.89134003149f,
		97508.4519312239f,
		97532.01394571598f,
		97555.57738333581f,
		97579.14224391151f,
		97602.70852727126f,
		97626.27623324326f,
		97649.84536165581f,
		97673.41591233722f,
		97696.98788511587f,
		97720.56127982022f,
		97744.1360962787f,
		97767.71233431989f,
		97791.28999377234f,
		97814.86907446472f,
		97838.44957622568f,
		97862.031498884f,
		97885.61484226845f,
		97909.19960620788f,
		97932.7857905312f,
		97956.37339506732f,
		97979.96241964525f,
		98003.55286409408f,
		98027.14472824286f,
		98050.73801192077f,
		98074.332714957f,
		98097.9288371808f,
		98121.52637842152f,
		98145.12533850846f,
		98168.72571727107f,
		98192.32751453877f,
		98215.93073014112f,
		98239.53536390766f,
		98263.14141566801f,
		98286.74888525181f,
		98310.35777248882f,
		98333.96807720876f,
		98357.57979924149f,
		98381.19293841685f,
		98404.80749456478f,
		98428.42346751524f,
		98452.04085709827f,
		98475.65966314392f,
		98499.27988548232f,
		98522.90152394367f,
		98546.52457835816f,
		98570.1490485561f,
		98593.77493436779f,
		98617.40223562362f,
		98641.03095215405f,
		98664.66108378951f,
		98688.29263036055f,
		98711.92559169777f,
		98735.5599676318f,
		98759.1957579933f,
		98782.83296261301f,
		98806.47158132173f,
		98830.11161395028f,
		98853.75306032957f,
		98877.39592029051f,
		98901.0401936641f,
		98924.68588028138f,
		98948.33297997342f,
		98971.98149257139f,
		98995.63141790645f,
		99019.28275580984f,
		99042.93550611287f,
		99066.58966864688f,
		99090.24524324323f,
		99113.9022297334f,
		99137.56062794886f,
		99161.22043772115f,
		99184.88165888184f,
		99208.54429126263f,
		99232.20833469517f,
		99255.87378901121f,
		99279.54065404256f,
		99303.20892962103f,
		99326.87861557852f,
		99350.54971174701f,
		99374.22221795844f,
		99397.89613404489f,
		99421.57145983842f,
		99445.24819517121f,
		99468.92633987544f,
		99492.60589378334f,
		99516.28685672721f,
		99539.9692285394f,
		99563.65300905229f,
		99587.33819809832f,
		99611.02479551f,
		99634.71280111987f,
		99658.4022147605f,
		99682.09303626454f,
		99705.7852654647f,
		99729.47890219369f,
		99753.17394628433f,
		99776.87039756944f,
		99800.56825588191f,
		99824.26752105469f,
		99847.96819292076f,
		99871.67027131317f,
		99895.373756065f,
		99919.07864700939f,
		99942.78494397952f,
		99966.49264680862f,
		99990.20175533001f,
		100013.91226937699f,
		100037.62418878295f,
		100061.33751338134f,
		100085.05224300563f,
		100108.76837748935f,
		100132.4859166661f,
		100156.2048603695f,
		100179.92520843323f,
		100203.64696069101f,
		100227.37011697664f,
		100251.09467712394f,
		100274.82064096678f,
		100298.54800833909f,
		100322.27677907483f,
		100346.00695300807f,
		100369.73852997283f,
		100393.47150980328f,
		100417.20589233354f,
		100440.94167739789f,
		100464.67886483055f,
		100488.41745446586f,
		100512.1574461382f,
		100535.89883968196f,
		100559.64163493161f,
		100583.3858317217f,
		100607.13142988674f,
		100630.87842926137f,
		100654.62682968024f,
		100678.37663097809f,
		100702.12783298964f,
		100725.88043554971f,
		100749.63443849317f,
		100773.38984165489f,
		100797.14664486986f,
		100820.90484797307f,
		100844.66445079957f,
		100868.42545318443f,
		100892.18785496285f,
		100915.95165596998f,
		100939.71685604108f,
		100963.48345501146f,
		100987.25145271645f,
		101011.02084899142f,
		101034.79164367184f,
		101058.56383659315f,
		101082.33742759094f,
		101106.11241650078f,
		101129.88880315828f,
		101153.66658739912f,
		101177.44576905905f,
		101201.22634797383f,
		101225.00832397929f,
		101248.7916969113f,
		101272.5764666058f,
		101296.36263289873f,
		101320.15019562612f,
		101343.93915462404f,
		101367.7295097286f,
		101391.52126077596f,
		101415.31440760233f,
		101439.10895004397f,
		101462.9048879372f,
		101486.70222111835f,
		101510.50094942382f,
		101534.30107269008f,
		101558.10259075361f,
		101581.90550345098f,
		101605.70981061876f,
		101629.5155120936f,
		101653.32260771218f,
		101677.13109731126f,
		101700.9409807276f,
		101724.75225779804f,
		101748.56492835947f,
		101772.3789922488f,
		101796.19444930303f,
		101820.01129935916f,
		101843.82954225427f,
		101867.64917782549f,
		101891.47020590997f,
		101915.29262634492f,
		101939.11643896763f,
		101962.94164361537f,
		101986.76824012553f,
		102010.59622833549f,
		102034.42560808272f,
		102058.25637920471f,
		102082.08854153901f,
		102105.92209492321f,
		102129.75703919494f,
		102153.59337419191f,
		102177.43109975185f,
		102201.27021571253f,
		102225.1107219118f,
		102248.95261818753f,
		102272.79590437764f,
		102296.64058032009f,
		102320.48664585294f,
		102344.33410081422f,
		102368.18294504205f,
		102392.03317837461f,
		102415.88480065008f,
		102439.73781170673f,
		102463.59221138287f,
		102487.44799951684f,
		102511.30517594703f,
		102535.1637405119f,
		102559.02369304994f,
		102582.88503339965f,
		102606.74776139966f,
		102630.6118768886f,
		102654.47737970512f,
		102678.34426968795f,
		102702.21254667587f,
		102726.08221050771f,
		102749.95326102231f,
		102773.8256980586f,
		102797.69952145554f,
		102821.57473105213f,
		102845.45132668741f,
		102869.32930820051f,
		102893.20867543056f,
		102917.08942821674f,
		102940.97156639831f,
		102964.85508981455f,
		102988.73999830478f,
		103012.6262917084f,
		103036.51396986481f,
		103060.40303261351f,
		103084.293479794f,
		103108.18531124585f,
		103132.07852680866f,
		103155.97312632212f,
		103179.8691096259f,
		103203.76647655977f,
		103227.66522696352f,
		103251.565360677f,
		103275.46687754011f,
		103299.36977739276f,
		103323.27406007495f,
		103347.1797254267f,
		103371.08677328809f,
		103394.99520349925f,
		103418.90501590034f,
		103442.81621033157f,
		103466.7287866332f,
		103490.64274464553f,
		103514.55808420894f,
		103538.4748051638f,
		103562.39290735057f,
		103586.31239060973f,
		103610.23325478184f,
		103634.15549970744f,
		103658.0791252272f,
		103682.00413118176f,
		103705.93051741188f,
		103729.8582837583f,
		103753.78743006183f,
		103777.71795616334f,
		103801.64986190372f,
		103825.58314712394f,
		103849.51781166499f,
		103873.4538553679f,
		103897.39127807376f,
		103921.33007962372f,
		103945.27025985895f,
		103969.21181862066f,
		103993.15475575015f,
		104017.0990710887f,
		104041.0447644777f,
		104064.99183575854f,
		104088.94028477269f,
		104112.89011136163f,
		104136.84131536692f,
		104160.79389663014f,
		104184.74785499295f,
		104208.70319029699f,
		104232.65990238401f,
		104256.61799109579f,
		104280.57745627411f,
		104304.53829776088f,
		104328.50051539797f,
		104352.46410902737f,
		104376.42907849104f,
		104400.39542363104f,
		104424.36314428947f,
		104448.33224030846f,
		104472.3027115302f,
		104496.27455779689f,
		104520.24777895081f,
		104544.22237483428f,
		104568.19834528965f,
		104592.17569015936f,
		104616.15440928582f,
		104640.13450251156f,
		104664.11596967909f,
		104688.09881063103f,
		104712.08302520998f,
		104736.06861325864f,
		104760.05557461972f,
		104784.043909136f,
		104808.03361665027f,
		104832.0246970054f,
		104856.01715004431f,
		104880.01097560991f,
		104904.00617354522f,
		104928.00274369326f,
		104952.00068589713f,
		104975.99999999993f,
		105000.00068584486f,
		105024.00274327511f,
		105048.00617213396f,
		105072.01097226472f,
		105096.0171435107f,
		105120.02468571535f,
		105144.03359872208f,
		105168.04388237436f,
		105192.05553651575f,
		105216.06856098982f,
		105240.08295564016f,
		105264.09872031047f,
		105288.11585484444f,
		105312.13435908582f,
		105336.1542328784f,
		105360.17547606604f,
		105384.19808849262f,
		105408.22207000206f,
		105432.24742043833f,
		105456.27413964548f,
		105480.30222746753f,
		105504.33168374863f,
		105528.36250833291f,
		105552.39470106458f,
		105576.42826178786f,
		105600.46319034706f,
		105624.49948658649f,
		105648.53715035053f,
		105672.5761814836f,
		105696.61657983017f,
		105720.65834523473f,
		105744.70147754184f,
		105768.74597659608f,
		105792.79184224212f,
		105816.83907432464f,
		105840.88767268835f,
		105864.93763717801f,
		105888.98896763846f,
		105913.04166391456f,
		105937.09572585119f,
		105961.15115329332f,
		105985.20794608595f,
		106009.2661040741f,
		106033.32562710284f,
		106057.3865150173f,
		106081.44876766266f,
		106105.51238488412f,
		106129.57736652695f,
		106153.64371243643f,
		106177.71142245791f,
		106201.78049643678f,
		106225.85093421848f,
		106249.92273564848f,
		106273.99590057228f,
		106298.07042883546f,
		106322.14632028362f,
		106346.2235747624f,
		106370.30219211751f,
		106394.38217219469f,
		106418.4635148397f,
		106442.54621989837f,
		106466.63028721658f,
		106490.71571664023f,
		106514.8025080153f,
		106538.89066118775f,
		106562.98017600364f,
		106587.07105230905f,
		106611.16328995011f,
		106635.25688877302f,
		106659.35184862395f,
		106683.44816934918f,
		106707.54585079502f,
		106731.64489280782f,
		106755.74529523395f,
		106779.84705791986f,
		106803.95018071201f,
		106828.05466345693f,
		106852.16050600118f,
		106876.26770819136f,
		106900.37626987413f,
		106924.48619089619f,
		106948.59747110425f,
		106972.71011034511f,
		106996.82410846559f,
		107020.93946531255f,
		107045.05618073288f,
		107069.17425457356f,
		107093.29368668159f,
		107117.41447690397f,
		107141.53662508781f,
		107165.66013108024f,
		107189.7849947284f,
		107213.91121587952f,
		107238.03879438085f,
		107262.16773007967f,
		107286.29802282334f,
		107310.42967245923f,
		107334.56267883476f,
		107358.69704179741f,
		107382.83276119467f,
		107406.96983687414f,
		107431.10826868335f,
		107455.24805646998f,
		107479.38920008171f,
		107503.53169936626f,
		107527.6755541714f,
		107551.82076434491f,
		107575.96732973469f,
		107600.11525018861f,
		107624.26452555461f,
		107648.41515568066f,
		107672.56714041479f,
		107696.72047960508f,
		107720.87517309963f,
		107745.03122074658f,
		107769.18862239414f,
		107793.34737789052f,
		107817.50748708403f,
		107841.66894982298f,
		107865.83176595572f,
		107889.99593533068f,
		107914.16145779629f,
		107938.32833320105f,
		107962.49656139348f,
		107986.66614222217f,
		108010.83707553573f,
		108035.00936118282f,
		108059.18299901215f,
		108083.35798887245f,
		108107.53433061253f,
		108131.71202408121f,
		108155.89106912735f,
		108180.07146559987f,
		108204.25321334775f,
		108228.43631221994f,
		108252.62076206553f,
		108276.80656273357f,
		108300.9937140732f,
		108325.18221593359f,
		108349.37206816394f,
		108373.5632706135f,
		108397.75582313156f,
		108421.94972556747f,
		108446.1449777706f,
		108470.34157959036f,
		108494.53953087622f,
		108518.7388314777f,
		108542.9394812443f,
		108567.14148002566f,
		108591.34482767139f,
		108615.54952403114f,
		108639.75556895464f,
		108663.96296229165f,
		108688.17170389196f,
		108712.38179360541f,
		108736.59323128188f,
		108760.80601677128f,
		108785.02014992358f,
		108809.23563058881f,
		108833.45245861699f,
		108857.67063385822f,
		108881.89015616261f,
		108906.11102538036f,
		108930.33324136169f,
		108954.55680395682f,
		108978.78171301607f,
		109003.00796838978f,
		109027.2355699283f,
		109051.4645174821f,
		109075.69481090162f,
		109099.92645003737f,
		109124.15943473988f,
		109148.39376485976f,
		109172.62944024763f,
		109196.86646075416f,
		109221.10482623006f,
		109245.3445365261f,
		109269.58559149304f,
		109293.82799098175f,
		109318.0717348431f,
		109342.316822928f,
		109366.56325508743f,
		109390.81103117237f,
		109415.06015103386f,
		109439.31061452301f,
		109463.56242149093f,
		109487.8155717888f,
		109512.0700652678f,
		109536.3259017792f,
		109560.58308117429f,
		109584.8416033044f,
		109609.1014680209f,
		109633.36267517522f,
		109657.62522461878f,
		109681.88911620309f,
		109706.15434977971f,
		109730.4209252002f,
		109754.68884231619f,
		109778.95810097932f,
		109803.22870104131f,
		109827.50064235389f,
		109851.77392476884f,
		109876.048548138f,
		109900.32451231324f,
		109924.60181714644f,
		109948.88046248957f,
		109973.1604481946f,
		109997.44177411357f,
		110021.72444009855f,
		110046.00844600165f,
		110070.29379167501f,
		110094.58047697082f,
		110118.86850174134f,
		110143.15786583882f,
		110167.44856911557f,
		110191.74061142397f,
		110216.0339926164f,
		110240.32871254528f,
		110264.62477106311f,
		110288.9221680224f,
		110313.22090327571f,
		110337.52097667565f,
		110361.82238807483f,
		110386.12513732594f,
		110410.42922428172f,
		110434.7346487949f,
		110459.04141071832f,
		110483.34950990479f,
		110507.6589462072f,
		110531.96971947847f,
		110556.28182957157f,
		110580.5952763395f,
		110604.91005963532f,
		110629.2261793121f,
		110653.54363522294f,
		110677.86242722106f,
		110702.18255515961f,
		110726.50401889188f,
		110750.82681827113f,
		110775.1509531507f,
		110799.47642338395f,
		110823.80322882428f,
		110848.13136932514f,
		110872.46084474004f,
		110896.79165492248f,
		110921.12379972603f,
		110945.4572790043f,
		110969.79209261097f,
		110994.12824039967f,
		111018.46572222418f,
		111042.80453793824f,
		111067.14468739566f,
		111091.48617045028f,
		111115.82898695602f,
		111140.1731367668f,
		111164.51861973657f,
		111188.86543571934f,
		111213.21358456917f,
		111237.56306614014f,
		111261.91388028639f,
		111286.26602686207f,
		111310.6195057214f,
		111334.97431671864f,
		111359.33045970804f,
		111383.68793454397f,
		111408.04674108078f,
		111432.40687917286f,
		111456.76834867468f,
		111481.13114944073f,
		111505.49528132551f,
		111529.8607441836f,
		111554.22753786962f,
		111578.59566223821f,
		111602.96511714405f,
		111627.33590244185f,
		111651.7080179864f,
		111676.08146363248f,
		111700.45623923496f,
		111724.8323446487f,
		111749.20977972864f,
		111773.58854432974f,
		111797.968638307f,
		111822.35006151545f,
		111846.73281381019f,
		111871.11689504632f,
		111895.50230507903f,
		111919.88904376348f,
		111944.27711095495f,
		111968.6665065087f,
		111993.05723028004f,
		112017.44928212435f,
		112041.842661897f,
		112066.23736945343f,
		112090.63340464912f,
		112115.0307673396f,
		112139.42945738042f,
		112163.82947462716f,
		112188.23081893545f,
		112212.63349016097f,
		112237.03748815943f,
		112261.44281278658f,
		112285.84946389822f,
		112310.25744135017f,
		112334.66674499828f,
		112359.07737469849f,
		112383.48933030672f,
		112407.90261167898f,
		112432.31721867126f,
		112456.73315113965f,
		112481.15040894024f,
		112505.56899192919f,
		112529.98889996266f,
		112554.41013289688f,
		112578.83269058811f,
		112603.25657289263f,
		112627.6817796668f,
		112652.10831076698f,
		112676.53616604958f,
		112700.96534537108f,
		112725.39584858794f,
		112749.82767555672f,
		112774.26082613398f,
		112798.6953001763f,
		112823.13109754038f,
		112847.56821808286f,
		112872.00666166049f,
		112896.44642813003f,
		112920.88751734828f,
		112945.32992917208f,
		112969.7736634583f,
		112994.21872006389f,
		113018.66509884578f,
		113043.11279966097f,
		113067.56182236652f,
		113092.01216681948f,
		113116.46383287695f,
		113140.9168203961f,
		113165.37112923413f,
		113189.82675924824f,
		113214.28371029573f,
		113238.74198223387f,
		113263.20157492002f,
		113287.66248821156f,
		113312.12472196593f,
		113336.58827604055f,
		113361.05315029295f,
		113385.51934458067f,
		113409.98685876124f,
		113434.45569269233f,
		113458.92584623155f,
		113483.39731923661f,
		113507.87011156522f,
		113532.34422307517f,
		113556.81965362425f,
		113581.2964030703f,
		113605.77447127122f,
		113630.2538580849f,
		113654.73456336933f,
		113679.21658698248f,
		113703.69992878241f,
		113728.18458862716f,
		113752.67056637487f,
		113777.15786188368f,
		113801.64647501177f,
		113826.13640561736f,
		113850.62765355874f,
		113875.12021869418f,
		113899.61410088204f,
		113924.1092999807f,
		113948.60581584855f,
		113973.10364834408f,
		113997.60279732574f,
		114022.1032626521f,
		114046.60504418172f,
		114071.10814177318f,
		114095.61255528513f,
		114120.11828457628f,
		114144.62532950533f,
		114169.13368993104f,
		114193.6433657122f,
		114218.15435670764f,
		114242.66666277626f,
		114267.18028377692f,
		114291.69521956862f,
		114316.21147001031f,
		114340.72903496103f,
		114365.24791427983f,
		114389.7681078258f,
		114414.2896154581f,
		114438.81243703587f,
		114463.33657241837f,
		114487.8620214648f,
		114512.38878403447f,
		114536.91685998671f,
		114561.44624918088f,
		114585.97695147636f,
		114610.5089667326f,
		114635.04229480909f,
		114659.57693556532f,
		114684.11288886084f,
		114708.65015455526f,
		114733.18873250818f,
		114757.72862257928f,
		114782.26982462825f,
		114806.81233851484f,
		114831.35616409882f,
		114855.90130124f,
		114880.44774979822f,
		114904.99550963337f,
		114929.5445806054f,
		114954.09496257425f,
		114978.64665539993f,
		115003.19965894247f,
		115027.75397306195f,
		115052.30959761847f,
		115076.86653247218f,
		115101.42477748329f,
		115125.984332512f,
		115150.54519741859f,
		115175.10737206334f,
		115199.67085630659f,
		115224.23565000873f,
		115248.80175303014f,
		115273.3691652313f,
		115297.93788647266f,
		115322.50791661476f,
		115347.07925551817f,
		115371.65190304347f,
		115396.2258590513f,
		115420.80112340231f,
		115445.37769595724f,
		115469.95557657682f,
		115494.53476512182f,
		115519.11526145306f,
		115543.6970654314f,
		115568.28017691776f,
		115592.86459577303f,
		115617.4503218582f,
		115642.03735503425f,
		115666.62569516223f,
		115691.21534210323f,
		115715.80629571836f,
		115740.39855586876f,
		115764.99212241563f,
		115789.58699522018f,
		115814.18317414368f,
		115838.78065904742f,
		115863.37944979276f,
		115887.97954624105f,
		115912.5809482537f,
		115937.18365569218f,
		115961.78766841792f,
		115986.39298629249f,
		116010.99960917742f,
		116035.60753693432f,
		116060.21676942479f,
		116084.82730651053f,
		116109.43914805322f,
		116134.0522939146f,
		116158.66674395645f,
		116183.2824980406f,
		116207.89955602886f,
		116232.51791778316f,
		116257.13758316539f,
		116281.75855203751f,
		116306.38082426153f,
		116331.0043996995f,
		116355.62927821343f,
		116380.25545966547f,
		116404.88294391775f,
		116429.51173083246f,
		116454.14182027178f,
		116478.77321209799f,
		116503.40590617337f,
		116528.03990236024f,
		116552.67520052097f,
		116577.31180051794f,
		116601.94970221359f,
		116626.5889054704f,
		116651.22941015086f,
		116675.8712161175f,
		116700.51432323293f,
		116725.15873135976f,
		116749.8044403606f,
		116774.45145009817f,
		116799.0997604352f,
		116823.74937123443f,
		116848.40028235866f,
		116873.05249367072f,
		116897.70600503348f,
		116922.36081630984f,
		116947.01692736275f,
		116971.67433805518f,
		116996.33304825013f,
		117020.99305781067f,
		117045.65436659988f,
		117070.31697448085f,
		117094.98088131678f,
		117119.64608697084f,
		117144.31259130625f,
		117168.98039418628f,
		117193.64949547425f,
		117218.31989503348f,
		117242.99159272734f,
		117267.66458841923f,
		117292.33888197262f,
		117317.01447325097f,
		117341.6913621178f,
		117366.36954843666f,
		117391.04903207115f,
		117415.72981288488f,
		117440.41189074152f,
		117465.09526550476f,
		117489.77993703831f,
		117514.46590520597f,
		117539.15316987154f,
		117563.84173089883f,
		117588.53158815173f,
		117613.22274149416f,
		117637.91519079005f,
		117662.60893590341f,
		117687.30397669821f,
		117712.00031303853f,
		117736.69794478847f,
		117761.39687181212f,
		117786.09709397367f,
		117810.7986111373f,
		117835.50142316725f,
		117860.20552992777f,
		117884.91093128319f,
		117909.6176270978f,
		117934.32561723603f,
		117959.03490156225f,
		117983.74547994092f,
		118008.45735223651f,
		118033.17051831353f,
		118057.88497803656f,
		118082.60073127014f,
		118107.31777787892f,
		118132.03611772758f,
		118156.75575068076f,
		118181.47667660323f,
		118206.19889535972f,
		118230.92240681504f,
		118255.64721083404f,
		118280.37330728157f,
		118305.10069602253f,
		118329.82937692187f,
		118354.55934984458f,
		118379.29061465565f,
		118404.02317122012f,
		118428.75701940308f,
		118453.49215906965f,
		118478.22859008498f,
		118502.96631231424f,
		118527.70532562268f,
		118552.44562987552f,
		118577.18722493808f,
		118601.93011067568f,
		118626.67428695368f,
		118651.41975363747f,
		118676.1665105925f,
		118700.91455768421f,
		118725.66389477813f,
		118750.41452173979f,
		118775.16643843475f,
		118799.91964472862f,
		118824.67414048707f,
		118849.42992557574f,
		118874.18699986035f,
		118898.94536320666f,
		118923.70501548043f,
		118948.46595654752f,
		118973.22818627374f,
		118997.99170452499f,
		119022.7565111672f,
		119047.52260606633f,
		119072.28998908834f,
		119097.0586600993f,
		119121.82861896523f,
		119146.59986555226f,
		119171.3723997265f,
		119196.14622135412f,
		119220.92133030134f,
		119245.69772643436f,
		119270.47540961947f,
		119295.25437972297f,
		119320.0346366112f,
		119344.81618015055f,
		119369.5990102074f,
		119394.38312664822f,
		119419.16852933947f,
		119443.95521814766f,
		119468.74319293935f,
		119493.53245358112f,
		119518.32299993958f,
		119543.1148318814f,
		119567.90794927324f,
		119592.70235198183f,
		119617.49803987393f,
		119642.29501281632f,
		119667.09327067583f,
		119691.89281331931f,
		119716.69364061367f,
		119741.49575242584f,
		119766.29914862274f,
		119791.10382907142f,
		119815.90979363887f,
		119840.71704219218f,
		119865.52557459843f,
		119890.33539072477f,
		119915.14649043836f,
		119939.95887360642f,
		119964.77254009615f,
		119989.58748977486f,
		120014.40372250983f,
		120039.22123816841f,
		120064.04003661797f,
		120088.86011772591f,
		120113.6814813597f,
		120138.50412738678f,
		120163.3280556747f,
		120188.15326609099f,
		120212.9797585032f,
		120237.807532779f,
		120262.636588786f,
		120287.46692639188f,
		120312.29854546436f,
		120337.13144587121f,
		120361.9656274802f,
		120386.80109015913f,
		120411.6378337759f,
		120436.47585819835f,
		120461.31516329442f,
		120486.15574893207f,
		120510.99761497928f,
		120535.84076130408f,
		120560.6851877745f,
		120585.53089425867f,
		120610.3778806247f,
		120635.22614674074f,
		120660.07569247499f,
		120684.92651769568f,
		120709.77862227106f,
		120734.63200606944f,
		120759.48666895913f,
		120784.3426108085f,
		120809.19983148595f,
		120834.05833085992f,
		120858.91810879884f,
		120883.77916517125f,
		120908.64149984565f,
		120933.5051126906f,
		120958.37000357473f,
		120983.23617236665f,
		121008.10361893504f,
		121032.9723431486f,
		121057.84234487606f,
		121082.71362398617f,
		121107.58618034775f,
		121132.46001382964f,
		121157.33512430069f,
		121182.21151162982f,
		121207.08917568595f,
		121231.96811633807f,
		121256.84833345517f,
		121281.72982690629f,
		121306.61259656049f,
		121331.49664228689f,
		121356.38196395461f,
		121381.26856143285f,
		121406.15643459078f,
		121431.04558329767f,
		121455.93600742277f,
		121480.82770683538f,
		121505.72068140487f,
		121530.61493100057f,
		121555.51045549192f,
		121580.40725474835f,
		121605.30532863933f,
		121630.20467703436f,
		121655.10529980299f,
		121680.00719681478f,
		121704.91036793934f,
		121729.81481304632f,
		121754.72053200539f,
		121779.62752468624f,
		121804.53579095862f,
		121829.44533069231f,
		121854.3561437571f,
		121879.26823002285f,
		121904.1815893594f,
		121929.09622163669f,
		121954.01212672464f,
		121978.92930449323f,
		122003.84775481246f,
		122028.76747755238f,
		122053.68847258303f,
		122078.61073977455f,
		122103.53427899707f,
		122128.45909012076f,
		122153.3851730158f,
		122178.31252755247f,
		122203.241153601f,
		122228.1710510317f,
		122253.10221971496f,
		122278.03465952107f,
		122302.9683703205f,
		122327.90335198362f,
		122352.83960438096f,
		122377.777127383f,
		122402.71592086025f,
		122427.65598468333f,
		122452.59731872278f,
		122477.53992284928f,
		122502.48379693348f,
		122527.42894084606f,
		122552.37535445779f,
		122577.3230376394f,
		122602.27199026172f,
		122627.22221219557f,
		122652.17370331181f,
		122677.12646348133f,
		122702.08049257506f,
		122727.03579046397f,
		122751.99235701906f,
		122776.95019211136f,
		122801.9092956119f,
		122826.8696673918f,
		122851.8313073222f,
		122876.79421527422f,
		122901.75839111907f,
		122926.72383472799f,
		122951.69054597223f,
		122976.65852472307f,
		123001.62777085182f,
		123026.59828422987f,
		123051.57006472857f,
		123076.54311221937f,
		123101.5174265737f,
		123126.49300766307f,
		123151.46985535898f,
		123176.447969533f,
		123201.42735005668f,
		123226.40799680166f,
		123251.38990963959f,
		123276.37308844214f,
		123301.35753308103f,
		123326.343243428f,
		123351.33021935483f,
		123376.31846073334f,
		123401.30796743535f,
		123426.29873933276f,
		123451.29077629748f,
		123476.28407820144f,
		123501.2786449166f,
		123526.27447631498f,
		123551.27157226863f,
		123576.2699326496f,
		123601.26955732999f,
		123626.27044618195f,
		123651.27259907764f,
		123676.27601588926f,
		123701.28069648903f,
		123726.28664074925f,
		123751.29384854218f,
		123776.30231974016f,
		123801.31205421555f,
		123826.32305184074f,
		123851.33531248817f,
		123876.34883603029f,
		123901.36362233957f,
		123926.37967128855f,
		123951.3969827498f,
		123976.41555659588f,
		124001.43539269941f,
		124026.45649093305f,
		124051.47885116948f,
		124076.50247328142f,
		124101.5273571416f,
		124126.55350262282f,
		124151.58090959788f,
		124176.60957793961f,
		124201.63950752091f,
		124226.67069821467f,
		124251.70314989384f,
		124276.73686243138f,
		124301.7718357003f,
		124326.80806957364f,
		124351.84556392446f,
		124376.88431862585f,
		124401.92433355095f,
		124426.96560857294f,
		124452.00814356498f,
		124477.05193840031f,
		124502.0969929522f,
		124527.14330709392f,
		124552.19088069882f,
		124577.23971364023f,
		124602.28980579154f,
		124627.34115702618f,
		124652.3937672176f,
		124677.44763623926f,
		124702.50276396469f,
		124727.55915026742f,
		124752.61679502104f,
		124777.67569809916f,
		124802.73585937542f,
		124827.79727872348f,
		124852.85995601704f,
		124877.92389112986f,
		124902.98908393568f,
		124928.05553430831f,
		124953.1232421216f,
		124978.19220724938f,
		125003.26242956554f,
		125028.33390894404f,
		125053.40664525882f,
		125078.48063838384f,
		125103.55588819316f,
		125128.63239456083f,
		125153.71015736091f,
		125178.78917646752f,
		125203.86945175481f,
		125228.95098309696f,
		125254.03377036817f,
		125279.1178134427f,
		125304.2031121948f,
		125329.28966649878f,
		125354.37747622898f,
		125379.46654125977f,
		125404.55686146552f,
		125429.6484367207f,
		125454.74126689974f,
		125479.83535187715f,
		125504.93069152744f,
		125530.02728572517f,
		125555.12513434493f,
		125580.22423726133f,
		125605.32459434902f,
		125630.42620548268f,
		125655.52907053704f,
		125680.63318938682f,
		125705.7385619068f,
		125730.84518797178f,
		125755.9530674566f,
		125781.06220023613f,
		125806.17258618528f,
		125831.28422517896f,
		125856.39711709213f,
		125881.51126179981f,
		125906.62665917698f,
		125931.74330909875f,
		125956.86121144016f,
		125981.98036607634f,
		126007.10077288245f,
		126032.22243173365f,
		126057.34534250517f,
		126082.46950507225f,
		126107.59491931014f,
		126132.72158509417f,
		126157.84950229966f,
		126182.97867080198f,
		126208.10909047653f,
		126233.24076119871f,
		126258.37368284403f,
		126283.50785528794f,
		126308.64327840599f,
		126333.7799520737f,
		126358.91787616667f,
		126384.0570505605f,
		126409.19747513086f,
		126434.3391497534f,
		126459.48207430386f,
		126484.62624865794f,
		126509.77167269142f,
		126534.9183462801f,
		126560.06626929982f,
		126585.21544162642f,
		126610.36586313581f,
		126635.51753370391f,
		126660.67045320668f,
		126685.82462152008f,
		126710.98003852014f,
		126736.1367040829f,
		126761.29461808444f,
		126786.45378040087f,
		126811.61419090834f,
		126836.77584948298f,
		126861.93875600102f,
		126887.10291033868f,
		126912.26831237224f,
		126937.43496197795f,
		126962.60285903217f,
		126987.77200341123f,
		127012.94239499152f,
		127038.11403364947f,
		127063.2869192615f,
		127088.46105170409f,
		127113.63643085376f,
		127138.81305658702f,
		127163.99092878048f,
		127189.17004731069f,
		127214.3504120543f,
		127239.53202288797f,
		127264.71487968838f,
		127289.89898233226f,
		127315.08433069635f,
		127340.27092465744f,
		127365.45876409234f,
		127390.64784887788f,
		127415.83817889093f,
		127441.02975400841f,
		127466.22257410725f,
		127491.4166390644f,
		127516.61194875685f,
		127541.80850306165f,
		127567.00630185583f,
		127592.20534501647f,
		127617.4056324207f,
		127642.60716394568f,
		127667.80993946856f,
		127693.01395886653f,
		127718.21922201688f,
		127743.42572879682f,
		127768.63347908368f,
		127793.8424727548f,
		127819.05270968749f,
		127844.26418975917f,
		127869.47691284724f,
		127894.69087882918f,
		127919.90608758242f,
		127945.12253898452f,
		127970.34023291297f,
		127995.55916924539f,
		128020.77934785932f,
		128046.00076863244f,
		128071.22343144237f,
		128096.44733616684f,
		128121.67248268353f,
		128146.89887087021f,
		128172.12650060465f,
		128197.35537176466f,
		128222.5854842281f,
		128247.81683787282f,
		128273.0494325767f,
		128298.28326821771f,
		128323.5183446738f,
		128348.75466182294f,
		128373.99221954317f,
		128399.23101771252f,
		128424.47105620909f,
		128449.71233491098f,
		128474.95485369631f,
		128500.19861244329f,
		128525.44361103009f,
		128550.68984933494f,
		128575.93732723613f,
		128601.18604461191f,
		128626.43600134061f,
		128651.68719730059f,
		128676.93963237021f,
		128702.1933064279f,
		128727.44821935208f,
		128752.70437102125f,
		128777.96176131385f,
		128803.22039010846f,
		128828.48025728362f,
		128853.74136271792f,
		128879.00370628996f,
		128904.2672878784f,
		128929.53210736193f,
		128954.79816461923f,
		128980.06545952905f,
		129005.33399197015f,
		129030.60376182134f,
		129055.87476896142f,
		129081.14701326926f,
		129106.42049462376f,
		129131.6952129038f,
		129156.97116798835f,
		129182.24835975636f,
		129207.52678808685f,
		129232.80645285884f,
		129258.08735395141f,
		129283.36949124365f,
		129308.65286461466f,
		129333.9374739436f,
		129359.22331910966f,
		129384.51039999202f,
		129409.79871646997f,
		129435.08826842274f,
		129460.37905572963f,
		129485.67107826998f,
		129510.96433592314f,
		129536.2588285685f,
		129561.55455608548f,
		129586.85151835352f,
		129612.14971525209f,
		129637.4491466607f,
		129662.74981245887f,
		129688.0517125262f,
		129713.35484674224f,
		129738.65921498663f,
		129763.96481713903f,
		129789.2716530791f,
		129814.57972268655f,
		129839.88902584116f,
		129865.19956242264f,
		129890.51133231082f,
		129915.82433538554f,
		129941.13857152662f,
		129966.45404061397f,
		129991.7707425275f,
		130017.08867714716f,
		130042.4078443529f,
		130067.72824402474f,
		130093.04987604271f,
		130118.37274028687f,
		130143.69683663732f,
		130169.02216497416f,
		130194.34872517755f,
		130219.67651712766f,
		130245.0055407047f,
		130270.33579578891f,
		130295.66728226055f,
		130320.99999999991f,
		130346.33394888733f,
		130371.66912880314f,
		130397.00553962773f,
		130422.34318124152f,
		130447.68205352494f,
		130473.02215635845f,
		130498.36348962256f,
		130523.70605319779f,
		130549.0498469647f,
		130574.39487080388f,
		130599.74112459592f,
		130625.08860822149f,
		130650.43732156123f,
		130675.78726449587f,
		130701.13843690613f,
		130726.49083867275f,
		130751.84446967654f,
		130777.19932979831f,
		130802.5554189189f,
		130827.91273691918f,
		130853.27128368006f,
		130878.63105908247f,
		130903.99206300738f,
		130929.35429533575f,
		130954.71775594862f,
		130980.08244472703f,
		131005.44836155206f,
		131030.81550630482f,
		131056.18387886642f,
		131081.55347911804f,
		131106.92430694087f,
		131132.29636221612f,
		131157.66964482504f,
		131183.0441546489f,
		131208.41989156904f,
		131233.79685546676f,
		131259.17504622342f,
		131284.55446372041f,
		131309.93510783918f,
		131335.31697846117f,
		131360.70007546784f,
		131386.0843987407f,
		131411.46994816128f,
		131436.85672361116f,
		131462.24472497194f,
		131487.6339521252f,
		131513.02440495262f,
		131538.41608333588f,
		131563.80898715663f,
		131589.2031162967f,
		131614.59847063778f,
		131639.9950500617f,
		131665.39285445024f,
		131690.7918836853f,
		131716.19213764873f,
		131741.5936162224f,
		131766.99631928833f,
		131792.4002467284f,
		131817.80539842462f,
		131843.21177425905f,
		131868.6193741137f,
		131894.02819787065f,
		131919.43824541202f,
		131944.84951661993f,
		131970.26201137656f,
		131995.67572956407f,
		132021.09067106468f,
		132046.50683576067f,
		132071.9242235343f,
		132097.34283426782f,
		132122.76266784366f,
		132148.1837241441f,
		132173.60600305157f,
		132199.02950444847f,
		132224.45422821722f,
		132249.88017424036f,
		132275.3073424003f,
		132300.73573257966f,
		132326.16534466096f,
		132351.59617852676f,
		132377.0282340597f,
		132402.46151114244f,
		132427.8960096576f,
		132453.3317294879f,
		132478.7686705161f,
		132504.2068326249f,
		132529.64621569714f,
		132555.0868196156f,
		132580.5286442631f,
		132605.97168952253f,
		132631.41595527678f,
		132656.8614414088f,
		132682.3081478015f,
		132707.75607433787f,
		132733.20522090094f,
		132758.65558737374f,
		132784.1071736393f,
		132809.55997958075f,
		132835.01400508118f,
		132860.46925002377f,
		132885.92571429166f,
		132911.3833977681f,
		132936.84230033628f,
		132962.30242187946f,
		132987.76376228096f,
		133013.22632142407f,
		133038.69009919214f,
		133064.15509546854f,
		133089.62131013666f,
		133115.08874307995f,
		133140.55739418184f,
		133166.0272633258f,
		133191.4983503954f,
		133216.97065527414f,
		133242.4441778456f,
		133267.91891799335f,
		133293.39487560102f,
		133318.87205055228f,
		133344.3504427308f,
		133369.83005202023f,
		133395.3108783044f,
		133420.79292146701f,
		133446.27618139185f,
		133471.76065796276f,
		133497.24635106357f,
		133522.73326057816f,
		133548.2213863904f,
		133573.71072838426f,
		133599.20128644365f,
		133624.6930604526f,
		133650.1860502951f,
		133675.68025585517f,
		133701.1756770169f,
		133726.67231366437f,
		133752.17016568172f,
		133777.66923295305f,
		133803.1695153626f,
		133828.67101279454f,
		133854.1737251331f,
		133879.67765226253f,
		133905.18279406714f,
		133930.68915043125f,
		133956.19672123916f,
		133981.70550637526f,
		134007.215505724f,
		134032.7267191697f,
		134058.23914659687f,
		134083.75278789f,
		134109.26764293358f,
		134134.78371161217f,
		134160.30099381026f,
		134185.8194894125f,
		134211.33919830353f,
		134236.8601203679f,
		134262.38225549037f,
		134287.90560355558f,
		134313.4301644483f,
		134338.95593805326f,
		134364.48292425525f,
		134390.0111229391f,
		134415.54053398955f,
		134441.0711572916f,
		134466.60299273f,
		134492.1360401898f,
		134517.67029955584f,
		134543.20577071316f,
		134568.74245354676f,
		134594.2803479416f,
		134619.81945378278f,
		134645.35977095537f,
		134670.90129934452f,
		134696.4440388353f,
		134721.9879893129f,
		134747.53315066252f,
		134773.07952276937f,
		134798.6271055187f,
		134824.17589879577f,
		134849.7259024859f,
		134875.27711647438f,
		134900.8295406466f,
		134926.38317488792f,
		134951.93801908373f,
		134977.4940731195f,
		135003.0513368807f,
		135028.60981025276f,
		135054.16949312127f,
		135079.73038537172f,
		135105.29248688967f,
		135130.85579756077f,
		135156.42031727062f,
		135181.98604590484f,
		135207.55298334916f,
		135233.12112948927f,
		135258.69048421088f,
		135284.26104739975f,
		135309.83281894168f,
		135335.4057987225f,
		135360.97998662802f,
		135386.55538254412f,
		135412.1319863567f,
		135437.70979795168f,
		135463.28881721498f,
		135488.86904403262f,
		135514.45047829056f,
		135540.03311987486f,
		135565.61696867156f,
		135591.20202456677f,
		135616.78828744654f,
		135642.37575719706f,
		135667.96443370447f,
		135693.55431685498f,
		135719.14540653478f,
		135744.7377026301f,
		135770.33120502727f,
		135795.92591361253f,
		135821.52182827223f,
		135847.11894889272f,
		135872.7172753604f,
		135898.3168075616f,
		135923.91754538284f,
		135949.51948871053f,
		135975.12263743114f,
		136000.72699143123f,
		136026.3325505973f,
		136051.9393148159f,
		136077.5472839737f,
		136103.15645795723f,
		136128.76683665317f,
		136154.37841994822f,
		136179.991207729f,
		136205.60519988232f,
		136231.2203962949f,
		136256.8367968535f,
		136282.45440144493f,
		136308.07320995603f,
		136333.69322227367f,
		136359.3144382847f,
		136384.93685787608f,
		136410.56048093468f,
		136436.18530734754f,
		136461.81133700156f,
		136487.43856978387f,
		136513.06700558143f,
		136538.6966442813f,
		136564.32748577066f,
		136589.95952993655f,
		136615.59277666616f,
		136641.22722584667f,
		136666.86287736523f,
		136692.49973110916f,
		136718.13778696564f,
		136743.77704482197f,
		136769.41750456547f,
		136795.05916608346f,
		136820.7020292633f,
		136846.34609399244f,
		136871.9913601582f,
		136897.63782764805f,
		136923.28549634948f,
		136948.93436614997f,
		136974.58443693706f,
		137000.23570859825f,
		137025.88818102115f,
		137051.54185409332f,
		137077.19672770242f,
		137102.8528017361f,
		137128.51007608202f,
		137154.16855062786f,
		137179.82822526142f,
		137205.4890998704f,
		137231.15117434258f,
		137256.8144485658f,
		137282.4789224279f,
		137308.14459581667f,
		137333.8114686201f,
		137359.47954072602f,
		137385.1488120224f,
		137410.8192823972f,
		137436.49095173844f,
		137462.16381993407f,
		137487.8378868722f,
		137513.5131524409f,
		137539.18961652822f,
		137564.8672790223f,
		137590.5461398113f,
		137616.22619878338f,
		137641.90745582676f,
		137667.58991082967f,
		137693.27356368033f,
		137718.95841426702f,
		137744.64446247809f,
		137770.33170820182f,
		137796.0201513266f,
		137821.7097917408f,
		137847.40062933284f,
		137873.09266399115f,
		137898.78589560417f,
		137924.48032406042f,
		137950.17594924837f,
		137975.8727710566f,
		138001.57078937365f,
		138027.27000408815f,
		138052.97041508864f,
		138078.67202226384f,
		138104.3748255024f,
		138130.07882469296f,
		138155.78401972432f,
		138181.49041048516f,
		138207.1979968643f,
		138232.9067787505f,
		138258.61675603263f,
		138284.3279285995f,
		138310.04029633995f,
		138335.75385914298f,
		138361.46861689744f,
		138387.18456949232f,
		138412.9017168166f,
		138438.62005875923f,
		138464.3395952093f,
		138490.06032605586f,
		138515.78225118798f,
		138541.50537049473f,
		138567.2296838653f,
		138592.95519118884f,
		138618.6818923545f,
		138644.40978725153f,
		138670.13887576913f,
		138695.86915779658f,
		138721.60063322316f,
		138747.33330193823f,
		138773.06716383106f,
		138798.80221879104f,
		138824.53846670757f,
		138850.27590747006f,
		138876.01454096794f,
		138901.7543670907f,
		138927.49538572782f,
		138953.2375967688f,
		138978.9810001032f,
		139004.7255956206f,
		139030.4713832106f,
		139056.2183627628f,
		139081.96653416683f,
		139107.7158973124f,
		139133.46645208917f,
		139159.2181983869f,
		139184.97113609532f,
		139210.7252651042f,
		139236.48058530336f,
		139262.23709658257f,
		139287.99479883176f,
		139313.75369194074f,
		139339.51377579942f,
		139365.27505029776f,
		139391.03751532568f,
		139416.80117077316f,
		139442.56601653024f,
		139468.3320524869f,
		139494.09927853322f,
		139519.86769455927f,
		139545.63730045516f,
		139571.408096111f,
		139597.18008141697f,
		139622.95325626322f,
		139648.72762054f,
		139674.5031741375f,
		139700.27991694602f,
		139726.0578488558f,
		139751.83696975713f,
		139777.61727954043f,
		139803.39877809596f,
		139829.18146531415f,
		139854.9653410854f,
		139880.75040530015f,
		139906.53665784886f,
		139932.324098622f,
		139958.11272751007f,
		139983.90254440365f,
		140009.69354919327f,
		140035.4857417695f,
		140061.27912202294f,
		140087.07368984428f,
		140112.86944512415f,
		140138.6663877532f,
		140164.4645176222f,
		140190.26383462187f,
		140216.06433864293f,
		140241.86602957622f,
		140267.66890731253f,
		140293.47297174268f,
		140319.27822275754f,
		140345.08466024802f,
		140370.89228410498f,
		140396.70109421943f,
		140422.51109048226f,
		140448.32227278448f,
		140474.13464101712f,
		140499.94819507122f,
		140525.7629348378f,
		140551.578860208f,
		140577.3959710729f,
		140603.21426732364f,
		140629.03374885136f,
		140654.8544155473f,
		140680.67626730262f,
		140706.49930400858f,
		140732.32352555645f,
		140758.1489318375f,
		140783.97552274304f,
		140809.80329816442f,
		140835.63225799298f,
		140861.46240212015f,
		140887.2937304373f,
		140913.12624283586f,
		140938.95993920733f,
		140964.79481944317f,
		140990.63088343487f,
		141016.468131074f,
		141042.30656225214f,
		141068.14617686084f,
		141093.98697479168f,
		141119.82895593636f,
		141145.6721201865f,
		141171.51646743377f,
		141197.36199756994f,
		141223.20871048668f,
		141249.05660607578f,
		141274.90568422904f,
		141300.75594483822f,
		141326.6073877952f,
		141352.4600129918f,
		141378.31382031992f,
		141404.16880967148f,
		141430.02498093838f,
		141455.8823340126f,
		141481.74086878612f,
		141507.60058515094f,
		141533.4614829991f,
		141559.32356222265f,
		141585.18682271364f,
		141611.0512643642f,
		141636.9168870665f,
		141662.78369071265f,
		141688.6516751948f,
		141714.5208404052f,
		141740.39118623605f,
		141766.26271257963f,
		141792.1354193282f,
		141818.00930637406f,
		141843.88437360956f,
		141869.760620927f,
		141895.6380482188f,
		141921.51665537735f,
		141947.39644229505f,
		141973.27740886438f,
		141999.15955497778f,
		142025.0428805278f,
		142050.9273854069f,
		142076.81306950765f,
		142102.69993272264f,
		142128.58797494444f,
		142154.4771960657f,
		142180.36759597904f,
		142206.25917457714f,
		142232.15193175265f,
		142258.04586739838f,
		142283.94098140698f,
		142309.83727367126f,
		142335.734744084f,
		142361.63339253806f,
		142387.5332189262f,
		142413.43422314132f,
		142439.33640507632f,
		142465.23976462413f,
		142491.14430167765f,
		142517.05001612983f,
		142542.95690787368f,
		142568.86497680223f,
		142594.77422280848f,
		142620.6846457855f,
		142646.5962456264f,
		142672.50902222423f,
		142698.42297547215f,
		142724.33810526333f,
		142750.25441149093f,
		142776.17189404817f,
		142802.09055282827f,
		142828.0103877245f,
		142853.93139863008f,
		142879.85358543837f,
		142905.77694804268f,
		142931.70148633636f,
		142957.62720021277f,
		142983.55408956532f,
		143009.48215428743f,
		143035.41139427255f,
		143061.34180941415f,
		143087.2733996057f,
		143113.20616474075f,
		143139.14010471283f,
		143165.0752194155f,
		143191.01150874238f,
		143216.94897258704f,
		143242.88761084314f,
		143268.82742340435f,
		143294.76841016437f,
		143320.71057101688f,
		143346.65390585564f,
		143372.59841457437f,
		143398.54409706692f,
		143424.490953227f,
		143450.43898294857f,
		143476.38818612538f,
		143502.33856265133f,
		143528.29011242036f,
		143554.24283532638f,
		143580.19673126334f,
		143606.1518001252f,
		143632.10804180597f,
		143658.0654561997f,
		143684.02404320036f,
		143709.98380270213f,
		143735.944734599f,
		143761.9068387852f,
		143787.87011515474f,
		143813.83456360188f,
		143839.8001840208f,
		143865.7669763057f,
		143891.7349403508f,
		143917.7040760504f,
		143943.67438329876f,
		143969.6458619902f,
		143995.61851201905f,
		144021.59233327967f,
		144047.56732566646f,
		144073.54348907378f,
		144099.52082339607f,
		144125.49932852783f,
		144151.4790043635f,
		144177.45985079758f,
		144203.44186772458f,
		144229.4250550391f,
		144255.40941263564f,
		144281.39494040885f,
		144307.3816382533f,
		144333.36950606373f,
		144359.35854373468f,
		144385.34875116093f,
		144411.34012823718f,
		144437.33267485813f,
		144463.32639091855f,
		144489.32127631325f,
		144515.31733093705f,
		144541.31455468474f,
		144567.3129474512f,
		144593.3125091313f,
		144619.31323961995f,
		144645.31513881206f,
		144671.31820660262f,
		144697.32244288657f,
		144723.3278475589f,
		144749.33442051467f,
		144775.34216164888f,
		144801.35107085665f,
		144827.36114803303f,
		144853.37239307314f,
		144879.38480587213f,
		144905.39838632516f,
		144931.41313432742f,
		144957.4290497741f,
		144983.44613256046f,
		145009.46438258173f,
		145035.48379973322f,
		145061.5043839102f,
		145087.52613500805f,
		145113.54905292206f,
		145139.57313754765f,
		145165.59838878017f,
		145191.6248065151f,
		145217.65239064783f,
		145243.68114107384f,
		145269.71105768863f,
		145295.74214038774f,
		145321.77438906668f,
		145347.807803621f,
		145373.8423839463f,
		145399.87812993818f,
		145425.9150414923f,
		145451.95311850426f,
		145477.9923608698f,
		145504.03276848458f,
		145530.07434124436f,
		145556.11707904484f,
		145582.1609817818f,
		145608.20604935108f,
		145634.25228164849f,
		145660.2996785698f,
		145686.34824001096f,
		145712.39796586783f,
		145738.4488560363f,
		145764.50091041232f,
		145790.55412889185f,
		145816.60851137087f,
		145842.66405774537f,
		145868.7207679114f,
		145894.778641765f,
		145920.83767920226f,
		145946.89788011924f,
		145972.95924441208f,
		145999.02177197693f,
		146025.08546270995f,
		146051.15031650732f,
		146077.21633326527f,
		146103.28351288004f,
		146129.3518552479f,
		146155.42136026506f,
		146181.49202782792f,
		146207.56385783272f,
		146233.63685017588f,
		146259.71100475377f,
		146285.78632146274f,
		146311.86280019928f,
		146337.94044085976f,
		146364.0192433407f,
		146390.09920753856f,
		146416.18033334985f,
		146442.26262067116f,
		146468.34606939898f,
		146494.43067942993f,
		146520.51645066062f,
		146546.60338298764f,
		146572.6914763077f,
		146598.7807305174f,
		146624.87114551352f,
		146650.96272119274f,
		146677.0554574518f,
		146703.14935418745f,
		146729.2444112965f,
		146755.34062867577f,
		146781.43800622207f,
		146807.53654383228f,
		146833.6362414033f,
		146859.73709883197f,
		146885.83911601527f,
		146911.94229285014f,
		146938.04662923355f,
		146964.15212506248f,
		146990.25878023397f,
		147016.36659464505f,
		147042.4755681928f,
		147068.58570077427f,
		147094.6969922866f,
		147120.80944262692f,
		147146.92305169237f,
		147173.03781938017f,
		147199.15374558745f,
		147225.2708302115f,
		147251.38907314953f,
		147277.5084742988f,
		147303.62903355664f,
		147329.75075082036f,
		147355.87362598727f,
		147381.99765895473f,
		147408.12284962015f,
		147434.2491978809f,
		147460.37670363448f,
		147486.50536677826f,
		147512.63518720976f,
		147538.76616482646f,
		147564.89829952587f,
		147591.03159120557f,
		147617.16603976308f,
		147643.301645096f,
		147669.43840710196f,
		147695.5763256786f,
		147721.71540072354f,
		147747.85563213445f,
		147773.9970198091f,
		147800.13956364512f,
		147826.28326354033f,
		147852.42811939248f,
		147878.57413109933f,
		147904.72129855872f,
		147930.8696216685f,
		147957.01910032652f,
		147983.16973443062f,
		148009.32152387875f,
		148035.47446856883f,
		148061.62856839882f,
		148087.78382326665f,
		148113.94023307035f,
		148140.09779770792f,
		148166.2565170774f,
		148192.41639107687f,
		148218.57741960438f,
		148244.73960255808f,
		148270.90293983606f,
		148297.0674313365f,
		148323.23307695755f,
		148349.39987659742f,
		148375.56783015432f,
		148401.73693752653f,
		148427.90719861226f,
		148454.07861330983f,
		148480.25118151752f,
		148506.42490313368f,
		148532.59977805667f,
		148558.77580618486f,
		148584.95298741665f,
		148611.13132165046f,
		148637.3108087847f,
		148663.4914487179f,
		148689.6732413485f,
		148715.85618657502f,
		148742.040284296f,
		148768.22553440998f,
		148794.41193681557f,
		148820.59949141133f,
		148846.7881980959f,
		148872.97805676793f,
		148899.16906732606f,
		148925.361229669f,
		148951.55454369547f,
		148977.74900930419f,
		149003.9446263939f,
		149030.14139486343f,
		149056.3393146115f,
		149082.538385537f,
		149108.73860753875f,
		149134.9399805156f,
		149161.14250436646f,
		149187.34617899026f,
		149213.5510042859f,
		149239.75698015234f,
		149265.96410648854f,
		149292.17238319354f,
		149318.38181016635f,
		149344.59238730598f,
		149370.80411451156f,
		149397.01699168212f,
		149423.2310187168f,
		149449.4461955147f,
		149475.66252197503f,
		149501.87999799693f,
		149528.0986234796f,
		149554.31839832227f,
		149580.53932242419f,
		149606.7613956846f,
		149632.98461800278f,
		149659.2089892781f,
		149685.43450940982f,
		149711.66117829733f,
		149737.88899584f,
		149764.11796193724f,
		149790.34807648844f,
		149816.5793393931f,
		149842.8117505506f,
		149869.0453098605f,
		149895.28001722222f,
		149921.51587253538f,
		149947.75287569952f,
		149973.99102661415f,
		150000.2303251789f,
		150026.47077129342f,
		150052.71236485732f,
		150078.95510577026f,
		150105.1989939319f,
		150131.444029242f,
		150157.69021160025f,
		150183.9375409064f,
		150210.18601706024f,
		150236.43563996154f,
		150262.68640951012f,
		150288.93832560582f,
		150315.19138814852f,
		150341.44559703805f,
		150367.70095217437f,
		150393.95745345735f,
		150420.215100787f,
		150446.4738940632f,
		150472.733833186f,
		150498.99491805542f,
		150525.25714857146f,
		150551.5205246342f,
		150577.7850461437f,
		150604.05071300003f,
		150630.31752510337f,
		150656.58548235384f,
		150682.8545846516f,
		150709.1248318968f,
		150735.39622398972f,
		150761.66876083054f,
		150787.9424423195f,
		150814.2172683569f,
		150840.49323884305f,
		150866.7703536782f,
		150893.04861276277f,
		150919.32801599705f,
		150945.60856328148f,
		150971.89025451642f,
		150998.1730896023f,
		151024.45706843957f,
		151050.74219092872f,
		151077.0284569702f,
		151103.31586646455f,
		151129.6044193123f,
		151155.894115414f,
		151182.1849546702f,
		151208.47693698155f,
		151234.77006224863f,
		151261.0643303721f,
		151287.35974125259f,
		151313.65629479082f,
		151339.95399088747f,
		151366.25282944329f,
		151392.55281035902f,
		151418.85393353543f,
		151445.1561988733f,
		151471.45960627345f,
		151497.76415563675f,
		151524.06984686397f,
		151550.3766798561f,
		151576.68465451393f,
		151602.99377073845f,
		151629.30402843058f,
		151655.61542749128f,
		151681.92796782157f,
		151708.24164932242f,
		151734.55647189484f,
		151760.87243543993f,
		151787.18953985872f,
		151813.50778505235f,
		151839.82717092187f,
		151866.14769736846f,
		151892.46936429327f,
		151918.79217159748f,
		151945.1161191823f,
		151971.4412069489f,
		151997.76743479856f,
		152024.09480263255f,
		152050.42331035214f,
		152076.75295785864f,
		152103.0837450534f,
		152129.41567183775f,
		152155.74873811303f,
		152182.08294378067f,
		152208.41828874208f,
		152234.7547728987f,
		152261.09239615197f,
		152287.43115840337f,
		152313.7710595544f,
		152340.11209950657f,
		152366.45427816146f,
		152392.79759542056f,
		152419.14205118554f,
		152445.48764535793f,
		152471.8343778394f,
		152498.1822485316f,
		152524.53125733617f,
		152550.88140415482f,
		152577.23268888926f,
		152603.5851114412f,
		152629.9386717124f,
		152656.29336960468f,
		152682.64920501978f,
		152709.00617785956f,
		152735.36428802583f,
		152761.72353542043f,
		152788.0839199453f,
		152814.4454415023f,
		152840.80809999333f,
		152867.1718953204f,
		152893.53682738543f,
		152919.9028960904f,
		152946.27010133737f,
		152972.63844302832f,
		152999.0079210653f,
		153025.3785353504f,
		153051.7502857857f,
		153078.12317227334f,
		153104.4971947154f,
		153130.8723530141f,
		153157.24864707157f,
		153183.62607679f,
		153210.00464207167f,
		153236.38434281875f,
		153262.76517893354f,
		153289.1471503183f,
		153315.53025687535f,
		153341.914498507f,
		153368.29987511563f,
		153394.68638660354f,
		153421.07403287315f,
		153447.4628138269f,
		153473.85272936718f,
		153500.24377939643f,
		153526.63596381716f,
		153553.02928253182f,
		153579.42373544298f,
		153605.81932245308f,
		153632.21604346478f,
		153658.61389838057f,
		153685.0128871031f,
		153711.41300953497f,
		153737.8142655788f,
		153764.21665513728f,
		153790.62017811305f,
		153817.02483440886f,
		153843.4306239274f,
		153869.8375465714f,
		153896.24560224364f,
		153922.65479084692f,
		153949.06511228404f,
		153975.4765664578f,
		154001.88915327107f,
		154028.3028726267f,
		154054.7177244276f,
		154081.13370857667f,
		154107.55082497682f,
		154133.969073531f,
		154160.38845414226f,
		154186.8089667135f,
		154213.23061114774f,
		154239.65338734805f,
		154266.07729521746f,
		154292.50233465908f,
		154318.92850557598f,
		154345.35580787127f,
		154371.7842414481f,
		154398.21380620962f,
		154424.64450205903f,
		154451.0763288995f,
		154477.50928663427f,
		154503.9433751666f,
		154530.3785943997f,
		154556.8149442369f,
		154583.25242458144f,
		154609.69103533673f,
		154636.13077640603f,
		154662.5716476928f,
		154689.01364910032f,
		154715.45678053208f,
		154741.90104189145f,
		154768.34643308193f,
		154794.79295400696f,
		154821.24060457002f,
		154847.68938467462f,
		154874.13929422433f,
		154900.59033312264f,
		154927.04250127316f,
		154953.49579857948f,
		154979.9502249452f,
		155006.40578027396f,
		155032.86246446942f,
		155059.32027743524f,
		155085.77921907514f,
		155112.2392892928f,
		155138.70048799197f,
		155165.16281507642f,
		155191.6262704499f,
		155218.09085401625f,
		155244.55656567923f,
		155271.0234053427f,
		155297.4913729106f,
		155323.96046828668f,
		155350.4306913749f,
		155376.9020420792f,
		155403.37452030348f,
		155429.8481259517f,
		155456.3228589279f,
		155482.79871913602f,
		155509.2757064801f,
		155535.75382086422f,
		155562.2330621924f,
		155588.71343036872f,
		155615.1949252973f,
		155641.67754688227f,
		155668.1612950278f,
		155694.64616963797f,
		155721.13217061706f,
		155747.6192978692f,
		155774.1075512987f,
		155800.59693080973f,
		155827.0874363066f,
		155853.5790676936f,
		155880.07182487496f,
		155906.56570775513f,
		155933.06071623837f,
		155959.5568502291f,
		155986.05410963166f,
		156012.5524943505f,
		156039.05200429005f,
		156065.55263935472f,
		156092.054399449f,
		156118.5572844774f,
		156145.06129434443f,
		156171.5664289546f,
		156198.07268821247f,
		156224.5800720226f,
		156251.0885802896f,
		156277.5982129181f,
		156304.10896981266f,
		156330.620850878f,
		156357.1338560188f,
		156383.6479851397f,
		156410.16323814544f,
		156436.67961494075f,
		156463.1971154304f,
		156489.71573951913f,
		156516.2354871118f,
		156542.7563581131f,
		156569.278352428f,
		156595.80146996127f,
		156622.32571061782f,
		156648.85107430254f,
		156675.37756092031f,
		156701.90517037612f,
		156728.4339025749f,
		156754.96375742165f,
		156781.4947348213f,
		156808.0268346789f,
		156834.5600568995f,
		156861.09440138817f,
		156887.62986804993f,
		156914.16645678994f,
		156940.70416751326f,
		156967.24300012505f,
		156993.78295453047f,
		157020.32403063469f,
		157046.8662283429f,
		157073.40954756032f,
		157099.9539881922f,
		157126.49955014378f,
		157153.04623332032f,
		157179.59403762716f,
		157206.14296296958f,
		157232.69300925292f,
		157259.24417638258f,
		157285.79646426387f,
		157312.3498728022f,
		157338.90440190304f,
		157365.46005147175f,
		157392.01682141385f,
		157418.57471163478f,
		157445.13372204005f,
		157471.69385253516f,
		157498.25510302564f,
		157524.81747341706f,
		157551.38096361503f,
		157577.9455735251f,
		157604.51130305286f,
		157631.07815210402f,
		157657.64612058416f,
		157684.21520839902f,
		157710.78541545427f,
		157737.3567416556f,
		157763.92918690876f,
		157790.50275111952f,
		157817.07743419363f,
		157843.65323603692f,
		157870.23015655516f,
		157896.80819565422f,
		157923.3873532399f,
		157949.96762921812f,
		157976.5490234948f,
		158003.13153597576f,
		158029.715166567f,
		158056.2999151745f,
		158082.88578170416f,
		158109.47276606198f,
		158136.06086815405f,
		158162.6500878863f,
		158189.24042516484f,
		158215.83187989573f,
		158242.42445198505f,
		158269.01814133892f,
		158295.61294786347f,
		158322.20887146486f,
		158348.80591204923f,
		158375.4040695228f,
		158402.00334379176f,
		158428.60373476235f,
		158455.2052423408f,
		158481.80786643337f,
		158508.4116069464f,
		158535.01646378616f,
		158561.62243685898f,
		158588.2295260712f,
		158614.8377313292f,
		158641.44705253936f,
		158668.05748960807f,
		158694.6690424418f,
		158721.28171094693f,
		158747.89549502998f,
		158774.5103945974f,
		158801.12640955573f,
		158827.74353981143f,
		158854.36178527112f,
		158880.9811458413f,
		158907.60162142856f,
		158934.22321193956f,
		158960.84591728085f,
		158987.4697373591f,
		159014.09467208097f,
		159040.72072135314f,
		159067.3478850823f,
		159093.9761631752f,
		159120.60555553852f,
		159147.23606207906f,
		159173.8676827036f,
		159200.5004173189f,
		159227.13426583182f,
		159253.76922814918f,
		159280.4053041778f,
		159307.0424938246f,
		159333.6807969965f,
		159360.32021360032f,
		159386.96074354305f,
		159413.60238673165f,
		159440.2451430731f,
		159466.88901247433f,
		159493.53399484244f,
		159520.18009008438f,
		159546.8272981072f,
		159573.47561881805f,
		159600.12505212397f,
		159626.77559793205f,
		159653.4272561494f,
		159680.08002668325f,
		159706.7339094407f,
		159733.38890432892f,
		159760.04501125516f,
		159786.70223012666f,
		159813.3605608506f,
		159840.02000333427f,
		159866.68055748497f,
		159893.34222320997f,
		159920.00500041663f,
		159946.66888901225f,
		159973.33388890422f,
		159999.99999999988f,
		160026.66722220668f,
		160053.33555543202f,
		160080.0049995833f,
		160106.675554568f,
		160133.3472202936f,
		160160.0199966676f,
		160186.6938835975f,
		160213.36888099083f,
		160240.04498875517f,
		160266.72220679803f,
		160293.4005350271f,
		160320.07997334987f,
		160346.76052167406f,
		160373.4421799073f,
		160400.1249479572f,
		160426.8088257315f,
		160453.49381313793f,
		160480.17991008417f,
		160506.86711647795f,
		160533.5554322271f,
		160560.24485723933f,
		160586.93539142248f,
		160613.62703468435f,
		160640.31978693279f,
		160667.0136480757f,
		160693.70861802087f,
		160720.40469667627f,
		160747.1018839498f,
		160773.80017974938f,
		160800.49958398298f,
		160827.20009655855f,
		160853.9017173841f,
		160880.60444636765f,
		160907.30828341722f,
		160934.0132284409f,
		160960.71928134665f,
		160987.4264420427f,
		161014.13471043704f,
		161040.84408643784f,
		161067.55456995327f,
		161094.26616089148f,
		161120.97885916062f,
		161147.69266466892f,
		161174.40757732463f,
		161201.12359703594f,
		161227.84072371112f,
		161254.55895725847f,
		161281.27829758628f,
		161307.99874460287f,
		161334.72029821656f,
		161361.4429583357f,
		161388.1667248687f,
		161414.8915977239f,
		161441.61757680977f,
		161468.34466203468f,
		161495.07285330712f,
		161521.80215053557f,
		161548.53255362847f,
		161575.26406249436f,
		161601.99667704175f,
		161628.7303971792f,
		161655.46522281526f,
		161682.2011538585f,
		161708.93819021754f,
		161735.676331801f,
		161762.4155785175f,
		161789.1559302757f,
		161815.89738698432f,
		161842.639948552f,
		161869.38361488748f,
		161896.1283858995f,
		161922.87426149676f,
		161949.62124158812f,
		161976.3693260823f,
		162003.1185148881f,
		162029.8688079144f,
		162056.62020507f,
		162083.37270626382f,
		162110.1263114047f,
		162136.88102040152f,
		162163.63683316324f,
		162190.3937495988f,
		162217.1517696171f,
		162243.91089312723f,
		162270.67112003808f,
		162297.43245025873f,
		162324.1948836982f,
		162350.9584202655f,
		162377.72305986975f,
		162404.48880242003f,
		162431.25564782543f,
		162458.0235959951f,
		162484.79264683815f,
		162511.56280026378f,
		162538.33405618116f,
		162565.1064144995f,
		162591.879875128f,
		162618.65443797593f,
		162645.43010295252f,
		162672.20686996708f,
		162698.98473892888f,
		162725.76370974723f,
		162752.54378233146f,
		162779.32495659095f,
		162806.10723243505f,
		162832.89060977317f,
		162859.67508851466f,
		162886.46066856902f,
		162913.24734984562f,
		162940.035132254f,
		162966.82401570358f,
		162993.6140001039f,
		163020.40508536444f,
		163047.19727139478f,
		163073.99055810447f,
		163100.78494540305f,
		163127.58043320014f,
		163154.37702140535f,
		163181.1747099283f,
		163207.97349867865f,
		163234.77338756606f,
		163261.57437650024f,
		163288.37646539084f,
		163315.17965414765f,
		163341.98394268038f,
		163368.78933089875f,
		163395.5958187126f,
		163422.40340603172f,
		163449.2120927659f,
		163476.02187882498f,
		163502.83276411882f,
		163529.6447485573f,
		163556.45783205028f,
		163583.2720145077f,
		163610.08729583945f,
		163636.90367595552f,
		163663.72115476584f,
		163690.53973218042f,
		163717.35940810922f,
		163744.18018246227f,
		163771.00205514964f,
		163797.82502608138f,
		163824.64909516752f,
		163851.4742623182f,
		163878.3005274435f,
		163905.12789045356f,
		163931.95635125853f,
		163958.78590976857f,
		163985.61656589387f,
		164012.44831954464f,
		164039.2811706311f,
		164066.11511906344f,
		164092.950164752f,
		164119.786307607f,
		164146.62354753874f,
		164173.46188445756f,
		164200.30131827376f,
		164227.1418488977f,
		164253.98347623978f,
		164280.82620021031f,
		164307.6700207198f,
		164334.51493767856f,
		164361.3609509971f,
		164388.20806058586f,
		164415.05626635533f,
		164441.905568216f,
		164468.75596607837f,
		164495.607459853f,
		164522.4600494504f,
		164549.31373478117f,
		164576.1685157559f,
		164603.02439228518f,
		164629.88136427966f,
		164656.7394316499f,
		164683.59859430668f,
		164710.4588521606f,
		164737.32020512238f,
		164764.18265310273f,
		164791.04619601235f,
		164817.91083376206f,
		164844.77656626256f,
		164871.6433934247f,
		164898.51131515924f,
		164925.38033137703f,
		164952.25044198887f,
		164979.1216469057f,
		165005.9939460383f,
		165032.86733929766f,
		165059.7418265946f,
		165086.61740784015f
	};
}
