/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.htmlunit.xpath.functions;

import javax.xml.transform.TransformerException;
import net.sourceforge.htmlunit.xpath.XPathContext;
import net.sourceforge.htmlunit.xpath.functions.Function3Args;
import net.sourceforge.htmlunit.xpath.functions.WrongNumberArgsException;
import net.sourceforge.htmlunit.xpath.objects.XObject;
import net.sourceforge.htmlunit.xpath.objects.XString;
import net.sourceforge.htmlunit.xpath.res.XPATHMessages;

public class FuncSubstring
extends Function3Args {
    @Override
    public XObject execute(XPathContext xctxt) throws TransformerException {
        XString substr;
        int startIndex;
        XString s1 = this.m_arg0.execute(xctxt).xstr();
        double start = this.m_arg1.execute(xctxt).num();
        int lenOfS1 = s1.length();
        if (lenOfS1 <= 0) {
            return XString.EMPTYSTRING;
        }
        if (Double.isNaN(start)) {
            start = -1000000.0;
            startIndex = 0;
        } else {
            int n = startIndex = (start = (double)Math.round(start)) > 0.0 ? (int)start - 1 : 0;
        }
        if (null != this.m_arg2) {
            double len = this.m_arg2.num(xctxt);
            int end = (int)((double)Math.round(len) + start) - 1;
            if (end < 0) {
                end = 0;
            } else if (end > lenOfS1) {
                end = lenOfS1;
            }
            if (startIndex > lenOfS1) {
                startIndex = lenOfS1;
            }
            substr = s1.substring(startIndex, end);
        } else {
            if (startIndex > lenOfS1) {
                startIndex = lenOfS1;
            }
            substr = s1.substring(startIndex);
        }
        return substr;
    }

    @Override
    public void checkNumberArgs(int argNum) throws WrongNumberArgsException {
        if (argNum < 2) {
            this.reportWrongNumberArgs();
        }
    }

    @Override
    protected void reportWrongNumberArgs() throws WrongNumberArgsException {
        throw new WrongNumberArgsException(XPATHMessages.createXPATHMessage("ER_TWO_OR_THREE", null));
    }
}

