/*
 * Decompiled with CFR 0.152.
 */
package net.sf.dynamicreports.googlecharts.jasper.geomap;

import java.awt.Color;
import java.util.List;
import java.util.Set;
import net.sf.dynamicreports.googlecharts.report.geomap.GeoMapDataMode;
import net.sf.jasperreports.engine.JRGenericPrintElement;
import net.sf.jasperreports.engine.export.GenericElementHtmlHandler;
import net.sf.jasperreports.engine.export.JRHtmlExporter;
import net.sf.jasperreports.engine.export.JRHtmlExporterContext;
import net.sf.jasperreports.engine.export.JRXhtmlExporter;
import net.sf.jasperreports.engine.type.ModeEnum;
import net.sf.jasperreports.engine.util.JRColorUtil;
import net.sf.jasperreports.web.util.VelocityUtil;
import org.apache.commons.lang.StringUtils;
import org.apache.velocity.VelocityContext;

public class GeoMapElementHtmlHandler
implements GenericElementHtmlHandler {
    private static final String GEOMAP_ELEMENT_HTML_TEMPLATE = "net/sf/dynamicreports/googlecharts/jasper/geomap/GeoMapElementHtmlTemplate.vm";

    public String getHtmlFragment(JRHtmlExporterContext context, JRGenericPrintElement element) {
        Boolean showLegend = (Boolean)element.getParameterValue("showLegend");
        GeoMapDataMode dataMode = (GeoMapDataMode)((Object)element.getParameterValue("dataMode"));
        String region = (String)element.getParameterValue("region");
        String valueLabel = (String)element.getParameterValue("valueLabel");
        if (valueLabel == null) {
            valueLabel = "";
        }
        List colors = (List)element.getParameterValue("colors");
        String stringColors = null;
        if (colors != null && !colors.isEmpty()) {
            stringColors = "";
            for (Color color : colors) {
                stringColors = String.valueOf(stringColors) + "," + this.getColorString(color);
            }
            stringColors = StringUtils.removeStart((String)stringColors, (String)",");
        }
        Set dataset = (Set)element.getParameterValue("dataset");
        VelocityContext velocityContext = new VelocityContext();
        velocityContext.put("showLegend", (Object)showLegend);
        if (dataMode != null) {
            switch (dataMode) {
                case REGIONS: {
                    velocityContext.put("dataMode", (Object)"regions");
                    break;
                }
                case MARKERS: {
                    velocityContext.put("dataMode", (Object)"markers");
                    break;
                }
            }
        }
        velocityContext.put("id", (Object)("map_" + element.hashCode()));
        velocityContext.put("region", (Object)region);
        velocityContext.put("valueLabel", (Object)valueLabel);
        velocityContext.put("colors", (Object)stringColors);
        velocityContext.put("dataset", (Object)dataset);
        if (context.getExporter() instanceof JRXhtmlExporter) {
            velocityContext.put("xhtml", (Object)"xhtml");
            velocityContext.put("elementX", (Object)((JRXhtmlExporter)context.getExporter()).toSizeUnit(element.getX()));
            velocityContext.put("elementY", (Object)((JRXhtmlExporter)context.getExporter()).toSizeUnit(element.getY()));
        } else {
            velocityContext.put("elementX", (Object)((JRHtmlExporter)context.getExporter()).toSizeUnit(element.getX()));
            velocityContext.put("elementY", (Object)((JRHtmlExporter)context.getExporter()).toSizeUnit(element.getY()));
        }
        velocityContext.put("elementWidth", (Object)element.getWidth());
        velocityContext.put("elementHeight", (Object)element.getHeight());
        if (element.getModeValue() == ModeEnum.OPAQUE) {
            velocityContext.put("backgroundColor", (Object)JRColorUtil.getColorHexa((Color)element.getBackcolor()));
        }
        return VelocityUtil.processTemplate((String)GEOMAP_ELEMENT_HTML_TEMPLATE, (VelocityContext)velocityContext);
    }

    private String getColorString(Color color) {
        int colorMask = Integer.parseInt("FFFFFF", 16);
        String hex = Integer.toHexString(color.getRGB() & colorMask).toUpperCase();
        return "0x" + ("000000" + hex).substring(hex.length());
    }

    public boolean toExport(JRGenericPrintElement element) {
        return true;
    }
}

