/*
 * Decompiled with CFR 0.152.
 */
package net.sf.dynamicreports.googlecharts.jasper.geomap;

import net.sf.dynamicreports.googlecharts.jasper.geomap.GeoMapComponent;
import net.sf.dynamicreports.googlecharts.jasper.geomap.GeoMapDataset;
import net.sf.dynamicreports.googlecharts.jasper.geomap.StandardGeoMapComponent;
import net.sf.jasperreports.engine.JRElementDataset;
import net.sf.jasperreports.engine.JRExpressionCollector;
import net.sf.jasperreports.engine.base.JRBaseObjectFactory;
import net.sf.jasperreports.engine.component.Component;
import net.sf.jasperreports.engine.component.ComponentCompiler;
import net.sf.jasperreports.engine.design.JRVerifier;
import net.sf.jasperreports.engine.type.EvaluationTimeEnum;

public class GeoMapCompiler
implements ComponentCompiler {
    public void collectExpressions(Component component, JRExpressionCollector collector) {
        GeoMapComponent geoMap = (GeoMapComponent)component;
        collector.addExpression(geoMap.getRegionExpression());
        collector.addExpression(geoMap.getValueLabelExpression());
        GeoMapCompiler.collectExpressions(geoMap.getDataset(), collector);
    }

    public static void collectExpressions(GeoMapDataset dataset, JRExpressionCollector collector) {
        if (dataset != null) {
            collector.collect((JRElementDataset)dataset);
            JRExpressionCollector datasetCollector = collector.getCollector((JRElementDataset)dataset);
            datasetCollector.addExpression(dataset.getLocationExpression());
            datasetCollector.addExpression(dataset.getValueExpression());
            datasetCollector.addExpression(dataset.getLabelExpression());
        }
    }

    public Component toCompiledComponent(Component component, JRBaseObjectFactory baseFactory) {
        GeoMapComponent geoMap = (GeoMapComponent)component;
        return new StandardGeoMapComponent(geoMap, baseFactory);
    }

    public void verify(Component component, JRVerifier verifier) {
        GeoMapComponent geoMap = (GeoMapComponent)component;
        EvaluationTimeEnum evaluationTime = geoMap.getEvaluationTime();
        if (evaluationTime == EvaluationTimeEnum.AUTO) {
            verifier.addBrokenRule("Auto evaluation time is not supported for geo maps", (Object)geoMap);
        } else if (evaluationTime == EvaluationTimeEnum.GROUP) {
            String evaluationGroup = geoMap.getEvaluationGroup();
            if (evaluationGroup == null || evaluationGroup.length() == 0) {
                verifier.addBrokenRule("No evaluation group set for geo map", (Object)geoMap);
            } else if (!verifier.getReportDesign().getGroupsMap().containsKey(evaluationGroup)) {
                verifier.addBrokenRule("Map evalution group \"" + evaluationGroup + " not found", (Object)geoMap);
            }
        }
        GeoMapDataset dataset = geoMap.getDataset();
        if (dataset == null) {
            verifier.addBrokenRule("No dataset for geo map", (Object)geoMap);
        } else {
            verifier.verifyElementDataset((JRElementDataset)dataset);
        }
    }
}

