/*
 * Decompiled with CFR 0.152.
 */
package net.snowflake.client.jdbc.internal.com.carrotsearch.hppc;

import java.util.Arrays;
import java.util.Iterator;
import net.snowflake.client.jdbc.internal.com.carrotsearch.hppc.AbstractDoubleCollection;
import net.snowflake.client.jdbc.internal.com.carrotsearch.hppc.AbstractIterator;
import net.snowflake.client.jdbc.internal.com.carrotsearch.hppc.BitMixer;
import net.snowflake.client.jdbc.internal.com.carrotsearch.hppc.BufferAllocationException;
import net.snowflake.client.jdbc.internal.com.carrotsearch.hppc.DoubleBufferVisualizer;
import net.snowflake.client.jdbc.internal.com.carrotsearch.hppc.DoubleContainer;
import net.snowflake.client.jdbc.internal.com.carrotsearch.hppc.DoubleLookupContainer;
import net.snowflake.client.jdbc.internal.com.carrotsearch.hppc.DoubleSet;
import net.snowflake.client.jdbc.internal.com.carrotsearch.hppc.HashContainers;
import net.snowflake.client.jdbc.internal.com.carrotsearch.hppc.HashOrderMixing;
import net.snowflake.client.jdbc.internal.com.carrotsearch.hppc.HashOrderMixingStrategy;
import net.snowflake.client.jdbc.internal.com.carrotsearch.hppc.Preallocable;
import net.snowflake.client.jdbc.internal.com.carrotsearch.hppc.cursors.DoubleCursor;
import net.snowflake.client.jdbc.internal.com.carrotsearch.hppc.predicates.DoublePredicate;
import net.snowflake.client.jdbc.internal.com.carrotsearch.hppc.procedures.DoubleProcedure;

public class DoubleHashSet
extends AbstractDoubleCollection
implements DoubleLookupContainer,
DoubleSet,
Preallocable,
Cloneable {
    public double[] keys;
    protected int assigned;
    protected int mask;
    protected int keyMixer;
    protected int resizeAt;
    protected boolean hasEmptyKey;
    protected double loadFactor;
    protected HashOrderMixingStrategy orderMixer;

    public DoubleHashSet() {
        this(4, 0.75);
    }

    public DoubleHashSet(int expectedElements) {
        this(expectedElements, 0.75);
    }

    public DoubleHashSet(int expectedElements, double loadFactor) {
        this(expectedElements, loadFactor, HashOrderMixing.defaultStrategy());
    }

    public DoubleHashSet(int expectedElements, double loadFactor, HashOrderMixingStrategy orderMixer) {
        this.orderMixer = orderMixer;
        this.loadFactor = this.verifyLoadFactor(loadFactor);
        this.ensureCapacity(expectedElements);
    }

    public DoubleHashSet(DoubleContainer container) {
        this(container.size());
        this.addAll(container);
    }

    @Override
    public boolean add(double key) {
        double existing;
        if (Double.doubleToLongBits(key) == 0L) {
            assert (Double.doubleToLongBits(this.keys[this.mask + 1]) == 0L);
            boolean added = !this.hasEmptyKey;
            this.hasEmptyKey = true;
            return added;
        }
        double[] keys = this.keys;
        int mask = this.mask;
        int slot = this.hashKey(key) & mask;
        while (Double.doubleToLongBits(existing = keys[slot]) != 0L) {
            if (Double.doubleToLongBits(existing) == Double.doubleToLongBits(key)) {
                return false;
            }
            slot = slot + 1 & mask;
        }
        if (this.assigned == this.resizeAt) {
            this.allocateThenInsertThenRehash(slot, key);
        } else {
            keys[slot] = key;
        }
        ++this.assigned;
        return true;
    }

    public final int addAll(double ... elements) {
        this.ensureCapacity(elements.length);
        int count = 0;
        for (double e : elements) {
            if (!this.add(e)) continue;
            ++count;
        }
        return count;
    }

    public int addAll(DoubleContainer container) {
        this.ensureCapacity(container.size());
        return this.addAll((Iterable<? extends DoubleCursor>)container);
    }

    public int addAll(Iterable<? extends DoubleCursor> iterable) {
        int count = 0;
        for (DoubleCursor doubleCursor : iterable) {
            if (!this.add(doubleCursor.value)) continue;
            ++count;
        }
        return count;
    }

    @Override
    public double[] toArray() {
        double[] cloned = new double[this.size()];
        int j = 0;
        if (this.hasEmptyKey) {
            cloned[j++] = 0.0;
        }
        double[] keys = this.keys;
        int max = this.mask;
        for (int slot = 0; slot <= max; ++slot) {
            double existing = keys[slot];
            if (Double.doubleToLongBits(existing) == 0L) continue;
            cloned[j++] = existing;
        }
        return cloned;
    }

    public boolean remove(double key) {
        double existing;
        if (Double.doubleToLongBits(key) == 0L) {
            boolean hadEmptyKey = this.hasEmptyKey;
            this.hasEmptyKey = false;
            return hadEmptyKey;
        }
        double[] keys = this.keys;
        int mask = this.mask;
        int slot = this.hashKey(key) & mask;
        while (Double.doubleToLongBits(existing = keys[slot]) != 0L) {
            if (Double.doubleToLongBits(existing) == Double.doubleToLongBits(key)) {
                this.shiftConflictingKeys(slot);
                return true;
            }
            slot = slot + 1 & mask;
        }
        return false;
    }

    @Override
    public int removeAll(double key) {
        return this.remove(key) ? 1 : 0;
    }

    @Override
    public int removeAll(DoublePredicate predicate) {
        int before = this.size();
        if (this.hasEmptyKey && predicate.apply(0.0)) {
            this.hasEmptyKey = false;
        }
        double[] keys = this.keys;
        int slot = 0;
        int max = this.mask;
        while (slot <= max) {
            double existing = keys[slot];
            if (Double.doubleToLongBits(existing) != 0L && predicate.apply(existing)) {
                this.shiftConflictingKeys(slot);
                continue;
            }
            ++slot;
        }
        return before - this.size();
    }

    @Override
    public boolean contains(double key) {
        double existing;
        if (Double.doubleToLongBits(key) == 0L) {
            return this.hasEmptyKey;
        }
        double[] keys = this.keys;
        int mask = this.mask;
        int slot = this.hashKey(key) & mask;
        while (Double.doubleToLongBits(existing = keys[slot]) != 0L) {
            if (Double.doubleToLongBits(existing) == Double.doubleToLongBits(key)) {
                return true;
            }
            slot = slot + 1 & mask;
        }
        return false;
    }

    @Override
    public void clear() {
        this.assigned = 0;
        this.hasEmptyKey = false;
        Arrays.fill(this.keys, 0.0);
    }

    @Override
    public void release() {
        this.assigned = 0;
        this.hasEmptyKey = false;
        this.keys = null;
        this.ensureCapacity(4);
    }

    @Override
    public boolean isEmpty() {
        return this.size() == 0;
    }

    @Override
    public void ensureCapacity(int expectedElements) {
        if (expectedElements > this.resizeAt || this.keys == null) {
            double[] prevKeys = this.keys;
            this.allocateBuffers(HashContainers.minBufferSize(expectedElements, this.loadFactor));
            if (prevKeys != null && !this.isEmpty()) {
                this.rehash(prevKeys);
            }
        }
    }

    @Override
    public int size() {
        return this.assigned + (this.hasEmptyKey ? 1 : 0);
    }

    public int hashCode() {
        int h = this.hasEmptyKey ? -559038737 : 0;
        double[] keys = this.keys;
        for (int slot = this.mask; slot >= 0; --slot) {
            double existing = keys[slot];
            if (Double.doubleToLongBits(existing) == 0L) continue;
            h += BitMixer.mix(existing);
        }
        return h;
    }

    public boolean equals(Object obj) {
        return obj != null && this.getClass() == obj.getClass() && this.sameKeys((DoubleSet)this.getClass().cast(obj));
    }

    private boolean sameKeys(DoubleSet other) {
        if (other.size() != this.size()) {
            return false;
        }
        for (DoubleCursor c : other) {
            if (this.contains(c.value)) continue;
            return false;
        }
        return true;
    }

    public DoubleHashSet clone() {
        try {
            DoubleHashSet cloned = (DoubleHashSet)super.clone();
            cloned.keys = (double[])this.keys.clone();
            cloned.hasEmptyKey = cloned.hasEmptyKey;
            cloned.orderMixer = this.orderMixer.clone();
            return cloned;
        }
        catch (CloneNotSupportedException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public Iterator<DoubleCursor> iterator() {
        return new EntryIterator();
    }

    @Override
    public <T extends DoubleProcedure> T forEach(T procedure) {
        if (this.hasEmptyKey) {
            procedure.apply(0.0);
        }
        double[] keys = this.keys;
        int max = this.mask;
        for (int slot = 0; slot <= max; ++slot) {
            double existing = keys[slot];
            if (Double.doubleToLongBits(existing) == 0L) continue;
            procedure.apply(existing);
        }
        return procedure;
    }

    @Override
    public <T extends DoublePredicate> T forEach(T predicate) {
        double existing;
        if (this.hasEmptyKey && !predicate.apply(0.0)) {
            return predicate;
        }
        double[] keys = this.keys;
        int max = this.mask;
        for (int slot = 0; slot <= max && (Double.doubleToLongBits(existing = keys[slot]) == 0L || predicate.apply(existing)); ++slot) {
        }
        return predicate;
    }

    public static DoubleHashSet from(double ... elements) {
        DoubleHashSet set = new DoubleHashSet(elements.length);
        set.addAll(elements);
        return set;
    }

    protected int hashKey(double key) {
        assert (Double.doubleToLongBits(key) != 0L);
        return BitMixer.mix(key, this.keyMixer);
    }

    public int indexOf(double key) {
        double existing;
        int mask = this.mask;
        if (Double.doubleToLongBits(key) == 0L) {
            return this.hasEmptyKey ? mask + 1 : ~(mask + 1);
        }
        double[] keys = this.keys;
        int slot = this.hashKey(key) & mask;
        while (Double.doubleToLongBits(existing = keys[slot]) != 0L) {
            if (Double.doubleToLongBits(existing) == Double.doubleToLongBits(key)) {
                return slot;
            }
            slot = slot + 1 & mask;
        }
        return ~slot;
    }

    public boolean indexExists(int index) {
        assert (index < 0 || index >= 0 && index <= this.mask || index == this.mask + 1 && this.hasEmptyKey);
        return index >= 0;
    }

    public double indexGet(int index) {
        assert (index >= 0) : "The index must point at an existing key.";
        assert (index <= this.mask || index == this.mask + 1 && this.hasEmptyKey);
        return this.keys[index];
    }

    public double indexReplace(int index, double equivalentKey) {
        assert (index >= 0) : "The index must point at an existing key.";
        assert (index <= this.mask || index == this.mask + 1 && this.hasEmptyKey);
        assert (Double.doubleToLongBits(equivalentKey) == Double.doubleToLongBits(this.keys[index]));
        double previousValue = this.keys[index];
        this.keys[index] = equivalentKey;
        return previousValue;
    }

    public void indexInsert(int index, double key) {
        assert (index < 0) : "The index must not point at an existing key.";
        index ^= 0xFFFFFFFF;
        if (Double.doubleToLongBits(key) == 0L) {
            assert (index == this.mask + 1);
            assert (Double.doubleToLongBits(this.keys[index]) == 0L);
            this.hasEmptyKey = true;
        } else {
            assert (Double.doubleToLongBits(this.keys[index]) == 0L);
            if (this.assigned == this.resizeAt) {
                this.allocateThenInsertThenRehash(index, key);
            } else {
                this.keys[index] = key;
            }
            ++this.assigned;
        }
    }

    @Override
    public String visualizeKeyDistribution(int characters) {
        return DoubleBufferVisualizer.visualizeKeyDistribution(this.keys, this.mask, characters);
    }

    protected double verifyLoadFactor(double loadFactor) {
        HashContainers.checkLoadFactor(loadFactor, 0.01f, 0.99f);
        return loadFactor;
    }

    protected void rehash(double[] fromKeys) {
        assert (HashContainers.checkPowerOfTwo(fromKeys.length - 1));
        double[] keys = this.keys;
        int mask = this.mask;
        int i = fromKeys.length - 1;
        while (--i >= 0) {
            double existing = fromKeys[i];
            if (Double.doubleToLongBits(existing) == 0L) continue;
            int slot = this.hashKey(existing) & mask;
            while (Double.doubleToLongBits(keys[slot]) != 0L) {
                slot = slot + 1 & mask;
            }
            keys[slot] = existing;
        }
    }

    protected void allocateBuffers(int arraySize) {
        assert (Integer.bitCount(arraySize) == 1);
        int newKeyMixer = this.orderMixer.newKeyMixer(arraySize);
        double[] prevKeys = this.keys;
        try {
            int emptyElementSlot = 1;
            this.keys = new double[arraySize + emptyElementSlot];
        }
        catch (OutOfMemoryError e) {
            this.keys = prevKeys;
            throw new BufferAllocationException("Not enough memory to allocate buffers for rehashing: %,d -> %,d", (Throwable)e, this.keys == null ? 0 : this.size(), arraySize);
        }
        this.resizeAt = HashContainers.expandAtCount(arraySize, this.loadFactor);
        this.keyMixer = newKeyMixer;
        this.mask = arraySize - 1;
    }

    protected void allocateThenInsertThenRehash(int slot, double pendingKey) {
        assert (this.assigned == this.resizeAt && Double.doubleToLongBits(this.keys[slot]) == 0L && Double.doubleToLongBits(pendingKey) != 0L);
        double[] prevKeys = this.keys;
        this.allocateBuffers(HashContainers.nextBufferSize(this.mask + 1, this.size(), this.loadFactor));
        assert (this.keys.length > prevKeys.length);
        prevKeys[slot] = pendingKey;
        this.rehash(prevKeys);
    }

    protected void shiftConflictingKeys(int gapSlot) {
        int slot;
        double existing;
        double[] keys = this.keys;
        int mask = this.mask;
        int distance = 0;
        while (Double.doubleToLongBits(existing = keys[slot = gapSlot + ++distance & mask]) != 0L) {
            int idealSlot = this.hashKey(existing);
            int shift = slot - idealSlot & mask;
            if (shift < distance) continue;
            keys[gapSlot] = existing;
            gapSlot = slot;
            distance = 0;
        }
        keys[gapSlot] = 0.0;
        --this.assigned;
    }

    protected final class EntryIterator
    extends AbstractIterator<DoubleCursor> {
        private final DoubleCursor cursor;
        private final int max;
        private int slot;

        public EntryIterator() {
            this.max = DoubleHashSet.this.mask + 1;
            this.slot = -1;
            this.cursor = new DoubleCursor();
        }

        @Override
        protected DoubleCursor fetch() {
            if (this.slot < this.max) {
                ++this.slot;
                while (this.slot < this.max) {
                    double existing = DoubleHashSet.this.keys[this.slot];
                    if (Double.doubleToLongBits(existing) != 0L) {
                        this.cursor.index = this.slot;
                        this.cursor.value = existing;
                        return this.cursor;
                    }
                    ++this.slot;
                }
            }
            if (this.slot == this.max && DoubleHashSet.this.hasEmptyKey) {
                this.cursor.index = this.slot++;
                this.cursor.value = 0.0;
                return this.cursor;
            }
            return (DoubleCursor)this.done();
        }
    }
}

