/*
 * Decompiled with CFR 0.152.
 */
package net.snowflake.client.jdbc.internal.apache.arrow.vector.util;

import java.math.BigDecimal;
import java.math.BigInteger;
import java.nio.ByteBuffer;
import net.snowflake.client.jdbc.internal.io.netty.buffer.ArrowBuf;

public class DecimalUtility {
    public static final int MAX_DIGITS = 9;
    public static final int DIGITS_BASE = 1000000000;
    public static final int DIGITS_MAX = 999999999;
    public static final int INTEGER_SIZE = 4;
    public static final String[] decimalToString = new String[]{"", "0", "00", "000", "0000", "00000", "000000", "0000000", "00000000", "000000000"};
    public static final long[] scale_long_constants = new long[]{1L, 10L, 100L, 1000L, 10000L, 100000L, 1000000L, 10000000L, 100000000L, 1000000000L, 10000000000L, 100000000000L, 1000000000000L, 10000000000000L, 100000000000000L, 1000000000000000L, 10000000000000000L, 100000000000000000L, 1000000000000000000L};
    public static final int DECIMAL_BYTE_LENGTH = 16;

    public static long getPowerOfTen(int power) {
        assert (power >= 0 && power < scale_long_constants.length);
        return scale_long_constants[power];
    }

    public static long adjustScaleMultiply(long input, int factor) {
        int index = Math.abs(factor);
        assert (index >= 0 && index < scale_long_constants.length);
        if (factor >= 0) {
            return input * scale_long_constants[index];
        }
        return input / scale_long_constants[index];
    }

    public static long adjustScaleDivide(long input, int factor) {
        int index = Math.abs(factor);
        assert (index >= 0 && index < scale_long_constants.length);
        if (factor >= 0) {
            return input / scale_long_constants[index];
        }
        return input * scale_long_constants[index];
    }

    public static StringBuilder toStringWithZeroes(int number, int desiredLength) {
        String value = Integer.valueOf(number).toString();
        int length = value.length();
        StringBuilder str = new StringBuilder();
        str.append(decimalToString[desiredLength - length]);
        str.append(value);
        return str;
    }

    public static StringBuilder toStringWithZeroes(long number, int desiredLength) {
        int zeroesLength;
        String value = Long.valueOf(number).toString();
        int length = value.length();
        StringBuilder str = new StringBuilder();
        for (zeroesLength = desiredLength - length; zeroesLength > 9; zeroesLength -= 9) {
            str.append(decimalToString[9]);
        }
        str.append(decimalToString[zeroesLength]);
        str.append(value);
        return str;
    }

    public static BigDecimal getBigDecimalFromArrowBuf(ArrowBuf bytebuf, int index, int scale) {
        byte[] value = new byte[16];
        int startIndex = index * 16;
        bytebuf.getBytes(startIndex, value, 0, 16);
        int stop = 8;
        for (int i = 0; i < stop; ++i) {
            byte temp = value[i];
            int j = 15 - i;
            value[i] = value[j];
            value[j] = temp;
        }
        BigInteger unscaledValue = new BigInteger(value);
        return new BigDecimal(unscaledValue, scale);
    }

    public static BigDecimal getBigDecimalFromByteBuffer(ByteBuffer bytebuf, int scale) {
        byte[] value = new byte[16];
        bytebuf.get(value);
        BigInteger unscaledValue = new BigInteger(value);
        return new BigDecimal(unscaledValue, scale);
    }

    public static byte[] getByteArrayFromArrowBuf(ArrowBuf bytebuf, int index) {
        byte[] value = new byte[16];
        int startIndex = index * 16;
        bytebuf.getBytes(startIndex, value, 0, 16);
        return value;
    }

    public static boolean checkPrecisionAndScale(BigDecimal value, int vectorPrecision, int vectorScale) {
        if (value.scale() != vectorScale) {
            throw new UnsupportedOperationException("BigDecimal scale must equal that in the Arrow vector: " + value.scale() + " != " + vectorScale);
        }
        if (value.precision() > vectorPrecision) {
            throw new UnsupportedOperationException("BigDecimal precision can not be greater than that in the Arrow vector: " + value.precision() + " > " + vectorPrecision);
        }
        return true;
    }

    public static void writeBigDecimalToArrowBuf(BigDecimal value, ArrowBuf bytebuf, int index) {
        byte[] bytes = value.unscaledValue().toByteArray();
        int padValue = value.signum() == -1 ? 255 : 0;
        DecimalUtility.writeByteArrayToArrowBuf(bytes, bytebuf, index, padValue);
    }

    public static void writeByteArrayToArrowBuf(byte[] bytes, ArrowBuf bytebuf, int index) {
        DecimalUtility.writeByteArrayToArrowBuf(bytes, bytebuf, index, 0);
    }

    private static void writeByteArrayToArrowBuf(byte[] bytes, ArrowBuf bytebuf, int index, int padValue) {
        int i;
        int startIndex = index * 16;
        if (bytes.length > 16) {
            throw new UnsupportedOperationException("Decimal size greater than 16 bytes");
        }
        byte[] bytesLE = new byte[bytes.length];
        int stop = bytes.length / 2;
        for (i = 0; i < stop; ++i) {
            int j = bytes.length - 1 - i;
            bytesLE[i] = bytes[j];
            bytesLE[j] = bytes[i];
        }
        if (bytes.length % 2 != 0) {
            i = bytes.length / 2;
            bytesLE[i] = bytes[i];
        }
        bytebuf.setBytes(startIndex, bytesLE, 0, bytes.length);
        for (i = bytes.length; i < 16; ++i) {
            bytebuf.setByte(startIndex + i, padValue);
        }
    }
}

