/*
 * Decompiled with CFR 0.152.
 */
package net.snowflake.client.jdbc.internal.apache.arrow.vector.complex.impl;

import net.snowflake.client.jdbc.internal.apache.arrow.vector.complex.impl.AbstractFieldReader;
import net.snowflake.client.jdbc.internal.apache.arrow.vector.holders.NullableTinyIntHolder;
import net.snowflake.client.jdbc.internal.apache.arrow.vector.holders.TinyIntHolder;
import net.snowflake.client.jdbc.internal.apache.arrow.vector.types.Types;

public class NullableTinyIntHolderReaderImpl
extends AbstractFieldReader {
    private NullableTinyIntHolder holder;

    public NullableTinyIntHolderReaderImpl(NullableTinyIntHolder holder) {
        this.holder = holder;
    }

    @Override
    public int size() {
        throw new UnsupportedOperationException("You can't call size on a Holder value reader.");
    }

    @Override
    public boolean next() {
        throw new UnsupportedOperationException("You can't call next on a single value reader.");
    }

    @Override
    public void setPosition(int index) {
        throw new UnsupportedOperationException("You can't call next on a single value reader.");
    }

    @Override
    public Types.MinorType getMinorType() {
        return Types.MinorType.TINYINT;
    }

    @Override
    public boolean isSet() {
        return this.holder.isSet == 1;
    }

    @Override
    public void read(TinyIntHolder h) {
        h.value = this.holder.value;
    }

    @Override
    public void read(NullableTinyIntHolder h) {
        h.value = this.holder.value;
        h.isSet = this.isSet() ? 1 : 0;
    }

    @Override
    public Byte readByte() {
        if (!this.isSet()) {
            return null;
        }
        Byte value = new Byte(this.holder.value);
        return value;
    }

    @Override
    public Object readObject() {
        return this.readByte();
    }
}

