/*
 * Decompiled with CFR 0.152.
 */
package net.snowflake.client.jdbc.internal.apache.arrow.vector.complex;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import net.snowflake.client.jdbc.internal.apache.arrow.memory.BaseAllocator;
import net.snowflake.client.jdbc.internal.apache.arrow.memory.BufferAllocator;
import net.snowflake.client.jdbc.internal.apache.arrow.memory.OutOfMemoryException;
import net.snowflake.client.jdbc.internal.apache.arrow.util.Preconditions;
import net.snowflake.client.jdbc.internal.apache.arrow.vector.AddOrGetResult;
import net.snowflake.client.jdbc.internal.apache.arrow.vector.BitVectorHelper;
import net.snowflake.client.jdbc.internal.apache.arrow.vector.BufferBacked;
import net.snowflake.client.jdbc.internal.apache.arrow.vector.FieldVector;
import net.snowflake.client.jdbc.internal.apache.arrow.vector.ValueVector;
import net.snowflake.client.jdbc.internal.apache.arrow.vector.ZeroVector;
import net.snowflake.client.jdbc.internal.apache.arrow.vector.complex.BaseRepeatedValueVector;
import net.snowflake.client.jdbc.internal.apache.arrow.vector.complex.PromotableVector;
import net.snowflake.client.jdbc.internal.apache.arrow.vector.complex.UnionVector;
import net.snowflake.client.jdbc.internal.apache.arrow.vector.complex.impl.ComplexCopier;
import net.snowflake.client.jdbc.internal.apache.arrow.vector.complex.impl.UnionListReader;
import net.snowflake.client.jdbc.internal.apache.arrow.vector.complex.impl.UnionListWriter;
import net.snowflake.client.jdbc.internal.apache.arrow.vector.ipc.message.ArrowFieldNode;
import net.snowflake.client.jdbc.internal.apache.arrow.vector.types.Types;
import net.snowflake.client.jdbc.internal.apache.arrow.vector.types.pojo.ArrowType;
import net.snowflake.client.jdbc.internal.apache.arrow.vector.types.pojo.DictionaryEncoding;
import net.snowflake.client.jdbc.internal.apache.arrow.vector.types.pojo.Field;
import net.snowflake.client.jdbc.internal.apache.arrow.vector.types.pojo.FieldType;
import net.snowflake.client.jdbc.internal.apache.arrow.vector.util.CallBack;
import net.snowflake.client.jdbc.internal.apache.arrow.vector.util.JsonStringArrayList;
import net.snowflake.client.jdbc.internal.apache.arrow.vector.util.OversizedAllocationException;
import net.snowflake.client.jdbc.internal.apache.arrow.vector.util.TransferPair;
import net.snowflake.client.jdbc.internal.io.netty.buffer.ArrowBuf;

public class ListVector
extends BaseRepeatedValueVector
implements FieldVector,
PromotableVector {
    protected ArrowBuf validityBuffer;
    private UnionListReader reader;
    private CallBack callBack;
    private final FieldType fieldType;
    private int validityAllocationSizeInBytes;
    private int lastSet;

    public static ListVector empty(String name, BufferAllocator allocator) {
        return new ListVector(name, allocator, FieldType.nullable(ArrowType.List.INSTANCE), null);
    }

    @Deprecated
    public ListVector(String name, BufferAllocator allocator, CallBack callBack) {
        this(name, allocator, FieldType.nullable(ArrowType.List.INSTANCE), callBack);
    }

    @Deprecated
    public ListVector(String name, BufferAllocator allocator, DictionaryEncoding dictionary, CallBack callBack) {
        this(name, allocator, new FieldType(true, ArrowType.List.INSTANCE, dictionary, null), callBack);
    }

    public ListVector(String name, BufferAllocator allocator, FieldType fieldType, CallBack callBack) {
        super(name, allocator, callBack);
        this.validityBuffer = allocator.getEmpty();
        this.reader = new UnionListReader(this);
        this.fieldType = Preconditions.checkNotNull(fieldType);
        this.callBack = callBack;
        this.validityAllocationSizeInBytes = ListVector.getValidityBufferSizeFromCount(3970);
        this.lastSet = 0;
    }

    @Override
    public void initializeChildrenFromFields(List<Field> children) {
        if (children.size() != 1) {
            throw new IllegalArgumentException("Lists have only one child. Found: " + children);
        }
        Field field = children.get(0);
        AddOrGetResult addOrGetVector = this.addOrGetVector(field.getFieldType());
        if (!addOrGetVector.isCreated()) {
            throw new IllegalArgumentException("Child vector already existed: " + addOrGetVector.getVector());
        }
        ((FieldVector)addOrGetVector.getVector()).initializeChildrenFromFields(field.getChildren());
    }

    @Override
    public void setInitialCapacity(int numRecords) {
        this.validityAllocationSizeInBytes = ListVector.getValidityBufferSizeFromCount(numRecords);
        super.setInitialCapacity(numRecords);
    }

    @Override
    public void setInitialCapacity(int numRecords, double density) {
        this.validityAllocationSizeInBytes = ListVector.getValidityBufferSizeFromCount(numRecords);
        super.setInitialCapacity(numRecords, density);
    }

    public double getDensity() {
        if (this.valueCount == 0) {
            return 0.0;
        }
        int startOffset = this.offsetBuffer.getInt(0);
        int endOffset = this.offsetBuffer.getInt(this.valueCount * 4);
        double totalListSize = endOffset - startOffset;
        return totalListSize / (double)this.valueCount;
    }

    @Override
    public List<FieldVector> getChildrenFromFields() {
        return Collections.singletonList(this.getDataVector());
    }

    @Override
    public void loadFieldBuffers(ArrowFieldNode fieldNode, List<ArrowBuf> ownBuffers) {
        if (ownBuffers.size() != 2) {
            throw new IllegalArgumentException("Illegal buffer count, expected 2, got: " + ownBuffers.size());
        }
        ArrowBuf bitBuffer = ownBuffers.get(0);
        ArrowBuf offBuffer = ownBuffers.get(1);
        this.validityBuffer.release();
        this.validityBuffer = BitVectorHelper.loadValidityBuffer(fieldNode, bitBuffer, this.allocator);
        this.offsetBuffer.release();
        this.offsetBuffer = offBuffer.retain(this.allocator);
        this.validityAllocationSizeInBytes = this.validityBuffer.capacity();
        this.offsetAllocationSizeInBytes = this.offsetBuffer.capacity();
        this.lastSet = fieldNode.getLength();
        this.valueCount = fieldNode.getLength();
    }

    @Override
    public List<ArrowBuf> getFieldBuffers() {
        ArrayList<ArrowBuf> result = new ArrayList<ArrowBuf>(2);
        this.setReaderAndWriterIndex();
        result.add(this.validityBuffer);
        result.add(this.offsetBuffer);
        return result;
    }

    private void setReaderAndWriterIndex() {
        this.validityBuffer.readerIndex(0);
        this.offsetBuffer.readerIndex(0);
        if (this.valueCount == 0) {
            this.validityBuffer.writerIndex(0);
            this.offsetBuffer.writerIndex(0);
        } else {
            this.validityBuffer.writerIndex(ListVector.getValidityBufferSizeFromCount(this.valueCount));
            this.offsetBuffer.writerIndex((this.valueCount + 1) * 4);
        }
    }

    @Override
    @Deprecated
    public List<BufferBacked> getFieldInnerVectors() {
        throw new UnsupportedOperationException("There are no inner vectors. Use getFieldBuffers");
    }

    public UnionListWriter getWriter() {
        return new UnionListWriter(this);
    }

    @Override
    public void allocateNew() throws OutOfMemoryException {
        if (!this.allocateNewSafe()) {
            throw new OutOfMemoryException("Failure while allocating memory");
        }
    }

    @Override
    public boolean allocateNewSafe() {
        boolean success = false;
        try {
            this.clear();
            this.allocateValidityBuffer(this.validityAllocationSizeInBytes);
            success = super.allocateNewSafe();
        }
        finally {
            if (!success) {
                this.clear();
                return false;
            }
        }
        return true;
    }

    private void allocateValidityBuffer(long size) {
        int curSize = (int)size;
        this.validityBuffer = this.allocator.buffer(curSize);
        this.validityBuffer.readerIndex(0);
        this.validityAllocationSizeInBytes = curSize;
        this.validityBuffer.setZero(0, this.validityBuffer.capacity());
    }

    @Override
    public void reAlloc() {
        this.reallocValidityBuffer();
        super.reAlloc();
    }

    private void reallocValidityAndOffsetBuffers() {
        this.reallocOffsetBuffer();
        this.reallocValidityBuffer();
    }

    private void reallocValidityBuffer() {
        long baseSize = this.validityAllocationSizeInBytes;
        int currentBufferCapacity = this.validityBuffer.capacity();
        if (baseSize < (long)currentBufferCapacity) {
            baseSize = currentBufferCapacity;
        }
        long newAllocationSize = baseSize * 2L;
        newAllocationSize = BaseAllocator.nextPowerOfTwo(newAllocationSize);
        assert (newAllocationSize >= 1L);
        if (newAllocationSize > (long)MAX_ALLOCATION_SIZE) {
            throw new OversizedAllocationException("Unable to expand the buffer");
        }
        ArrowBuf newBuf = this.allocator.buffer((int)newAllocationSize);
        newBuf.setBytes(0, this.validityBuffer, 0, currentBufferCapacity);
        newBuf.setZero(currentBufferCapacity, newBuf.capacity() - currentBufferCapacity);
        this.validityBuffer.release(1);
        this.validityBuffer = newBuf;
        this.validityAllocationSizeInBytes = (int)newAllocationSize;
    }

    public void copyFromSafe(int inIndex, int outIndex, ListVector from) {
        this.copyFrom(inIndex, outIndex, from);
    }

    public void copyFrom(int inIndex, int outIndex, ListVector from) {
        UnionListReader in = from.getReader();
        in.setPosition(inIndex);
        UnionListWriter out = this.getWriter();
        out.setPosition(outIndex);
        ComplexCopier.copy(in, out);
    }

    @Override
    public FieldVector getDataVector() {
        return this.vector;
    }

    @Override
    public TransferPair getTransferPair(String ref, BufferAllocator allocator) {
        return this.getTransferPair(ref, allocator, null);
    }

    @Override
    public TransferPair getTransferPair(String ref, BufferAllocator allocator, CallBack callBack) {
        return new TransferImpl(ref, allocator, callBack);
    }

    @Override
    public TransferPair makeTransferPair(ValueVector target) {
        return new TransferImpl((ListVector)target);
    }

    @Override
    public long getValidityBufferAddress() {
        return this.validityBuffer.memoryAddress();
    }

    @Override
    public long getDataBufferAddress() {
        throw new UnsupportedOperationException();
    }

    @Override
    public long getOffsetBufferAddress() {
        return this.offsetBuffer.memoryAddress();
    }

    @Override
    public ArrowBuf getValidityBuffer() {
        return this.validityBuffer;
    }

    @Override
    public ArrowBuf getDataBuffer() {
        throw new UnsupportedOperationException();
    }

    @Override
    public ArrowBuf getOffsetBuffer() {
        return this.offsetBuffer;
    }

    @Override
    public UnionListReader getReader() {
        return this.reader;
    }

    @Override
    public <T extends ValueVector> AddOrGetResult<T> addOrGetVector(FieldType fieldType) {
        AddOrGetResult result = super.addOrGetVector(fieldType);
        this.reader = new UnionListReader(this);
        return result;
    }

    @Override
    public int getBufferSize() {
        if (this.valueCount == 0) {
            return 0;
        }
        int offsetBufferSize = (this.valueCount + 1) * 4;
        int validityBufferSize = ListVector.getValidityBufferSizeFromCount(this.valueCount);
        return offsetBufferSize + validityBufferSize + this.vector.getBufferSize();
    }

    @Override
    public Field getField() {
        return new Field(this.name, this.fieldType, Collections.singletonList(this.getDataVector().getField()));
    }

    @Override
    public Types.MinorType getMinorType() {
        return Types.MinorType.LIST;
    }

    @Override
    public void clear() {
        super.clear();
        this.validityBuffer = this.releaseBuffer(this.validityBuffer);
        this.lastSet = 0;
    }

    @Override
    public void reset() {
        super.reset();
        this.validityBuffer.setZero(0, this.validityBuffer.capacity());
        this.lastSet = 0;
    }

    @Override
    public ArrowBuf[] getBuffers(boolean clear) {
        ArrowBuf[] buffers;
        this.setReaderAndWriterIndex();
        if (this.getBufferSize() == 0) {
            buffers = new ArrowBuf[]{};
        } else {
            ArrayList<ArrowBuf> list = new ArrayList<ArrowBuf>();
            list.add(this.offsetBuffer);
            list.add(this.validityBuffer);
            list.addAll(Arrays.asList(this.vector.getBuffers(false)));
            buffers = list.toArray(new ArrowBuf[list.size()]);
        }
        if (clear) {
            for (ArrowBuf buffer : buffers) {
                buffer.retain();
            }
            this.clear();
        }
        return buffers;
    }

    @Override
    public UnionVector promoteToUnion() {
        UnionVector vector = new UnionVector("$data$", this.allocator, this.callBack);
        this.replaceDataVector(vector);
        this.reader = new UnionListReader(this);
        if (this.callBack != null) {
            this.callBack.doWork();
        }
        return vector;
    }

    @Override
    public Object getObject(int index) {
        if (this.isSet(index) == 0) {
            return null;
        }
        JsonStringArrayList<Object> vals = new JsonStringArrayList<Object>();
        int start = this.offsetBuffer.getInt(index * 4);
        int end = this.offsetBuffer.getInt((index + 1) * 4);
        FieldVector vv = this.getDataVector();
        for (int i = start; i < end; ++i) {
            vals.add(vv.getObject(i));
        }
        return vals;
    }

    @Override
    public boolean isNull(int index) {
        return this.isSet(index) == 0;
    }

    public int isSet(int index) {
        int byteIndex = index >> 3;
        byte b = this.validityBuffer.getByte(byteIndex);
        int bitIndex = index & 7;
        return b >> bitIndex & 1;
    }

    @Override
    public int getNullCount() {
        return BitVectorHelper.getNullCount(this.validityBuffer, this.valueCount);
    }

    @Override
    public int getValueCapacity() {
        return this.getValidityAndOffsetValueCapacity();
    }

    private int getValidityAndOffsetValueCapacity() {
        int offsetValueCapacity = Math.max(this.getOffsetBufferValueCapacity() - 1, 0);
        return Math.min(offsetValueCapacity, this.getValidityBufferValueCapacity());
    }

    private int getValidityBufferValueCapacity() {
        return (int)((long)this.validityBuffer.capacity() * 8L);
    }

    public void setNotNull(int index) {
        while (index >= this.getValidityAndOffsetValueCapacity()) {
            this.reallocValidityAndOffsetBuffers();
        }
        BitVectorHelper.setValidityBitToOne(this.validityBuffer, index);
        this.lastSet = index + 1;
    }

    @Override
    public int startNewValue(int index) {
        while (index >= this.getValidityAndOffsetValueCapacity()) {
            this.reallocValidityAndOffsetBuffers();
        }
        for (int i = this.lastSet; i <= index; ++i) {
            int currentOffset = this.offsetBuffer.getInt(i * 4);
            this.offsetBuffer.setInt((i + 1) * 4, currentOffset);
        }
        BitVectorHelper.setValidityBitToOne(this.validityBuffer, index);
        this.lastSet = index + 1;
        return this.offsetBuffer.getInt(this.lastSet * 4);
    }

    public void endValue(int index, int size) {
        int currentOffset = this.offsetBuffer.getInt((index + 1) * 4);
        this.offsetBuffer.setInt((index + 1) * 4, currentOffset + size);
    }

    @Override
    public void setValueCount(int valueCount) {
        this.valueCount = valueCount;
        if (valueCount > 0) {
            while (valueCount > this.getValidityAndOffsetValueCapacity()) {
                this.reallocValidityAndOffsetBuffers();
            }
            for (int i = this.lastSet; i < valueCount; ++i) {
                int currentOffset = this.offsetBuffer.getInt(i * 4);
                this.offsetBuffer.setInt((i + 1) * 4, currentOffset);
            }
        }
        int childValueCount = valueCount == 0 ? 0 : this.offsetBuffer.getInt(this.lastSet * 4);
        this.vector.setValueCount(childValueCount);
    }

    public void setLastSet(int value) {
        this.lastSet = value;
    }

    public int getLastSet() {
        return this.lastSet;
    }

    private class TransferImpl
    implements TransferPair {
        ListVector to;
        TransferPair dataTransferPair;

        public TransferImpl(String name, BufferAllocator allocator, CallBack callBack) {
            this(new ListVector(name, allocator, listVector.fieldType, callBack));
        }

        public TransferImpl(ListVector to) {
            this.to = to;
            to.addOrGetVector(ListVector.this.vector.getField().getFieldType());
            if (to.getDataVector() instanceof ZeroVector) {
                to.addOrGetVector(ListVector.this.vector.getField().getFieldType());
            }
            this.dataTransferPair = ListVector.this.getDataVector().makeTransferPair(to.getDataVector());
        }

        @Override
        public void transfer() {
            this.to.clear();
            this.dataTransferPair.transfer();
            this.to.validityBuffer = ListVector.this.validityBuffer.transferOwnership((BufferAllocator)((ListVector)this.to).allocator).buffer;
            this.to.offsetBuffer = ListVector.this.offsetBuffer.transferOwnership((BufferAllocator)((ListVector)this.to).allocator).buffer;
            this.to.lastSet = ListVector.this.lastSet;
            if (ListVector.this.valueCount > 0) {
                this.to.setValueCount(ListVector.this.valueCount);
            }
            ListVector.this.clear();
        }

        @Override
        public void splitAndTransfer(int startIndex, int length) {
            int startPoint = ListVector.this.offsetBuffer.getInt(startIndex * 4);
            int sliceLength = ListVector.this.offsetBuffer.getInt((startIndex + length) * 4) - startPoint;
            this.to.clear();
            this.to.allocateOffsetBuffer((length + 1) * 4);
            for (int i = 0; i < length + 1; ++i) {
                int relativeOffset = ListVector.this.offsetBuffer.getInt((startIndex + i) * 4) - startPoint;
                this.to.offsetBuffer.setInt(i * 4, relativeOffset);
            }
            this.splitAndTransferValidityBuffer(startIndex, length, this.to);
            this.dataTransferPair.splitAndTransfer(startPoint, sliceLength);
            this.to.lastSet = length;
            this.to.setValueCount(length);
        }

        private void splitAndTransferValidityBuffer(int startIndex, int length, ListVector target) {
            assert (startIndex + length <= ListVector.this.valueCount);
            int firstByteSource = BitVectorHelper.byteIndex(startIndex);
            int lastByteSource = BitVectorHelper.byteIndex(ListVector.this.valueCount - 1);
            int byteSizeTarget = ListVector.getValidityBufferSizeFromCount(length);
            int offset = startIndex % 8;
            if (length > 0) {
                if (offset == 0) {
                    if (target.validityBuffer != null) {
                        target.validityBuffer.release();
                    }
                    target.validityBuffer = ListVector.this.validityBuffer.slice(firstByteSource, byteSizeTarget);
                    target.validityBuffer.retain(1);
                } else {
                    byte b1;
                    target.allocateValidityBuffer(byteSizeTarget);
                    for (int i = 0; i < byteSizeTarget - 1; ++i) {
                        byte b12 = BitVectorHelper.getBitsFromCurrentByte(ListVector.this.validityBuffer, firstByteSource + i, offset);
                        byte b2 = BitVectorHelper.getBitsFromNextByte(ListVector.this.validityBuffer, firstByteSource + i + 1, offset);
                        target.validityBuffer.setByte(i, b12 + b2);
                    }
                    if (firstByteSource + byteSizeTarget - 1 < lastByteSource) {
                        b1 = BitVectorHelper.getBitsFromCurrentByte(ListVector.this.validityBuffer, firstByteSource + byteSizeTarget - 1, offset);
                        byte b2 = BitVectorHelper.getBitsFromNextByte(ListVector.this.validityBuffer, firstByteSource + byteSizeTarget, offset);
                        target.validityBuffer.setByte(byteSizeTarget - 1, b1 + b2);
                    } else {
                        b1 = BitVectorHelper.getBitsFromCurrentByte(ListVector.this.validityBuffer, firstByteSource + byteSizeTarget - 1, offset);
                        target.validityBuffer.setByte(byteSizeTarget - 1, b1);
                    }
                }
            }
        }

        @Override
        public ValueVector getTo() {
            return this.to;
        }

        @Override
        public void copyValueSafe(int from, int to) {
            this.to.copyFrom(from, to, ListVector.this);
        }
    }
}

