/*
 * Decompiled with CFR 0.152.
 */
package net.snowflake.client.jdbc.internal.apache.arrow.vector.complex;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Iterator;
import net.snowflake.client.jdbc.internal.apache.arrow.memory.BaseAllocator;
import net.snowflake.client.jdbc.internal.apache.arrow.memory.BufferAllocator;
import net.snowflake.client.jdbc.internal.apache.arrow.util.Preconditions;
import net.snowflake.client.jdbc.internal.apache.arrow.vector.AddOrGetResult;
import net.snowflake.client.jdbc.internal.apache.arrow.vector.BaseFixedWidthVector;
import net.snowflake.client.jdbc.internal.apache.arrow.vector.BaseValueVector;
import net.snowflake.client.jdbc.internal.apache.arrow.vector.BaseVariableWidthVector;
import net.snowflake.client.jdbc.internal.apache.arrow.vector.DensityAwareVector;
import net.snowflake.client.jdbc.internal.apache.arrow.vector.FieldVector;
import net.snowflake.client.jdbc.internal.apache.arrow.vector.UInt4Vector;
import net.snowflake.client.jdbc.internal.apache.arrow.vector.ValueVector;
import net.snowflake.client.jdbc.internal.apache.arrow.vector.ZeroVector;
import net.snowflake.client.jdbc.internal.apache.arrow.vector.complex.RepeatedValueVector;
import net.snowflake.client.jdbc.internal.apache.arrow.vector.types.pojo.ArrowType;
import net.snowflake.client.jdbc.internal.apache.arrow.vector.types.pojo.FieldType;
import net.snowflake.client.jdbc.internal.apache.arrow.vector.util.CallBack;
import net.snowflake.client.jdbc.internal.apache.arrow.vector.util.OversizedAllocationException;
import net.snowflake.client.jdbc.internal.apache.arrow.vector.util.SchemaChangeRuntimeException;
import net.snowflake.client.jdbc.internal.io.netty.buffer.ArrowBuf;

public abstract class BaseRepeatedValueVector
extends BaseValueVector
implements RepeatedValueVector {
    public static final FieldVector DEFAULT_DATA_VECTOR = ZeroVector.INSTANCE;
    public static final String DATA_VECTOR_NAME = "$data$";
    public static final byte OFFSET_WIDTH = 4;
    protected ArrowBuf offsetBuffer;
    protected FieldVector vector;
    protected final CallBack callBack;
    protected int valueCount;
    protected int offsetAllocationSizeInBytes = 15880;

    protected BaseRepeatedValueVector(String name, BufferAllocator allocator, CallBack callBack) {
        this(name, allocator, DEFAULT_DATA_VECTOR, callBack);
    }

    protected BaseRepeatedValueVector(String name, BufferAllocator allocator, FieldVector vector, CallBack callBack) {
        super(name, allocator);
        this.offsetBuffer = allocator.getEmpty();
        this.vector = Preconditions.checkNotNull(vector, "data vector cannot be null");
        this.callBack = callBack;
        this.valueCount = 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean allocateNewSafe() {
        boolean dataAlloc = false;
        try {
            this.allocateOffsetBuffer(this.offsetAllocationSizeInBytes);
            dataAlloc = this.vector.allocateNewSafe();
        }
        catch (Exception e) {
            e.printStackTrace();
            this.clear();
            boolean bl = false;
            return bl;
        }
        finally {
            if (!dataAlloc) {
                this.clear();
            }
        }
        return dataAlloc;
    }

    protected void allocateOffsetBuffer(long size) {
        int curSize = (int)size;
        this.offsetBuffer = this.allocator.buffer(curSize);
        this.offsetBuffer.readerIndex(0);
        this.offsetAllocationSizeInBytes = curSize;
        this.offsetBuffer.setZero(0, this.offsetBuffer.capacity());
    }

    @Override
    public void reAlloc() {
        this.reallocOffsetBuffer();
        this.vector.reAlloc();
    }

    protected void reallocOffsetBuffer() {
        long baseSize = this.offsetAllocationSizeInBytes;
        int currentBufferCapacity = this.offsetBuffer.capacity();
        if (baseSize < (long)currentBufferCapacity) {
            baseSize = currentBufferCapacity;
        }
        long newAllocationSize = baseSize * 2L;
        newAllocationSize = BaseAllocator.nextPowerOfTwo(newAllocationSize);
        assert (newAllocationSize >= 1L);
        if (newAllocationSize > (long)MAX_ALLOCATION_SIZE) {
            throw new OversizedAllocationException("Unable to expand the buffer");
        }
        ArrowBuf newBuf = this.allocator.buffer((int)newAllocationSize);
        newBuf.setBytes(0, this.offsetBuffer, 0, currentBufferCapacity);
        newBuf.setZero(currentBufferCapacity, newBuf.capacity() - currentBufferCapacity);
        this.offsetBuffer.release(1);
        this.offsetBuffer = newBuf;
        this.offsetAllocationSizeInBytes = (int)newAllocationSize;
    }

    @Override
    @Deprecated
    public UInt4Vector getOffsetVector() {
        throw new UnsupportedOperationException("There is no inner offset vector");
    }

    @Override
    public FieldVector getDataVector() {
        return this.vector;
    }

    @Override
    public void setInitialCapacity(int numRecords) {
        this.offsetAllocationSizeInBytes = (numRecords + 1) * 4;
        if (this.vector instanceof BaseFixedWidthVector || this.vector instanceof BaseVariableWidthVector) {
            this.vector.setInitialCapacity(numRecords * 5);
        } else {
            this.vector.setInitialCapacity(numRecords);
        }
    }

    @Override
    public void setInitialCapacity(int numRecords, double density) {
        if ((double)numRecords * density >= 2.147483647E9) {
            throw new OversizedAllocationException("Requested amount of memory is more than max allowed");
        }
        this.offsetAllocationSizeInBytes = (numRecords + 1) * 4;
        int innerValueCapacity = Math.max((int)((double)numRecords * density), 1);
        if (this.vector instanceof DensityAwareVector) {
            ((DensityAwareVector)((Object)this.vector)).setInitialCapacity(innerValueCapacity, density);
        } else {
            this.vector.setInitialCapacity(innerValueCapacity);
        }
    }

    @Override
    public int getValueCapacity() {
        int offsetValueCapacity = Math.max(this.getOffsetBufferValueCapacity() - 1, 0);
        if (this.vector == DEFAULT_DATA_VECTOR) {
            return offsetValueCapacity;
        }
        return Math.min(this.vector.getValueCapacity(), offsetValueCapacity);
    }

    protected int getOffsetBufferValueCapacity() {
        return (int)((double)this.offsetBuffer.capacity() * 1.0 / 4.0);
    }

    @Override
    public int getBufferSize() {
        if (this.getValueCount() == 0) {
            return 0;
        }
        return (this.valueCount + 1) * 4 + this.vector.getBufferSize();
    }

    @Override
    public int getBufferSizeFor(int valueCount) {
        if (valueCount == 0) {
            return 0;
        }
        return (valueCount + 1) * 4 + this.vector.getBufferSizeFor(valueCount);
    }

    @Override
    public Iterator<ValueVector> iterator() {
        return Collections.singleton(this.getDataVector()).iterator();
    }

    @Override
    public void clear() {
        this.offsetBuffer = this.releaseBuffer(this.offsetBuffer);
        this.vector.clear();
        this.valueCount = 0;
        super.clear();
    }

    @Override
    public void reset() {
        this.offsetBuffer.setZero(0, this.offsetBuffer.capacity());
        this.vector.reset();
        this.valueCount = 0;
    }

    @Override
    public ArrowBuf[] getBuffers(boolean clear) {
        ArrowBuf[] buffers;
        if (this.getBufferSize() == 0) {
            buffers = new ArrowBuf[]{};
        } else {
            ArrayList<ArrowBuf> list = new ArrayList<ArrowBuf>();
            list.add(this.offsetBuffer);
            list.addAll(Arrays.asList(this.vector.getBuffers(false)));
            buffers = list.toArray(new ArrowBuf[list.size()]);
        }
        if (clear) {
            for (ArrowBuf buffer : buffers) {
                buffer.retain();
            }
            this.clear();
        }
        return buffers;
    }

    public int size() {
        return this.vector == DEFAULT_DATA_VECTOR ? 0 : 1;
    }

    public <T extends ValueVector> AddOrGetResult<T> addOrGetVector(FieldType fieldType) {
        boolean created = false;
        if (this.vector instanceof ZeroVector) {
            this.vector = fieldType.createNewSingleVector(DATA_VECTOR_NAME, this.allocator, this.callBack);
            created = true;
            if (this.callBack != null && fieldType.getType().getTypeID() != ArrowType.ArrowTypeID.Null) {
                this.callBack.doWork();
            }
        }
        if (this.vector.getField().getType().getTypeID() != fieldType.getType().getTypeID()) {
            String msg = String.format("Inner vector type mismatch. Requested type: [%s], actual type: [%s]", new Object[]{fieldType.getType().getTypeID(), this.vector.getField().getType().getTypeID()});
            throw new SchemaChangeRuntimeException(msg);
        }
        return new AddOrGetResult<FieldVector>(this.vector, created);
    }

    protected void replaceDataVector(FieldVector v) {
        this.vector.clear();
        this.vector = v;
    }

    @Override
    public int getValueCount() {
        return this.valueCount;
    }

    public int getInnerValueCount() {
        return this.vector.getValueCount();
    }

    public int getInnerValueCountAt(int index) {
        return this.offsetBuffer.getInt((index + 1) * 4) - this.offsetBuffer.getInt(index * 4);
    }

    @Override
    public boolean isNull(int index) {
        return false;
    }

    public boolean isEmpty(int index) {
        return false;
    }

    public int startNewValue(int index) {
        while (index >= this.getOffsetBufferValueCapacity()) {
            this.reallocOffsetBuffer();
        }
        int offset = this.offsetBuffer.getInt(index * 4);
        this.offsetBuffer.setInt((index + 1) * 4, offset);
        this.setValueCount(index + 1);
        return offset;
    }

    @Override
    public void setValueCount(int valueCount) {
        this.valueCount = valueCount;
        while (valueCount > this.getOffsetBufferValueCapacity()) {
            this.reallocOffsetBuffer();
        }
        int childValueCount = valueCount == 0 ? 0 : this.offsetBuffer.getInt(valueCount * 4);
        this.vector.setValueCount(childValueCount);
    }
}

