/*
 * Decompiled with CFR 0.152.
 */
package net.snowflake.client.jdbc.internal.apache.arrow.vector;

import java.time.LocalDateTime;
import net.snowflake.client.jdbc.internal.apache.arrow.memory.BufferAllocator;
import net.snowflake.client.jdbc.internal.apache.arrow.vector.BitVectorHelper;
import net.snowflake.client.jdbc.internal.apache.arrow.vector.TimeStampVector;
import net.snowflake.client.jdbc.internal.apache.arrow.vector.ValueVector;
import net.snowflake.client.jdbc.internal.apache.arrow.vector.complex.impl.TimeStampMilliReaderImpl;
import net.snowflake.client.jdbc.internal.apache.arrow.vector.complex.reader.FieldReader;
import net.snowflake.client.jdbc.internal.apache.arrow.vector.holders.NullableTimeStampMilliHolder;
import net.snowflake.client.jdbc.internal.apache.arrow.vector.holders.TimeStampMilliHolder;
import net.snowflake.client.jdbc.internal.apache.arrow.vector.types.Types;
import net.snowflake.client.jdbc.internal.apache.arrow.vector.types.pojo.FieldType;
import net.snowflake.client.jdbc.internal.apache.arrow.vector.util.DateUtility;
import net.snowflake.client.jdbc.internal.apache.arrow.vector.util.TransferPair;

public class TimeStampMilliVector
extends TimeStampVector {
    private final FieldReader reader = new TimeStampMilliReaderImpl(this);

    public TimeStampMilliVector(String name, BufferAllocator allocator) {
        this(name, FieldType.nullable(Types.MinorType.TIMESTAMPMILLI.getType()), allocator);
    }

    public TimeStampMilliVector(String name, FieldType fieldType, BufferAllocator allocator) {
        super(name, fieldType, allocator);
    }

    @Override
    public FieldReader getReader() {
        return this.reader;
    }

    @Override
    public Types.MinorType getMinorType() {
        return Types.MinorType.TIMESTAMPMILLI;
    }

    public void get(int index, NullableTimeStampMilliHolder holder) {
        if (this.isSet(index) == 0) {
            holder.isSet = 0;
            return;
        }
        holder.isSet = 1;
        holder.value = this.valueBuffer.getLong(index * 8);
    }

    @Override
    public LocalDateTime getObject(int index) {
        if (this.isSet(index) == 0) {
            return null;
        }
        long millis = this.valueBuffer.getLong(index * 8);
        return DateUtility.getLocalDateTimeFromEpochMilli(millis);
    }

    public void set(int index, NullableTimeStampMilliHolder holder) throws IllegalArgumentException {
        if (holder.isSet < 0) {
            throw new IllegalArgumentException();
        }
        if (holder.isSet > 0) {
            BitVectorHelper.setValidityBitToOne(this.validityBuffer, index);
            this.setValue(index, holder.value);
        } else {
            BitVectorHelper.setValidityBit(this.validityBuffer, index, 0);
        }
    }

    public void set(int index, TimeStampMilliHolder holder) {
        BitVectorHelper.setValidityBitToOne(this.validityBuffer, index);
        this.setValue(index, holder.value);
    }

    public void setSafe(int index, NullableTimeStampMilliHolder holder) throws IllegalArgumentException {
        this.handleSafe(index);
        this.set(index, holder);
    }

    public void setSafe(int index, TimeStampMilliHolder holder) {
        this.handleSafe(index);
        this.set(index, holder);
    }

    @Override
    public TransferPair getTransferPair(String ref, BufferAllocator allocator) {
        TimeStampMilliVector to = new TimeStampMilliVector(ref, this.field.getFieldType(), allocator);
        return new TimeStampVector.TransferImpl(to);
    }

    @Override
    public TransferPair makeTransferPair(ValueVector to) {
        return new TimeStampVector.TransferImpl((TimeStampMilliVector)to);
    }
}

