/*
 * Decompiled with CFR 0.152.
 */
package net.snowflake.client.jdbc.internal.apache.arrow.vector;

import java.time.Duration;
import net.snowflake.client.jdbc.internal.apache.arrow.memory.BufferAllocator;
import net.snowflake.client.jdbc.internal.apache.arrow.vector.BaseFixedWidthVector;
import net.snowflake.client.jdbc.internal.apache.arrow.vector.BitVectorHelper;
import net.snowflake.client.jdbc.internal.apache.arrow.vector.ValueVector;
import net.snowflake.client.jdbc.internal.apache.arrow.vector.complex.impl.IntervalDayReaderImpl;
import net.snowflake.client.jdbc.internal.apache.arrow.vector.complex.reader.FieldReader;
import net.snowflake.client.jdbc.internal.apache.arrow.vector.holders.IntervalDayHolder;
import net.snowflake.client.jdbc.internal.apache.arrow.vector.holders.NullableIntervalDayHolder;
import net.snowflake.client.jdbc.internal.apache.arrow.vector.types.Types;
import net.snowflake.client.jdbc.internal.apache.arrow.vector.types.pojo.FieldType;
import net.snowflake.client.jdbc.internal.apache.arrow.vector.util.TransferPair;
import net.snowflake.client.jdbc.internal.io.netty.buffer.ArrowBuf;

public class IntervalDayVector
extends BaseFixedWidthVector {
    private static final byte TYPE_WIDTH = 8;
    private static final byte MILLISECOND_OFFSET = 4;
    private final FieldReader reader = new IntervalDayReaderImpl(this);

    public IntervalDayVector(String name, BufferAllocator allocator) {
        this(name, FieldType.nullable(Types.MinorType.INTERVALDAY.getType()), allocator);
    }

    public IntervalDayVector(String name, FieldType fieldType, BufferAllocator allocator) {
        super(name, allocator, fieldType, 8);
    }

    @Override
    public FieldReader getReader() {
        return this.reader;
    }

    @Override
    public Types.MinorType getMinorType() {
        return Types.MinorType.INTERVALDAY;
    }

    public ArrowBuf get(int index) throws IllegalStateException {
        if (this.isSet(index) == 0) {
            return null;
        }
        return this.valueBuffer.slice(index * 8, 8);
    }

    public void get(int index, NullableIntervalDayHolder holder) {
        if (this.isSet(index) == 0) {
            holder.isSet = 0;
            return;
        }
        int startIndex = index * 8;
        holder.isSet = 1;
        holder.days = this.valueBuffer.getInt(startIndex);
        holder.milliseconds = this.valueBuffer.getInt(startIndex + 4);
    }

    @Override
    public Duration getObject(int index) {
        if (this.isSet(index) == 0) {
            return null;
        }
        int startIndex = index * 8;
        int days = this.valueBuffer.getInt(startIndex);
        int milliseconds = this.valueBuffer.getInt(startIndex + 4);
        return Duration.ofDays(days).plusMillis(milliseconds);
    }

    public StringBuilder getAsStringBuilder(int index) {
        if (this.isSet(index) == 0) {
            return null;
        }
        return this.getAsStringBuilderHelper(index);
    }

    private StringBuilder getAsStringBuilderHelper(int index) {
        int startIndex = index * 8;
        int days = this.valueBuffer.getInt(startIndex);
        int millis = this.valueBuffer.getInt(startIndex + 4);
        int hours = millis / 3600000;
        int minutes = (millis %= 3600000) / 60000;
        int seconds = (millis %= 60000) / 1000;
        String dayString = Math.abs(days) == 1 ? " day " : " days ";
        return new StringBuilder().append(days).append(dayString).append(hours).append(":").append(minutes).append(":").append(seconds).append(".").append(millis %= 1000);
    }

    public void copyFrom(int fromIndex, int thisIndex, IntervalDayVector from) {
        BitVectorHelper.setValidityBit(this.validityBuffer, thisIndex, from.isSet(fromIndex));
        from.valueBuffer.getBytes(fromIndex * 8, this.valueBuffer, thisIndex * 8, 8);
    }

    public void copyFromSafe(int fromIndex, int thisIndex, IntervalDayVector from) {
        this.handleSafe(thisIndex);
        this.copyFrom(fromIndex, thisIndex, from);
    }

    public void set(int index, ArrowBuf value) {
        BitVectorHelper.setValidityBitToOne(this.validityBuffer, index);
        this.valueBuffer.setBytes(index * 8, value, 0, 8);
    }

    public void set(int index, int days, int milliseconds) {
        int offsetIndex = index * 8;
        BitVectorHelper.setValidityBitToOne(this.validityBuffer, index);
        this.valueBuffer.setInt(offsetIndex, days);
        this.valueBuffer.setInt(offsetIndex + 4, milliseconds);
    }

    public void set(int index, NullableIntervalDayHolder holder) throws IllegalArgumentException {
        if (holder.isSet < 0) {
            throw new IllegalArgumentException();
        }
        if (holder.isSet > 0) {
            this.set(index, holder.days, holder.milliseconds);
        } else {
            BitVectorHelper.setValidityBit(this.validityBuffer, index, 0);
        }
    }

    public void set(int index, IntervalDayHolder holder) {
        this.set(index, holder.days, holder.milliseconds);
    }

    public void setSafe(int index, ArrowBuf value) {
        this.handleSafe(index);
        this.set(index, value);
    }

    public void setSafe(int index, int days, int milliseconds) {
        this.handleSafe(index);
        this.set(index, days, milliseconds);
    }

    public void setSafe(int index, NullableIntervalDayHolder holder) throws IllegalArgumentException {
        this.handleSafe(index);
        this.set(index, holder);
    }

    public void setSafe(int index, IntervalDayHolder holder) {
        this.handleSafe(index);
        this.set(index, holder);
    }

    public void setNull(int index) {
        this.handleSafe(index);
        BitVectorHelper.setValidityBit(this.validityBuffer, index, 0);
    }

    public void set(int index, int isSet, int days, int milliseconds) {
        if (isSet > 0) {
            this.set(index, days, milliseconds);
        } else {
            BitVectorHelper.setValidityBit(this.validityBuffer, index, 0);
        }
    }

    public void setSafe(int index, int isSet, int days, int milliseconds) {
        this.handleSafe(index);
        this.set(index, isSet, days, milliseconds);
    }

    @Override
    public TransferPair getTransferPair(String ref, BufferAllocator allocator) {
        return new TransferImpl(ref, allocator);
    }

    @Override
    public TransferPair makeTransferPair(ValueVector to) {
        return new TransferImpl((IntervalDayVector)to);
    }

    private class TransferImpl
    implements TransferPair {
        IntervalDayVector to;

        public TransferImpl(String ref, BufferAllocator allocator) {
            this.to = new IntervalDayVector(ref, IntervalDayVector.this.field.getFieldType(), allocator);
        }

        public TransferImpl(IntervalDayVector to) {
            this.to = to;
        }

        @Override
        public IntervalDayVector getTo() {
            return this.to;
        }

        @Override
        public void transfer() {
            IntervalDayVector.this.transferTo(this.to);
        }

        @Override
        public void splitAndTransfer(int startIndex, int length) {
            IntervalDayVector.this.splitAndTransferTo(startIndex, length, this.to);
        }

        @Override
        public void copyValueSafe(int fromIndex, int toIndex) {
            this.to.copyFromSafe(fromIndex, toIndex, IntervalDayVector.this);
        }
    }
}

