/*
 * Decompiled with CFR 0.152.
 */
package net.snowflake.client.jdbc.internal.apache.arrow.vector;

import net.snowflake.client.jdbc.internal.apache.arrow.memory.BufferAllocator;
import net.snowflake.client.jdbc.internal.apache.arrow.vector.BaseFixedWidthVector;
import net.snowflake.client.jdbc.internal.apache.arrow.vector.BitVectorHelper;
import net.snowflake.client.jdbc.internal.apache.arrow.vector.ValueVector;
import net.snowflake.client.jdbc.internal.apache.arrow.vector.complex.impl.FixedSizeBinaryReaderImpl;
import net.snowflake.client.jdbc.internal.apache.arrow.vector.complex.reader.FieldReader;
import net.snowflake.client.jdbc.internal.apache.arrow.vector.holders.FixedSizeBinaryHolder;
import net.snowflake.client.jdbc.internal.apache.arrow.vector.holders.NullableFixedSizeBinaryHolder;
import net.snowflake.client.jdbc.internal.apache.arrow.vector.types.Types;
import net.snowflake.client.jdbc.internal.apache.arrow.vector.types.pojo.ArrowType;
import net.snowflake.client.jdbc.internal.apache.arrow.vector.types.pojo.FieldType;
import net.snowflake.client.jdbc.internal.apache.arrow.vector.util.TransferPair;
import net.snowflake.client.jdbc.internal.io.netty.buffer.ArrowBuf;

public class FixedSizeBinaryVector
extends BaseFixedWidthVector {
    private final int byteWidth;
    private final FieldReader reader = new FixedSizeBinaryReaderImpl(this);

    public FixedSizeBinaryVector(String name, BufferAllocator allocator, int byteWidth) {
        this(name, FieldType.nullable(new ArrowType.FixedSizeBinary(byteWidth)), allocator);
    }

    public FixedSizeBinaryVector(String name, FieldType fieldType, BufferAllocator allocator) {
        super(name, allocator, fieldType, ((ArrowType.FixedSizeBinary)fieldType.getType()).getByteWidth());
        this.byteWidth = ((ArrowType.FixedSizeBinary)fieldType.getType()).getByteWidth();
    }

    @Override
    public FieldReader getReader() {
        return this.reader;
    }

    @Override
    public Types.MinorType getMinorType() {
        return Types.MinorType.FIXEDSIZEBINARY;
    }

    public byte[] get(int index) {
        assert (index >= 0);
        if (this.isSet(index) == 0) {
            throw new IllegalStateException("Value at index is null");
        }
        byte[] dst = new byte[this.byteWidth];
        this.valueBuffer.getBytes(index * this.byteWidth, dst, 0, this.byteWidth);
        return dst;
    }

    public void get(int index, NullableFixedSizeBinaryHolder holder) {
        assert (index >= 0);
        if (this.isSet(index) == 0) {
            holder.isSet = 0;
            return;
        }
        holder.isSet = 1;
        holder.buffer = this.valueBuffer.slice(index * this.byteWidth, this.byteWidth);
    }

    public byte[] getObject(int index) {
        assert (index >= 0);
        if (this.isSet(index) == 0) {
            return null;
        }
        byte[] dst = new byte[this.byteWidth];
        this.valueBuffer.getBytes(index * this.byteWidth, dst, 0, this.byteWidth);
        return dst;
    }

    public void copyFrom(int fromIndex, int thisIndex, FixedSizeBinaryVector from) {
        BitVectorHelper.setValidityBit(this.validityBuffer, thisIndex, from.isSet(fromIndex));
        from.valueBuffer.getBytes(fromIndex * this.byteWidth, this.valueBuffer, thisIndex * this.byteWidth, this.byteWidth);
    }

    public void copyFromSafe(int fromIndex, int thisIndex, FixedSizeBinaryVector from) {
        this.handleSafe(thisIndex);
        this.copyFrom(fromIndex, thisIndex, from);
    }

    public int getByteWidth() {
        return this.byteWidth;
    }

    public void set(int index, byte[] value) {
        assert (index >= 0);
        assert (this.byteWidth <= value.length);
        BitVectorHelper.setValidityBitToOne(this.validityBuffer, index);
        this.valueBuffer.setBytes(index * this.byteWidth, value, 0, this.byteWidth);
    }

    public void setSafe(int index, byte[] value) {
        this.handleSafe(index);
        this.set(index, value);
    }

    public void set(int index, int isSet, byte[] value) {
        if (isSet > 0) {
            this.set(index, value);
        } else {
            BitVectorHelper.setValidityBit(this.validityBuffer, index, 0);
        }
    }

    public void setSafe(int index, int isSet, byte[] value) {
        this.handleSafe(index);
        this.set(index, isSet, value);
    }

    public void set(int index, ArrowBuf buffer) {
        assert (index >= 0);
        assert (this.byteWidth <= buffer.capacity());
        BitVectorHelper.setValidityBitToOne(this.validityBuffer, index);
        this.valueBuffer.setBytes(index * this.byteWidth, buffer, 0, this.byteWidth);
    }

    public void setSafe(int index, ArrowBuf buffer) {
        this.handleSafe(index);
        this.set(index, buffer);
    }

    public void set(int index, int isSet, ArrowBuf buffer) {
        if (isSet > 0) {
            this.set(index, buffer);
        } else {
            BitVectorHelper.setValidityBit(this.validityBuffer, index, 0);
        }
    }

    public void setSafe(int index, int isSet, ArrowBuf buffer) {
        this.handleSafe(index);
        this.set(index, isSet, buffer);
    }

    public void set(int index, FixedSizeBinaryHolder holder) {
        assert (holder.byteWidth == this.byteWidth);
        this.set(index, holder.buffer);
    }

    public void setSafe(int index, FixedSizeBinaryHolder holder) {
        this.handleSafe(index);
        this.set(index, holder);
    }

    public void set(int index, NullableFixedSizeBinaryHolder holder) {
        assert (holder.byteWidth == this.byteWidth);
        if (holder.isSet < 0) {
            throw new IllegalArgumentException("holder has a negative isSet value");
        }
        if (holder.isSet > 0) {
            this.set(index, holder.buffer);
        } else {
            BitVectorHelper.setValidityBit(this.validityBuffer, index, 0);
        }
    }

    public void setSafe(int index, NullableFixedSizeBinaryHolder holder) {
        this.handleSafe(index);
        this.set(index, holder);
    }

    public void setNull(int index) {
        this.handleSafe(index);
        BitVectorHelper.setValidityBit(this.validityBuffer, index, 0);
    }

    public static byte[] get(ArrowBuf buffer, int index, int byteWidth) {
        byte[] dst = new byte[byteWidth];
        buffer.getBytes(index * byteWidth, dst, 0, byteWidth);
        return dst;
    }

    @Override
    public TransferPair getTransferPair(String ref, BufferAllocator allocator) {
        return new TransferImpl(ref, allocator);
    }

    @Override
    public TransferPair makeTransferPair(ValueVector to) {
        return new TransferImpl((FixedSizeBinaryVector)to);
    }

    private class TransferImpl
    implements TransferPair {
        FixedSizeBinaryVector to;

        public TransferImpl(String ref, BufferAllocator allocator) {
            this.to = new FixedSizeBinaryVector(ref, allocator, FixedSizeBinaryVector.this.byteWidth);
        }

        public TransferImpl(FixedSizeBinaryVector to) {
            this.to = to;
        }

        @Override
        public FixedSizeBinaryVector getTo() {
            return this.to;
        }

        @Override
        public void transfer() {
            FixedSizeBinaryVector.this.transferTo(this.to);
        }

        @Override
        public void splitAndTransfer(int startIndex, int length) {
            FixedSizeBinaryVector.this.splitAndTransferTo(startIndex, length, this.to);
        }

        @Override
        public void copyValueSafe(int fromIndex, int toIndex) {
            this.to.copyFromSafe(fromIndex, toIndex, FixedSizeBinaryVector.this);
        }
    }
}

