/*
 * Decompiled with CFR 0.152.
 */
package net.snowflake.client.jdbc.internal.apache.arrow.vector;

import java.util.Collections;
import java.util.Iterator;
import net.snowflake.client.jdbc.internal.apache.arrow.memory.BaseAllocator;
import net.snowflake.client.jdbc.internal.apache.arrow.memory.BufferAllocator;
import net.snowflake.client.jdbc.internal.apache.arrow.util.Preconditions;
import net.snowflake.client.jdbc.internal.apache.arrow.vector.ValueVector;
import net.snowflake.client.jdbc.internal.apache.arrow.vector.util.TransferPair;
import net.snowflake.client.jdbc.internal.io.netty.buffer.ArrowBuf;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class BaseValueVector
implements ValueVector {
    private static final Logger logger = LoggerFactory.getLogger(BaseValueVector.class);
    public static final String MAX_ALLOCATION_SIZE_PROPERTY = "arrow.vector.max_allocation_bytes";
    public static final int MAX_ALLOCATION_SIZE = Integer.getInteger("arrow.vector.max_allocation_bytes", Integer.MAX_VALUE);
    public static final int INITIAL_VALUE_ALLOCATION = 3970;
    protected final BufferAllocator allocator;
    protected final String name;

    protected BaseValueVector(String name, BufferAllocator allocator) {
        this.allocator = Preconditions.checkNotNull(allocator, "allocator cannot be null");
        this.name = name;
    }

    public String toString() {
        return super.toString() + "[name = " + this.name + ", ...]";
    }

    @Override
    public void clear() {
    }

    @Override
    public void close() {
        this.clear();
    }

    @Override
    public TransferPair getTransferPair(BufferAllocator allocator) {
        return this.getTransferPair(this.name, allocator);
    }

    @Override
    public Iterator<ValueVector> iterator() {
        return Collections.emptyIterator();
    }

    public static boolean checkBufRefs(ValueVector vv) {
        for (ArrowBuf buffer : vv.getBuffers(false)) {
            if (buffer.refCnt() > 0) continue;
            throw new IllegalStateException("zero refcount");
        }
        return true;
    }

    @Override
    public BufferAllocator getAllocator() {
        return this.allocator;
    }

    protected void compareTypes(BaseValueVector target, String caller) {
        if (this.getMinorType() != target.getMinorType()) {
            throw new UnsupportedOperationException(caller + " should have vectors of exact same type");
        }
    }

    protected ArrowBuf releaseBuffer(ArrowBuf buffer) {
        buffer.release();
        buffer = this.allocator.getEmpty();
        return buffer;
    }

    protected static int getValidityBufferSizeFromCount(int valueCount) {
        return (int)Math.ceil((double)valueCount / 8.0);
    }

    private static long roundUp8(long size) {
        return (size + 7L) / 8L * 8L;
    }

    protected long computeCombinedBufferSize(int valueCount, int typeWidth) {
        Preconditions.checkArgument(valueCount >= 0, "valueCount must be >= 0");
        Preconditions.checkArgument(typeWidth >= 0, "typeWidth must be >= 0");
        long bufferSize = BaseValueVector.roundUp8(BaseValueVector.getValidityBufferSizeFromCount(valueCount));
        bufferSize = typeWidth == 0 ? (bufferSize *= 2L) : (bufferSize += BaseValueVector.roundUp8(valueCount * typeWidth));
        return BaseAllocator.nextPowerOfTwo(bufferSize);
    }

    protected DataAndValidityBuffers allocFixedDataAndValidityBufs(int valueCount, int typeWidth) {
        int validityBufferSize;
        int dataBufferSize;
        long bufferSize = this.computeCombinedBufferSize(valueCount, typeWidth);
        assert (bufferSize < (long)MAX_ALLOCATION_SIZE);
        if (typeWidth == 0) {
            validityBufferSize = dataBufferSize = (int)(bufferSize / 2L);
        } else {
            int actualCount = (int)((double)bufferSize * 8.0 / (double)(8 * typeWidth + 1));
            while ((long)((validityBufferSize = (int)BaseValueVector.roundUp8(BaseValueVector.getValidityBufferSizeFromCount(actualCount))) + (dataBufferSize = (int)BaseValueVector.roundUp8(actualCount * typeWidth))) > bufferSize) {
                --actualCount;
            }
        }
        ArrowBuf combinedBuffer = this.allocator.buffer((int)bufferSize);
        ArrowBuf dataBuf = null;
        ArrowBuf validityBuf = null;
        int bufferOffset = 0;
        for (int numBuffers = 0; numBuffers < 2; ++numBuffers) {
            int len = numBuffers == 0 ? dataBufferSize : validityBufferSize;
            ArrowBuf buf = combinedBuffer.slice(bufferOffset, len);
            buf.retain();
            buf.readerIndex(0);
            buf.writerIndex(0);
            bufferOffset += len;
            if (numBuffers == 0) {
                dataBuf = buf;
                continue;
            }
            validityBuf = buf;
        }
        combinedBuffer.release();
        return new DataAndValidityBuffers(dataBuf, validityBuf);
    }

    class DataAndValidityBuffers {
        private ArrowBuf dataBuf;
        private ArrowBuf validityBuf;

        DataAndValidityBuffers(ArrowBuf dataBuf, ArrowBuf validityBuf) {
            this.dataBuf = dataBuf;
            this.validityBuf = validityBuf;
        }

        public ArrowBuf getDataBuf() {
            return this.dataBuf;
        }

        public ArrowBuf getValidityBuf() {
            return this.validityBuf;
        }
    }
}

