/*
 * Decompiled with CFR 0.152.
 */
package net.snowflake.client.jdbc;

import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import net.snowflake.client.core.DataConversionContext;
import net.snowflake.client.core.arrow.ArrowVectorConverter;
import net.snowflake.client.core.arrow.BigIntToFixedConverter;
import net.snowflake.client.core.arrow.BigIntToTimeConverter;
import net.snowflake.client.core.arrow.DoubleToRealConverter;
import net.snowflake.client.core.arrow.IntToDateConverter;
import net.snowflake.client.core.arrow.IntToFixedConverter;
import net.snowflake.client.core.arrow.SmallIntToFixedConverter;
import net.snowflake.client.core.arrow.TinyIntToBooleanConverter;
import net.snowflake.client.core.arrow.TinyIntToFixedConverter;
import net.snowflake.client.core.arrow.VarBinaryToBinaryConverter;
import net.snowflake.client.core.arrow.VarCharToTextConverter;
import net.snowflake.client.jdbc.SnowflakeResultChunk;
import net.snowflake.client.jdbc.SnowflakeType;
import net.snowflake.client.jdbc.internal.apache.arrow.memory.BufferAllocator;
import net.snowflake.client.jdbc.internal.apache.arrow.memory.RootAllocator;
import net.snowflake.client.jdbc.internal.apache.arrow.vector.FieldVector;
import net.snowflake.client.jdbc.internal.apache.arrow.vector.ValueVector;
import net.snowflake.client.jdbc.internal.apache.arrow.vector.VectorSchemaRoot;
import net.snowflake.client.jdbc.internal.apache.arrow.vector.ipc.ArrowStreamReader;
import net.snowflake.client.jdbc.internal.apache.arrow.vector.types.Types;
import net.snowflake.client.jdbc.internal.apache.arrow.vector.util.TransferPair;

public class ArrowResultChunk
extends SnowflakeResultChunk {
    private List<List<ValueVector>> batchOfVectors = new ArrayList<List<ValueVector>>();
    private static RootAllocator rootAllocator = new RootAllocator(Integer.MAX_VALUE);

    public ArrowResultChunk(String url, int rowCount, int colCount, int uncompressedSize) {
        super(url, rowCount, colCount, uncompressedSize);
    }

    private void addBatchData(List<ValueVector> batch) {
        this.batchOfVectors.add(batch);
    }

    public static void readArrowStream(InputStream is, ArrowResultChunk resultChunk) throws IOException {
        try (ArrowStreamReader reader = new ArrowStreamReader(is, (BufferAllocator)rootAllocator);){
            while (reader.loadNextBatch()) {
                ArrayList<ValueVector> valueVectors = new ArrayList<ValueVector>();
                VectorSchemaRoot root = reader.getVectorSchemaRoot();
                for (FieldVector f : root.getFieldVectors()) {
                    TransferPair t = f.getTransferPair(rootAllocator);
                    t.transfer();
                    valueVectors.add(t.getTo());
                }
                resultChunk.addBatchData(valueVectors);
            }
        }
    }

    @Override
    public long computeNeededChunkMemory() {
        return this.getUncompressedSize();
    }

    @Override
    public void freeData() {
        this.batchOfVectors.forEach(list -> list.forEach(ValueVector::clear));
    }

    private static List<ArrowVectorConverter> initConverters(List<ValueVector> vectors, DataConversionContext context) {
        ArrayList<ArrowVectorConverter> converters = new ArrayList<ArrowVectorConverter>();
        block20: for (int i = 0; i < vectors.size(); ++i) {
            ValueVector vector = vectors.get(i);
            Types.MinorType type = Types.getMinorTypeForArrowType(vector.getField().getType());
            Map<String, String> customMeta = vector.getField().getMetadata();
            SnowflakeType st = SnowflakeType.valueOf(customMeta.get("logicalType"));
            switch (st) {
                case ANY: {
                    continue block20;
                }
                case ARRAY: {
                    continue block20;
                }
                case CHAR: 
                case TEXT: {
                    converters.add(new VarCharToTextConverter(vector, context));
                    continue block20;
                }
                case BINARY: {
                    converters.add(new VarBinaryToBinaryConverter(vector, context));
                    continue block20;
                }
                case BOOLEAN: {
                    converters.add(new TinyIntToBooleanConverter(vector, context));
                    continue block20;
                }
                case DATE: {
                    converters.add(new IntToDateConverter(vector, context));
                    continue block20;
                }
                case FIXED: {
                    switch (type) {
                        case TINYINT: {
                            converters.add(new TinyIntToFixedConverter(vector, context));
                            break;
                        }
                        case SMALLINT: {
                            converters.add(new SmallIntToFixedConverter(vector, context));
                            break;
                        }
                        case INT: {
                            converters.add(new IntToFixedConverter(vector, context));
                            break;
                        }
                        case BIGINT: {
                            converters.add(new BigIntToFixedConverter(vector, context));
                        }
                    }
                    continue block20;
                }
                case INTEGER: {
                    continue block20;
                }
                case OBJECT: {
                    continue block20;
                }
                case REAL: {
                    converters.add(new DoubleToRealConverter(vector, context));
                    continue block20;
                }
                case TIME: {
                    converters.add(new BigIntToTimeConverter(vector, context));
                    continue block20;
                }
                case TIMESTAMP: 
                case TIMESTAMP_LTZ: 
                case TIMESTAMP_NTZ: 
                case TIMESTAMP_TZ: {
                    continue block20;
                }
            }
        }
        return converters;
    }

    public ArrowChunkIterator getIterator(DataConversionContext dataConversionContext) {
        return new ArrowChunkIterator(this, dataConversionContext);
    }

    public static ArrowChunkIterator getEmptyChunkIterator() {
        return new ArrowChunkIterator(new EmptyArrowResultChunk());
    }

    private static class EmptyArrowResultChunk
    extends ArrowResultChunk {
        EmptyArrowResultChunk() {
            super("", 0, 0, 0);
        }

        @Override
        public final long computeNeededChunkMemory() {
            return 0L;
        }

        @Override
        public final void freeData() {
        }
    }

    public static class ArrowChunkIterator {
        private ArrowResultChunk resultChunk;
        private int currentRecordBatchIndex;
        private int totalRecordBatch;
        private int currentRowInRecordBatch;
        private int rowCountInCurrentRecordBatch;
        private List<ArrowVectorConverter> currentConverters;
        private DataConversionContext dataConversionContext;

        ArrowChunkIterator(ArrowResultChunk resultChunk, DataConversionContext dataConversionContext) {
            this.resultChunk = resultChunk;
            this.currentRecordBatchIndex = -1;
            this.totalRecordBatch = resultChunk.batchOfVectors.size();
            this.currentRowInRecordBatch = -1;
            this.rowCountInCurrentRecordBatch = 0;
            this.dataConversionContext = dataConversionContext;
        }

        ArrowChunkIterator(EmptyArrowResultChunk emptyArrowResultChunk) {
            this.resultChunk = emptyArrowResultChunk;
            this.currentRecordBatchIndex = 0;
            this.totalRecordBatch = 0;
            this.currentRowInRecordBatch = -1;
            this.rowCountInCurrentRecordBatch = 0;
            this.currentConverters = Collections.emptyList();
        }

        public boolean next() {
            ++this.currentRowInRecordBatch;
            if (this.currentRowInRecordBatch < this.rowCountInCurrentRecordBatch) {
                return true;
            }
            ++this.currentRecordBatchIndex;
            if (this.currentRecordBatchIndex < this.totalRecordBatch) {
                this.currentRowInRecordBatch = 0;
                this.rowCountInCurrentRecordBatch = ((ValueVector)((List)this.resultChunk.batchOfVectors.get(this.currentRecordBatchIndex)).get(0)).getValueCount();
                this.currentConverters = ArrowResultChunk.initConverters((List)this.resultChunk.batchOfVectors.get(this.currentRecordBatchIndex), this.dataConversionContext);
                return true;
            }
            return false;
        }

        public boolean isLast() {
            return this.currentRecordBatchIndex + 1 == this.totalRecordBatch && this.currentRowInRecordBatch + 1 == this.rowCountInCurrentRecordBatch;
        }

        public boolean isAfterLast() {
            return this.currentRecordBatchIndex >= this.totalRecordBatch && this.currentRowInRecordBatch >= this.rowCountInCurrentRecordBatch;
        }

        public ArrowResultChunk getChunk() {
            return this.resultChunk;
        }

        public ArrowVectorConverter getCurrentConverter(int columnIndex) {
            return this.currentConverters.get(columnIndex);
        }

        public int getCurrentRowInRecordBatch() {
            return this.currentRowInRecordBatch;
        }
    }
}

