/*
 * Decompiled with CFR 0.152.
 */
package net.snowflake.client.core.arrow;

import java.math.BigDecimal;
import net.snowflake.client.core.DataConversionContext;
import net.snowflake.client.core.SFException;
import net.snowflake.client.core.arrow.AbstractArrowVectorConverter;
import net.snowflake.client.jdbc.ErrorCode;
import net.snowflake.client.jdbc.SnowflakeType;
import net.snowflake.client.jdbc.internal.apache.arrow.vector.IntVector;
import net.snowflake.client.jdbc.internal.apache.arrow.vector.ValueVector;

public class IntToFixedConverter
extends AbstractArrowVectorConverter {
    private IntVector intVector;
    private Integer sfScale;

    public IntToFixedConverter(ValueVector fieldVector, DataConversionContext context) {
        super(String.format("%s(%s,%s)", new Object[]{SnowflakeType.FIXED, fieldVector.getField().getMetadata().get("precision"), fieldVector.getField().getMetadata().get("scale")}), fieldVector, context);
        this.intVector = (IntVector)fieldVector;
        String scaleStr = fieldVector.getField().getMetadata().get("scale");
        this.sfScale = Integer.parseInt(scaleStr);
    }

    @Override
    public byte toByte(int index) throws SFException {
        int intVal = this.toInt(index);
        byte byteVal = (byte)intVal;
        if (byteVal == intVal) {
            return byteVal;
        }
        throw new SFException(ErrorCode.INVALID_VALUE_CONVERT, this.logicalTypeStr, "byte", intVal);
    }

    @Override
    public short toShort(int index) throws SFException {
        int intVal = this.toInt(index);
        short shortVal = (short)intVal;
        if (shortVal == intVal) {
            return shortVal;
        }
        throw new SFException(ErrorCode.INVALID_VALUE_CONVERT, this.logicalTypeStr, "byte", intVal);
    }

    @Override
    public int toInt(int index) throws SFException {
        if (this.intVector.isNull(index)) {
            return 0;
        }
        if (this.sfScale != 0) {
            int val = this.intVector.getDataBuffer().getInt(index * 4);
            throw new SFException(ErrorCode.INVALID_VALUE_CONVERT, this.logicalTypeStr, "int", val);
        }
        return this.intVector.getDataBuffer().getInt(index * 4);
    }

    @Override
    public long toLong(int index) throws SFException {
        return this.toInt(index);
    }

    @Override
    public BigDecimal toBigDecimal(int index) {
        if (this.intVector.isNull(index)) {
            return null;
        }
        int val = this.intVector.getDataBuffer().getInt(index * 4);
        return BigDecimal.valueOf(val, this.sfScale);
    }

    @Override
    public Object toObject(int index) throws SFException {
        return this.isNull(index) ? null : (this.sfScale == 0 ? Integer.valueOf(this.toInt(index)) : this.toBigDecimal(index));
    }

    @Override
    public String toString(int index) {
        return this.isNull(index) ? null : this.toBigDecimal(index).toString();
    }
}

