/*
 * Decompiled with CFR 0.152.
 */
package net.snowflake.client.core;

import java.math.BigDecimal;
import java.math.RoundingMode;
import java.sql.Date;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.TimeZone;
import net.snowflake.client.core.IncidentUtil;
import net.snowflake.client.core.ResultUtil;
import net.snowflake.client.core.SFBaseResultSet;
import net.snowflake.client.core.SFException;
import net.snowflake.client.jdbc.ErrorCode;
import net.snowflake.client.jdbc.internal.snowflake.common.core.SFBinary;
import net.snowflake.client.jdbc.internal.snowflake.common.core.SFBinaryFormat;
import net.snowflake.client.jdbc.internal.snowflake.common.core.SFTime;
import net.snowflake.client.jdbc.internal.snowflake.common.core.SFTimestamp;
import net.snowflake.client.log.SFLogger;
import net.snowflake.client.log.SFLoggerFactory;

public abstract class SFJsonResultSet
extends SFBaseResultSet {
    private static final SFLogger logger = SFLoggerFactory.getLogger(SFJsonResultSet.class);
    private static TimeZone timeZoneUTC = TimeZone.getTimeZone("UTC");
    TimeZone timeZone;

    protected abstract Object getObjectInternal(int var1) throws SFException;

    @Override
    public Object getObject(int columnIndex) throws SFException {
        logger.debug("public Object getObject(int columnIndex)");
        int type = this.resultSetMetaData.getColumnType(columnIndex);
        Object obj = this.getObjectInternal(columnIndex);
        if (obj == null) {
            return null;
        }
        switch (type) {
            case 1: 
            case 12: {
                return this.getString(columnIndex);
            }
            case -2: {
                return this.getBytes(columnIndex);
            }
            case 4: {
                return this.getInt(columnIndex);
            }
            case 3: {
                return this.getBigDecimal(columnIndex);
            }
            case -5: {
                return this.getLong(columnIndex);
            }
            case 8: {
                return this.getDouble(columnIndex);
            }
            case 93: {
                return this.getTimestamp(columnIndex);
            }
            case 91: {
                return this.getDate(columnIndex);
            }
            case 92: {
                return this.getTime(columnIndex);
            }
            case 16: {
                return this.getBoolean(columnIndex);
            }
        }
        throw (SFException)IncidentUtil.generateIncidentV2WithException(this.session, new SFException(ErrorCode.FEATURE_UNSUPPORTED, "data type: " + type), null, null);
    }

    @Override
    public String getString(int columnIndex) throws SFException {
        logger.debug("public String getString(int columnIndex)");
        Object obj = this.getObjectInternal(columnIndex);
        if (obj == null) {
            return null;
        }
        int columnType = this.resultSetMetaData.getInternalColumnType(columnIndex);
        switch (columnType) {
            case 16: {
                return ResultUtil.getBooleanAsString(ResultUtil.getBoolean(obj.toString()));
            }
            case 93: 
            case 50000: 
            case 50001: {
                SFTimestamp sfTS = this.getSFTimestamp(columnIndex);
                int columnScale = this.resultSetMetaData.getScale(columnIndex);
                String timestampStr = ResultUtil.getSFTimestampAsString(sfTS, columnType, columnScale, this.timestampNTZFormatter, this.timestampLTZFormatter, this.timestampTZFormatter, this.session);
                Object[] objectArray = new Object[2];
                objectArray[0] = obj::toString;
                objectArray[1] = timestampStr;
                logger.debug("Converting timestamp to string from: {} to: {}", objectArray);
                return timestampStr;
            }
            case 91: {
                Date date = this.getDate(columnIndex, timeZoneUTC);
                if (this.dateFormatter == null) {
                    throw (SFException)IncidentUtil.generateIncidentV2WithException(this.session, new SFException(ErrorCode.INTERNAL_ERROR, "missing date formatter"), null, null);
                }
                String dateStr = ResultUtil.getDateAsString(date, this.dateFormatter);
                Object[] objectArray = new Object[2];
                objectArray[0] = obj::toString;
                objectArray[1] = dateStr;
                logger.debug("Converting date to string from: {} to: {}", objectArray);
                return dateStr;
            }
            case 92: {
                SFTime sfTime = this.getSFTime(columnIndex);
                if (this.timeFormatter == null) {
                    throw (SFException)IncidentUtil.generateIncidentV2WithException(this.session, new SFException(ErrorCode.INTERNAL_ERROR, "missing time formatter"), null, null);
                }
                int scale = this.resultSetMetaData.getScale(columnIndex);
                String timeStr = ResultUtil.getSFTimeAsString(sfTime, scale, this.timeFormatter);
                Object[] objectArray = new Object[2];
                objectArray[0] = obj::toString;
                objectArray[1] = timeStr;
                logger.debug("Converting time to string from: {} to: {}", objectArray);
                return timeStr;
            }
            case -2: {
                if (this.binaryFormatter == null) {
                    throw (SFException)IncidentUtil.generateIncidentV2WithException(this.session, new SFException(ErrorCode.INTERNAL_ERROR, "missing binary formatter"), null, null);
                }
                if (this.binaryFormatter == SFBinaryFormat.HEX) {
                    return obj.toString();
                }
                SFBinary sfb = new SFBinary(this.getBytes(columnIndex));
                return this.binaryFormatter.format(sfb);
            }
        }
        return obj.toString();
    }

    @Override
    public boolean getBoolean(int columnIndex) throws SFException {
        logger.debug("public boolean getBoolean(int columnIndex)");
        Object obj = this.getObjectInternal(columnIndex);
        if (obj == null) {
            return false;
        }
        if (obj instanceof Boolean) {
            return (Boolean)obj;
        }
        return ResultUtil.getBoolean(obj.toString());
    }

    @Override
    public byte getByte(int columnIndex) throws SFException {
        logger.debug("public short getByte(int columnIndex)");
        Object obj = this.getObjectInternal(columnIndex);
        if (obj == null) {
            return 0;
        }
        if (obj instanceof String) {
            return Byte.parseByte((String)obj);
        }
        return ((Number)obj).byteValue();
    }

    @Override
    public short getShort(int columnIndex) throws SFException {
        logger.debug("public short getShort(int columnIndex)");
        Object obj = this.getObjectInternal(columnIndex);
        if (obj == null) {
            return 0;
        }
        if (obj instanceof String) {
            return Short.parseShort((String)obj);
        }
        return ((Number)obj).shortValue();
    }

    @Override
    public int getInt(int columnIndex) throws SFException {
        logger.debug("public int getInt(int columnIndex)");
        Object obj = this.getObjectInternal(columnIndex);
        if (obj == null) {
            return 0;
        }
        if (obj instanceof String) {
            return Integer.parseInt((String)obj);
        }
        return ((Number)obj).intValue();
    }

    @Override
    public long getLong(int columnIndex) throws SFException {
        logger.debug("public long getLong(int columnIndex)");
        Object obj = this.getObjectInternal(columnIndex);
        if (obj == null) {
            return 0L;
        }
        try {
            if (obj instanceof String) {
                return Long.parseLong((String)obj);
            }
            return ((Number)obj).longValue();
        }
        catch (NumberFormatException nfe) {
            int columnType = this.resultSetMetaData.getColumnType(columnIndex);
            if (4 == columnType || 5 == columnType) {
                throw (SFException)IncidentUtil.generateIncidentV2WithException(this.session, new SFException(ErrorCode.INTERNAL_ERROR, " long: " + obj.toString()), null, null);
            }
            throw new SFException(ErrorCode.INVALID_VALUE_CONVERT, columnType, "LONG", obj);
        }
    }

    @Override
    public BigDecimal getBigDecimal(int columnIndex) throws SFException {
        logger.debug("public BigDecimal getBigDecimal(int columnIndex)");
        Object obj = this.getObjectInternal(columnIndex);
        if (obj == null) {
            return null;
        }
        return new BigDecimal(obj.toString());
    }

    @Override
    public BigDecimal getBigDecimal(int columnIndex, int scale) throws SFException {
        logger.debug("public BigDecimal getBigDecimal(int columnIndex)");
        Object obj = this.getObjectInternal(columnIndex);
        if (obj == null) {
            return null;
        }
        BigDecimal value = new BigDecimal(obj.toString());
        value = value.setScale(scale, RoundingMode.HALF_UP);
        return value;
    }

    private SFTimestamp getSFTimestamp(int columnIndex) throws SFException {
        logger.debug("public Timestamp getTimestamp(int columnIndex)");
        Object obj = this.getObjectInternal(columnIndex);
        if (obj == null) {
            return null;
        }
        return ResultUtil.getSFTimestamp(obj.toString(), this.resultSetMetaData.getScale(columnIndex), this.resultSetMetaData.getInternalColumnType(columnIndex), this.resultVersion, this.timeZone, this.session);
    }

    @Override
    public Time getTime(int columnIndex) throws SFException {
        logger.debug("public Time getTime(int columnIndex)");
        int columnType = this.resultSetMetaData.getColumnType(columnIndex);
        if (92 == columnType) {
            SFTime sfTime = this.getSFTime(columnIndex);
            if (sfTime == null) {
                return null;
            }
            return new Time(sfTime.getFractionalSeconds(3));
        }
        if (93 == columnType) {
            return new Time(this.getTimestamp(columnIndex).getTime());
        }
        throw new SFException(ErrorCode.INVALID_VALUE_CONVERT, columnType, "Time", this.getObjectInternal(columnIndex));
    }

    @Override
    public Timestamp getTimestamp(int columnIndex, TimeZone tz) throws SFException {
        int columnType = this.resultSetMetaData.getColumnType(columnIndex);
        if (93 == columnType) {
            SFTimestamp sfTS = this.getSFTimestamp(columnIndex);
            if (sfTS == null) {
                return null;
            }
            Timestamp res = sfTS.getTimestamp();
            if (res == null) {
                return null;
            }
            if (this.honorClientTZForTimestampNTZ && this.resultSetMetaData.getInternalColumnType(columnIndex) == 93) {
                res = sfTS.moveToTimeZone(tz).getTimestamp();
            }
            Timestamp adjustedTimestamp = ResultUtil.adjustTimestamp(res);
            return adjustedTimestamp;
        }
        if (91 == columnType) {
            return new Timestamp(this.getDate(columnIndex, tz).getTime());
        }
        if (92 == columnType) {
            return new Timestamp(this.getTime(columnIndex).getTime());
        }
        throw new SFException(ErrorCode.INVALID_VALUE_CONVERT, columnType, "Timestamp", this.getObjectInternal(columnIndex));
    }

    @Override
    public float getFloat(int columnIndex) throws SFException {
        logger.debug("public float getFloat(int columnIndex)");
        Object obj = this.getObjectInternal(columnIndex);
        if (obj == null) {
            return 0.0f;
        }
        if (obj instanceof String) {
            if ("inf".equals(obj)) {
                return Float.POSITIVE_INFINITY;
            }
            if ("-inf".equals(obj)) {
                return Float.NEGATIVE_INFINITY;
            }
            return Float.parseFloat((String)obj);
        }
        return ((Number)obj).floatValue();
    }

    @Override
    public double getDouble(int columnIndex) throws SFException {
        logger.debug("public double getDouble(int columnIndex)");
        Object obj = this.getObjectInternal(columnIndex);
        if (obj == null) {
            return 0.0;
        }
        if (obj instanceof String) {
            if ("inf".equals(obj)) {
                return Double.POSITIVE_INFINITY;
            }
            if ("-inf".equals(obj)) {
                return Double.NEGATIVE_INFINITY;
            }
            return Double.parseDouble((String)obj);
        }
        return ((Number)obj).doubleValue();
    }

    @Override
    public byte[] getBytes(int columnIndex) throws SFException {
        logger.debug("public byte[] getBytes(int columnIndex)");
        Object obj = this.getObjectInternal(columnIndex);
        if (obj == null) {
            return null;
        }
        try {
            return SFBinary.fromHex(obj.toString()).getBytes();
        }
        catch (IllegalArgumentException ex) {
            throw new SFException(ErrorCode.INTERNAL_ERROR, "Invalid binary value: " + obj.toString());
        }
    }

    @Override
    public Date getDate(int columnIndex) throws SFException {
        return this.getDate(columnIndex, TimeZone.getDefault());
    }

    public Date getDate(int columnIndex, TimeZone tz) throws SFException {
        if (tz == null) {
            tz = TimeZone.getDefault();
        }
        logger.debug("public Date getDate(int columnIndex)");
        Object obj = this.getObjectInternal(columnIndex);
        if (obj == null) {
            return null;
        }
        int columnType = this.resultSetMetaData.getColumnType(columnIndex);
        if (93 == columnType) {
            return new Date(this.getTimestamp(columnIndex, tz).getTime());
        }
        if (91 == columnType) {
            return ResultUtil.getDate(obj.toString(), tz, this.session);
        }
        throw new SFException(ErrorCode.INVALID_VALUE_CONVERT, columnType, "DATE", obj);
    }

    private SFTime getSFTime(int columnIndex) throws SFException {
        Object obj = this.getObjectInternal(columnIndex);
        if (obj == null) {
            return null;
        }
        int scale = this.resultSetMetaData.getScale(columnIndex);
        return ResultUtil.getSFTime(obj.toString(), scale, this.session);
    }

    private Timestamp getTimestamp(int columnIndex) throws SFException {
        return this.getTimestamp(columnIndex, TimeZone.getDefault());
    }
}

