/*
 * Decompiled with CFR 0.152.
 */
package net.snowflake.client.core;

import java.sql.SQLException;
import java.sql.SQLFeatureNotSupportedException;
import java.util.List;
import net.snowflake.client.core.IncidentUtil;
import net.snowflake.client.core.SFException;
import net.snowflake.client.core.SFJsonResultSet;
import net.snowflake.client.core.SFResultSetMetaData;
import net.snowflake.client.core.SFStatementType;
import net.snowflake.client.jdbc.ErrorCode;
import net.snowflake.client.jdbc.SnowflakeFileTransferAgent;
import net.snowflake.client.jdbc.SnowflakeFixedView;
import net.snowflake.client.jdbc.SnowflakeSQLException;
import net.snowflake.client.log.SFLogger;
import net.snowflake.client.log.SFLoggerFactory;

public class SFFixedViewResultSet
extends SFJsonResultSet {
    private static final SFLogger logger = SFLoggerFactory.getLogger(SFFixedViewResultSet.class);
    private SnowflakeFixedView fixedView;
    private Object[] nextRow = null;
    private final SnowflakeFileTransferAgent.CommandType commandType;

    public SFFixedViewResultSet(SnowflakeFixedView fixedView, SnowflakeFileTransferAgent.CommandType commandType) throws SnowflakeSQLException {
        this.fixedView = fixedView;
        this.commandType = commandType;
        try {
            this.resultSetMetaData = new SFResultSetMetaData(fixedView.describeColumns(), this.session, this.timestampNTZFormatter, this.timestampLTZFormatter, this.timestampTZFormatter, this.dateFormatter, this.timeFormatter);
        }
        catch (Exception ex) {
            throw new SnowflakeSQLException(ex, "XX000", (int)ErrorCode.INTERNAL_ERROR.getMessageCode(), "Failed to describe fixed view: " + fixedView.getClass().getName());
        }
    }

    @Override
    public boolean next() throws SFException {
        List<Object> nextRowList;
        logger.debug("next called");
        try {
            nextRowList = this.fixedView.getNextRow();
        }
        catch (Exception ex) {
            throw (SFException)IncidentUtil.generateIncidentV2WithException(this.session, new SFException(ErrorCode.INTERNAL_ERROR, IncidentUtil.oneLiner("Error getting next row from fixed view:", ex)), null, null);
        }
        ++this.row;
        if (nextRowList == null) {
            logger.debug("end of result");
            return false;
        }
        if (this.nextRow == null) {
            this.nextRow = new Object[nextRowList.size()];
        }
        this.nextRow = nextRowList.toArray(this.nextRow);
        return true;
    }

    @Override
    protected Object getObjectInternal(int columnIndex) throws SFException {
        logger.debug("public Object getObjectInternal(int columnIndex)");
        if (this.nextRow == null) {
            throw new SFException(ErrorCode.ROW_DOES_NOT_EXIST, new Object[0]);
        }
        if (columnIndex <= 0 || columnIndex > this.nextRow.length) {
            throw new SFException(ErrorCode.COLUMN_DOES_NOT_EXIST, columnIndex);
        }
        this.wasNull = this.nextRow[columnIndex - 1] == null;
        return this.nextRow[columnIndex - 1];
    }

    @Override
    public void close() {
        super.close();
        this.nextRow = null;
        this.fixedView = null;
    }

    @Override
    public SFStatementType getStatementType() {
        if (this.commandType == SnowflakeFileTransferAgent.CommandType.DOWNLOAD) {
            return SFStatementType.GET;
        }
        return SFStatementType.PUT;
    }

    @Override
    public void setStatementType(SFStatementType statementType) throws SQLException {
        throw new SQLFeatureNotSupportedException();
    }

    @Override
    public boolean isLast() {
        return this.row == this.fixedView.getTotalRows();
    }

    @Override
    public boolean isAfterLast() {
        return this.row > this.fixedView.getTotalRows();
    }

    @Override
    public String getQueryId() {
        return "";
    }
}

