/*
 * Decompiled with CFR 0.152.
 */
package net.snowflake.client.util;

import java.util.ArrayList;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import net.snowflake.client.log.SFLogger;
import net.snowflake.client.log.SFLoggerFactory;

public class SecretDetector {
    private static final Pattern GENERIC_CREDS_PATTERN = Pattern.compile("([a-z0-9+/%]{18,})", 2);
    private static final Pattern AWS_KEY_PATTERN = Pattern.compile("(aws_key_id)|(aws_secret_key)|(access_key_id)|(secret_access_key)", 2);
    private static final Pattern AWS_TOKEN_PATTERN = Pattern.compile("(accessToken|tempToken|keySecret)\"\\s*:\\s*\"([a-z0-9/+]{32,}={0,2})\"", 2);
    private static final Pattern SAS_TOKEN_PATTERN = Pattern.compile("(sig|signature|AWSAccessKeyId)=(?<secret>[a-z0-9%/+]{16,})", 2);
    private static final int LOOK_AHEAD = 10;
    private static final int MAX_LENGTH = 100000;
    private static final SFLogger LOGGER = SFLoggerFactory.getLogger(SecretDetector.class);

    private static List<SecretRange> getAWSSecretPos(String text) {
        LOGGER.debug("pre-regex getAWSSecretPos");
        Matcher matcher = AWS_KEY_PATTERN.matcher(text);
        ArrayList<SecretRange> awsSecretRanges = new ArrayList<SecretRange>();
        while (matcher.find()) {
            int endPos;
            int beginPos;
            for (beginPos = Math.min(matcher.end() + 10, text.length()); beginPos > 0 && beginPos < text.length() && SecretDetector.isBase64(text.charAt(beginPos)); --beginPos) {
            }
            for (endPos = Math.min(matcher.end() + 10, text.length()); endPos < text.length() && SecretDetector.isBase64(text.charAt(endPos)); ++endPos) {
            }
            if (beginPos >= text.length() || endPos > text.length() || beginPos < 0 || endPos < 0) continue;
            awsSecretRanges.add(new SecretRange(beginPos + 1, endPos));
        }
        LOGGER.debug("post-regex getAWSSecretPos");
        return awsSecretRanges;
    }

    private static List<SecretRange> getGenericSecretPos(String text) {
        LOGGER.debug("pre-regex getGenericSecretPos");
        Matcher matcher = GENERIC_CREDS_PATTERN.matcher(text.length() <= 100000 ? text : text.substring(0, 100000));
        ArrayList<SecretRange> awsSecretRanges = new ArrayList<SecretRange>();
        while (matcher.find()) {
            awsSecretRanges.add(new SecretRange(matcher.start(), matcher.end()));
        }
        LOGGER.debug("post-regex getGenericSecretPos");
        return awsSecretRanges;
    }

    private static List<SecretRange> getSASTokenPos(String text) {
        LOGGER.debug("pre-regex getSASTokenPos");
        Matcher matcher = SAS_TOKEN_PATTERN.matcher(text.length() <= 100000 ? text : text.substring(0, 100000));
        ArrayList<SecretRange> secretRanges = new ArrayList<SecretRange>();
        while (matcher.find()) {
            secretRanges.add(new SecretRange(matcher.start("secret"), matcher.end("secret")));
        }
        LOGGER.debug("post-regex getSASTokenPos");
        return secretRanges;
    }

    private static boolean isBase64(char ch) {
        return 'A' <= ch && ch <= 'Z' || 'a' <= ch && ch <= 'z' || '0' <= ch && ch <= '9' || ch == '+' || ch == '/' || ch == '=';
    }

    public static String maskAWSSecret(String sql) {
        List<SecretRange> secretRanges = SecretDetector.getAWSSecretPos(sql);
        return SecretDetector.maskText(sql, secretRanges);
    }

    public static String maskSASToken(String text) {
        List<SecretRange> secretRanges = SecretDetector.getSASTokenPos(text);
        return SecretDetector.maskText(text, secretRanges);
    }

    public static String maskSecrets(String text) {
        List<SecretRange> secretRanges = SecretDetector.getAWSSecretPos(text);
        secretRanges.addAll(SecretDetector.getSASTokenPos(text));
        return SecretDetector.maskText(text, secretRanges);
    }

    private static String maskText(String text, List<SecretRange> ranges) {
        if (ranges.isEmpty()) {
            return text;
        }
        char[] chars = text.toCharArray();
        for (SecretRange range : ranges) {
            int beginPos = range.beginPos;
            int endPos = range.endPos;
            for (int curPos = beginPos; curPos < endPos; ++curPos) {
                chars[curPos] = 9786;
            }
        }
        return String.valueOf(chars);
    }

    static class SecretRange {
        final int beginPos;
        final int endPos;

        SecretRange(int beginPos, int endPos) {
            this.beginPos = beginPos;
            this.endPos = endPos;
        }
    }
}

