/*
 * Decompiled with CFR 0.152.
 */
package net.snowflake.client.log;

import net.snowflake.client.log.JDK14Logger;
import net.snowflake.client.log.SFLogger;
import net.snowflake.client.log.SLF4JLogger;

public class SFLoggerFactory {
    private static LoggerImpl loggerImplementation;

    public static SFLogger getLogger(Class<?> clazz) {
        String logger;
        if (loggerImplementation == null && (loggerImplementation = LoggerImpl.fromString(logger = System.getProperty("net.snowflake.jdbc.loggerImpl"))) == null) {
            loggerImplementation = LoggerImpl.JDK14LOGGER;
        }
        switch (loggerImplementation) {
            case SLF4JLOGGER: {
                return new SLF4JLogger(clazz);
            }
        }
        return new JDK14Logger(clazz.getName());
    }

    static enum LoggerImpl {
        SLF4JLOGGER("net.snowflake.client.log.SLF4JLogger"),
        JDK14LOGGER("net.snowflake.client.log.JDK14Logger");

        private String loggerImplClassName;

        private LoggerImpl(String loggerClass) {
            this.loggerImplClassName = loggerClass;
        }

        public String getLoggerImplClassName() {
            return this.loggerImplClassName;
        }

        public static LoggerImpl fromString(String loggerImplClassName) {
            if (loggerImplClassName != null) {
                for (LoggerImpl imp : LoggerImpl.values()) {
                    if (!loggerImplClassName.equalsIgnoreCase(imp.getLoggerImplClassName())) continue;
                    return imp;
                }
            }
            return null;
        }
    }
}

