/*
 * Decompiled with CFR 0.152.
 */
package net.snowflake.client.jdbc.internal.apache.http.impl.entity;

import java.io.IOException;
import java.io.OutputStream;
import net.snowflake.client.jdbc.internal.apache.http.HttpEntity;
import net.snowflake.client.jdbc.internal.apache.http.HttpException;
import net.snowflake.client.jdbc.internal.apache.http.HttpMessage;
import net.snowflake.client.jdbc.internal.apache.http.annotation.Contract;
import net.snowflake.client.jdbc.internal.apache.http.annotation.ThreadingBehavior;
import net.snowflake.client.jdbc.internal.apache.http.entity.ContentLengthStrategy;
import net.snowflake.client.jdbc.internal.apache.http.impl.io.ChunkedOutputStream;
import net.snowflake.client.jdbc.internal.apache.http.impl.io.ContentLengthOutputStream;
import net.snowflake.client.jdbc.internal.apache.http.impl.io.IdentityOutputStream;
import net.snowflake.client.jdbc.internal.apache.http.io.SessionOutputBuffer;
import net.snowflake.client.jdbc.internal.apache.http.util.Args;

@Deprecated
@Contract(threading=ThreadingBehavior.IMMUTABLE_CONDITIONAL)
public class EntitySerializer {
    private final ContentLengthStrategy lenStrategy;

    public EntitySerializer(ContentLengthStrategy lenStrategy) {
        this.lenStrategy = Args.notNull(lenStrategy, "Content length strategy");
    }

    protected OutputStream doSerialize(SessionOutputBuffer outbuffer, HttpMessage message) throws HttpException, IOException {
        long len = this.lenStrategy.determineLength(message);
        if (len == -2L) {
            return new ChunkedOutputStream(outbuffer);
        }
        if (len == -1L) {
            return new IdentityOutputStream(outbuffer);
        }
        return new ContentLengthOutputStream(outbuffer, len);
    }

    public void serialize(SessionOutputBuffer outbuffer, HttpMessage message, HttpEntity entity) throws HttpException, IOException {
        Args.notNull(outbuffer, "Session output buffer");
        Args.notNull(message, "HTTP message");
        Args.notNull(entity, "HTTP entity");
        OutputStream outstream = this.doSerialize(outbuffer, message);
        entity.writeTo(outstream);
        outstream.close();
    }
}

