/*
 * Decompiled with CFR 0.152.
 */
package net.snowflake.client.jdbc;

import java.lang.ref.SoftReference;
import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import java.util.concurrent.locks.Condition;
import java.util.concurrent.locks.ReentrantLock;
import net.snowflake.client.jdbc.ErrorCode;
import net.snowflake.client.jdbc.SnowflakeSQLException;
import net.snowflake.client.jdbc.internal.fasterxml.jackson.databind.JsonNode;
import net.snowflake.client.log.SFLogger;
import net.snowflake.client.log.SFLoggerFactory;

public class SnowflakeResultChunk {
    private static final int NULL_VALUE = Integer.MIN_VALUE;
    private static final SFLogger logger = SFLoggerFactory.getLogger(SnowflakeResultChunk.class);
    private final String url;
    private final int colCount;
    private int uncompressedSize;
    private final int rowCount;
    private volatile JsonNode resultData;
    private ResultChunkData data;
    private long downloadTime;
    private long parseTime;
    private DownloadState downloadState = DownloadState.NOT_STARTED;
    private ReentrantLock lock = new ReentrantLock();
    private Condition downloadCondition = this.lock.newCondition();
    private String downloadError;
    private int currentRow;

    public SnowflakeResultChunk(String url, int rowCount, int colCount, int uncompressedSize, boolean efficientStorage) {
        this.url = url;
        this.rowCount = rowCount;
        this.colCount = colCount;
        this.uncompressedSize = uncompressedSize;
        this.data = efficientStorage ? new BlockResultChunkData(this.computeCharactersNeeded(), rowCount * colCount) : new LegacyResultChunkData(this.computeCharactersNeeded(), rowCount * colCount);
    }

    public void tryReuse(ResultChunkDataCache cache) {
        cache.reuseOrCreateResultData(this.data);
    }

    @Deprecated
    public void setResultData(JsonNode resultData) {
        this.resultData = resultData;
    }

    public static Object extractCell(JsonNode resultData, int rowIdx, int colIdx) {
        JsonNode currentRow = resultData.get(rowIdx);
        JsonNode colNode = currentRow.get(colIdx);
        if (colNode.isTextual()) {
            return colNode.asText();
        }
        if (colNode.isNumber()) {
            return colNode.numberValue();
        }
        if (colNode.isNull()) {
            return null;
        }
        throw new RuntimeException("Unknow json type");
    }

    public final Object getCell(int rowIdx, int colIdx) {
        if (this.resultData != null) {
            return SnowflakeResultChunk.extractCell(this.resultData, rowIdx, colIdx);
        }
        return this.data.get(this.colCount * rowIdx + colIdx);
    }

    public final String getUrl() {
        return this.url;
    }

    public final int getRowCount() {
        return this.rowCount;
    }

    public final int getUncompressedSize() {
        return this.uncompressedSize;
    }

    public final void addRow(Object[] row) throws SnowflakeSQLException {
        if (row.length != this.colCount) {
            throw new SnowflakeSQLException("XX000", ErrorCode.INTERNAL_ERROR.getMessageCode(), "Exception: expected " + this.colCount + " columns and received " + row.length);
        }
        for (Object cell : row) {
            if (cell == null) {
                this.data.add(null);
                continue;
            }
            if (cell instanceof String) {
                this.data.add((String)cell);
                continue;
            }
            if (cell instanceof Boolean) {
                this.data.add((Boolean)cell != false ? "1" : "0");
                continue;
            }
            throw new SnowflakeSQLException("XX000", ErrorCode.INTERNAL_ERROR.getMessageCode(), "unknown data type in JSON row " + cell.getClass().toString());
        }
        ++this.currentRow;
    }

    public final void ensureRowsComplete() throws SnowflakeSQLException {
        if (this.rowCount != this.currentRow) {
            throw new SnowflakeSQLException("XX000", ErrorCode.INTERNAL_ERROR.getMessageCode(), "Exception: expected " + this.rowCount + " rows and received " + this.currentRow);
        }
    }

    public final long computeNeededChunkMemory() {
        return this.data.computeNeededChunkMemory();
    }

    public final void freeData() {
        if (this.data != null) {
            this.data.freeData();
        }
        this.resultData = null;
    }

    public final int getColCount() {
        return this.colCount;
    }

    public long getDownloadTime() {
        return this.downloadTime;
    }

    public void setDownloadTime(long downloadTime) {
        this.downloadTime = downloadTime;
    }

    public long getParseTime() {
        return this.parseTime;
    }

    public void setParseTime(long parseTime) {
        this.parseTime = parseTime;
    }

    public ReentrantLock getLock() {
        return this.lock;
    }

    public Condition getDownloadCondition() {
        return this.downloadCondition;
    }

    public String getDownloadError() {
        return this.downloadError;
    }

    public void setDownloadError(String downloadError) {
        this.downloadError = downloadError;
    }

    public DownloadState getDownloadState() {
        return this.downloadState;
    }

    public void setDownloadState(DownloadState downloadState) {
        this.downloadState = downloadState;
    }

    private int computeCharactersNeeded() {
        return this.uncompressedSize - this.rowCount * 2 - this.rowCount * this.colCount;
    }

    static class ResultChunkDataCache {
        List<SoftReference<ResultChunkData>> cache = new LinkedList<SoftReference<ResultChunkData>>();

        ResultChunkDataCache() {
        }

        void add(SnowflakeResultChunk chunk) {
            this.cache.add(new SoftReference<ResultChunkData>(chunk.data));
            chunk.data = null;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        void reuseOrCreateResultData(ResultChunkData data) {
            ArrayList<SoftReference<ResultChunkData>> remove = new ArrayList<SoftReference<ResultChunkData>>();
            try {
                for (SoftReference<ResultChunkData> ref : this.cache) {
                    ResultChunkData dat = ref.get();
                    if (dat == null) {
                        remove.add(ref);
                        continue;
                    }
                    if (dat instanceof BlockResultChunkData) {
                        BlockResultChunkData bTargetData = (BlockResultChunkData)data;
                        BlockResultChunkData bCachedDat = (BlockResultChunkData)dat;
                        if (bCachedDat.data.size() == 0 && bCachedDat.offsets.size() == 0) {
                            remove.add(ref);
                            continue;
                        }
                        while (bTargetData.data.size() < bTargetData.blockCount && bCachedDat.data.size() > 0) {
                            bTargetData.data.add(bCachedDat.data.remove(bCachedDat.data.size() - 1));
                        }
                        while (bTargetData.offsets.size() < bTargetData.metaBlockCount && bCachedDat.offsets.size() > 0) {
                            bTargetData.offsets.add(bCachedDat.offsets.remove(bCachedDat.offsets.size() - 1));
                            bTargetData.lengths.add(bCachedDat.lengths.remove(bCachedDat.lengths.size() - 1));
                        }
                        if (bTargetData.data.size() != bTargetData.blockCount || bTargetData.offsets.size() != bTargetData.metaBlockCount) continue;
                        return;
                    }
                    if (dat instanceof LegacyResultChunkData) {
                        LegacyResultChunkData lTargetData = (LegacyResultChunkData)data;
                        LegacyResultChunkData lCachedDat = (LegacyResultChunkData)dat;
                        if (lCachedDat.list == null) {
                            remove.add(ref);
                            continue;
                        }
                        if (lTargetData.list != null) continue;
                        lTargetData.list = lCachedDat.list;
                        lTargetData.list.clear();
                        lCachedDat.list = null;
                        remove.add(ref);
                        return;
                    }
                    remove.add(ref);
                }
            }
            finally {
                this.cache.removeAll(remove);
            }
        }

        void clear() {
            for (SoftReference<ResultChunkData> ref : this.cache) {
                ResultChunkData dat = ref.get();
                if (dat == null) continue;
                dat.freeData();
            }
            this.cache.clear();
        }
    }

    private static class LegacyResultChunkData
    implements ResultChunkData {
        private final int totalLength;
        private final int count;
        ArrayList<String> list;

        LegacyResultChunkData(int totalLength, int count) {
            this.totalLength = totalLength;
            this.count = count;
        }

        @Override
        public void add(String string) {
            if (this.list == null) {
                this.list = new ArrayList(this.count);
            }
            this.list.add(string);
        }

        @Override
        public String get(int index) {
            return this.list.get(index);
        }

        @Override
        public long computeNeededChunkMemory() {
            return this.totalLength + 8 * this.count + 45 * this.count;
        }

        @Override
        public void freeData() {
            if (this.list != null) {
                this.list.clear();
                this.list.trimToSize();
            }
        }
    }

    private static class BlockResultChunkData
    implements ResultChunkData {
        int blockCount;
        private static final int blockLengthBits = 24;
        private static int blockLength = 0x1000000;
        private final ArrayList<char[]> data = new ArrayList();
        private int currentDatOffset = 0;
        int metaBlockCount;
        private static int metaBlockLengthBits = 15;
        private static int metaBlockLength = 1 << metaBlockLengthBits;
        private final ArrayList<int[]> offsets = new ArrayList();
        private final ArrayList<int[]> lengths = new ArrayList();
        private int nextIndex = 0;

        BlockResultChunkData(int totalLength, int count) {
            this.blockCount = BlockResultChunkData.getBlock(totalLength - 1) + 1;
            this.metaBlockCount = BlockResultChunkData.getMetaBlock(count - 1) + 1;
        }

        @Override
        public void add(String string) {
            if (this.data.size() < this.blockCount || this.offsets.size() < this.metaBlockCount) {
                this.allocateArrays();
            }
            if (string == null) {
                this.lengths.get((int)BlockResultChunkData.getMetaBlock((int)this.nextIndex))[BlockResultChunkData.getMetaBlockIndex((int)this.nextIndex)] = Integer.MIN_VALUE;
            } else {
                int offset = this.currentDatOffset;
                int length = string.length();
                this.offsets.get((int)BlockResultChunkData.getMetaBlock((int)this.nextIndex))[BlockResultChunkData.getMetaBlockIndex((int)this.nextIndex)] = offset;
                this.lengths.get((int)BlockResultChunkData.getMetaBlock((int)this.nextIndex))[BlockResultChunkData.getMetaBlockIndex((int)this.nextIndex)] = length;
                char[] source = string.toCharArray();
                if (BlockResultChunkData.spaceLeftOnBlock(offset) < length) {
                    int copySize;
                    for (int copied = 0; copied < length; copied += copySize) {
                        copySize = Math.min(length - copied, BlockResultChunkData.spaceLeftOnBlock(offset + copied));
                        System.arraycopy(source, copied, this.data.get(BlockResultChunkData.getBlock(offset + copied)), BlockResultChunkData.getBlockOffset(offset + copied), copySize);
                    }
                } else {
                    System.arraycopy(source, 0, this.data.get(BlockResultChunkData.getBlock(offset)), BlockResultChunkData.getBlockOffset(offset), string.length());
                }
                this.currentDatOffset += string.length();
            }
            ++this.nextIndex;
        }

        @Override
        public String get(int index) {
            int length = this.lengths.get(BlockResultChunkData.getMetaBlock(index))[BlockResultChunkData.getMetaBlockIndex(index)];
            if (length == Integer.MIN_VALUE) {
                return null;
            }
            int offset = this.offsets.get(BlockResultChunkData.getMetaBlock(index))[BlockResultChunkData.getMetaBlockIndex(index)];
            if (BlockResultChunkData.spaceLeftOnBlock(offset) < length) {
                int copySize;
                char[] cell = new char[length];
                for (int copied = 0; copied < length; copied += copySize) {
                    copySize = Math.min(length - copied, BlockResultChunkData.spaceLeftOnBlock(offset + copied));
                    System.arraycopy(this.data.get(BlockResultChunkData.getBlock(offset + copied)), BlockResultChunkData.getBlockOffset(offset + copied), cell, copied, copySize);
                }
                return new String(cell);
            }
            return new String(this.data.get(BlockResultChunkData.getBlock(offset)), BlockResultChunkData.getBlockOffset(offset), length);
        }

        @Override
        public long computeNeededChunkMemory() {
            long dataRequirement = (long)(this.blockCount * blockLength) * 2L;
            long metadataRequirement = (long)(this.metaBlockCount * metaBlockLength) * 8L;
            return dataRequirement + metadataRequirement;
        }

        @Override
        public void freeData() {
            this.data.clear();
            this.offsets.clear();
            this.lengths.clear();
        }

        private static int getBlock(int offset) {
            return offset >> 24;
        }

        private static int getBlockOffset(int offset) {
            return offset & blockLength - 1;
        }

        private static int spaceLeftOnBlock(int offset) {
            return blockLength - BlockResultChunkData.getBlockOffset(offset);
        }

        private static int getMetaBlock(int index) {
            return index >> metaBlockLengthBits;
        }

        private static int getMetaBlockIndex(int index) {
            return index & metaBlockLength - 1;
        }

        private void allocateArrays() {
            logger.debug("allocating {} B for ResultChunk", this.computeNeededChunkMemory());
            while (this.data.size() < this.blockCount) {
                this.data.add(new char[0x1000000]);
            }
            while (this.offsets.size() < this.metaBlockCount) {
                this.offsets.add(new int[1 << metaBlockLengthBits]);
                this.lengths.add(new int[1 << metaBlockLengthBits]);
            }
            logger.debug("allocated {} B for ResultChunk", this.computeNeededChunkMemory());
        }
    }

    private static interface ResultChunkData {
        public void add(String var1);

        public String get(int var1);

        public long computeNeededChunkMemory();

        public void freeData();
    }

    public static enum DownloadState {
        NOT_STARTED,
        IN_PROGRESS,
        SUCCESS,
        FAILURE;

    }
}

