/*
 * Decompiled with CFR 0.152.
 */
package net.snowflake.client.jdbc.internal.org.bouncycastle.cms;

import java.io.IOException;
import java.io.InputStream;
import net.snowflake.client.jdbc.internal.org.bouncycastle.asn1.ASN1Set;
import net.snowflake.client.jdbc.internal.org.bouncycastle.asn1.cms.AuthEnvelopedData;
import net.snowflake.client.jdbc.internal.org.bouncycastle.asn1.cms.ContentInfo;
import net.snowflake.client.jdbc.internal.org.bouncycastle.asn1.cms.EncryptedContentInfo;
import net.snowflake.client.jdbc.internal.org.bouncycastle.asn1.cms.OriginatorInfo;
import net.snowflake.client.jdbc.internal.org.bouncycastle.asn1.x509.AlgorithmIdentifier;
import net.snowflake.client.jdbc.internal.org.bouncycastle.cms.CMSEnvelopedHelper;
import net.snowflake.client.jdbc.internal.org.bouncycastle.cms.CMSException;
import net.snowflake.client.jdbc.internal.org.bouncycastle.cms.CMSSecureReadable;
import net.snowflake.client.jdbc.internal.org.bouncycastle.cms.CMSUtils;
import net.snowflake.client.jdbc.internal.org.bouncycastle.cms.RecipientInformationStore;

class CMSAuthEnvelopedData {
    RecipientInformationStore recipientInfoStore;
    ContentInfo contentInfo;
    private OriginatorInfo originator;
    private AlgorithmIdentifier authEncAlg;
    private ASN1Set authAttrs;
    private byte[] mac;
    private ASN1Set unauthAttrs;

    public CMSAuthEnvelopedData(byte[] byArray) throws CMSException {
        this(CMSUtils.readContentInfo(byArray));
    }

    public CMSAuthEnvelopedData(InputStream inputStream) throws CMSException {
        this(CMSUtils.readContentInfo(inputStream));
    }

    public CMSAuthEnvelopedData(ContentInfo contentInfo) throws CMSException {
        this.contentInfo = contentInfo;
        AuthEnvelopedData authEnvelopedData = AuthEnvelopedData.getInstance(contentInfo.getContent());
        this.originator = authEnvelopedData.getOriginatorInfo();
        ASN1Set aSN1Set = authEnvelopedData.getRecipientInfos();
        EncryptedContentInfo encryptedContentInfo = authEnvelopedData.getAuthEncryptedContentInfo();
        this.authEncAlg = encryptedContentInfo.getContentEncryptionAlgorithm();
        CMSSecureReadable cMSSecureReadable = new CMSSecureReadable(){

            public InputStream getInputStream() throws IOException, CMSException {
                return null;
            }
        };
        this.recipientInfoStore = CMSEnvelopedHelper.buildRecipientInformationStore(aSN1Set, this.authEncAlg, cMSSecureReadable);
        this.authAttrs = authEnvelopedData.getAuthAttrs();
        this.mac = authEnvelopedData.getMac().getOctets();
        this.unauthAttrs = authEnvelopedData.getUnauthAttrs();
    }
}

