/*
 * Decompiled with CFR 0.152.
 */
package net.snowflake.client.core;

import java.awt.Desktop;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.PrintWriter;
import java.net.InetAddress;
import java.net.ServerSocket;
import java.net.Socket;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URLDecoder;
import java.nio.charset.Charset;
import java.util.HashMap;
import java.util.Locale;
import net.snowflake.client.core.Constants;
import net.snowflake.client.core.HttpUtil;
import net.snowflake.client.core.SFException;
import net.snowflake.client.core.SessionUtil;
import net.snowflake.client.jdbc.ErrorCode;
import net.snowflake.client.jdbc.SnowflakeSQLException;
import net.snowflake.client.jdbc.internal.apache.http.client.methods.HttpPost;
import net.snowflake.client.jdbc.internal.apache.http.client.utils.URIBuilder;
import net.snowflake.client.jdbc.internal.apache.http.entity.StringEntity;
import net.snowflake.client.jdbc.internal.fasterxml.jackson.databind.JsonNode;
import net.snowflake.client.jdbc.internal.fasterxml.jackson.databind.ObjectMapper;
import net.snowflake.client.jdbc.internal.snowflake.common.core.ClientAuthnDTO;
import net.snowflake.client.jdbc.internal.snowflake.common.core.ClientAuthnParameter;
import net.snowflake.client.log.SFLogger;
import net.snowflake.client.log.SFLoggerFactory;

class SessionUtilExternalBrowser {
    static final SFLogger logger = SFLoggerFactory.getLogger(SessionUtilExternalBrowser.class);
    private final ObjectMapper mapper = new ObjectMapper();
    private final SessionUtil.LoginInput loginInput;
    String token;
    private String proofKey;
    private final AuthExternalBrowserHandlers handlers;
    private static final String PREFIX_GET = "GET ";
    private static final String PREFIX_USER_AGENT = "USER-AGENT: ";
    private static final String PREFIX_TOKEN_PARAMETER = "/?token=";
    private static Charset UTF8_CHARSET = Charset.forName("UTF-8");

    SessionUtilExternalBrowser(SessionUtil.LoginInput loginInput) {
        this.loginInput = loginInput;
        this.handlers = new DefaultAuthExternalBrowserHandlers();
    }

    SessionUtilExternalBrowser(SessionUtil.LoginInput loginInput, AuthExternalBrowserHandlers handlers) {
        this.loginInput = loginInput;
        this.handlers = handlers;
    }

    ServerSocket getServerSocket() throws SFException {
        try {
            return new ServerSocket(0, 0, InetAddress.getByName("localhost"));
        }
        catch (IOException ex) {
            throw new SFException(ex, ErrorCode.NETWORK_ERROR, ex.getMessage());
        }
    }

    int getLocalPort(ServerSocket ssocket) {
        return ssocket.getLocalPort();
    }

    private String getSSOUrl(int port) throws SFException, SnowflakeSQLException {
        try {
            String serverUrl = this.loginInput.getServerUrl();
            String authenticator = this.loginInput.getAuthenticator();
            URIBuilder fedUriBuilder = new URIBuilder(serverUrl);
            fedUriBuilder.setPath("/session/authenticator-request");
            URI fedUrlUri = fedUriBuilder.build();
            HttpPost postRequest = this.handlers.build(fedUrlUri);
            ClientAuthnDTO authnData = new ClientAuthnDTO();
            HashMap<String, Object> data = new HashMap<String, Object>();
            data.put(ClientAuthnParameter.AUTHENTICATOR.name(), authenticator);
            data.put(ClientAuthnParameter.ACCOUNT_NAME.name(), this.loginInput.getAccountName());
            data.put(ClientAuthnParameter.LOGIN_NAME.name(), this.loginInput.getUserName());
            data.put(ClientAuthnParameter.BROWSER_MODE_REDIRECT_PORT.name(), Integer.toString(port));
            data.put(ClientAuthnParameter.CLIENT_APP_ID.name(), this.loginInput.getAppId());
            data.put(ClientAuthnParameter.CLIENT_APP_VERSION.name(), this.loginInput.getAppVersion());
            authnData.setData(data);
            String json = this.mapper.writeValueAsString(authnData);
            StringEntity input = new StringEntity(json, Charset.forName("UTF-8"));
            input.setContentType("application/json");
            postRequest.setEntity(input);
            postRequest.addHeader("accept", "application/json");
            String theString = HttpUtil.executeRequest(postRequest, this.loginInput.getLoginTimeout(), 0, null);
            logger.debug("authenticator-request response: {}", theString);
            JsonNode jsonNode = this.mapper.readTree(theString);
            if (!jsonNode.path("success").asBoolean()) {
                logger.debug("response = {}", theString);
                String errorCode = jsonNode.path("code").asText();
                throw new SnowflakeSQLException("08001", new Integer(errorCode), jsonNode.path("message").asText());
            }
            JsonNode dataNode = jsonNode.path("data");
            this.proofKey = dataNode.path("proofKey").asText();
            return dataNode.path("ssoUrl").asText();
        }
        catch (IOException | URISyntaxException ex) {
            throw new SFException(ex, ErrorCode.NETWORK_ERROR, ex.getMessage());
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    void authenticate() throws SFException, SnowflakeSQLException {
        ServerSocket ssocket = this.getServerSocket();
        try {
            int port = this.getLocalPort(ssocket);
            logger.debug("Listening localhost:{}", port);
            String ssoUrl = this.getSSOUrl(port);
            this.handlers.output("Initiating login request with your identity provider. A browser window should have opened for you to complete the login. If you can't see it, check existing browser windows, or your OS settings. Press CTRL+C to abort and try again...");
            this.handlers.openBrowser(ssoUrl);
            this.receiveSamlToken(ssocket);
        }
        catch (IOException ex) {
            try {
                throw new SFException(ex, ErrorCode.NETWORK_ERROR, ex.getMessage());
            }
            catch (Throwable throwable) {
                try {
                    ssocket.close();
                    throw throwable;
                }
                catch (IOException ex2) {
                    throw new SFException(ex2, ErrorCode.NETWORK_ERROR, ex2.getMessage());
                }
            }
        }
        try {
            ssocket.close();
            return;
        }
        catch (IOException ex) {
            throw new SFException(ex, ErrorCode.NETWORK_ERROR, ex.getMessage());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void receiveSamlToken(ServerSocket ssocket) throws IOException, SFException {
        try (Socket socket = ssocket.accept();){
            String[] elems;
            BufferedReader in = new BufferedReader(new InputStreamReader(socket.getInputStream(), UTF8_CHARSET));
            char[] buf = new char[16384];
            int strLen = in.read(buf);
            String[] rets = new String(buf, 0, strLen).split("\r\n");
            String targetLine = null;
            String userAgent = null;
            for (String line : rets) {
                if (line.length() > PREFIX_GET.length() && line.substring(0, PREFIX_GET.length()).equalsIgnoreCase(PREFIX_GET)) {
                    targetLine = line;
                    continue;
                }
                if (line.length() <= PREFIX_USER_AGENT.length() || !line.substring(0, PREFIX_USER_AGENT.length()).equalsIgnoreCase(PREFIX_USER_AGENT)) continue;
                userAgent = line;
            }
            if (targetLine == null) {
                throw new SFException(ErrorCode.NETWORK_ERROR, "Invalid HTTP request. No token is given from the browser.");
            }
            if (userAgent != null) {
                logger.debug("{}", userAgent);
            }
            if (!((elems = targetLine.split("\\s")).length == 3 && elems[0].toLowerCase(Locale.US).equalsIgnoreCase("GET") && elems[2].startsWith("HTTP/1.") && elems[1].startsWith(PREFIX_TOKEN_PARAMETER))) {
                throw new SFException(ErrorCode.NETWORK_ERROR, String.format("Invalid HTTP request. No token is given from the browser: %s", targetLine));
            }
            this.token = URLDecoder.decode(elems[1].substring(PREFIX_TOKEN_PARAMETER.length()), "UTF-8");
            this.returnToBrowser(socket);
        }
    }

    private void returnToBrowser(Socket socket) throws IOException {
        PrintWriter out = new PrintWriter(socket.getOutputStream(), true);
        String responseText = "<!DOCTYPE html><html><head><meta charset=\"UTF-8\"/><title>SAML Response for Snowflake</title></head><body>Your identity was confirmed and propagated to Snowflake JDBC driver. You can close this window now and go back where you started from.</body></html>";
        String[] content = new String[]{"HTTP/1.0 200 OK", "Content-Type: text/html", String.format("Content-Length: %s", responseText.length()), "", responseText};
        for (int i = 0; i < content.length; ++i) {
            if (i > 0) {
                out.print("\r\n");
            }
            out.print(content[i]);
        }
        out.flush();
    }

    String getToken() {
        return this.token;
    }

    String getProofKey() {
        return this.proofKey;
    }

    class DefaultAuthExternalBrowserHandlers
    implements AuthExternalBrowserHandlers {
        DefaultAuthExternalBrowserHandlers() {
        }

        @Override
        public HttpPost build(URI uri) {
            return new HttpPost(uri);
        }

        @Override
        public void openBrowser(String ssoUrl) throws SFException {
            try {
                if (Desktop.isDesktopSupported()) {
                    URI uri = new URI(ssoUrl);
                    Desktop.getDesktop().browse(uri);
                } else {
                    Runtime runtime = Runtime.getRuntime();
                    Constants.OS os = Constants.getOS();
                    if (os == Constants.OS.MAC) {
                        runtime.exec("open " + ssoUrl);
                    } else {
                        runtime.exec("xdg-open " + ssoUrl);
                    }
                }
            }
            catch (IOException | URISyntaxException ex) {
                throw new SFException(ex, ErrorCode.NETWORK_ERROR, ex.getMessage());
            }
        }

        @Override
        public void output(String msg) {
            System.out.println(msg);
        }
    }

    public static interface AuthExternalBrowserHandlers {
        public HttpPost build(URI var1);

        public void openBrowser(String var1) throws SFException;

        public void output(String var1);
    }
}

