/*
 * Decompiled with CFR 0.152.
 */
package net.snowflake.client.jdbc.telemetry;

import java.io.IOException;
import java.rmi.UnexpectedException;
import java.sql.Connection;
import java.util.LinkedList;
import net.snowflake.client.core.HttpUtil;
import net.snowflake.client.core.SFSession;
import net.snowflake.client.jdbc.SnowflakeConnectionV1;
import net.snowflake.client.jdbc.SnowflakeSQLException;
import net.snowflake.client.jdbc.internal.apache.http.client.HttpClient;
import net.snowflake.client.jdbc.internal.apache.http.client.methods.HttpPost;
import net.snowflake.client.jdbc.internal.apache.http.entity.StringEntity;
import net.snowflake.client.jdbc.internal.fasterxml.jackson.databind.ObjectMapper;
import net.snowflake.client.jdbc.internal.fasterxml.jackson.databind.node.ArrayNode;
import net.snowflake.client.jdbc.internal.fasterxml.jackson.databind.node.ObjectNode;
import net.snowflake.client.jdbc.telemetry.TelemetryData;
import net.snowflake.client.log.SFLogger;
import net.snowflake.client.log.SFLoggerFactory;

public class Telemetry {
    private static final SFLogger logger = SFLoggerFactory.getLogger(SFSession.class);
    private static final String SF_PATH_TELEMETRY = "/telemetry/send";
    private final int forceFlushSize;
    private static final int DEFAULT_FORCE_FLUSH_SIZE = 100;
    private final String serverUrl;
    private final String telemetryUrl;
    private final SFSession session;
    private LinkedList<TelemetryData> logBatch;
    private static final ObjectMapper mapper = new ObjectMapper();
    private boolean isClosed;
    private Object locker = new Object();
    private boolean isTelemetryServiceAvailable = true;

    private Telemetry(SFSession session, int flushSize) {
        this.session = session;
        this.serverUrl = session.getUrl();
        this.telemetryUrl = this.serverUrl.endsWith("/") ? this.serverUrl.substring(0, this.serverUrl.length() - 1) + SF_PATH_TELEMETRY : this.serverUrl + SF_PATH_TELEMETRY;
        this.logBatch = new LinkedList();
        this.isClosed = false;
        this.forceFlushSize = flushSize;
    }

    public boolean isTelemetryEnabled() {
        return this.session.isClientTelemetryEnabled() && this.isTelemetryServiceAvailable;
    }

    public void disableTelemetry() {
        this.isTelemetryServiceAvailable = false;
    }

    public static Telemetry createTelemetry(Connection conn, int flushSize) {
        if (conn instanceof SnowflakeConnectionV1) {
            return Telemetry.createTelemetry(((SnowflakeConnectionV1)conn).getSfSession(), flushSize);
        }
        logger.debug("input connection is not a SnowflakeConnection");
        return null;
    }

    public static Telemetry createTelemetry(Connection conn) {
        return Telemetry.createTelemetry(conn, 100);
    }

    public static Telemetry createTelemetry(SFSession session) {
        return Telemetry.createTelemetry(session, 100);
    }

    public static Telemetry createTelemetry(SFSession session, int flushSize) {
        return new Telemetry(session, flushSize);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addLogToBatch(TelemetryData log) throws IOException {
        if (this.isClosed) {
            throw new IOException("Telemetry connector is closed");
        }
        if (!this.isTelemetryEnabled()) {
            return;
        }
        Object object = this.locker;
        synchronized (object) {
            this.logBatch.add(log);
        }
        if (this.logBatch.size() >= this.forceFlushSize) {
            this.sendBatch();
        }
    }

    public void addLogToBatch(ObjectNode message, long timeStamp) throws IOException {
        this.addLogToBatch(new TelemetryData(message, timeStamp));
    }

    public void close() throws IOException {
        if (this.isClosed) {
            throw new IOException("Telemetry connector is closed");
        }
        try {
            this.sendBatch();
        }
        catch (IOException e) {
            logger.error("Send logs failed on closing", e);
        }
        finally {
            this.isClosed = true;
        }
    }

    public boolean isClosed() {
        return this.isClosed;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean sendBatch() throws IOException {
        LinkedList<TelemetryData> tmpList;
        if (this.isClosed) {
            throw new IOException("Telemetry connector is closed");
        }
        if (!this.isTelemetryEnabled()) {
            return false;
        }
        Object object = this.locker;
        synchronized (object) {
            tmpList = this.logBatch;
            this.logBatch = new LinkedList();
        }
        if (this.session.isClosed()) {
            throw new UnexpectedException("Session is closed when sending log");
        }
        if (!tmpList.isEmpty()) {
            String sessionToken = this.session.getSessionToken();
            HttpClient httpClient = HttpUtil.getHttpClient();
            HttpPost post = new HttpPost(this.telemetryUrl);
            post.setEntity(new StringEntity(Telemetry.logsToString(tmpList)));
            post.setHeader("Content-type", "application/json");
            post.setHeader("Authorization", "Snowflake Token=\"" + sessionToken + "\"");
            String response = null;
            try {
                response = HttpUtil.executeRequest(post, httpClient, 1000, 0, null);
            }
            catch (SnowflakeSQLException e) {
                this.disableTelemetry();
                logger.error("Telemetry request failed, response: {}, exception: {}", response, e.getMessage());
                return false;
            }
        }
        return true;
    }

    public boolean sendLog(TelemetryData log) throws IOException {
        this.addLogToBatch(log);
        return this.sendBatch();
    }

    public boolean sendLog(ObjectNode message, long timeStamp) throws IOException {
        return this.sendLog(new TelemetryData(message, timeStamp));
    }

    static ObjectNode logsToJson(LinkedList<TelemetryData> telemetryData) {
        ObjectNode node = mapper.createObjectNode();
        ArrayNode logs = mapper.createArrayNode();
        for (TelemetryData data : telemetryData) {
            logs.add(data.toJson());
        }
        node.set("logs", logs);
        return node;
    }

    static String logsToString(LinkedList<TelemetryData> telemetryData) {
        return Telemetry.logsToJson(telemetryData).toString();
    }

    public int bufferSize() {
        return this.logBatch.size();
    }

    public LinkedList<TelemetryData> logBuffer() {
        return new LinkedList<TelemetryData>(this.logBatch);
    }
}

