/*
 * Decompiled with CFR 0.152.
 */
package net.snowflake.client.jdbc.internal.fasterxml.jackson.datatype.joda.deser;

import java.io.IOException;
import net.snowflake.client.jdbc.internal.fasterxml.jackson.core.JsonParser;
import net.snowflake.client.jdbc.internal.fasterxml.jackson.databind.DeserializationContext;
import net.snowflake.client.jdbc.internal.fasterxml.jackson.databind.DeserializationFeature;
import net.snowflake.client.jdbc.internal.fasterxml.jackson.datatype.joda.cfg.FormatConfig;
import net.snowflake.client.jdbc.internal.fasterxml.jackson.datatype.joda.cfg.JacksonJodaPeriodFormat;
import net.snowflake.client.jdbc.internal.fasterxml.jackson.datatype.joda.deser.JodaDeserializerBase;
import net.snowflake.client.jdbc.internal.joda.time.Duration;

public class DurationDeserializer
extends JodaDeserializerBase<Duration> {
    private static final long serialVersionUID = 1L;
    protected final JacksonJodaPeriodFormat _format;

    public DurationDeserializer() {
        this(FormatConfig.DEFAULT_PERIOD_FORMAT);
    }

    public DurationDeserializer(JacksonJodaPeriodFormat format) {
        super(Duration.class);
        this._format = format;
    }

    @Override
    public Duration deserialize(JsonParser p, DeserializationContext ctxt) throws IOException {
        switch (p.getCurrentTokenId()) {
            case 7: {
                return new Duration(p.getLongValue());
            }
            case 6: {
                return this._format.parsePeriod(ctxt, p.getText().trim()).toStandardDuration();
            }
        }
        return (Duration)this._handleNotNumberOrString(p, ctxt);
    }

    protected Duration _deserialize(DeserializationContext ctxt, String str) throws IOException {
        if (str.length() == 0 && ctxt.isEnabled(DeserializationFeature.ACCEPT_EMPTY_STRING_AS_NULL_OBJECT)) {
            return null;
        }
        return Duration.parse(str);
    }
}

