/*
 * Decompiled with CFR 0.152.
 */
package net.snowflake.client.jdbc.internal.com.nimbusds.jose.util;

import java.io.IOException;
import java.io.InputStream;
import java.net.HttpURLConnection;
import java.net.URL;
import java.nio.charset.Charset;
import net.snowflake.client.jdbc.internal.com.nimbusds.jose.util.AbstractRestrictedResourceRetriever;
import net.snowflake.client.jdbc.internal.com.nimbusds.jose.util.BoundedInputStream;
import net.snowflake.client.jdbc.internal.com.nimbusds.jose.util.IOUtils;
import net.snowflake.client.jdbc.internal.com.nimbusds.jose.util.Resource;
import net.snowflake.client.jdbc.internal.com.nimbusds.jose.util.RestrictedResourceRetriever;
import net.snowflake.client.jdbc.internal.net.jcip.annotations.ThreadSafe;

@ThreadSafe
public class DefaultResourceRetriever
extends AbstractRestrictedResourceRetriever
implements RestrictedResourceRetriever {
    private boolean disconnectAfterUse;

    public DefaultResourceRetriever() {
        this(0, 0);
    }

    public DefaultResourceRetriever(int connectTimeout, int readTimeout) {
        this(connectTimeout, readTimeout, 0);
    }

    public DefaultResourceRetriever(int connectTimeout, int readTimeout, int sizeLimit) {
        this(connectTimeout, readTimeout, sizeLimit, true);
    }

    public DefaultResourceRetriever(int connectTimeout, int readTimeout, int sizeLimit, boolean disconnectAfterUse) {
        super(connectTimeout, readTimeout, sizeLimit);
        this.disconnectAfterUse = disconnectAfterUse;
    }

    public boolean disconnectsAfterUse() {
        return this.disconnectAfterUse;
    }

    public void setDisconnectsAfterUse(boolean disconnectAfterUse) {
        this.disconnectAfterUse = disconnectAfterUse;
    }

    @Override
    public Resource retrieveResource(URL url) throws IOException {
        HttpURLConnection con = null;
        try {
            String content;
            con = (HttpURLConnection)url.openConnection();
            con.setConnectTimeout(this.getConnectTimeout());
            con.setReadTimeout(this.getReadTimeout());
            InputStream inputStream = con.getInputStream();
            try {
                if (this.getSizeLimit() > 0) {
                    inputStream = new BoundedInputStream(inputStream, this.getSizeLimit());
                }
                content = IOUtils.readInputStreamToString(inputStream, Charset.forName("UTF-8"));
            }
            finally {
                inputStream.close();
            }
            int statusCode = con.getResponseCode();
            String statusMessage = con.getResponseMessage();
            if (statusCode > 299 || statusCode < 200) {
                throw new IOException("HTTP " + statusCode + ": " + statusMessage);
            }
            Resource resource = new Resource(content, con.getContentType());
            return resource;
        }
        catch (ClassCastException e) {
            throw new IOException("Couldn't open HTTP(S) connection: " + e.getMessage(), e);
        }
        finally {
            if (this.disconnectAfterUse && con != null) {
                con.disconnect();
            }
        }
    }
}

