/*
 * Decompiled with CFR 0.152.
 */
package net.snowflake.client.core;

import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.OutputStream;
import java.math.BigInteger;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.security.InvalidKeyException;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.security.NoSuchProviderException;
import java.security.Security;
import java.security.Signature;
import java.security.SignatureException;
import java.security.cert.CertificateEncodingException;
import java.security.cert.CertificateException;
import java.security.cert.X509Certificate;
import java.text.MessageFormat;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TimeZone;
import javax.net.ssl.KeyManagerFactory;
import javax.net.ssl.TrustManager;
import javax.net.ssl.TrustManagerFactory;
import javax.net.ssl.X509TrustManager;
import net.snowflake.client.core.FileCacheManager;
import net.snowflake.client.core.HttpUtil;
import net.snowflake.client.jdbc.internal.apache.commons.codec.binary.Base64;
import net.snowflake.client.jdbc.internal.apache.commons.io.IOUtils;
import net.snowflake.client.jdbc.internal.apache.http.HttpResponse;
import net.snowflake.client.jdbc.internal.apache.http.client.HttpClient;
import net.snowflake.client.jdbc.internal.apache.http.client.methods.HttpGet;
import net.snowflake.client.jdbc.internal.apache.http.ssl.SSLInitializationException;
import net.snowflake.client.jdbc.internal.fasterxml.jackson.databind.JsonNode;
import net.snowflake.client.jdbc.internal.fasterxml.jackson.databind.ObjectMapper;
import net.snowflake.client.jdbc.internal.fasterxml.jackson.databind.node.ArrayNode;
import net.snowflake.client.jdbc.internal.fasterxml.jackson.databind.node.JsonNodeType;
import net.snowflake.client.jdbc.internal.fasterxml.jackson.databind.node.ObjectNode;
import net.snowflake.client.jdbc.internal.org.bouncycastle.asn1.ASN1Encodable;
import net.snowflake.client.jdbc.internal.org.bouncycastle.asn1.ASN1Integer;
import net.snowflake.client.jdbc.internal.org.bouncycastle.asn1.ASN1ObjectIdentifier;
import net.snowflake.client.jdbc.internal.org.bouncycastle.asn1.ASN1OctetString;
import net.snowflake.client.jdbc.internal.org.bouncycastle.asn1.DEROctetString;
import net.snowflake.client.jdbc.internal.org.bouncycastle.asn1.DLSequence;
import net.snowflake.client.jdbc.internal.org.bouncycastle.asn1.ocsp.CertID;
import net.snowflake.client.jdbc.internal.org.bouncycastle.asn1.oiw.OIWObjectIdentifiers;
import net.snowflake.client.jdbc.internal.org.bouncycastle.asn1.x509.AlgorithmIdentifier;
import net.snowflake.client.jdbc.internal.org.bouncycastle.asn1.x509.Certificate;
import net.snowflake.client.jdbc.internal.org.bouncycastle.asn1.x509.Extension;
import net.snowflake.client.jdbc.internal.org.bouncycastle.asn1.x509.Extensions;
import net.snowflake.client.jdbc.internal.org.bouncycastle.asn1.x509.GeneralName;
import net.snowflake.client.jdbc.internal.org.bouncycastle.asn1.x509.TBSCertificate;
import net.snowflake.client.jdbc.internal.org.bouncycastle.cert.X509CertificateHolder;
import net.snowflake.client.jdbc.internal.org.bouncycastle.cert.jcajce.JcaX509CertificateConverter;
import net.snowflake.client.jdbc.internal.org.bouncycastle.cert.ocsp.BasicOCSPResp;
import net.snowflake.client.jdbc.internal.org.bouncycastle.cert.ocsp.CertificateID;
import net.snowflake.client.jdbc.internal.org.bouncycastle.cert.ocsp.CertificateStatus;
import net.snowflake.client.jdbc.internal.org.bouncycastle.cert.ocsp.OCSPException;
import net.snowflake.client.jdbc.internal.org.bouncycastle.cert.ocsp.OCSPReq;
import net.snowflake.client.jdbc.internal.org.bouncycastle.cert.ocsp.OCSPReqBuilder;
import net.snowflake.client.jdbc.internal.org.bouncycastle.cert.ocsp.OCSPResp;
import net.snowflake.client.jdbc.internal.org.bouncycastle.cert.ocsp.RevokedStatus;
import net.snowflake.client.jdbc.internal.org.bouncycastle.cert.ocsp.SingleResp;
import net.snowflake.client.jdbc.internal.org.bouncycastle.crypto.digests.SHA1Digest;
import net.snowflake.client.jdbc.internal.org.bouncycastle.jce.provider.BouncyCastleProvider;
import net.snowflake.client.jdbc.internal.org.bouncycastle.operator.DigestCalculator;
import net.snowflake.client.log.SFLogger;
import net.snowflake.client.log.SFLoggerFactory;
import net.snowflake.client.util.DecorrelatedJitterBackoff;
import net.snowflake.client.util.SFPair;

class SFTrustManager
implements X509TrustManager {
    private static final SFLogger LOGGER = SFLoggerFactory.getLogger(SFTrustManager.class);
    private static final ASN1ObjectIdentifier OIDocsp = new ASN1ObjectIdentifier("1.3.6.1.5.5.7.48.1").intern();
    private static final ASN1ObjectIdentifier SHA1RSA = new ASN1ObjectIdentifier("1.2.840.113549.1.1.5").intern();
    private static final ASN1ObjectIdentifier SHA256RSA = new ASN1ObjectIdentifier("1.2.840.113549.1.1.11").intern();
    private static final ASN1ObjectIdentifier SHA384RSA = new ASN1ObjectIdentifier("1.2.840.113549.1.1.12").intern();
    private static final ASN1ObjectIdentifier SHA512RSA = new ASN1ObjectIdentifier("1.2.840.113549.1.1.13").intern();
    private static final ObjectMapper OBJECT_MAPPER = new ObjectMapper();
    public static final String CACHE_DIR_PROP = "net.snowflake.jdbc.ocspResponseCacheDir";
    private static final String CACHE_DIR_ENV = "SF_OCSP_RESPONSE_CACHE_DIR";
    private static final long CACHE_EXPIRATION_IN_SECONDS = 86400L;
    private static final long CACHE_FILE_LOCK_EXPIRATION_IN_SECONDS = 60L;
    public static final String DEFAULT_OCSP_CACHE_HOST = "http://ocsp.snowflakecomputing.com";
    public static final String CACHE_FILE_NAME = "ocsp_response_cache.json";
    private static final FileCacheManager fileCacheManager = FileCacheManager.builder().setCacheDirectorySystemProperty("net.snowflake.jdbc.ocspResponseCacheDir").setCacheDirectoryEnvironmentVariable("SF_OCSP_RESPONSE_CACHE_DIR").setBaseCacheFileName("ocsp_response_cache.json").setCacheExpirationInSeconds(86400L).setCacheFileLockExpirationInSeconds(60L).build();
    private static String SF_OCSP_RESPONSE_CACHE_SERVER_URL = String.format("%s/%s", "http://ocsp.snowflakecomputing.com", "ocsp_response_cache.json");
    private static String SF_OCSP_RESPONSE_CACHE_SERVER_RETRY_URL_PATTERN;
    private static final float TOLERABLE_VALIDITY_RANGE_RATIO = 0.01f;
    private static final long MAX_CLOCK_SKEW_IN_MILLISECONDS = 900000L;
    private static final long MIN_CACHE_WARMUP_TIME_IN_MILLISECONDS = 18000000L;
    private static final int MAX_RETRY_COUNTER = 10;
    private static final long INITIAL_SLEEPING_TIME_IN_MILLISECONDS = 1000L;
    private static final long MAX_SLEEPING_TIME_IN_MILLISECONDS = 16000L;
    private static final Map<ASN1ObjectIdentifier, String> SIGNATURE_OID_TO_STRING;
    private static final Map<Integer, String> OCSP_RESPONSE_CODE_TO_STRING;
    private static JcaX509CertificateConverter CONVERTER_X509;
    private static Map<Integer, Certificate> ROOT_CA;
    private static final Object ROOT_CA_LOCK;
    private static final Map<OcspResponseCacheKey, SFPair<Long, OCSPResp>> OCSP_RESPONSE_CACHE;
    private static final Object OCSP_RESPONSE_CACHE_LOCK;
    private static boolean WAS_CACHE_UPDATED;
    private static boolean WAS_CACHE_READ;
    private static final SimpleDateFormat DATE_FORMAT_UTC;
    private final X509TrustManager trustManager = this.getTrustManager(KeyManagerFactory.getDefaultAlgorithm());
    private final boolean useOcspResponseCacheServer;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    SFTrustManager(File cacheFile, boolean useOcspResponseCacheServer) {
        Object object = OCSP_RESPONSE_CACHE_LOCK;
        synchronized (object) {
            if (cacheFile != null) {
                fileCacheManager.overrideCacheFile(cacheFile);
            }
            if (!WAS_CACHE_READ) {
                JsonNode res = fileCacheManager.readCacheFile();
                SFTrustManager.readJsonStoreCache(res);
                WAS_CACHE_READ = true;
            }
        }
        this.useOcspResponseCacheServer = useOcspResponseCacheServer;
    }

    static void resetOCSPResponseCacherServerURL(String ocspCacheServerUrl) {
        if (ocspCacheServerUrl == null || SF_OCSP_RESPONSE_CACHE_SERVER_RETRY_URL_PATTERN != null) {
            return;
        }
        SF_OCSP_RESPONSE_CACHE_SERVER_URL = ocspCacheServerUrl;
        if (!SF_OCSP_RESPONSE_CACHE_SERVER_URL.startsWith(DEFAULT_OCSP_CACHE_HOST)) {
            try {
                URL url = new URL(SF_OCSP_RESPONSE_CACHE_SERVER_URL);
                if (url.getPort() > 0) {
                    SF_OCSP_RESPONSE_CACHE_SERVER_RETRY_URL_PATTERN = String.format("%s://%s:%d/retry/", url.getProtocol(), url.getHost(), url.getPort()) + "%s/%s";
                }
                SF_OCSP_RESPONSE_CACHE_SERVER_RETRY_URL_PATTERN = String.format("%s://%s/retry/", url.getProtocol(), url.getHost()) + "%s/%s";
            }
            catch (IOException e) {
                throw new RuntimeException(String.format("Failed to parse SF_OCSP_RESPONSE_CACHE_SERVER_URL: %s", SF_OCSP_RESPONSE_CACHE_SERVER_URL));
            }
        } else {
            SF_OCSP_RESPONSE_CACHE_SERVER_RETRY_URL_PATTERN = null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private X509TrustManager getTrustManager(String algorithm) {
        try {
            TrustManagerFactory factory = TrustManagerFactory.getInstance(algorithm);
            factory.init((KeyStore)null);
            X509TrustManager ret = null;
            for (TrustManager tm : factory.getTrustManagers()) {
                if (!(tm instanceof X509TrustManager)) continue;
                ret = (X509TrustManager)tm;
                break;
            }
            if (ret == null) {
                return null;
            }
            Object object = ROOT_CA_LOCK;
            synchronized (object) {
                if (ROOT_CA.size() == 0) {
                    for (X509Certificate cert : ret.getAcceptedIssuers()) {
                        Certificate bcCert = Certificate.getInstance(cert.getEncoded());
                        ROOT_CA.put(bcCert.getSubject().hashCode(), bcCert);
                    }
                }
            }
            return ret;
        }
        catch (KeyStoreException | NoSuchAlgorithmException | CertificateEncodingException ex) {
            throw new SSLInitializationException(ex.getMessage(), ex);
        }
    }

    @Override
    public void checkClientTrusted(X509Certificate[] chain, String authType) throws CertificateException {
        this.trustManager.checkClientTrusted(chain, authType);
    }

    @Override
    public void checkServerTrusted(X509Certificate[] chain, String authType) throws CertificateException {
        this.trustManager.checkServerTrusted(chain, authType);
        this.validateRevocationStatus(chain);
    }

    @Override
    public X509Certificate[] getAcceptedIssuers() {
        return this.trustManager.getAcceptedIssuers();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void validateRevocationStatus(X509Certificate[] chain) throws CertificateException {
        List<Certificate> bcChain = this.convertToBouncyCastleCertificate(chain);
        List<SFPair<Certificate, Certificate>> pairIssuerSubjectList = this.getPairIssuerSubject(bcChain);
        Object object = OCSP_RESPONSE_CACHE_LOCK;
        synchronized (object) {
            boolean isCached = this.isCached(pairIssuerSubjectList);
            if (this.useOcspResponseCacheServer && !isCached) {
                LOGGER.debug("Downloading OCSP response cache from the server. URL: {}", SF_OCSP_RESPONSE_CACHE_SERVER_URL);
                SFTrustManager.readOcspResponseCacheServer();
                WAS_CACHE_UPDATED = true;
            }
            this.executeRevocationStatusChecks(pairIssuerSubjectList);
            if (WAS_CACHE_UPDATED) {
                ObjectNode input = SFTrustManager.encodeCacheToJSON();
                fileCacheManager.writeCacheFile(input);
                WAS_CACHE_UPDATED = false;
            }
        }
    }

    private void executeRevocationStatusChecks(List<SFPair<Certificate, Certificate>> pairIssuerSubjectList) throws CertificateException {
        long currentTimeSecond = new Date().getTime() / 1000L;
        try {
            for (SFPair<Certificate, Certificate> pairIssuerSubject : pairIssuerSubjectList) {
                this.executeOneRevoctionStatusCheck(pairIssuerSubject, currentTimeSecond);
            }
        }
        catch (IOException ex) {
            LOGGER.debug("Failed to decode CertID. Ignored.");
        }
    }

    private void executeOneRevoctionStatusCheck(SFPair<Certificate, Certificate> pairIssuerSubject, long currentTimeSecond) throws IOException, CertificateException {
        OCSPReq req = this.createRequest(pairIssuerSubject);
        CertID cid = req.getRequestList()[0].getCertID().toASN1Primitive();
        OcspResponseCacheKey keyOcspResponse = new OcspResponseCacheKey(cid.getIssuerNameHash().getEncoded(), cid.getIssuerKeyHash().getEncoded(), cid.getSerialNumber().getValue());
        long sleepTime = 1000L;
        DecorrelatedJitterBackoff backoff = new DecorrelatedJitterBackoff(sleepTime, 16000L);
        CertificateException error = null;
        boolean success = false;
        for (int retry = 0; retry < 10; ++retry) {
            SFPair<Long, OCSPResp> value0 = OCSP_RESPONSE_CACHE.get(keyOcspResponse);
            try {
                OCSPResp ocspResp;
                if (value0 == null) {
                    LOGGER.debug("not hit cache.");
                    ocspResp = this.fetchOcspResponse(pairIssuerSubject, req);
                    OCSP_RESPONSE_CACHE.put(keyOcspResponse, SFPair.of(currentTimeSecond, ocspResp));
                    WAS_CACHE_UPDATED = true;
                } else {
                    LOGGER.debug("hit cache.");
                    ocspResp = (OCSPResp)value0.right;
                }
                LOGGER.debug("validating. {}", SFTrustManager.CertificateIDToString(req.getRequestList()[0].getCertID()));
                this.validateRevocationStatusMain(pairIssuerSubject, ocspResp);
                success = true;
                break;
            }
            catch (CertificateException ex) {
                if (OCSP_RESPONSE_CACHE.containsKey(keyOcspResponse)) {
                    LOGGER.debug("deleting the invalid OCSP cache.");
                    OCSP_RESPONSE_CACHE.remove(keyOcspResponse);
                    WAS_CACHE_UPDATED = true;
                }
                error = ex;
                LOGGER.debug("Retrying {}/{} after sleeping {}(ms)", retry + 1, 10, sleepTime);
                try {
                    Thread.sleep(sleepTime);
                    sleepTime = backoff.nextSleepTime(sleepTime);
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
                continue;
            }
        }
        if (!success) {
            throw error;
        }
    }

    private boolean isCached(List<SFPair<Certificate, Certificate>> pairIssuerSubjectList) {
        long currentTimeSecond = new Date().getTime() / 1000L;
        boolean isCached = true;
        try {
            for (SFPair<Certificate, Certificate> pairIssuerSubject : pairIssuerSubjectList) {
                OCSPReq req = this.createRequest(pairIssuerSubject);
                CertificateID certificateId = req.getRequestList()[0].getCertID();
                LOGGER.debug(SFTrustManager.CertificateIDToString(certificateId));
                CertID cid = certificateId.toASN1Primitive();
                OcspResponseCacheKey k = new OcspResponseCacheKey(cid.getIssuerNameHash().getEncoded(), cid.getIssuerKeyHash().getEncoded(), cid.getSerialNumber().getValue());
                SFPair<Long, OCSPResp> res = OCSP_RESPONSE_CACHE.get(k);
                if (res == null) {
                    LOGGER.debug("Not all OCSP responses for the certificate is in the cache.");
                    isCached = false;
                    break;
                }
                if (currentTimeSecond - 86400L > (Long)res.left) {
                    LOGGER.debug("Cache for CertID expired.");
                    isCached = false;
                    break;
                }
                try {
                    this.validateRevocationStatusMain(pairIssuerSubject, (OCSPResp)res.right);
                }
                catch (CertificateException ex) {
                    LOGGER.debug("Cache includes invalid OCSPResponse. Will download the OCSP cache from Snowflake OCSP server");
                    isCached = false;
                }
            }
        }
        catch (IOException ex) {
            LOGGER.debug("Failed to encode CertID.");
        }
        return isCached;
    }

    private static String CertificateIDToString(CertificateID certificateID) {
        return String.format("CertID. NameHash: %s, KeyHash: %s, Serial Number: %s", SFTrustManager.byteToHexString(certificateID.getIssuerNameHash()), SFTrustManager.byteToHexString(certificateID.getIssuerKeyHash()), MessageFormat.format("{0,number,#}", certificateID.getSerialNumber()));
    }

    private static SFPair<OcspResponseCacheKey, SFPair<Long, OCSPResp>> decodeCacheFromJSON(Map.Entry<String, JsonNode> elem) throws IOException {
        long currentTimeSecond = new Date().getTime() / 1000L;
        byte[] certIdDer = Base64.decodeBase64(elem.getKey());
        DLSequence rawCertId = (DLSequence)ASN1ObjectIdentifier.fromByteArray(certIdDer);
        ASN1Encodable[] rawCertIdArray = rawCertId.toArray();
        byte[] issuerNameHashDer = ((DEROctetString)rawCertIdArray[1]).getEncoded();
        byte[] issuerKeyHashDer = ((DEROctetString)rawCertIdArray[2]).getEncoded();
        BigInteger serialNumber = ((ASN1Integer)rawCertIdArray[3]).getValue();
        OcspResponseCacheKey k = new OcspResponseCacheKey(issuerNameHashDer, issuerKeyHashDer, serialNumber);
        JsonNode ocspRespBase64 = elem.getValue();
        if (!ocspRespBase64.isArray() || ocspRespBase64.size() != 2) {
            LOGGER.debug("Invalid cache file format.");
            return null;
        }
        long producedAt = ocspRespBase64.get(0).asLong();
        byte[] ocspRespDer = Base64.decodeBase64(ocspRespBase64.get(1).asText());
        if (currentTimeSecond - 86400L <= producedAt) {
            OCSPResp v0 = new OCSPResp(ocspRespDer);
            return SFPair.of(k, SFPair.of(producedAt, v0));
        }
        return SFPair.of(k, SFPair.of(producedAt, null));
    }

    private static ObjectNode encodeCacheToJSON() {
        try {
            ObjectNode out = OBJECT_MAPPER.createObjectNode();
            for (Map.Entry<OcspResponseCacheKey, SFPair<Long, OCSPResp>> elem : OCSP_RESPONSE_CACHE.entrySet()) {
                OcspResponseCacheKey key = elem.getKey();
                SFPair<Long, OCSPResp> value0 = elem.getValue();
                long currentTimeSecond = (Long)value0.left;
                OCSPResp value = (OCSPResp)value0.right;
                SHA1DigestCalculator digest = new SHA1DigestCalculator();
                AlgorithmIdentifier algo = digest.getAlgorithmIdentifier();
                ASN1OctetString nameHash = ASN1OctetString.getInstance(key.nameHash);
                ASN1OctetString keyHash = ASN1OctetString.getInstance(key.keyHash);
                ASN1Integer serialNumber = new ASN1Integer(key.serialNumber);
                CertID cid = new CertID(algo, nameHash, keyHash, serialNumber);
                ArrayNode vout = OBJECT_MAPPER.createArrayNode();
                vout.add(currentTimeSecond);
                vout.add(Base64.encodeBase64String(value.getEncoded()));
                out.set(Base64.encodeBase64String(cid.toASN1Primitive().getEncoded()), vout);
            }
            return out;
        }
        catch (IOException ex) {
            LOGGER.debug("Failed to encode ASN1 object.");
            return null;
        }
    }

    private static void readOcspResponseCacheServer() {
        long sleepTime = 1000L;
        DecorrelatedJitterBackoff backoff = new DecorrelatedJitterBackoff(sleepTime, 16000L);
        Exception error = null;
        for (int retry = 0; retry < 10; ++retry) {
            try {
                HttpClient client = SFTrustManager.getHttpClient();
                URI uri = new URI(SF_OCSP_RESPONSE_CACHE_SERVER_URL);
                HttpGet get = new HttpGet(uri);
                HttpResponse response = client.execute(get);
                if (response == null || response.getStatusLine().getStatusCode() != 200) {
                    throw new IOException(String.format("Failed to get the OCSP response from the OCSP cache server: HTTP: %d", response != null ? response.getStatusLine().getStatusCode() : -1));
                }
                ByteArrayOutputStream out = new ByteArrayOutputStream();
                IOUtils.copy(response.getEntity().getContent(), (OutputStream)out);
                JsonNode m = OBJECT_MAPPER.readTree(out.toByteArray());
                SFTrustManager.readJsonStoreCache(m);
                LOGGER.debug("Successfully downloaded OCSP cache from the server.");
                return;
            }
            catch (IOException | URISyntaxException ex) {
                error = ex;
                LOGGER.debug("Retrying {}/{} after sleeping {}(ms)", retry + 1, 10, sleepTime);
                try {
                    Thread.sleep(sleepTime);
                    sleepTime = backoff.nextSleepTime(sleepTime);
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
                continue;
            }
        }
        LOGGER.debug("Failed to read the OCSP response cache from the server. Server: {}, Err: {}", SF_OCSP_RESPONSE_CACHE_SERVER_URL, error);
    }

    private static void readJsonStoreCache(JsonNode m) {
        if (m == null || !m.getNodeType().equals((Object)JsonNodeType.OBJECT)) {
            LOGGER.debug("Invalid cache file format.");
            return;
        }
        try {
            Iterator<Map.Entry<String, JsonNode>> itr = m.fields();
            while (itr.hasNext()) {
                SFPair<OcspResponseCacheKey, SFPair<Long, OCSPResp>> ky = SFTrustManager.decodeCacheFromJSON(itr.next());
                if (ky != null && ky.right != null && ((SFPair)ky.right).right != null) {
                    OCSP_RESPONSE_CACHE.put((OcspResponseCacheKey)ky.left, (SFPair<Long, OCSPResp>)ky.right);
                    continue;
                }
                if (ky == null || !OCSP_RESPONSE_CACHE.containsKey(ky.left)) continue;
                OCSP_RESPONSE_CACHE.remove(ky.left);
                WAS_CACHE_UPDATED = true;
            }
        }
        catch (IOException ex) {
            LOGGER.debug("Failed to decode the cache file");
        }
    }

    private OCSPResp fetchOcspResponse(SFPair<Certificate, Certificate> pairIssuerSubject, OCSPReq req) throws CertificateEncodingException {
        try {
            URL url;
            byte[] ocspReqDer = req.getEncoded();
            String ocspReqDerBase64 = Base64.encodeBase64String(ocspReqDer);
            Set<String> ocspUrls = this.getOcspUrls((Certificate)pairIssuerSubject.right);
            String ocspUrlStr = ocspUrls.iterator().next();
            if (SF_OCSP_RESPONSE_CACHE_SERVER_RETRY_URL_PATTERN != null) {
                URL ocspUrl = new URL(ocspUrlStr);
                url = new URL(String.format(SF_OCSP_RESPONSE_CACHE_SERVER_RETRY_URL_PATTERN, ocspUrl.getHost(), ocspReqDerBase64));
            } else {
                url = new URL(String.format("%s/%s", ocspUrlStr, ocspReqDerBase64));
            }
            LOGGER.debug("not hit cache. Fetching OCSP response from CA OCSP server. {}", url.toString());
            long sleepTime = 1000L;
            DecorrelatedJitterBackoff backoff = new DecorrelatedJitterBackoff(sleepTime, 16000L);
            boolean success = false;
            HttpResponse response = null;
            for (int retry = 0; retry < 10; ++retry) {
                HttpGet get;
                HttpClient client = SFTrustManager.getHttpClient();
                response = client.execute(get = new HttpGet(url.toString()));
                if (response != null && response.getStatusLine().getStatusCode() == 200) {
                    success = true;
                    LOGGER.debug("Successfully downloaded OCSP response from CA server. URL: {}", url.toString());
                    break;
                }
                LOGGER.debug("Retrying {}/{} after sleeping {}(ms)", retry + 1, 10, sleepTime);
                try {
                    Thread.sleep(sleepTime);
                    sleepTime = backoff.nextSleepTime(sleepTime);
                    continue;
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
            }
            if (!success) {
                throw new CertificateEncodingException(String.format("Failed to get OCSP response. StatusCode: %d, URL: %s", response == null ? null : Integer.valueOf(response.getStatusLine().getStatusCode()), ocspUrlStr));
            }
            ByteArrayOutputStream out = new ByteArrayOutputStream();
            IOUtils.copy(response.getEntity().getContent(), (OutputStream)out);
            OCSPResp ocspResp = new OCSPResp(out.toByteArray());
            if (ocspResp.getStatus() != 0) {
                throw new CertificateEncodingException(String.format("Failed to get OCSP response. Status: %s", OCSP_RESPONSE_CODE_TO_STRING.get(ocspResp.getStatus())));
            }
            return ocspResp;
        }
        catch (IOException ex) {
            throw new CertificateEncodingException("Failed to encode object.", ex);
        }
    }

    private void validateRevocationStatusMain(SFPair<Certificate, Certificate> pairIssuerSubject, OCSPResp ocspResp) throws CertificateException {
        try {
            X509CertificateHolder signVerifyCert;
            Date currentTime = new Date();
            BasicOCSPResp basicOcspResp = (BasicOCSPResp)ocspResp.getResponseObject();
            X509CertificateHolder[] attachedCerts = basicOcspResp.getCerts();
            if (attachedCerts.length > 0) {
                LOGGER.debug("Certificate is attached for verification. Verifying it by the issuer certificate.");
                signVerifyCert = attachedCerts[0];
                SFTrustManager.verifySignature(new X509CertificateHolder(((Certificate)pairIssuerSubject.left).getEncoded()), signVerifyCert.getSignature(), CONVERTER_X509.getCertificate(signVerifyCert).getTBSCertificate(), signVerifyCert.getSignatureAlgorithm());
                LOGGER.debug("Verifying OCSP signature by the attached certificate public key.");
            } else {
                LOGGER.debug("Certificate is NOT attached for verification. Verifying OCSP signature by the issuer public key.");
                signVerifyCert = new X509CertificateHolder(((Certificate)pairIssuerSubject.left).getEncoded());
            }
            SFTrustManager.verifySignature(signVerifyCert, basicOcspResp.getSignature(), basicOcspResp.getTBSResponseData(), basicOcspResp.getSignatureAlgorithmID());
            this.validateBasicOcspResponse(currentTime, basicOcspResp);
        }
        catch (IOException | OCSPException ex) {
            throw new CertificateEncodingException("Failed to check revocation status.", ex);
        }
    }

    private void validateBasicOcspResponse(Date currentTime, BasicOCSPResp basicOcspResp) throws CertificateEncodingException {
        for (SingleResp singleResps : basicOcspResp.getResponses()) {
            Date thisUpdate = singleResps.getThisUpdate();
            Date nextUpdate = singleResps.getNextUpdate();
            LOGGER.debug("Current Time: {}, This Update: {}, Next Update: {}", currentTime, thisUpdate, nextUpdate);
            CertificateStatus certStatus = singleResps.getCertStatus();
            if (certStatus != CertificateStatus.GOOD) {
                if (certStatus instanceof RevokedStatus) {
                    int reason;
                    RevokedStatus status = (RevokedStatus)certStatus;
                    try {
                        reason = status.getRevocationReason();
                    }
                    catch (IllegalStateException ex) {
                        reason = -1;
                    }
                    Date revocationTime = status.getRevocationTime();
                    throw new CertificateEncodingException(String.format("The certificate has been revoked. Reason: %d, Time: %s", reason, DATE_FORMAT_UTC.format(revocationTime)));
                }
                throw new CertificateEncodingException("Failed to validate the certificate for UNKNOWN reason.");
            }
            if (SFTrustManager.isValidityRange(currentTime, thisUpdate, nextUpdate)) continue;
            throw new CertificateEncodingException(String.format("The validity is out of range: Current Time: %s, This Update: %s, Next Update: %s", DATE_FORMAT_UTC.format(currentTime), DATE_FORMAT_UTC.format(thisUpdate), DATE_FORMAT_UTC.format(nextUpdate)));
        }
        LOGGER.debug("OK. Verified the certificate revocation status.");
    }

    private static void verifySignature(X509CertificateHolder cert, byte[] sig, byte[] data, AlgorithmIdentifier idf) throws CertificateException {
        try {
            String algorithm = SIGNATURE_OID_TO_STRING.get(idf.getAlgorithm());
            if (algorithm == null) {
                throw new NoSuchAlgorithmException(String.format("Unsupported signature OID. OID: %s", idf));
            }
            Signature signer = Signature.getInstance(algorithm, "BC");
            X509Certificate c = CONVERTER_X509.getCertificate(cert);
            signer.initVerify(c.getPublicKey());
            signer.update(data);
            if (!signer.verify(sig)) {
                throw new CertificateEncodingException(String.format("Failed to verify the signature. Potentially the data was not generated by by the cert, %s", cert.getSubject()));
            }
        }
        catch (InvalidKeyException | NoSuchAlgorithmException | NoSuchProviderException | SignatureException ex) {
            throw new CertificateEncodingException("Failed to verify the signature.", ex);
        }
    }

    private static String byteToHexString(byte[] bytes) {
        char[] hexArray = "0123456789ABCDEF".toCharArray();
        char[] hexChars = new char[bytes.length * 2];
        for (int j = 0; j < bytes.length; ++j) {
            int v = bytes[j] & 0xFF;
            hexChars[j * 2] = hexArray[v >>> 4];
            hexChars[j * 2 + 1] = hexArray[v & 0xF];
        }
        return new String(hexChars);
    }

    private OCSPReq createRequest(SFPair<Certificate, Certificate> pairIssuerSubject) {
        Certificate issuer = (Certificate)pairIssuerSubject.left;
        Certificate subject = (Certificate)pairIssuerSubject.right;
        OCSPReqBuilder gen = new OCSPReqBuilder();
        try {
            SHA1DigestCalculator digest = new SHA1DigestCalculator();
            X509CertificateHolder certHolder = new X509CertificateHolder(issuer.getEncoded());
            CertificateID certId = new CertificateID(digest, certHolder, subject.getSerialNumber().getValue());
            gen.addRequest(certId);
            return gen.build();
        }
        catch (IOException | OCSPException ex) {
            throw new RuntimeException("Failed to build a OCSPReq.");
        }
    }

    private List<Certificate> convertToBouncyCastleCertificate(X509Certificate[] chain) {
        ArrayList<Certificate> bcChain = new ArrayList<Certificate>();
        for (X509Certificate cert : chain) {
            try {
                bcChain.add(Certificate.getInstance(cert.getEncoded()));
            }
            catch (CertificateEncodingException ex) {
                throw new RuntimeException("Failed to decode the certificate DER data");
            }
        }
        return bcChain;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private List<SFPair<Certificate, Certificate>> getPairIssuerSubject(List<Certificate> bcChain) {
        ArrayList<SFPair<Certificate, Certificate>> pairIssuerSubject = new ArrayList<SFPair<Certificate, Certificate>>();
        int len = bcChain.size();
        for (int i = 0; i < len; ++i) {
            Certificate bcCert = bcChain.get(i);
            if (bcCert.getIssuer().equals(bcCert.getSubject())) continue;
            if (i < len - 1) {
                pairIssuerSubject.add(SFPair.of(bcChain.get(i + 1), bcChain.get(i)));
                continue;
            }
            Object object = ROOT_CA_LOCK;
            synchronized (object) {
                Certificate issuer = ROOT_CA.get(bcCert.getIssuer().hashCode());
                if (issuer == null) {
                    throw new RuntimeException("Failed to find the root CA.");
                }
                pairIssuerSubject.add(SFPair.of(issuer, bcChain.get(i)));
                continue;
            }
        }
        return pairIssuerSubject;
    }

    private Set<String> getOcspUrls(Certificate bcCert) {
        TBSCertificate bcTbsCert = bcCert.getTBSCertificate();
        Extensions bcExts = bcTbsCert.getExtensions();
        if (bcExts == null) {
            throw new RuntimeException("Failed to get Tbs Certificate.");
        }
        HashSet<String> ocsp = new HashSet<String>();
        Enumeration en = bcExts.oids();
        while (en.hasMoreElements()) {
            ASN1ObjectIdentifier oid = (ASN1ObjectIdentifier)en.nextElement();
            Extension bcExt = bcExts.getExtension(oid);
            if (bcExt.getExtnId() != Extension.authorityInfoAccess) continue;
            DLSequence seq = (DLSequence)bcExt.getParsedValue();
            for (ASN1Encodable asn : seq) {
                ASN1ObjectIdentifier key;
                ASN1Encodable[] pairOfAsn = ((DLSequence)asn).toArray();
                if (pairOfAsn.length != 2 || (key = (ASN1ObjectIdentifier)pairOfAsn[0]) != OIDocsp) continue;
                GeneralName gn = GeneralName.getInstance(pairOfAsn[1]);
                ocsp.add(gn.getName().toString());
            }
        }
        return ocsp;
    }

    private static HttpClient getHttpClient() {
        return HttpUtil.getHttpClient();
    }

    private static long maxLong(long v1, long v2) {
        return v1 > v2 ? v1 : v2;
    }

    private static long calculateTolerableVadility(Date thisUpdate, Date nextUpdate) {
        return SFTrustManager.maxLong((long)((float)(nextUpdate.getTime() - thisUpdate.getTime()) * 0.01f), 18000000L);
    }

    private static boolean isValidityRange(Date currentTime, Date thisUpdate, Date nextUpdate) {
        long tolerableValidity = SFTrustManager.calculateTolerableVadility(thisUpdate, nextUpdate);
        return thisUpdate.getTime() - 900000L <= currentTime.getTime() && currentTime.getTime() <= nextUpdate.getTime() + tolerableValidity;
    }

    static {
        SIGNATURE_OID_TO_STRING = new HashMap<ASN1ObjectIdentifier, String>();
        SIGNATURE_OID_TO_STRING.put(SHA1RSA, "SHA1withRSA");
        SIGNATURE_OID_TO_STRING.put(SHA256RSA, "SHA256withRSA");
        SIGNATURE_OID_TO_STRING.put(SHA384RSA, "SHA384withRSA");
        SIGNATURE_OID_TO_STRING.put(SHA512RSA, "SHA512withRSA");
        OCSP_RESPONSE_CODE_TO_STRING = new HashMap<Integer, String>();
        OCSP_RESPONSE_CODE_TO_STRING.put(0, "successful");
        OCSP_RESPONSE_CODE_TO_STRING.put(1, "malformedRequest");
        OCSP_RESPONSE_CODE_TO_STRING.put(2, "internalError");
        OCSP_RESPONSE_CODE_TO_STRING.put(3, "tryLater");
        OCSP_RESPONSE_CODE_TO_STRING.put(5, "sigRequired");
        OCSP_RESPONSE_CODE_TO_STRING.put(6, "unauthorized");
        Security.addProvider(new BouncyCastleProvider());
        CONVERTER_X509 = new JcaX509CertificateConverter();
        ROOT_CA = new HashMap<Integer, Certificate>();
        ROOT_CA_LOCK = new Object();
        OCSP_RESPONSE_CACHE = new HashMap<OcspResponseCacheKey, SFPair<Long, OCSPResp>>();
        OCSP_RESPONSE_CACHE_LOCK = new Object();
        WAS_CACHE_UPDATED = false;
        WAS_CACHE_READ = false;
        DATE_FORMAT_UTC = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        DATE_FORMAT_UTC.setTimeZone(TimeZone.getTimeZone("UTC"));
    }

    static class SHA1DigestCalculator
    implements DigestCalculator {
        private ByteArrayOutputStream bOut = new ByteArrayOutputStream();

        SHA1DigestCalculator() {
        }

        @Override
        public AlgorithmIdentifier getAlgorithmIdentifier() {
            return new AlgorithmIdentifier(OIWObjectIdentifiers.idSHA1);
        }

        @Override
        public OutputStream getOutputStream() {
            return this.bOut;
        }

        @Override
        public byte[] getDigest() {
            byte[] bytes = this.bOut.toByteArray();
            this.bOut.reset();
            SHA1Digest sha1 = new SHA1Digest();
            sha1.update(bytes, 0, bytes.length);
            byte[] digest = new byte[sha1.getDigestSize()];
            sha1.doFinal(digest, 0);
            return digest;
        }
    }

    static class OcspResponseCacheKey {
        final byte[] nameHash;
        final byte[] keyHash;
        final BigInteger serialNumber;

        OcspResponseCacheKey(byte[] nameHash, byte[] keyHash, BigInteger serialNumber) {
            this.nameHash = nameHash;
            this.keyHash = keyHash;
            this.serialNumber = serialNumber;
        }

        public int hashCode() {
            int ret = Arrays.hashCode(this.nameHash) * 37;
            ret = ret * 10 + Arrays.hashCode(this.keyHash) * 37;
            ret = ret * 10 + this.serialNumber.hashCode();
            return ret;
        }

        public boolean equals(Object obj) {
            if (!(obj instanceof OcspResponseCacheKey)) {
                return false;
            }
            OcspResponseCacheKey target = (OcspResponseCacheKey)obj;
            return Arrays.equals(this.nameHash, target.nameHash) && Arrays.equals(this.keyHash, target.keyHash) && this.serialNumber.equals(target.serialNumber);
        }

        public String toString() {
            return String.format("OcspResponseCacheKey: NameHash: %s, KeyHash: %s, SerialNumber: %s", SFTrustManager.byteToHexString(this.nameHash), SFTrustManager.byteToHexString(this.keyHash), this.serialNumber.toString());
        }
    }
}

