/*
 * Decompiled with CFR 0.152.
 */
package net.snowflake.client.jdbc.internal.org.bouncycastle.crypto.ec;

import net.snowflake.client.jdbc.internal.org.bouncycastle.crypto.CipherParameters;
import net.snowflake.client.jdbc.internal.org.bouncycastle.crypto.ec.ECDecryptor;
import net.snowflake.client.jdbc.internal.org.bouncycastle.crypto.ec.ECPair;
import net.snowflake.client.jdbc.internal.org.bouncycastle.crypto.params.ECPrivateKeyParameters;
import net.snowflake.client.jdbc.internal.org.bouncycastle.math.ec.ECPoint;

public class ECElGamalDecryptor
implements ECDecryptor {
    private ECPrivateKeyParameters key;

    public void init(CipherParameters cipherParameters) {
        if (!(cipherParameters instanceof ECPrivateKeyParameters)) {
            throw new IllegalArgumentException("ECPrivateKeyParameters are required for decryption.");
        }
        this.key = (ECPrivateKeyParameters)cipherParameters;
    }

    public ECPoint decrypt(ECPair eCPair) {
        if (this.key == null) {
            throw new IllegalStateException("ECElGamalDecryptor not initialised");
        }
        ECPoint eCPoint = eCPair.getX().multiply(this.key.getD());
        return eCPair.getY().subtract(eCPoint).normalize();
    }
}

