/*
 * Decompiled with CFR 0.152.
 */
package net.snowflake.client.jdbc.internal.org.bouncycastle.cert.crmf;

import java.io.IOException;
import net.snowflake.client.jdbc.internal.org.bouncycastle.asn1.cms.EnvelopedData;
import net.snowflake.client.jdbc.internal.org.bouncycastle.asn1.crmf.CRMFObjectIdentifiers;
import net.snowflake.client.jdbc.internal.org.bouncycastle.asn1.crmf.EncKeyWithID;
import net.snowflake.client.jdbc.internal.org.bouncycastle.asn1.crmf.EncryptedKey;
import net.snowflake.client.jdbc.internal.org.bouncycastle.asn1.crmf.PKIArchiveOptions;
import net.snowflake.client.jdbc.internal.org.bouncycastle.asn1.pkcs.PrivateKeyInfo;
import net.snowflake.client.jdbc.internal.org.bouncycastle.asn1.x509.GeneralName;
import net.snowflake.client.jdbc.internal.org.bouncycastle.cert.crmf.PKIArchiveControl;
import net.snowflake.client.jdbc.internal.org.bouncycastle.cms.CMSEnvelopedData;
import net.snowflake.client.jdbc.internal.org.bouncycastle.cms.CMSEnvelopedDataGenerator;
import net.snowflake.client.jdbc.internal.org.bouncycastle.cms.CMSException;
import net.snowflake.client.jdbc.internal.org.bouncycastle.cms.CMSProcessableByteArray;
import net.snowflake.client.jdbc.internal.org.bouncycastle.cms.RecipientInfoGenerator;
import net.snowflake.client.jdbc.internal.org.bouncycastle.operator.OutputEncryptor;

public class PKIArchiveControlBuilder {
    private CMSEnvelopedDataGenerator envGen;
    private CMSProcessableByteArray keyContent;

    public PKIArchiveControlBuilder(PrivateKeyInfo privateKeyInfo, GeneralName generalName) {
        EncKeyWithID encKeyWithID = new EncKeyWithID(privateKeyInfo, generalName);
        try {
            this.keyContent = new CMSProcessableByteArray(CRMFObjectIdentifiers.id_ct_encKeyWithID, encKeyWithID.getEncoded());
        }
        catch (IOException iOException) {
            throw new IllegalStateException("unable to encode key and general name info");
        }
        this.envGen = new CMSEnvelopedDataGenerator();
    }

    public PKIArchiveControlBuilder addRecipientGenerator(RecipientInfoGenerator recipientInfoGenerator) {
        this.envGen.addRecipientInfoGenerator(recipientInfoGenerator);
        return this;
    }

    public PKIArchiveControl build(OutputEncryptor outputEncryptor) throws CMSException {
        CMSEnvelopedData cMSEnvelopedData = this.envGen.generate(this.keyContent, outputEncryptor);
        EnvelopedData envelopedData = EnvelopedData.getInstance(cMSEnvelopedData.toASN1Structure().getContent());
        return new PKIArchiveControl(new PKIArchiveOptions(new EncryptedKey(envelopedData)));
    }
}

