/*
 * Decompiled with CFR 0.152.
 */
package net.snowflake.client.jdbc.internal.amazonaws.regions;

import net.snowflake.client.jdbc.internal.amazonaws.AmazonClientException;
import net.snowflake.client.jdbc.internal.amazonaws.SdkClientException;
import net.snowflake.client.jdbc.internal.amazonaws.regions.AwsRegionProvider;
import net.snowflake.client.jdbc.internal.amazonaws.util.EC2MetadataUtils;
import net.snowflake.client.jdbc.internal.apache.commons.logging.LogFactory;

public class InstanceMetadataRegionProvider
extends AwsRegionProvider {
    private volatile String region;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String getRegion() throws SdkClientException {
        if (this.region == null) {
            InstanceMetadataRegionProvider instanceMetadataRegionProvider = this;
            synchronized (instanceMetadataRegionProvider) {
                if (this.region == null) {
                    this.region = this.tryDetectRegion();
                }
            }
        }
        return this.region;
    }

    private String tryDetectRegion() {
        try {
            return EC2MetadataUtils.getEC2InstanceRegion();
        }
        catch (AmazonClientException sce) {
            LogFactory.getLog(InstanceMetadataRegionProvider.class).debug("Ignoring failure to retrieve the region: " + sce.getMessage());
            return null;
        }
    }
}

